/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/dlayer.c_v   1.0   15 Jan 1990 19:25:54   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/dlayer.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:25:54   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   dlayer.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/


/*   
*     DLAYER
*     Hardware level routines, data link layer
*
****************************************************************************
*                                                                          *
*      part of:                                                            *
*      TCP/IP kernel for NCSA Telnet                                       *
*      by Tim Krauskopf                                                    *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
****************************************************************************
*/
#include "stdio.h"
#if  defined(__TURBOC__)||defined(_MSC_)
#include <time.h>
#endif
#include "protocol.h"
#include "data.h"
#include "newwin.h"

#ifdef	_MSC_
#define	bioskey(mode)	_bios_keybrd(mode)
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include "mem.h"
extern  int     slip_mode;      /* defined in packet.c if slip packet driver */
#ifdef	_MSC_X
uint8	getdlayer(uint8 *tipnum);
#endif
#ifdef  BOOTP
/* bootp routines - These routines are based on the stanford/clarkson
   bootp code. Originally developed at Stanford University.

   Bootp is a UDP based protocol that determines the clients IP address and
   gateway information etc.
*/

#include        <string.h>
#include        "bootp.h"
#include        "windat.h"
#include        "hostform.h"

static struct bootp    bootpacket;
static  long    bootp_xid;
extern  int     foundbreak;

int
sendbootp()             /* sends a bootp broadcast packet */
{

                        /* this routine does not do the initial setup of
                           the bootp packet */

        int     rc;

        return(netusend(broadip,IPPORT_BOOTPS,IPPORT_BOOTPC, &bootpacket, sizeof(struct bootp)));
}

void
bootp_init()            /* initialize the bootp packet */
{
   bootp_xid = time(NULL);    /* get a unique transaction ID */
   memset((char *) &bootpacket,0,sizeof(bootpacket));

   bootpacket.bp_op = BOOTREQUEST;
   bootpacket.bp_htype = 1;     /* hardware type 1 is ethernet. This should be
                                   made more robust. */
   bootpacket.bp_hlen  = sizeof(nnmyaddr);
   bootpacket.bp_xid   = bootp_xid;
   bootpacket.bp_secs  = 1;
   memcpy(bootpacket.bp_vend,VM_RFC1048,4);
   memcpy(bootpacket.bp_chaddr, nnmyaddr, sizeof(nnmyaddr));
}


parse_bootpacket(bp)    /* parse an incoming bootp packet */
        struct bootp *bp;
{
        int     x,items,len;
        unsigned char *c;
        char    message[80],*cp;
        int     gateway=0,nameserver=0;
        struct machinfo *sp;
        extern  struct config Scon;
        extern  struct machinfo *Sns;

   nprintf(CONSOLE,"\nValid BOOTP Packet Received\n");
   nprintf(CONSOLE,"BootP: Reply from server %s IP [%d.%d.%d.%d]\n",bp->bp_sname,
        bp->bp_siaddr.addr[0],bp->bp_siaddr.addr[1],
        bp->bp_siaddr.addr[2],bp->bp_siaddr.addr[3]);
   nprintf(CONSOLE,"BootP: My IP [%d.%d.%d.%d]  Gateway IP [%d.%d.%d.%d]\n",
        bp->bp_yiaddr.addr[0],bp->bp_yiaddr.addr[1],
        bp->bp_yiaddr.addr[2],bp->bp_yiaddr.addr[3],
        bp->bp_giaddr.addr[0],bp->bp_giaddr.addr[1],bp->bp_giaddr.addr[2],
        bp->bp_giaddr.addr[3]);

   netsetip(&bp->bp_yiaddr.addr[0]);             /* set my ip address */
   movebytes(Scon.myipnum,&bp->bp_yiaddr,4);

   if(comparen(bp->bp_vend,VM_RFC1048,4))  {
        nprintf(CONSOLE,"BootP: RFC1048 Style BootP Packet Received\n");
        c = bp->bp_vend + 4;
        while((*c != 255) && ((c - bp->bp_vend) < 64)) {
                switch (*c) {

                case 0 :        /* nop pad */
                        c++;
                        break;
                case 1 :        /* subnet mask */
                        len = *(c + 1);
                        c += 2;
                        memcpy(Scon.netmask,c, 4);
                        netsetmask(Scon.netmask);
                        sprintf(message,"BootP: Subnet is %d.%d.%d.%d\n\r",
                           *c, *(c+1), *(c+2), *(c+3));
                        vprint(console->vs,message);
                        c += len;
                        Scon.havemask = 1;
                        break;
                case 2 :        /* time offset */
                        c += *(c + 1) + 2;
                        break;

                case 3 :       /* gateways      */
                        len = *(c + 1);
                        items = len/4;
                        c += 2;
                        for(x=0; x < items; x++) {
                                sprintf(message,"%d.%d.%d.%d",*c, *(c+1), *(c+2), *(c+3));
                                if(!(sp = Smadd(message))) {
                                        nprintf(CONSOLE,"Out of Memory Adding Gateway - Smadd()\n");
                                        return(-1);
                                }
                                gateway++;
                                nprintf(CONSOLE,"BootP: Adding Gateway number %d IP %s\n",
                                   gateway,sp->hname);
                                sp->gateway = gateway;
                                memcpy(sp->hostip,c,4);
                                sp->mstat = HFILE;
                                c += 4;
                        }
                        break;
                case 4 :        /* time servers */
                case 5 :        /* IEN=116 name server */
                        c += *(c + 1) + 2;
                        break;
                case 6 :        /* domain name server  */
                        len = *(c + 1);
                        items = len/4;
                        c += 2;
                        for(x=0; x < items; x++) {
                                sprintf(message,"%d.%d.%d.%d",*c, *(c+1), *(c+2), *(c+3));
                                if(!(sp = Smadd(message))) {
                                        nprintf(CONSOLE,"Out of Memory Adding Nameserver - Smadd()\n");
                                        return(-1);
                                }
                                nameserver++;
                                nprintf(CONSOLE,"BootP: Adding Nameserver number %d IP %s\n",
                                   nameserver,sp->hname);
                                sp->nameserv = nameserver;
                                memcpy(sp->hostip,c,4);
                                sp->mstat = HFILE;
                                if(!Sns)
                                        Sns = sp;
                                c += 4;
                        }
                        Scon.nstype = 1;
                        break;
                case 7 :        /* log server */
                case 8 :        /* cookie server */
                case 9 :        /* lpr server */
                case 10 :       /* impress server */
                case 11 :       /* rlp server */
                        c += *(c + 1) + 2;
                        break;
                case 12 :       /* client host name    */
                        len = *(c + 1);
                        strncpy(message,c + 2, len);
                        message[len] = 0;
                        if(!(sp = Smadd(message))) {
                                nprintf(CONSOLE,"Out of Memory Adding client name - Smadd()\n");
                                return(-1);
                        }
                        nprintf(CONSOLE,"BootP: This Clients Name is %s\n",sp->hname);
                        if(!strlen(Scon.me)) 
                                strncpy(Scon.me,sp->hname,31);
                        Scon.me[31] = 0;
                        if(cp = strchr(sp->hname,'.')) {      /* assume fully qualified
                                                        name if a . is in hostname */
                                if(!Scon.domainpath) {  /* if no domain set yet */
                                        message[0] = 0;
                                        while(cp) {
                                                strcat(message,",");
                                                strcat(message,cp+1);
                                                cp = strchr(cp+1,'.');
                                        }
                                        Scon.domainpath = mem_malloc(strlen(message)+1);
                                        strcpy(Scon.domainpath, message);
                                        nprintf(message,"BootP: Setting Domainpath to (%s)\n",Scon.domainpath);
                                        removejunk(Scon.domainpath);
                                }
                        }
                        c += len + 2;
                        break;
                case 255 :
                        break;
                default :
                        c += *(c + 1) + 2;
                        break;                        
                }       /* end switch */
        }       /* end while    */
    }   /* end if comparen */

        if(!gateway)   {        /* if none were in the rfc1048 vend packet, add
                                   the default gateway as an entry */
                c = bp->bp_giaddr.addr;
                sprintf(message,"%d.%d.%d.%d",*c, *(c+1), *(c+2), *(c+3));
                if(!(sp = Smadd(message))) {
                        nprintf(CONSOLE,"Out of Memory Adding Gateway - Smadd()\n");
                        return(-1);
                }
                gateway++;
                nprintf(CONSOLE,"BootP: Adding Gateway number %d IP %s\n",
                        gateway,sp->hname);
                sp->gateway = gateway;
                memcpy(sp->hostip,c,4);
                sp->mstat = HFILE;

        }
        return(0);
}


int
bootp()                 /* main processing of bootp lookup request
                           calls sendbootp to send a bootp request,
                           sets up the udp listen port etc.
                           handles retries
                        */
{

   int  x,y,i,delay;
   time_t start_time;
   union {
        char junk_buff[1506];
        struct bootp bootpacket;
   } udp_data;
   char message[80];
   unsigned char *ea;
   struct bootp *bp;
#ifndef	_MSC_
   unsigned char myip[]={0,0,0,0};
#else
   unsigned char myip[4];

   memset(myip,0,sizeof(myip));
#endif
   time(&start_time);
   netsetip(myip);
   bootp_init();
   bp = &udp_data.bootpacket;
   i = console->vs;
   ea = (unsigned char *) &nnmyaddr;
   nprintf(CONSOLE, "My Etheraddress: %x:%x:%x:%x:%x:%x\n",*ea, *(ea+1), *(ea+2), *(ea+3), *(ea+4), *(ea+5), *(ea+6));
   nprintf(CONSOLE,"Sending BOOTPs: (Press <SPACEBAR> to give up.)\n");
   while(neturead(udp_data.junk_buff) != -1);    /* should only go around once */

   for(x = 0; x < BOOTP_RETRIES; x++) {
        netulisten(IPPORT_BOOTPC);
        if(y = sendbootp()) {               /* do some error processing */
                nprintf(CONSOLE,"\n\rError %d from sendbootp\n",y);
                return(-1);
        }
        nprintf(CONSOLE,".");
        start_time = time(NULL);
        delay = ((rand() % 10) + 1); 
                /* I hate this!
                        why is time() defined as n_clicks in pcdef.h ?
                        what a waste of time to find out why this routine
                        wouldn't delay correctly, and why time(&x) wouldn't
                        work either. If you wanted clicks, then call it! geesh

                        Never mind, I changed all calls to time to n_clicks when
                        that was what was wanted all along. For the Mac, I suppose,
                        n_clicks will have to be redefined as something.
                        */
        while((time(NULL) - start_time) < (long) delay) {
                if(bioskey(1)) {
                        if((bioskey(0) & 0xFF) == 32)
                                return(-1);
                        while(bioskey(1))
                                bioskey(0);     /* throw it all away */
                }
                if(!demux(1)) {
		   	 bootpacket.bp_secs++;
                        continue;         /* process all packets */
 		 }
                if(neturead(udp_data.junk_buff) == -1) 
                        continue;
                delay = 0;
                break;
        }
        if(delay)
                continue;       /* time ran out and got nothing */

        if(bp->bp_xid == bootp_xid &&
           bp->bp_op  == BOOTREPLY &&
           comparen(bp->bp_chaddr,nnmyaddr,sizeof(nnmyaddr))
        ) break;              /* got a valid reply */
   }
   if(x == BOOTP_RETRIES)       {       /* do some error processing */
        nprintf(CONSOLE,"BOOTP Timeout. No Response from BOOTP server\n");
        return(-1);
   }

   if(parse_bootpacket(bp))
        return(-1);
   return(0);
        
}
#endif

/************************************************************************/
/*
*   Address Resolution Protocol handling.  This can be looked at as
*   Ethernet-dependent, but the data structure can handle any ARP
*   hardware, with minor changes here.
*
*/
replyarp(thardware,tipnum)
	uint8 *thardware,*tipnum;
	{
	uint8 *pc;

	movebytes(&arp.tha,thardware,DADDLEN);   /* who this goes to */

	movebytes(&arp.tpa,tipnum,4);		/* requester's IP address */
	arp.op = intswap(ARPREP);			/* byte swapped reply opcode */

	movebytes(arp.d.dest,thardware,DADDLEN);	/* hardware place to send to */

	dlayersend(&arp,sizeof(arp));

/*
*  check for conflicting IP number with your own
*/
	if (comparen(tipnum,nnipnum,4))	{	 /* we are in trouble */
		pc = neterrstring(-1);
		sprintf(pc,"Conflict with Ethernet hardware address: %2x:%2x:%2x:%2x:%2x:%2x",
		thardware[0],thardware[1],thardware[2],thardware[3],thardware[4],thardware[5]);
		netposterr(-1);
		netposterr(102);
		return(-3);
	}

}

/************************************************************************/
/*  reqarp
*    put out an ARP request packet, doesn't wait for response
*/
reqarp(tipnum)
	uint8 *tipnum;
	{
        if(slip_mode)
                return;         /* this is a no-op */
#ifdef MAC
	if (KIP) {
		if (0 < KIParp(tipnum,&arp.tha))
			cacheupdate(tipnum, &arp.tha);
		return(0);
	}
#endif MAC

	movebytes(&arp.tha,broadaddr,DADDLEN); 
	movebytes(&arp.tpa,tipnum,4);      		/* put in IP address we want */
	arp.op = intswap(ARPREQ);				/* request packet */

	movebytes(arp.d.dest,broadaddr,DADDLEN);		/* send to everyone */

	if (dlayersend(&arp,sizeof(arp)))
		return(1);          				/* error return */

	return(0);
}

/************************************************************************/
/*  interpret ARP packets
*   Look at incoming ARP packet and make required assessment of usefulness,
*   check to see if we requested this packet, clear all appropriate flags.
*/
arpinterpret(p)
	ARPKT *p;
	{

/*
*  check packet's desired IP address translation to see if it wants
*  me to answer.
*/
#ifdef  NNDEBUG
        printf("Pkt Arp type %04x\n",intswap(p->op));
#endif
	if (p->op == intswap(ARPREQ) && (comparen(&p->tpa,nnipnum,4))) { 

		cacheupdate(&p->spa,&p->sha);   /* keep her address for me */

		replyarp(&p->sha,&p->spa);		/* proper reply */
		return(0);
	}
/*
*  Check for a RARP reply.  If present, call netsetip()
*/
	else if (p->op == intswap(RARPR) && (comparen(&p->tha,nnmyaddr,DADDLEN))) {
		movebytes(nnipnum,&p->tpa,4);
		return(0);
	}

/* 
*  Check for a reply that I probably asked for.
*/
	if (comparen(&p->tpa,nnipnum,4)) {
		if (p->op == intswap(ARPREP) &&
			p->hrd == intswap(HTYPE) &&       /* consistency checking */
			p->hln == DADDLEN &&
			p->pln == 4 ) {
			cacheupdate(&p->spa,&p->sha);
			return(0);
		}
	}

	return(1);

}
#ifndef	MINITEL
/*************************************************************************/
/* rarp
*  Send a rarp request to look up my IP number
*/
rarp()
	{
/*
*  our other fields should already be loaded
*/
        if(slip_mode)
                return; /* no op for slip connections */
	movebytes(&arp.tha,nnmyaddr,DADDLEN);   /* address to look up (me) */
	movebytes(&arp.sha,nnmyaddr,DADDLEN);   /* address to look up (me) */
	arp.op = intswap(RARPQ);				/* request packet */

	movebytes(arp.d.dest,broadaddr,DADDLEN);		/* send to everyone */
	arp.d.type = ERARP;

	if (dlayersend(&arp,sizeof(arp)))
		return(1);          				/* error return */

	arp.d.type = EARP;						/* set back for ARP to use */
	return(0);

}
#endif
/*************************************************************************/
/* cacheupdate
*  We just received an ARP, or reply to ARP and need to add the information
*  to the cache.
*
*  Reset arptime so that another machine may be ARPed.  This timer keeps
*  ARPs from going out more than one a second unless we receive a reply.
*/
static int32 arptime=0L;

cacheupdate(ipn,hrdn)
	int32 *ipn;
        uint8 *hrdn;
{
	int i,found;
	int32 timer;
static	char	nulladdr[]={0,0,0,0,0,0};

#ifdef  NNDEBUG
        printf("In cache update\n");
#endif
	found = -1;
/*
* linear search to see if we already have this entry
*/
	for (i=0; found < 0 && i < CACHELEN; i++) 
		if (comparen(ipn,&arpc[i].ip,4))
			found = i;

/*
*  if that IP number is not already here, take the oldest entry.
*  If it is already here, update the info and reset the timer.
*  These were pre-initialized to 0, so if any are blank, they will be
*  taken first because they are faked to be oldest.
*/
	if (found < 0) {
		timer = arpc[0].tm;
		found = 0;

		for (i=1; i < CACHELEN; i++) 
			if (arpc[i].tm < timer && !arpc[i].gate) {/* exclude gateways */
				found = i;
				timer = arpc[i].tm;
			}
	}
/*
*   do the update to the cache
*/

#ifdef  NNDEBUG
        printf("found is first %d\n",found);
#endif
	movebytes(&arpc[found].hrd[0],hrdn,DADDLEN);
	movebytes(&arpc[found].ip[0],ipn,4);
	if(memcmp(&arpc[found].hrd[0],nulladdr, DADDLEN))
		arpc[found].tm = n_clicks(NULL);
	else
	        arpc[found].tm = 0;		/* timeout */
#ifdef  NNDEBUG
        printf("arp cache entry number %d time %ld ip %0d.%0d.%0d.%0d\n",found,arpc[found].tm,
                arpc[found].ip[3], arpc[found].ip[2],arpc[found].ip[1],arpc[found].ip[0]);
        printf("Now found is %d\n",found);
#endif

	arptime = 0L;					/* reset, allow more arps */
	return(found);

}

/*************************************************************************/
/*  cachelook
*   look up information in the cache
*   returns the cache entry number for the IP number given.
*   Returns -1 on no valid entry, also if the entry present is too old.
*
*   doarp is a flag for non-gateway requests which determines whether an
*   arp will be sent or not.
*/

cachelook(ipn,gate,doarp)
	int32 *ipn;
	int gate,doarp;
	{
	int i,haveg;
/*
*  First option, we are not looking for a gateway, but a host on our
*  local network.
*/
        if(slip_mode) {
                int32 *l;

                l = (unsigned long *) &nnipnum;
                if(*ipn == *l)
                        return(-1);
                return(0);              /* always return something in slip_mode */
        }
	if (!gate) {
#ifdef  NNDEBUG
        printf("Cache lookup looking for %08lx\n",*ipn);
#endif
		for (i=0; i<CACHELEN; i++) {
			if (comparen(ipn,&arpc[i].ip,4) && 
				arpc[i].tm + CACHETO > n_clicks(NULL))  {
#ifdef  NNDEBUG
                printf("Cache lookup Found entry at %d\n",i);
#endif
		    		return(i);
                        }
#ifdef  NNDEBUG
                printf("skipping %d looking for %08lx have %08lx at time %ld\n",i,*ipn, *((long *) &arpc[i].ip),arpc[i].tm);
#endif
                }
/*
*  no valid entry, send an ARP
*/
		if (n_clicks(NULL) >= arptime && doarp) {	/* check time limit */
			reqarp(ipn);				/* put out a broadcast request */
			arptime = n_clicks(NULL)+ARPTO;
#ifdef  NNDEBUG
        printf("Sent arp req, next arp at %ld\n",arptime);
#endif
		}
		return(-1);
	}
	else {
/*
*  Second option, we need a gateway.
*  if there is a gateway with a current ARP, use it.
*  if not, arp all of the gateways and return an error.  Next call will
*  probably catch the result of the ARP.
*/
		haveg = 0;
		for (i=CACHELEN-1; i >= 0; i--)
			if (arpc[i].gate && arpc[i].tm + CACHETO > n_clicks(NULL))
				return(i);

		if (n_clicks(NULL) >= arptime) {	
			for (i=CACHELEN-1; i >= 0; i--)
				if (arpc[i].gate) {
					haveg = 1;
					reqarp(&arpc[i].ip);	/* put out a broadcast request */
				}

			if (!haveg) 			/* blind luck, try ARPing even for */
				reqarp(ipn);		/* a node not on our net. (proxy ARP)*/

			arptime = n_clicks(NULL)+ARPTO;
		}

		return(-1);
	}

}



/***************************************************************************/
/*  netdlayer
*       get data layer address for insertion into outgoing packets.
*   searches based on ip number.  If it finds the address, ok, else . . .
*
*   Checks to see if the address is on the same network.  If it is,
*   then ARPs the machine to get address.  Forces pause between sending
*   arps to guarantee not saturating network.
*
*   If not on the same network, it needs the ether address of a 
*   gateway.  Searches the list of machines for a gateway flag.
*   Returns the first gateway found with an Ethernet address. 
*
*   Returns NULL if not here, or pointer to ether address if here.
*   If we don't have it, this also sends an ARP request so that the
*   next time we are called, the ARP reply may be here by then.
*
*/
uint8
*netdlayer(tipnum)
	uint8 *tipnum;
	{
	int32 t;
	uint8 *pc;

	t = n_clicks(NULL) + nndto*TICKSPERSEC;			/* some seconds time out */
	pc = NULL;
	do {
		if (t <= n_clicks(NULL)) 					/* timed out */
			return(NULL);
		pc = getdlayer(tipnum);
		netsleep(0);							/* can't have deadlock */
	} while (pc == NULL);

	return(pc);
}
#ifndef	MINITEL
/***************************************************************************/
/*  netgetrarp
*   Look for a RARP response to arrive
*   wait for nndto seconds before returning failure.
*   If response arrives, return success.
*/
netgetrarp()
	{
	int32 t,tr;

	t = n_clicks(NULL) + nndto*TICKSPERSEC*3;		/* some seconds time out */
	tr = 0L;									/* one second retry */

	do {
		if (tr <= n_clicks(NULL)) {					/* need retry? */
			rarp();
			tr = n_clicks(NULL) + TICKSPERSEC;
		}

		if (t <= n_clicks(NULL)) {					/* timed out */
			netposterr(103);
			return(-1);
		}

		netsleep(0);							/* can't have deadlock */
	} while (comparen(nnipnum,"RARP",4));		/* until RARP is served */

	return(0);
}
#endif
/***************************************************************************/
/*  getdlayer
*   check for the hardware address one time
*/
uint8
*getdlayer(tipnum)
	uint8 *tipnum;
	{
	int needgate,i;

	needgate = 0;

/*
*  Check to see if we need to go through a gateway.
*  If the machine is on our network, then assume that we can send an ARP
*  to that machine, otherwise, send the ARP to the gateway.
*
*  Uses internet standard subnet mask method, RFC950
*  if subnets are not in use, netmask has been pre-set to the appropriate 
*  network addressing mask.
*/ 
	for (i=3; i >= 0; i--)
		if ((nnmask[i] & tipnum[i]) != (nnmask[i] & nnipnum[i]))
			needgate = 1;

	if (needgate && (0 <= (i = cachelook(tipnum,1,1)))) 
		return(&arpc[i].hrd);

	if (!needgate && (0 <= (i = cachelook(tipnum,0,1))))
		return(&arpc[i].hrd);

	return(NULL);
}

/***************************************************************************/
/*  netsetgate
*   Establish an IP number to use as a gateway.
*   They are added in the order that they arrive and there is a limit on
*   the number of gateways equal to CACHELEN/2.
*   ARPs them as they are added so that the Cache will get pre-filled
*   with gateways.
*
*   returns 0 if ok, -1 on error (full)
*/
netsetgate(ipn)
	uint8 *ipn;
	{
	int i;

	for (i=CACHELEN-1 ; i >= CACHELEN/2 ; i--)
		if (!arpc[i].gate) {
			arpc[i].gate = 1;
			movebytes(&arpc[i].ip,ipn,4);
			reqarp(ipn);
			return(0);
		}

	return(-1);
}
