/* #define	DEBUG	1 */
/* #define	DEBUGXY	1 */
/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/bkgr.c_v   1.0   15 Jan 1990 19:25:48   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/bkgr.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:25:48   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   bkgr.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/
/* version 2.2c revisions
      2/7/89  fixed NLST command to return just the file name, not dir info (bkc)
*/

/* #define XBUG    1  */
/*
*  Background procedures for rcp and ftp
*             11/86          Tim Krauskopf
*             1988    rewritten several times
*  National Center for Supercomputing Applications
*
****************************************************************************
*                                                                          *
*      part of:                                                            *
*      Network utilities for NCSA Telnet                                   *
*      by Tim Krauskopf                                                    *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
****************************************************************************
*
*/
#include "stdio.h"
#include <dos.h>
#include <alloc.h>
#include "fcntl.h"
#include <string.h>
#include "whatami.h"
#include "hostform.h"
#include "windat.h"
#include "newwin.h"
#include "mem.h"
#ifdef	DEBUG
#include <errno.h>
#endif
#define HTELNET 23
#define HRSHD 514
#define HFTP 21
#define BUFFERS 2048
#define PATHLEN 73

#ifdef PC

#define RCPSEGSIZE 1024
#define EOLCHAR 10

#if defined(_MSC_)|defined(__TURBOC__)
#define O_RAW O_BINARY
#ifdef	_MSC_
#define	_SIZE_T 1
#include <sys/types.h>
#endif
#include <sys/stat.h>
#endif

#else

#define MACBINARY

#ifdef MACBINARY
#include "MacBinary.h"
int
	MacBinary=1;
MBFile
	*MBopen(),
	*mbfp;
#endif
#include "mem.h"

#define RCPSEGSIZE 512
#define O_RAW O_RDONLY
#define EOLCHAR 13
#endif


int32 atol(),lseek();

char *firstname(),*nextname(),*nextfile;

static int
	ftpenable=0,				/* is file transfer enabled? */
	rcpenable=0,				/* is rcp enabled? */
	ftpdata=-1,					/* port for ftp data connection */
	fnum=-1,					/* port number for incoming ftp */
	rsnum=-1,					/* port number for incoming rshell */
	rserr=-1;					/* port number for rshd() stderr */

static unsigned char xs[BUFFERS+10],	/* buffer space for file transfer */
		pathname[PATHLEN],			/* space to keep path names */
		newfile[PATHLEN],			/* current file being received */
		myuser[17],					/* user name on my machine */
		hisuser[17],				/* user name on his machine */
		waitchar;					/* character waiting for from net */

static	char	*file_buffer, *file_ptr;
static	unsigned buffer_size;

static int 
	curstate = -1,			/* state machine for background processes */
	retstate = 200,			/* to emulate a subroutine call */
	ftpstate = 0,			/* state of the ftp data transfer */
	isdir=0,				/* flag for rcp target pathname */
	waitpos=0,				/* marker for gathering strings from net */
	cnt=0,					/* number of characters from last netread() */
	fh=0,					/* file handle when transfer file is open */
	ftpfh=0,				/* file handle for ftp data */
	rc=0;					/* telnet flag */
static unsigned int	xp=0,					/* general pointer */
	towrite=0,				/* file transfer pointer */
	len=0;					/* file transfer length */
static	int olddisk;
static char olddir[128];

static long int
	filelen=0L;				/* length of current file for transfer */

static char crfound=0;
static  int     listmode;       /* ## fix NLST true if NLST else LIST */


extern char Sptypes[NPORTS];			/* flags for port #'s */

#define PFTP 1
#define PRCP 2
#define PDATA 3

#ifdef PC

#define ga()  while (!netwrite(rsnum,"",1)) netsleep(0)

#define	ALLOC_BUFFER	0
#define	FREE_BUFFER	1

static void
set_file_buffer(int mode)
{
	unsigned long free_mem = coreleft();

	if(mode == ALLOC_BUFFER) {
	       	if(file_buffer)
		       	return;
		free_mem = (free_mem *  25/ 100);
		if(free_mem > 0xfff0)
		       	free_mem = 0xfff0;
		buffer_size = free_mem;
		if(buffer_size < BUFFERS) {
		       	file_buffer = file_ptr = xs;
			buffer_size = BUFFERS;
			nprintf(CONSOLE,"FTP buffer size is %u\n",BUFFERS);
		}
		else {
		       	file_buffer = file_ptr = mem_malloc(buffer_size);
			nprintf(CONSOLE,"FTP Allocated %u byte transfer buffer\n",buffer_size);
		}
	}
	else {
	       	if(file_buffer != xs && file_buffer) {
		       	mem_free(file_buffer);
			nprintf(CONSOLE,"FTP Deallocated transfer buffer\n");
		}
		file_buffer = NULL;
	}
}

/************************************************************************/
/*  unsetrshd
*   remove the acceptance of rshd calls (rcp)
*/
unsetrshd()
	{
	netclose(rsnum);
	rsnum = -1;
	rcpenable = 0;
}

/************************************************************************/

setrshd()
{
	int i;
/*
*  set up to receive a rsh call connection 
*/
	if (rsnum >= 0)
		return(0);
	curstate = 199;					/* waiting for connection */
	i = netsegsize(RCPSEGSIZE);
	rsnum = netlisten(HRSHD);
	netsegsize(i);
	if (rsnum >= 0)
		Sptypes[rsnum] = PRCP;

	rcpenable = 1;
}


/************************************************************************/
/*  rshell
*   take an incoming rshell request and service it.  Designed to handle
*   rcp primarily.
*/
rshd(code)
	int code;
	{
	int i,j;

	if (!rcpenable)
		return(0);

	switch (curstate) {
		case 199:					/* wait to get started */
			if (code != CONOPEN)
				break;

			curstate = 0;
			netputuev(SCLASS,RCPACT,rsnum);		/* keep us alive */

			break;
			
/*
* in effect, this is a subroutine that captures network traffic while
* waiting for a specific character to be received
*/
		case 50:
			while (0 < (cnt = netread(rsnum,&xs[waitpos],1))) {
				if (xs[waitpos] == waitchar) {
					curstate = retstate;
					netputuev(SCLASS,RCPACT,rsnum);		/* keep us alive */
					break;
				}
				else 
					waitpos += cnt;
			}
			netpush(rsnum);
			break;

		case 51:				/* for recursion, passes straight through */
			break;

		case 0:					/* waiting for first string */
			retstate = 1;
			curstate = 50;
			waitchar = 0;
			waitpos = 0;
			netputuev(SCLASS,RCPACT,rsnum);		/* keep us alive */
			break;

		case 1:					/* we have received stderr port number */
			i = atoi(xs);		/* port number */
			curstate = 51;
#ifdef notneeded
/*
*  caution, netrespond calls netsleep()
*  which will call this routine
*  careful with the synchronicity!
*/
			if (i)		/* zero means, don't bother */
				rserr = netrespond(i,rsnum,1);	/* respond to rsh */
			else
#else
			if (i) {
				cnt = -1;		/* abort it all, we don't take rsh */
				break;
			}
			else
#endif
				rserr = -1;

			retstate = 2; curstate = 50;
			waitpos = 0; waitchar = 0;
			break;

		case 2:				/* get user name, my machine */
			strncpy(myuser,xs,16);

			retstate = 3; curstate = 50;
			waitpos = 0; waitchar = 0;
			break;

		case 3: 			/* get user name, his machine */
			strncpy(hisuser,xs,16);
/*			ftransinfo(hisuser); */

			retstate = 4; curstate = 50;
			waitchar = 0; waitpos = 0;

			break;

		case 4:
/*			ftransinfo(xs);*/
/*
* ACK receipt of command line
*/
			if (rserr >= 0)
				netwrite(rserr,&xp,1);		/* send null byte */
			else {
				ga();			/* send NULL on main connection */
			}

			if (!strncmp(xs,"rcp ",4)) {
/*
*  rcp will be using wildcards, target must be a directory
*/
				if (!strncmp(&xs[4],"-d -t",5)) {
					strncpy(pathname,&xs[10],PATHLEN);
					if (direxist(pathname)) {
/*						ftransinfo("no directory by that name ");*/
						netwrite(rsnum,"\001 No dir found ",16);
						netpush(rsnum);
						cnt = -1;
						break;
					}

					isdir = 1;
					retstate = 20; curstate = 50;
					waitchar = '\012'; waitpos = 0;

					ga();		/* ready for them to start */
					break;
				}
/*
* target could be a directory or a complete file spec
*/
				if (!strncmp(&xs[4],"-t",2)) {
					strncpy(pathname,&xs[7],PATHLEN);
					if (!direxist(pathname)) 
						isdir = 1;
					else
						isdir = 0;

					retstate = 20 ; curstate = 50;
					waitchar = '\012'; waitpos = 0;

					ga();			/* ready for rcp to start */
					break;
				}
/*
*  rcp is requesting me to transfer file(s) (or giving directory name)
*/
				if (!strncmp(&xs[4],"-f",2)) {
					strncpy(pathname,&xs[7],PATHLEN);

/*
*  direxist returns whether the path spec refers to a directory, and if
*  it does, prepares it as a prefix.  Therefore, if it is a dir, we append
*  a '*' to it to wildcard all members of the directory.
*  Firstname() takes a file spec (with wildcards) and returns a pointer
*  to a prepared ACTUAL file name.  nextname() returns successive ACTUAL
*  filenames based on firstname().
*/
					if (!direxist(pathname)) {
						i = strlen(pathname);
						pathname[i] = '*';		/* all members of directory*/
						pathname[++i] = '\0';
					}
					nextfile = firstname(pathname);

					if (nextfile == NULL) {
/*						ftransinfo(" file or directory not found ");*/
						netwrite(rsnum,"\001 File not found ",18);
						netpush(rsnum);
						cnt = -1;
					}
					else {
						/* wait for other side to be ready */
						retstate = 30;	curstate = 50;
						waitchar = 0; waitpos = 0;
					}
					break;
				}
			}

			break;

		case 20:
			xs[waitpos] = '\0';		/* add terminator */

/*
*  get working values from command line just received
*  open file for receive
*/
			if (xs[0] != 'C' || xs[5] != ' ') {
/*				ftransinfo(" Cannot parse filename line "); */
				netwrite(rsnum,"\001 Problem with file name ",26);
				cnt = -1;
				break;
			}

			filelen = atol(&xs[6]);

			for (i = 6; xs[i] != ' '; i++) 
				if (!xs[i]) {
/*					ftransinfo(" premature EOL ");*/
					netwrite(rsnum,"\001 Problem with file name ",26);
					cnt = -1;
					break;
				}

			strcpy(newfile,pathname);		/* path spec for file */

			if (isdir)						/* add file name for wildcards */
				strcat(newfile,&xs[++i]);
#if  defined(__TURBOC__)||defined(_MSC_)
                        if (0 > (fh = open(newfile,O_CREAT|O_BINARY|O_TRUNC,S_IREAD|S_IWRITE))) {
#else
			if (0 > (fh = creat(newfile,O_RAW))) {
#endif
				netwrite(rsnum,"\001 Cannot open file for write ",29);
				cnt = -1;
				break;
			}
			netputevent(USERCLASS,RCPBEGIN,-1);
			ga();							/* start sending the file to me */
			xp = len = 0;
			curstate = 21;					/* receive file, fall through */
			break;

		case 21:
			do {
			/* wait until xs is full before writing to disk */
				if (len <= 0) {
					if (xp) {
						write(fh,xs,xp);
						xp = 0;
					}
					if (filelen > (long)BUFFERS)
						len = BUFFERS;
					else
						len = (int)filelen;
				}

				cnt = netread(rsnum,&xs[xp],len);

				filelen -= (long)cnt;
				len -= cnt;
				xp += cnt;

/*				printf(" %ld %d %d %d ",filelen,len,xp,cnt);
				n_row(); n_puts(""); */

				if (filelen <= 0L || cnt < 0) {
					write(fh,xs,xp);		/* write last block */
					close(fh);
					fh = 0;
					
					/* wait for NULL byte at end after closing file */
					curstate = 50;  retstate = 22;
					waitchar = 0;   waitpos = 0;
					break;
				}

			} while (cnt > 0);
			break;

		case 22:
			/* cause next sequence of bytes to be saved as next filename
				to transfer     */
			ga();			/* tell other side, I am ready */
			waitchar = '\012'; waitpos = 0;
			curstate = 50; retstate = 20;
			break;

/*
*  transfer file(s) to the sun via rcp
*/
		case 30:
#if  defined(__TURBOC__)||defined(_MSC_)
                        if (0 > (fh = open(nextfile,O_BINARY|O_RDONLY))) {
#else                        
			if (0 > (fh = open(nextfile,O_RAW))) {
#endif
				netwrite(rsnum,"\001 File not found ",19);
/*				ftransinfo("Cannot open file to transfer: ");
				ftransinfo(nextfile); */
				cnt = -1;
				break;
			}
			netputevent(USERCLASS,RCPBEGIN,-1);
			filelen = lseek(fh,0L,2);	/* how long is file? */
			lseek(fh,0L,0);				/* back to beginning */

			for (i=0,j=-1; nextfile[i] ; i++)
				if (nextfile[i] == '\\')
					j = i;

			sprintf(xs,"C0755 %lu %s\012",filelen,&nextfile[j+1]);
			netwrite(rsnum,xs,strlen(xs));	/* send info to other side */

/*			ftransinfo(xs);					 check it */

			retstate = 31; curstate = 50;
			waitchar = 0;  waitpos = 0;

			towrite = xp = 0;
			break;

		case 31:
/*
*   we are in the process of sending the file 
*/
			netputuev(SCLASS,RCPACT,rsnum);		/* keep us alive */

			if (towrite <= xp) {
				towrite = read(fh,xs,BUFFERS);
				xp = 0;
				filelen -= (long)towrite;
			}
			i = netwrite(rsnum,&xs[xp],towrite-xp);
			if (i > 0)
				xp += i;

/*			printf(" %d %d %d %ld\012",i,xp,towrite,filelen);
			n_row();
*/
/*
*  done if:  the file is all read from disk and all sent
*  or other side has ruined connection
*/
			if ((filelen <= 0L && xp >= towrite) || netest(rsnum)) {
				close(fh);
				fh = 0;
				nextfile = nextname();		/* case of wildcards */
				ga(); 
				netputuev(SCLASS,RCPACT,rsnum);
				if (nextfile == NULL)
					retstate = 32;
				else
					retstate = 30;
				curstate = 50;
				waitchar = 0;	waitpos = 0;
			}
			break;
		case 32:
			cnt = -1;
			break;
		case 5:
			break;
		default:
			break;

	}

/*
*  after reading from connection, if the connection is closed,
*  reset up shop.
*/
	if (cnt < 0) {
		if (fh > 0) {
			close(fh);
			fh = 0;
		}
		curstate = 5;
		cnt = 0;
		netclose(rsnum);
		rsnum = -1;
		netputevent(USERCLASS,RCPEND,-1);

		setrshd();					/* reset for next transfer */
	}


}

#endif

/***********************************************************************/
/***********************************************************************/
/***********************************************************************/
/************************************************************************/
/*  ftp section
*   This should be extracted from rcp so that it compiles cleanly
*/

#define CRESP(A)  netwrite(fnum, messs[(A)], strlen(messs[(A)]))

#define FASCII 0
#if	defined(__TURBOC__)||defined(_MSC_)
#define FIMAGE  (O_BINARY)
#undef  FASCII
#define FASCII  (O_TEXT)
#else
#define FIMAGE O_RAW
#endif
#define FAMODE 0
#define FIMODE 1
#define FMMODE 2			/* Mac Binary, when ready */

static int rfstate,
	portnum[8],
	ftpfilemode=FASCII,			/* how to open ze file */
	ftptmode=FAMODE;			/* how to transfer ze file on net */

static uint16 fdport;

setftp()
	{
/*
*  set up to receive a telnet connection for ftp commands
*/
	rfstate = 0;
	ftpstate = 0;
	fnum = netlisten(HFTP);
	ftpenable = 1;

	if (fnum >= 0)				/* signal that events should be caught */
		Sptypes[fnum] = PFTP;

	strcpy(myuser,"unknown");	/* set unknown user name */
}

unsetftp()
	{
	rfstate = 0;
	ftpstate = 0;
	netclose(fnum);
	fnum = -1;
	ftpenable = 0;
}

/***********************************************************************/
/*
*  resident ftp server -- enables initiation of ftp without a username
*  and password, as long as this telnet is active at the same time
*  Now checks for the need of passwords.
*/

static char *messs[] = {
#ifdef	FUNNY_MESSAGES
#ifdef PC
						"220 PC Resident FTP " VERSION " server, ready \015\012",
#else
						"220 Macintosh Resident FTP server, ready \015\012",
#endif
						"451 Error in processing list command \015\012",
						"221 Goodbye. Sorry to see you go.\015\012",						/*2*/
						"200 Friends come and go, but enemies accumulate. \015\012",
						"150 Opening connection (open sesame) \015\012",
						"226 Transfer complete (phew!) \015\012",			/*5*/
						"200 Type set to A, ASCII transfer mode \015\012",
						"200 Type set to I, binary transfer mode \015\012",
						"500 Command not understood, try it again jack! \015\012",		/*8*/
						"200 Okay. A bird in the hand is safer than one overhead. \015\012",
						"230 User logged in \015\012",
						"550 File or Directory not found \015\012",				/*11*/
						"501 Directory not present or syntax error \015\012",
						"250 Chdir okay\015\012",
						"257 \"",
						"\" is the current directory \015\012",		/*15*/
						"501 File not found \015\012",
						"504 Parameter not accepted, not implemented\015\012",
						"200 Stru F, file structure\015\012",
						"200 Mode S, stream mode\015\012",		/*19*/
						"202 Allocate and Account not required for this server\015\012",
						"501 Cannot open file to write, check for valid name\015\012",
						"530 USER and PASS required to activate me\015\012",
						"331 What's the password? \015\012",      /*23 */
						"530 Login failed, Too bad bud\015\012",
						"200 MacBinary Mode enabled\015\012",
						"200 MacBinary Mode disabled\015\012",  /*26 */
						"552 Disk write error, probably disk full\015\012",
						"214-NCSA Telnet FTP server, supported commands:\015\012",
						"    USER  PORT  RETR  ALLO  PASS  STOR  CWD  XCWD  XPWD  LIST  NLST\015\012",
#ifdef MAC
						"    HELP  QUIT  MODE  TYPE  STRU  ACCT  NOOP  MACB\015\012",  /*30*/
						"    MACB is MacBinary and must be done with TYPE I\015\012",
#else
						"    HELP  QUIT  MODE  TYPE  STRU  ACCT  NOOP  RMD  MKD   DELE\015\012",
						"    A Macintosh version of NCSA Telnet is also available.\015\012",
#endif
						"214 Direct comments and bugs to cutcp-support@dorm.rutgers.edu\015\012", /* 32 */
					/* 33 */ "552 Could not create directory\015\012",
#else
	/* not funny messages */
#ifdef PC
						"220 PC Resident FTP " VERSION " server, ready \015\012",
#else
						"220 Macintosh Resident FTP server, ready \015\012",
#endif
						"451 Error in processing list command \015\012",
						"221 Goodbye. \015\012",						/*2*/
						"200 Command Accepted \015\012",
						"150 Opening connection  \015\012",
						"226 Transfer complete  \015\012",			/*5*/
						"200 Type set to A, ASCII transfer mode \015\012",
						"200 Type set to I, binary transfer mode \015\012",
						"500 Command not understood \015\012",		/*8*/
						"200 Okay. \015\012",
						"230 User logged in \015\012",
						"550 File or Directory not found \015\012",				/*11*/
						"501 Directory not present or syntax error \015\012",
						"250 Chdir okay\015\012",
						"257 \"",
						"\" is the current directory \015\012",		/*15*/
						"501 File not found \015\012",
						"504 Parameter not accepted, not implemented\015\012",
						"200 Stru F, file structure\015\012",
						"200 Mode S, stream mode\015\012",		/*19*/
						"202 Allocate and Account not required for this server\015\012",
						"501 Cannot open file to write, check for valid name\015\012",
						"530 USER and PASS required to activate me\015\012",
						"331 Password required. \015\012",      /*23 */
						"530 Login failed, check password.\015\012",
						"200 MacBinary Mode enabled\015\012",
						"200 MacBinary Mode disabled\015\012",  /*26 */
						"552 Disk write error, probably disk full\015\012",
						"214-NCSA Telnet FTP server, supported commands:\015\012",
						"    USER  PORT  RETR  ALLO  PASS  STOR  CWD  XCWD  XPWD  LIST  NLST\015\012",
#ifdef MAC
						"    HELP  QUIT  MODE  TYPE  STRU  ACCT  NOOP  MACB\015\012",  /*30*/
						"    MACB is MacBinary and must be done with TYPE I\015\012",
#else
						"    HELP  QUIT  MODE  TYPE  STRU  ACCT  NOOP  RMD  MKD   DELE\015\012",
						"    A Macintosh version of NCSA Telnet is also available.\015\012",
#endif
						"214 Direct comments and bugs to cutcp-support@dorm.rutgers.edu\015\012", /* 32 */
					/* 33 */ "552 Could not create directory\015\012",
#endif
				""};

rftpd(code)
	int code;
	{
	int i;

	if (!ftpenable)
		return(0);

	netpush(fnum);

	switch (rfstate) {
		case 0:
			if (code != CONOPEN) 
				break;
			ftpfilemode = FASCII;
			ftptmode = FAMODE;
			netputevent(USERCLASS,FTPCOPEN,-1);
			rfstate = 1;				/* drop through */
			set_file_buffer(ALLOC_BUFFER);

#ifdef	__TURBOC__
			olddisk = getdisk();
		 	getcwd(olddir,128);
#ifdef	DEBUG
			printf("\n\nolddisk %d, olddir '%s'\n",olddisk, olddir);
#endif
#else
#ifdef	_MSC_
      			_dos_getdrive(&olddisk);
		 	getcwd(olddir, 64);

#endif
#endif

		case 1:
			CRESP(0);
			netgetftp(portnum,fnum);	/* get default ftp information */
			for (i=0; i<4; i++)			/* copy IP number */
				hisuser[i] = portnum[i];
			fdport = portnum[6]*256+portnum[7];

			waitpos = 0; waitchar = '\012';
			rfstate = 50;       		/* note skips over */
			if (Sneedpass()) 
				retstate = 3;				/* check pass */
			else
				retstate = 5;				/* who needs one ? */
			break;
		case 3:				/* check for passwords */
		case 4:
			waitpos = 0;  waitchar = '\012';
			rfstate = 50;  
			if (!strncmp("USER",xs,4)) {
				strncpy(myuser,&xs[5],16);		/* keep user name */
				netputevent(USERCLASS,FTPUSER,-1);
				CRESP(23);
				retstate = 4;		/* wait for password */
				break;
			}
			if (!strncmp("PASS",xs,4)) {
				if (Scheckpass(myuser,&xs[5])) {
					netputevent(USERCLASS,FTPPWOK,-1);
					CRESP(10);
					retstate = 5;
				}
				else {
					netputevent(USERCLASS,FTPPWNO,-1);
					CRESP(24);
					retstate = 3;
				}
				break;
			}
			if (!strncmp("QUIT",xs,4)) {
				CRESP(2);
				cnt = -1;
			}
			else
				CRESP(22);
			retstate = 3;			/* must have password first */
			break;				
				
/*
*  interpret commands that are received from the other side
*/
			
		case 5:
#ifdef PC
			for (i=4; i< strlen(xs); i++)
				if (xs[i] == '/')		/* flip slashes */
					xs[i] = '\\';
#endif

/*
*  set to a safe state to handle recursion
*  wait for another command line from client
*  
*/
			rfstate = 50; retstate = 5;
			waitchar = '\012';  waitpos = 0;

			if (!strncmp(xs,"LIST",4) || !strncmp(xs,"NLST",4)) {
                                if(!strncmp(xs,"NLST",4))
                                        listmode = -1;
                                else
                                        listmode = 0;
				if ((strlen(xs) < 6) || xs[5] == '.')
					strcpy(xs,"LIST *");

				nextfile = firstname(&xs[5],listmode);	/* find first name */
				if (nextfile == NULL) {
					CRESP(16);
				}
				else {
					ftpgo();			/* open the connection */
					fdport = portnum[6]*256+portnum[7]; /* reset to def */
					if (ftpdata >= 0)
						Sptypes[ftpdata] = PDATA;
					ftpstate = 40;		/* ready to transmit */
					CRESP(4);
					netputevent(USERCLASS,FTPLIST,-1);
				}
			}
			else if (!strncmp(xs,"CWD",3)) {
				if (chgdir(&xs[4])) 			/* failed */
					CRESP(12);
				else						/* success */
					CRESP(13);
			}
		 	else if (!strncmp(xs,"DELE", 4)) {	/* delete file */
			        if(unlink(&xs[5]))
				       	CRESP(11);
				 else
					CRESP(9);
			 }
		  	else if(!strncmp(xs, "MKD", 3)) {
			       	if(mkdir(&xs[4]))
				       CRESP(33);
				else
				       CRESP(9);
			}
		 	else if(!strncmp(xs, "RMD", 3)) {
			       	if(rmdir(&xs[4]))
				       CRESP(11);
				else
				       CRESP(9);
			}
			else if (!strncmp(xs,"STOR",4)) {

#ifdef MACBINARY
				if ((mbfp = MBopen(&xs[5],0,MB_WRITE +
					(((!MacBinary) || (ftptmode == FAMODE)) ? MB_DISABLE : 0
					))) == 0L) {
					CRESP(21);
					break;
				}
				else
					ftpfh = 12;
#else
#if  defined(__TURBOC__)||defined(_MSC_)
                                if (0 > (ftpfh = open(&xs[5],ftpfilemode|O_WRONLY|O_CREAT|O_TRUNC,S_IREAD|S_IWRITE))) {
#ifdef  DEBUGPC
                                perror("ftp STOR open");
#endif
#else
				if (0 > (ftpfh = creat(&xs[5],ftpfilemode))) {
#endif
					CRESP(21);
					break;
				}
#endif

				ftpstate = 0;

				strncpy(newfile,&xs[5],PATHLEN-1);

				ftpgo();				/* open connection */
				fdport = portnum[6]*256+portnum[7]; /* reset to def */
				if (ftpdata >= 0)
					Sptypes[ftpdata] = PDATA;

				CRESP(4);

				ftpstate = 30;		/* ready for data */
			}

			else if (!strncmp(xs,"RETR",4)) {

#ifdef MACBINARY
			if ((mbfp = MBopen( &xs[5], 0, MB_READ + ((!MacBinary) ||
				(ftptmode == FAMODE)) ? MB_DISABLE : 0)) == 0L) {
				CRESP(11);
				break;
			}
			ftpfh = 12;
#else
#if  defined(__TURBOC__)||defined(_MSC_)
				if (0 > (ftpfh = open(&xs[5],ftpfilemode|O_RDONLY))) {
#else
				if (0 > (ftpfh = open(&xs[5],ftpfilemode))) {
#endif
					CRESP(11);
					break;
				}
#endif
				strncpy(newfile,&xs[5],PATHLEN-1);

				ftpgo();				/* open connection */
				fdport = portnum[6]*256+portnum[7]; /* reset to def */

				ftpstate = 20;		/* ready for data */
				if (ftpdata >= 0)
					Sptypes[ftpdata] = PDATA;

				CRESP(4);
			}
			else if (!strncmp(xs,"TYPE",4)) {
				if (toupper(xs[5]) == 'I') {
					ftpfilemode = FIMAGE;
					ftptmode = FIMODE;
					CRESP(7);
				}
				else if (toupper(xs[5]) == 'A') {
					ftpfilemode = FASCII;
					ftptmode = FAMODE;
					CRESP(6);
				}
				else
					CRESP(17);

			}
#ifdef MACBINARY
			else if (!strncmp(xs,"MACB",4)) {
				if (toupper(xs[5]) == 'E') {
					MacBinary = 1;
					CRESP(25);
				}
				else {
					MacBinary = 0;
					CRESP(26);
				}
				DisplayMacBinary();			/* post an event ? */
			}
#endif
			else if (!strncmp(xs,"PORT",4)) {
/*
* get the requested port number from the command given
*/
				sscanf(&xs[5],"%d,%d,%d,%d,%d,%d",&portnum[0],&portnum[1],
				&portnum[2],&portnum[3],&portnum[4],&portnum[5]);
				fdport = portnum[4]*256+portnum[5];
				CRESP(3);
			}
			else if (!strncmp(xs,"QUIT",4)) {
				CRESP(2);
				rfstate = 60;
				netputuev(CONCLASS,CONDATA,fnum);	/* post back to me */
			}
			else if (!strncmp(xs,"XPWD",4) || !strncmp(xs,"PWD",3)) {
				CRESP(14);						/* start reply */
				dopwd(xs,1000);					/* get directory */
				netwrite(fnum,xs,strlen(xs));	/* write dir name */
				CRESP(15);						/* finish reply */
			}
			else if (!strncmp(xs,"USER",4)) {
				strncpy(myuser,&xs[5],16);		/* keep user name */
				netputevent(USERCLASS,FTPUSER,-1);
				/* confirm log in without password */
				CRESP(10);
			}
			else if (!strncmp(xs,"STRU",4)) {	/* only one stru allowed */
				if (xs[5] == 'F') 
					CRESP(18);
				else
					CRESP(17);
			}
			else if (!strncmp(xs,"MODE",4)) {	/* only one mode allowed */
				if (xs[5] == 'S') 
					CRESP(19);
				else
					CRESP(17);
			}
			else if (!strncmp(xs,"ALLO",4) || !strncmp(xs,"ACCT",4))
				CRESP(20);
			else if (!strncmp(xs,"HELP",4)) {
				for (i=28; i<33; i++)
					CRESP(i);
			}
			else if (!strncmp(xs,"NOOP",4)) 
				CRESP(9);
			else			/* command not understood */
				CRESP(8);

			break;

/*
*  subroutine to wait for a particular character
*/
		case 50:
			while (0 < (cnt = netread(fnum,&xs[waitpos],1))) {
				if (xs[waitpos] == waitchar) {
					rfstate = retstate;

					while (xs[waitpos] < 33)		/* find end of string */
						waitpos--;
					xs[++waitpos] = '\0';			/* put in terminator */

					for (i=0; i<4; i++)				/* want upper case */
						xs[i] = toupper(xs[i]);

					break;
				}
				else
					waitpos += cnt;

			}
			break;

		case 60:					/* wait for message to get through */
									/* or connection is broken */
/*			printf("                  %d,%d",netpush(fnum),netest(fnum));*/
			if (!netpush(fnum) || netest(fnum))
				cnt = -1;
			else
				netputuev(CONCLASS,CONDATA,fnum);	/* post back to me */
			break;

		default:
			break;

	}

	if (cnt < 0) {
		if (ftpfh > 0) {
#ifdef MACBINARY
			MBclose( mbfp );
#else
			close(ftpfh);
#endif
			ftpfh = 0;
		}
		if (ftpdata > 0) {
			netclose(ftpdata);
			netputevent(USERCLASS,FTPEND,-1);
		}
		rfstate = 100;
		ftpstate = 0;
		cnt = 0;
		netclose(fnum);
		netputevent(USERCLASS,FTPCLOSE,-1);
		fnum = -1;
		ftpdata = -1;
		setftp();				/* reset it */
		set_file_buffer(FREE_BUFFER);

#ifdef	__TURBOC__
		setdisk(olddisk);
	 	chdir(olddir);
#ifdef	DEBUG
	printf("chdir '%s' errno %d\n",olddir,errno);
#endif
#else
#ifdef	_MSC_
	{
		int junk;

		_dos_setdrive(olddisk, &junk);
		chdir(olddir);
	}
#endif
#endif
	}

}

/***********************************************************************/
/* ftpgo
*  open the FTP data connection to the remote host
*/
ftpgo()
	{
	int savest;
	struct machinfo *m;

	xs[0] = portnum[0];
	xs[1] = portnum[1];
	xs[2] = portnum[2];
	xs[3] = portnum[3];

	netfromport(20);	 /* ftp data port */

	if (NULL == (m = Slookip(xs))) {		/* use default entry */
		if (NULL == (m = Shostlook("default")))
			return(0);
		savest = m->mstat;
		m->mstat = HAVEIP;
		movebytes(m->hostip,xs,4);
		ftpdata = Snetopen(m,fdport);
		m->mstat = savest;
		movebytes(m->hostip,"\0\0\0\0",4);
		return(0);
	}

	ftpdata = Snetopen(m,fdport);

}

/*********************************************************************/
/*
*  FTP receive and send file functions
*/
static int fcnt=0;

ftpd(code,curcon)
	int code,curcon;
	{
	int i;

	if (curcon != ftpdata)		/* wrong event, was for someone else */
		return(0);

	switch (ftpstate) {
		default:
			break;

		case 40:				/* list file names in current dir */

			if (code == CONFAIL)	/* something went wrong */
				fcnt = -1;
			if (code != CONOPEN) 	/* waiting for connection to open */
				break;
			
			ftpstate = 41;

/*
*  send the "nextfile" string and then see if there is another file
*  name to send
*/
		case 41:
			netputuev(SCLASS,FTPACT,ftpdata);
			netpush(ftpdata);
                        if(listmode) {
                                char *c;
                                c = strchr(nextfile,' ');
                                if(c)
                                        *c = 0; /* chop off the directory information if NLST */
                        }
			i = strlen(nextfile);
			if(netroom(ftpdata) < i + 2)
			       	break;
                        if(*(nextfile+i-1) != '.') {  /* don't show this dir or upper directory */
        			if (i != netwrite(ftpdata,nextfile,i)) {
         				CRESP(1);
      	 				fcnt = -1;
      					break;
        			}
        			netwrite(ftpdata,"\015\012",2);
                        }
			if (NULL == (nextfile = nextname(listmode))) {	/* normal end */
			        extern long freediskspace();
			 	long count;

				if(!listmode && (count = freediskspace()) > -1) {
				       	char buff[80];

					sprintf(buff,"          %ld Bytes Available\r\n",count);
					netwrite(ftpdata, buff, strlen(buff));
				}
				ftpstate = 22;   			/* push data through */
			}
		 	break;
			
		case 30:
			if (code == CONFAIL)	/* something went wrong */
				fcnt = -1;
			if (code != CONOPEN)	/* waiting for connection to open */
				break;
			ftpstate = 31;
			crfound = 0;
			len = xp = 0;
			file_ptr = file_buffer;
			filelen = 0L;
			netputevent(USERCLASS,FTPBEGIN,-2);
			break;
		case 31:
/*
* file has already been opened, take everything from the connection
* and place into the open file: ftpfh
*/
			do {
			/* wait until xs is full before writing to disk */
				if (len == 0 || ((ftptmode == FAMODE) && len < 2048)) {

					if (xp) {
#ifdef MACBINARY
						if (0 > MBwrite(mbfp, file_buffer, xp)) {
							netclose(ftpdata);
							fcnt = -1;
							CRESP(27);
							break;
						}
#else
#ifdef	DEBUG
	nprintf(CONSOLE,"Write %d\n",xp);
#endif
						if (xp > write(ftpfh,file_buffer,xp)) { /* disk full err */
							netclose(ftpdata);
							fcnt = -1;
							CRESP(27);
							close(ftpfh);
							ftpfh = 0;
							break;
						}
#endif
						xp = 0;
					}
				 	file_ptr = file_buffer;
					len = buffer_size;		/* expected or desired len to go */
				}

				if (ftptmode == FAMODE)
					fcnt = Sfread(ftpdata,file_ptr,len > 0x7fff ? 0x7fff : len);
				else
					fcnt = netread(ftpdata,file_ptr,len > 0x7fff ? 0x7fff : len);

				if (fcnt > 0) {
				       	xp += fcnt;
					len -= fcnt;
					file_ptr += fcnt;
					filelen += fcnt;
				}
#ifdef	DEBUGX
				nprintf(CONSOLE,"len  %d  xp %d fcnt %d \012",len,xp,fcnt);
#endif
				n_row();  

				if (fcnt < 0) {
#ifdef MACBINARY
					if (0 > MBwrite( mbfp, file_buffer, xp)) {
						CRESP(27);
						break;
					}
					MBclose( mbfp );
#else
					if (xp > write(ftpfh,file_buffer,xp)) { /* disk full check */
						CRESP(27);
						break;
					}
					close(ftpfh);
#endif
					ftpfh = 0;
					CRESP(5);
				}

			} while (fcnt > 0);
			break;

		case 20:

			if (code == CONFAIL)	/* something went wrong */
				fcnt = -1;
			if (code != CONOPEN)	/* waiting for connection to open */
				break;
			ftpstate = 21;
#ifndef MACBINARY
			filelen = lseek(ftpfh,0L,2);	/* how long is file? */
			lseek(ftpfh,0L,0);				/* back to beginning */
#endif
			towrite = 0;
			xp = 0;
			file_ptr = file_buffer;
			netputevent(USERCLASS,FTPBEGIN,-1);

		case 21:
/*
*  transfer file(s) to the other host via ftp request
*  file is already open = ftpfh
*/
			netputuev(SCLASS,FTPACT,ftpdata);
		
			if (towrite == 0) { /* was <= xp */

				i = buffer_size;
#ifdef MACBINARY
				towrite = MBread( mbfp,file_buffer, i);
#else
#ifdef  XBUG
        printf("FTPGO case 21 reading %d bytes to %lp for %d\n",i,file_buffer,ftpdata);
        n_row();
#endif
				towrite = read(ftpfh,file_buffer,i);
#ifdef  XBUG
        printf("FTPGO case 21 read %d bytes\n",towrite);
        n_row();
#endif

#endif
				xp = 0;
			 	file_ptr = file_buffer;
			}
			if (!towrite || netest(ftpdata)) {		/* we are done */
#ifdef	DEBUGXY
		nprintf(CONSOLE,"towrite is %x, state now 22\n",towrite);
#endif
				ftpstate = 22;
				break;
			}

			if (ftptmode == FAMODE)
				i = Sfwrite(ftpdata,file_ptr,towrite > 0x7fff ? 0x7fff : towrite);
			else
				i = netwrite(ftpdata,file_ptr,towrite > 0x7fff ? 0x7fff: towrite);

#ifdef  XBUG
        printf("FTPGO case 21 wrote %d bytes on channel, wanted %d on %d\n",i,towrite-xp,ftpdata);
        n_row();  

#endif
                        netpush(ftpdata);
/* #### */
/*			printf(" wrote %d sent %d to go %d wanted %d at %ld\012",i,xp,towrite,towrite-xp,(long) time(NULL)); */

			if (i > 0) {
				xp += i;
				file_ptr += i;
				filelen -= i;
				towrite -= i;
				if (filelen < 0L)
					filelen = 0L;
			}

			break;

		case 22:		/* wait for data to be accepted */
			netputuev(SCLASS,FTPACT,ftpdata);

			fcnt = netpush(ftpdata);		/* will go negative on err */
			if (!fcnt || netest(ftpdata))
				fcnt = -1;
			if (fcnt < 0)
				CRESP(5);
			break;

		case 0:
			break;

	}  /* end of switch */

/*
*  after reading from connection, if the connection is closed,
*  reset up shop.
*/
	if (fcnt < 0) {
		if (ftpfh > 0) {
			close(ftpfh);
			ftpfh = 0;
		}
		ftpstate = 0;
		fcnt = 0;
		if (ftpdata >= 0) {
			netclose(ftpdata);
			netputevent(USERCLASS,FTPEND,-1);
			ftpdata = -1;
		}
	}

}


/***************************************************************************/
/*  Sfwrite
*   Write an EOL translated buffer into netwrite.
*   Returns the number of bytes which were processed from the incoming
*   buffer.  Uses its own 1024 byte buffer for the translation (with Sfread).
*/

Sfwrite(pnum,buf,nsrc)
	int pnum,nsrc;
	char *buf;
	{
	int i,ndone,nout,lim;
	char *p,*q;
        char    mungbuf[1024];

	ndone = 0;

	while (ndone < nsrc) {

		if (0 > ( i = netroom(pnum)))
			return(-1);

		if (i < 1024)					/* not enough room to work with */
			return(ndone);
/*
*  process up to 512 source bytes for output (could produce 1K bytes out) 
*/
		if (nsrc - ndone > 512)
			lim = 512;
		else
			lim = nsrc-ndone;

		p = buf + ndone;				/* where to start this block */
		q = mungbuf;					/* where munged stuff goes */
		for (i=0; i < lim; i++) {
			if (*p == EOLCHAR) {
				*q++ = 13;
				*q++ = 10;
				p++;
			}
			else
				*q++ = *p++;
		}
		ndone += lim;					/* # of chars processed */
		nout = q-mungbuf;				/* # of chars new */

		netwrite(pnum,mungbuf,nout);	/* send them on their way */

	}

	return(ndone);
}

/*
*  important note:  for Sfread, nwant must be 256 bytes LARGER than the amount
*  which will probably be read from the connection.
*  Sfread will stop anywhere from 0 to 256 bytes short of filling nwant
*  number of bytes.
*/
Sfread(pnum,buf,nwant)
	int pnum,nwant;
	char *buf;
	{
	int i,ndone,lim;
	char *p,*q;
        char mungbuf[1024];

	if (nwant < 1024)
		return(-1);

	ndone = 0;

	while (ndone < nwant - 1024) {		/* bugfix 6/88 - TK (added -1024) */

		if (0 >= (lim = netread(pnum,mungbuf,1024))) {
			if (ndone || !lim)			/* if this read is valid, but no data */
				return(ndone);
			else
				return(-1);				/* if connection is closed for good */
		}

		p = mungbuf;
		q = buf + ndone;

/*		printf("\012 lim=%d done=%d want=%d",lim,ndone,nwant);
		n_row();
*/
		for (i=0; i < lim; i++) {

			if (crfound) {
				if (*p == 10)
					*q++ = EOLCHAR;
				else if (*p == 0)
					*q++ = 13;			/* CR-NUL means CR */
				else {
					*q++ = 13;
					*q++ = *p;
				}
				crfound = 0;
			}
			else if (*p == 13)
				crfound = 1;
			else 
				*q++ = *p;				/* copy the char */

			p++;
		}

		ndone = q-buf;					/* count chars ready */
	}

	return(ndone);
}

/***********************************************************************/
/* Sftpname and Sftpuser and Sftphost
*  record the name of the file being transferred, to use in the status
*  line updates
*/

Sftpname(s)
	char *s;
	{
	strcpy(s,newfile);
}

Sftpuser(user)
	char *user;
	{
	strcpy(user,myuser);			/* user name entered to log in */
}

Sftphost(host)
	char *host;
	{
	movebytes(host,hisuser,4);		/* IP address of remote host */
}

Sftpstat(byt)
	long *byt;
	{
	*byt = filelen;

}

#ifdef MACBINARY
MBstat()
	{
	return(0);
}
#endif



/***********************************************************************/
/* ftpstart
*  update status line with new file length remaining
*/
ftpstart(dir,buf)
	char dir,*buf;
	{
	int r,c,cl;
	long int fpos;

	r = n_row();
	c = n_col();
	cl = n_color(current->colors[0]);

	if (dir)
		dir = '<';
	else
		dir = '>';

	Sftpname(&buf[100]);	/* get file name */
	Sftpstat(&fpos);		/* get position in file */

	n_cur(NUMLINES+1,36);
	sprintf(buf,"FTP %c %14s %10lu",dir,&buf[100],fpos);

	if (scmode()) 
		n_cheat(buf,strlen(buf));
	else
		n_draw(buf,strlen(buf));

	n_color(cl);
	n_cur(r,c);
	return(0);
}


