// mtcpc.h -- c++ 
#ifndef	_MTCPC_H

const unsigned N_Flags_Initialized = 0x1;
const int      INFO_LENGTH = 64;

const int	Error_No_Driver = -1;
const int	Error_No_IP_Handle = -2;
const int	Error_No_ARP_Handle = -3;

class	Network {		// packet driver for ethernet vector
	char			Packet_Info[INFO_LENGTH];
	unsigned 		Flags;
	unsigned		Packet_Vector;
	unsigned		IP_Handle;
	unsigned		ARP_Handle;
	unsigned char	far	*Raw_Buffer;
	unsigned		Raw_Buffer_Length;
	unsigned char   far	*Raw_Recv_Ptr;
	unsigned char	far	*Raw_Write_Ptr;
	void   far		(*Upcall)(void *data, unsigned length);
	int			Hook();
	int			UnHook();
public:
	int 	Initialize(unsigned vector, unsigned char *buffer, unsigned length);	// true if error, 0 otherwise
	int 	Shutdown();		// true if error, 0 otherwise
	int 	Send(void *packet, int length);
	void   	Register_Upcall( void far (*Upcall)(void *data, unsigned length));
	int	Reserve_Length();	// returns MAC header length
};


#endif