/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/pctools.c_v   1.0   15 Jan 1990 19:26:58   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/pctools.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:26:58   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   pctools.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/


/*
*  pctools.c
****************************************************************************
*                                                                          *
*      part of:                                                            *
*      TCP/UDP/ICMP/IP Network kernel for NCSA Telnet                      *
*      by Tim Krauskopf                                                    *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
****************************************************************************
*
*  those generic tool-type things that only work on PCs.
*  includes all hardware-level calls to Ethernet that are unique to the PC
*
*  Function pointers for Ether calls
*/
#include <stdio.h>
#include <string.h>

#ifdef	_MSC_
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include "protocol.h"
#include "data.h"
#include "mem.h"
#include "windat.h"
#include "newwin.h"
/* #define XDEBUG  1 */
/*
*   defined in assembly language file for interrupt driven Ether buffering
*
*/
extern unsigned char stat;                    /* status from last read */
extern int bufbig,buflim;
extern  int     slip_mode;              /* set in packet.c if slip driver */
unsigned int	rawbuff_size={RAWBUFF_LEN};

int	slip_mode;
/*
*  Declare each and every Ethernet driver.
*  To add a driver, pick a unique 2 char prefix and declare your own
*  routines.  I want to keep the same parameters for EVERY driver.
*  If your driver needs additional parameters, then see netconfig() below 
*  for an indication of where to put custom board code.
*/
#ifdef	MINITEL
#define	MODE	near
#else
#define	MODE	far
#endif
#ifdef	NI5210ONLY
#include	<dos.h>
#undef		MODE
#define	MODE	far
extern int MODE M5etopen();
extern int MODE M5getaddr();
extern int MODE M5recv();
extern int MODE M5xmit();
extern int MODE M5etupdate();
extern int MODE M5etclose();

#endif
extern char MODE *bufpt;
extern char MODE *bufend;
extern char MODE *bufread;
extern char MODE *buforg;

#if	!defined(PONLY) && !defined(NI5210ONLY) && !defined(ODIONLY)
extern int E1etopen(),E1getaddr(),E1setaddr(),E1recv(),E1xmit(),E1etupdate(),E1etclose();
extern int E3etopen(),E3getaddr(),E3setaddr(),E3recv(),E3xmit(),E3etupdate(),E3etclose();
extern int M5etopen(),M5getaddr(),M5recv(),M5xmit(),M5etupdate(),M5etclose();
extern int U1etopen(),U1getaddr(),U1recv(),U1xmit(),U1etupdate(),U1etclose();
extern int U2etopen(),U2getaddr(),U2recv(),U2xmit(),U2etupdate(),U2etclose();
extern int WDetopen(),WDgetaddr(),WDrecv(),WDxmit(),WDetupdate(),WDetclose();
extern int E2etopen(),E2getaddr(),E2recv(),E2xmit(),E2etupdate(),E2etclose();
#endif
#if	!defined(NI5210ONLY) && !defined(ODIONLY)
extern int pketopen(),pkgetaddr(),pkrecv(),pkxmit(),pketupdate(),pketclose();
#endif
#if	defined(ODI)
extern int odetopen(), odgetaddr(), odrecv(), odxmit(), odetupdate(), odetclose();
#endif

int	no_arpme;		/* set if we are not to arp ourselves */

static int (MODE *etopen)()=NULL,	/* open the device */
	(MODE *getaddr)()=NULL,		/* get the Ether address */
	(MODE *setaddr)()=NULL,			/* set the Ether address to use */
	(MODE *recv)()=NULL,				/* load a packet from queue */
	(MODE *etupdate)()=NULL,			/* update pointers in buffer */
	(MODE *etclose)()=NULL,			/* shut down network */
	(MODE *xmit)()=NULL;				/* transmit a packet */


/**********************************************************************/
/*  statcheck
*   look at the connection status of the memory buffers to see if the
*   allocation schemes are working.  Only used as a debug tool.
*/
statcheck(struct twin *t)
	{
	int i;
static char *states[]={"",
		"CLOSED  ",
		"LISTEN  ",
		"TWAIT   ",
		"SYNR    ",
		"SYNS    ",
		"EST     ",
		"CWAIT	 ",
		"FW1     ",
		"FW2     ",
		"CLOSING ",
		"LAST	 "
};
#define	WR(t,s)	VSwrite((t)->vs,(s),strlen((s)))

	char	buffer[120];
	register struct port *p;

	sprintf(buffer,"Port  State     Lport   Rport                   InQBytes  OutQBytes Rto Lasttime\r\n");
	if(!t)
	       	nprintf(CONSOLE,"%s",buffer);
	else
		WR(t,buffer);

	for (i=0; i< NPORTS; i++) {
		p = portlist[i];
		if (p != NULL) {
		       	long now;

			now = n_clicks(NULL);
			if(!p->nextstate)
			sprintf(buffer,"% 2d    %s % 6d  % 3d.%03d.%03d.%03d:%-6d     % 5d    % 5d   % 3d % 7ld\r\n",

			       	i,p->flags & PORT_FLAGS_LOOPBACK ? "LOOPBACK" : states[p->state],intswap(p->tcpout.t.source),
				p->tcpout.i.ipdest[0],
				p->tcpout.i.ipdest[1],
				p->tcpout.i.ipdest[2],
				p->tcpout.i.ipdest[3],
				intswap(p->tcpout.t.dest), p->in.contain, p->out.contain,p->rto, now - p->out.lasttime);
			 else
			sprintf(buffer,"\033[1m% 2d    %s % 6d  % 3d.%03d.%03d.%03d:%-6d     % 5d    % 5d * %3d %s\033[m\r\n",

			       	i,p->flags & PORT_FLAGS_LOOPBACK ? "LOOPBACK" : states[p->state],intswap(p->tcpout.t.source),
				p->tcpout.i.ipdest[0],
				p->tcpout.i.ipdest[1],
				p->tcpout.i.ipdest[2],
				p->tcpout.i.ipdest[3],
				intswap(p->tcpout.t.dest), p->in.contain, p->out.contain, (int) (p->alarm - time(NULL)), states[p->nextstate]);

			if(!t)
			       	nprintf(CONSOLE,"%s",buffer);
			else
			       	WR(t,buffer);
		 }

	}
}

/*************************************************************************/
/*  config network parameters
*   Set IRQ and DMA parameters for initialization of the 3com adaptor
*/
static int nnirq=3,nnaddr=0xd000,nnioaddr=0x300;

netparms(irq,address,ioaddr)
	int irq,address,ioaddr;
	{

	nnirq = irq;
	nnaddr = address;
	nnioaddr = ioaddr;

	return(0);
}

/**********************************************************************/
/* netconfig
*  load the function pointers for network access
*  Currently setaddr() is not used, so it isn't loaded.
*
*  Note that netparms is called BEFORE netconfig.  So if you have any
*  really special variables to set for your board that involve
*  irq,address and ioaddr, you can add calls to your special routines
*  in this section.
*
*  Some drivers will do the interrupt driver and board initialization
*  in etopen() and some will do it in getaddr().
*/
netconfig(s)
	char *s;
	{
#if	defined(ODI)
        if (!strncmp(s,"odi",3)) {
                etopen = odetopen;
                xmit   = odxmit;
                recv   = odrecv;
                getaddr = odgetaddr;
                etupdate = odetupdate;
                etclose = odetclose;
        }
#endif
#if	defined(ODI) && !defined(ODIONLY)
	else
#endif
#if	!defined(NI5210ONLY) && !defined(ODIONLY)
      	if (!strncmp(s,"packet",6)) {
                etopen = pketopen;
                xmit   = pkxmit;
                recv   = pkrecv;
                getaddr = pkgetaddr;
                etupdate = pketupdate;
                etclose = pketclose;

        }
#endif

#if	!defined(PONLY) && !defined(NI5210ONLY) && !defined(ODIONLY)
     	else if (!strncmp(s,"ni5",3) || !strncmp(s,"mi",2)) {
		etopen = M5etopen;
		xmit = M5xmit;
		recv = M5recv;
		getaddr = M5getaddr;
		etupdate = M5etupdate;
		etclose = M5etclose;
/*
*   special initialization call would go here
*/
	}
	else if (!strncmp(s,"nicps",5)) {
		etopen = U2etopen;
		xmit = U2xmit;
		recv = U2recv;
		getaddr = U2getaddr;
		etupdate = U2etupdate;
		etclose = U2etclose;
	}
	else if (!strncmp(s,"nicpc",5) || !strncmp(s,"pcnic",5)) {
		etopen = U1etopen;
		xmit = U1xmit;
		recv = U1recv;
		getaddr = U1getaddr;
		etupdate = U1etupdate;
		etclose = U1etclose;
	}
	else if (!strncmp(s,"wd",2) || !strncmp(s,"800",3)) {
		etopen = WDetopen;
		xmit = WDxmit;
		recv = WDrecv;
		getaddr = WDgetaddr;
		etupdate = WDetupdate;
		etclose = WDetclose;
	}
	else if (!strncmp(s,"3c523",5) || !strncmp(s,"523",3)) {
		etopen = E2etopen;
		xmit = E2xmit;
		recv = E2recv;
		getaddr = E2getaddr;
		etupdate = E2etupdate;
		etclose = E2etclose;
	}
	else if (!strncmp(s,"r501",4)) {		/* special reserve driver */
		etopen = E3etopen;
		xmit = E3xmit;
		recv = E3recv;
		getaddr = E3getaddr;
		etupdate = E3etupdate;
		etclose = E3etclose;
	}
	else if (!strncmp(s,"3c",2)) {		/* default choice */
		etopen = E1etopen;
		xmit = E1xmit;
		recv = E1recv;
		getaddr = E1getaddr;
		etupdate = E1etupdate;
		etclose = E1etclose;
	}
#endif
#ifndef	PONLY
        else {
#if	defined(ODIONLY)
	printf("Error: This version supports hardware=odi only!\n");
#else
                printf("Error: Unrecognized Hardware type in config.tel\n"
                        "Valid types are:\n\t3com\n\tni5210 or micom\n\tpacket\n"
                        "\tnicps\n\tnicpc or pcnic\n\twd8003 or 8003\n\t3c523 or 523\n"
                        "\tr501\n\todi\n");
#endif
#else
	else {	
		printf("This version recognizes hardware=packet only!\n");
#endif
                exit(1);
        }
	return(0);
}

/**********************************************************************/
/*  netarpme
*   send an arp to my address.  arpinterpret will notice any response.
*   Checks for adapters which receive their own broadcast packets.
*/
netarpme(s)
	char *s;
	{
        if(slip_mode || no_arpme)
                return(0);
#if	!defined(PONLY) && !defined(NI5210ONLY) && !defined(ODIONLY)
	if (etopen == U2etopen)
		return(0);
	if (etopen == U1etopen)
		return(0);
#endif
	reqarp(s);		/* send it */

	return(0);
}


/**********************************************************************/

initbuffer()
	{

        char *raw;

#if	!defined(ODIONLY)
        raw = mem_malloc(rawbuff_size+1520);
        if(!raw) {
                fprintf(stderr,"Error. Can't allocate Rawbuffer, not enough memory\n");
                exit(1);
        }
#ifdef	NI5210ONLY
	bufend = MK_FP(_DS,raw + rawbuff_size);        		/* leave 512bytes breathing room, required */
	bufpt  =  MK_FP(_DS,raw);	/*  start at the beginning */
	bufread  = MK_FP(_DS,raw);
	buforg = MK_FP(_DS,raw);
#else
	bufpt = bufread = buforg = raw;	/*  start at the beginning */

	bufend = raw + rawbuff_size;        		/* leave 512bytes breathing room, required */
#endif
	buflim = rawbuff_size;                      /* 1K breathing room */
#endif
#ifdef	NI5210ONLY
	{
		char far *x = MK_FP(_DS, nnmyaddr);
		(*getaddr)((char far *) x,nnaddr, nnioaddr);
	}
#else
	(*getaddr)(nnmyaddr,nnaddr,nnioaddr);
#endif
	return(0);
}

/**********************************************************************/
/*   demux
*      find the packets in the buffer, determine their lowest level
*  packet type and call the correct interpretation routines
*
*  the 'all' parameter tells demux whether it should attempt to empty
*  the input packet buffer or return after the first packet is dealt with.
*
*  returns the number of packets demuxed
*/
demux(all)
	int all;
	{
	uint16 getcode;
	int nmuxed;
	DLAYER *firstlook;

	nmuxed = 0;
	if (!etupdate)					/* check that network is hooked up */
		return(0);

	do {							/* while all flag is on */

		(*recv)();					/* NULL operation for 3COM */

		if (bufbig > 0) {

			nmuxed++;
#ifdef	NI5210ONLY
			firstlook = (DLAYER *) (FP_OFF(bufread)+2); 	/* where packet is */
#else
			firstlook = (DLAYER *)(bufread+2); 	/* where packet is */
#endif
			getcode = firstlook->type;			/* where does it belong? */

#ifdef  XDEBUG
                printf("Pkt Demux type %04x",getcode);
#endif
			switch (getcode) {					/* what to do with it? */
				case EARP:
				case ERARP:
					arpinterpret(firstlook);	/* handle ARP packet */
					break;
				case EIP:
					ipinterpret(firstlook);
					break;
				default:
					break;
			}

			(*etupdate)();   		/* update read pointers in buffer, free packet */

		}
		else 
			all = 0;


	} while (all);			/* should we look for more to deal with? */


	return(nmuxed);          /* no packets anymore */

}

/************************************************************************/
/*  dlayersend
*
*  usage:   err = dlayersend(ptr,size)
*      err = 0 for successful, non-zero error code otherwise
*      ptr is to a dlayer packet header
*      size is the number of bytes total
*
*  This particular dlayer routine is for Ethernet.  It will have to be
*  replaced for any other dlayer.
*
*  Ethernet addresses are resolved at higher levels because they will only
*  need to be resolved once per logical connection, instead of once per
*  packet.  Not too layer-like, but hopefully modular.
*
*/

dlayersend(ptr,size)
	DLAYER *ptr;
	unsigned size;
	{
	int ret;

#ifdef  XDEBUG
                { char xx[80]; 
                   nprintf(CONSOLE,"dlayer send %d bytes\n",size);
                }
#endif
#ifdef	NI5210ONLY
	{
	  DLAYER far *x = MK_FP(_DS, ptr);
	  ret = (*xmit) (x, size);
	  return(ret);
	}
#else
	ret = (*xmit)(ptr,size);	/* send it out, pass back return code */
								/* xmit checks for size < 60 */

/*
*   automatic, immediate retry once
*/
	if (ret) {
		if (ret == (*xmit)(ptr,size))
			nnerror(100);		/* post user error message */
	}

	return(ret);
#endif
}

/***************************************************************************/
/* dlayerinit
*  Do machine dependent initializations of whatever hardware we have
*  (happens to be ethernet board here ) 
*/
dlayerinit()
	{

	if (initbuffer() || !etopen){
		return(-1);
	}
#ifdef	NI5210ONLY
	{
		char far *x = MK_FP(_DS, nnmyaddr);
		return((*etopen) ((char far *) x, nnirq, nnaddr, nnioaddr));
	}
#else

	return((*etopen)(nnmyaddr,nnirq,nnaddr,nnioaddr));
#endif
}

dlayershut()
	{
	if (etclose)
		(*etclose)();
}

/***************************************************************************/
/*  pcgetaddr
*   return results from indirect getaddr call.
*   This is a pc-specific request for the 48-bit address which was added
*   so that the user program could print the value.
*/
pcgetaddr(s,x,y)
	char *s;
	int x,y;
	{
	if (getaddr)
#ifdef	NI5210ONLY
		(*getaddr)(_DS, s,x,y);
#else
		(*getaddr)(s, x , y);
#endif
}
