/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/confile.c_v   1.0   15 Jan 1990 19:25:36   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/confile.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:25:36   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   confile.c  $ $Revision:   1.0  $"};
/* #define	DEBUG	1 */
/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/
/*
#define	XDEBUG	1
*/

/*
*   Confile.c
*   Split from util.c 5/88
*   Reads and stores the appropriate information for the config file
*
*   version 2, full session layer, TK started 6/17/87
*
****************************************************************************
*                                                                          *
*      part of:                                                            *
*      Network kernel for NCSA Telnet                                      *
*      by Tim Krauskopf                                                    *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
****************************************************************************
*/
#include <stdio.h>
#include <stdlib.h>
#ifndef	_MSC_
#include <alloc.h>
#else
#include <malloc.h>
#endif
#include "whatami.h"
#include "hostform.h"
#include <ctype.h>
#include "windat.h"
#include "newwin.h"
#ifdef PC
#include <string.h>
#else
char *index();
#define strchr(A,B) index(A,B)
#endif
#include "mem.h"

#define NUMSPECS 128
#ifdef	VJC
extern int enable_vjc;
#ifdef	SPLAYC
extern int enable_splayc;
#endif
#endif
#ifdef	CLOCK
int	clockmode=24;
#endif
char 							/* special function types */
			*neterrstring();
int32 time();					/* don't forget this sucker! */
SOUNDS	bell_sound[]={
	{4,1200},
       {0,0}
};

SOUNDS badkey_sound[]={
	{6,1500},
       {6,700},
       {0,0}
};

SOUNDS ftp_sound[]={
	{6,600},
       {6,0},
       {6,2400},
       {0,0}
};

SOUNDS margin_sound[]={
	{17,2000},
       {0,0}
};

SOUNDS	*sounds[MAX_SOUNDS]={bell_sound,
			    badkey_sound,
			    ftp_sound,
			    margin_sound
};
#define	MAX_STEPS	8	/* number of freq step changes */
static struct machinfo *Smachlist,*Smptr;
struct machinfo *Sns=NULL;

static unsigned char *Smachfile = {"config.tel"},
			Sflags[NUMSPECS-95],	/* which parms we have or have not */
			*Sspace;

struct config Scon = {
		0,0,0,0,
		0,
		3,
                66,79,79,84, /* default ip address BOOT for bootp */
		                /* old default IP address 127,0,0,1, */
		"",
		7,1,0x70,
		"packet",       /* default hardware type */
		"auto",
		0,		/* bios */
		1,		/* tek */
		1,		/* ftp */
		1,		/* rcp */
		0,		/* comkeys */
		"DEC-VT100",
		"*",
		NULL,		/* def domain */
                NULL,		/* capture file */
		NULL,		/* passfile */
		NULL,		/* hpfile */
		NULL,		/* psfile */
		NULL,		/* tek file */
		1,
		4,
		3,
		-1,
		0x0,    /* hardware address */
		0x0,    /* hardware ioaddr */
                NULL,   /* domainslist */
                NULL,    /* map3270 */
                TNMODE_AUTO,       /* tnmode auto is default */
		0			/* sys_flags */
};


int
Sxxnf[3] = NFDEF,
Sxxnb[3] = NBDEF,
Sxxbf[3] = BFDEF,
Sxxbb[3] = BBDEF,
Sxxuf[3] = UFDEF,
Sxxub[3] = UBDEF;
char	*env_config;
static int
		mno=0,					/* how many machines in host file */
		lineno,					/* line number in hosts file */
		position,				/* position for scanning string */
		constate,				/* state for config file parser */
		inquote;				/* flag, inside quotes now */

/*
*   States for config file reading state machine.
*   One for each type of keyword and some for controlling.
*/

#define	CONNAME	101
#define CONHOST	102
#define CONIP	103
#define CONGATE	104
#define CONCOLOR 105
#define CONBKSP	106
#define CONBKSC	107
#define CONRETR	108
#define CONWIND	109
#define CONSEG	110
#define CONMTU	111
#define CONNS	112
#define CONTO	113
#define CONCRMAP 114
#define CONDUP  115
#define CONWRAP 116
#define CONWIDE 117
#define CONFONT 118
#define CONFSIZE 119
#define CONNF 120
#define CONNB 121
#define CONBF 122
#define CONBB 123
#define CONUF 124
#define CONUB 125
#define CONRF 126
#define CONRB 127
#define CONCLMODE 128
/*
*  above this line are per machine entries, below are configuration entries
*/
#define CONDOMTO 129
#define CONNDOM  130
#define	CONMASK	131
#define CONMYIP	132
#define CONHPF  133
#define CONPSF  134
#define CONTEKF 135
#define CONJTIME 136
#define CONME	137
#define CONCCOL	138
#define CONHW	139
#define CONADDR	140
#define CONIOA	141
#define CONDEF  142
#define CONCKEYS 143
#define CONINT	144
#define CONBIOS	145
#define CONTEK	146
#define CONVIDEO	147
#define CONFTP	148
#define CONRCP	149
#define CONPASS	150
#define CONCAP	151
#define CONTTYPE	152
#define CONNSTYPE 	153
#define CONFROM	154
#define CONARPTO 155
#define CONZONE 156
#define CONDOMPATH 157

#define MAP3270 158            
#define CONTNMODE       159
#define CONVJC		160	/* enable vjc compression */
#define CONSPLAYC	161	/* enable splay compression */
#define CONCLOCK	162	/* clock control */

#define CONKEYMAP	163	/* set the keymap file name */
#define CONFLAGS	164	/* set flags into machine structure */
#define CONNOARPME	165
#define CONINCLUDE	166
#define CONVISBELL	167
#define CONSOUND	168
char *Skeyw[] = {
		"",	
		"name",							/* name of session */
		"host",							/* name of host */
		"hostip",						/* IP number */
		"gateway",						/* gateway level */
		"color",						/* color code  ==5== */
		"erase",						/* value to use for backspace */
		"scrollback",					/* how many lines to backscroll */
		"retrans",						/* initial retrans time */
		"rwin",							/* window to allow for this host */
		"maxseg",						/* maximum transfer size (in) ==10== */
		"mtu",							/* transfer unit (out) */
		"nameserver",					/* name server level */
		"contime",						/* timeout for opening connection */
		"crmap",						/* map for Berkeley 4.3 compatibility */
		"duplex",						/* half duplex for IBM machines */
		"vtwrap",						/* should VT wrap? */
		"vtmargin",						/* margin to ring bell at */
		"font",							/* font to use, when given a choice */
		"fsize",						/* font size, in points */
		"nfcolor",						/* normal foreground color */
		"nbcolor",						/* normal background color */
		"bfcolor",						/* blink foreground color */
		"bbcolor",						/* blink background color */
		"ufcolor",						/* underline foreground color */
		"ubcolor",						/* underline background color */
		"rfcolor",						/* reverse foreground color */
		"rbcolor",						/* reverse background color */
		"clearsave",					/* clear screen saves lines */

/*
*  following are one-time entries, above are part of the data structure
*/
		"domaintime",					/* time-out for DOMAIN */
		"domainretry",					/* # of retries */
		"netmask",						/* subnetting mask */
		"myip",							/* local machine's IP # */
		"hpfile",						/* HPGL output file */
		"psfile",						/* postscript output file */
		"tekfile",						/* tektronix output file */
		"timeslice",					/* timer slice for multi-tasking */
		"myname",						/* identifying info ==15==*/
		"concolor",						/* console colors */
		"hardware",						/* network hardware */
		"address",						/* Address of hardware */
		"ioaddr",						/* ioaddress of hardware */
		"domain",						/* default domain for lookup */
		"commandkeys",					/* use command keys on mac */
		"interrupt",					/* interrupt request 3 or 5 */
		"bios",							/* use BIOS screen */
		"tek",							/* tektronix graphics ==20==*/
		"video",						/* type of video hardware */
		"ftp",							/* enable ftp? */
		"rcp",							/* enable rcp? */
		"passfile",						/* password file name */
		"capfile",						/* capture file name */
		"termtype",						/* terminal type */
		"nameservertype",				/* nameserver type */
		"copyfrom",						/* copy from another machine */
		"arptime",						/* time-out for ARPs */
		"zone",							/* NBP zone for Macs */
                "domainslist",                                           /* domain search path   */
                "map3270",                                              /* where to find the map3270 file */
                "tnmode",                                               /* how to connect to 3270 hosts */
		"vjc",							/* enable vj compression */
		"splayc",						/* enable splay compression*/
		"clock",						/* control clock */
		"keymap",						/* the keymap */
		"flags",						/* raw flags control */
		"noarpme",					/* set if we are not supposed to arp ourselves */
		"include",					/* include file */
		"visbell",					/* visual bell */
	        "sound",					/* sounds... */
		""
	};

#ifndef	PCNFS
extern int no_arpme;
#endif
#define	INCLUDE_FILE	125
#define	MAX_FILES	3
/************************************************************************/
/*  Sgetconfig
*   copy the configuration information into the user's data structure
*   directly.  The user can do with it what he feels like.
*/
Sgetconfig(cp)
	struct config *cp;
	{

	movebytes(cp,&Scon,sizeof(struct config));
	return(0);

}

static char
Env_read(unsigned int *token)
{
static	char	*currbuff;
	char	ask_buff[20];
static	unsigned char	curr_token = 0;
	char	c;

	if(!*token) {
	        if(currbuff = getenv("$CUTCP1")) {
		        *token = 0x100;
			curr_token = 1;
		}
	 	else if(env_config) {
		       	currbuff = env_config;
			*token = 0xf000;
			curr_token = 0xf0;
			env_config = NULL;
		}
		return(0);
	}
	if(curr_token != (*token >> 8)) {
		sprintf(ask_buff,"$CUTCP%d",curr_token);
		if(!(currbuff = getenv(ask_buff))) {
		        if(env_config) {
			       	currbuff = env_config;
				env_config = NULL;
			}
			else				
			       	return(EOF);
		}
	       	curr_token = *token >> 8;
	}
	if(!(c = *(currbuff + (*token & 0xFF)))) {
	        *token = (*token &  0xff00) + 0x100;
		return('\n');
	}
	(*token)++;
	return((c == '~') ? '=' : c);
}

/************************************************************************/
/*  Sreadhosts
*   read in the hosts file into our in-memory data structure.
*   Handle everything by keyword, see docs for specifications about file.
*/
Sreadhosts()
	{
	FILE 	*fp[MAX_FILES+1];
	int	lines[MAX_FILES+1];
	int	file_stack=0;
	int c,retval,env_read=0;
	unsigned int	token=0;

	Smachlist = Smptr = NULL;
	retval = mno = 0;

	Sspace = mem_malloc(256);				/* get room for gathering stuff */
	if (Sspace == NULL) {
		Serrline(901);
		return(1);
	}
	Env_read(&token);
restart:;
	position = constate = inquote = lineno = 0;   /* state vars */
	retval = 0;
	if (NULL == (fp[file_stack] = fopen(Smachfile,"r"))) {
#ifdef	XDEBUG
	fprintf(stderr,"Sreadhost %s\n",Smachfile);
#endif
		Serrline(900);
		nprintf(CONSOLE,"Couldn't open config.file %s\n",Smachfile);
		if(!file_stack)
			return(1);
		else {
		       	file_stack--;
			lineno = lines[file_stack];
		}
	}
rescan:;
	while (!retval) {
	        if(env_read && !file_stack) {
		       	c = Env_read(&token);
#ifdef	XDEBUG
			fprintf(stderr,"Envread %c\n",c);
#endif
		}
		else {
			c = fgetc(fp[file_stack]);
#ifdef	XDEBUG
			fprintf(stderr,"%c",c);
#endif
		}
		if (c == '#' && !inquote) {
			while (c != EOF && c != '\n' && c != '\r')		/* skip to EOL */
				c = fgetc(fp[file_stack]);
		}
		if (c == '\n' || c == '\r') {
			lineno++;
			inquote = 0;
		}
	 	if(c == EOF) {
		        if(file_stack) {
			       	fclose(fp[file_stack]);
				file_stack--;
				lineno = lines[file_stack];
				continue;
			}
		 	if( (token && !env_read))
			       	break;
		}
		retval = Scontoken(c);		/* add character to token */
	}
	if(retval == INCLUDE_FILE)  {
	       	if(file_stack < MAX_FILES) {
			lines[file_stack] = lineno;
		       	file_stack++;
		       	goto restart;
		}
	 	else {
		       	nprintf(CONSOLE,"File include stack limit of %d exceeded\n",MAX_FILES);
			goto rescan;
		}
	}
	if(!env_read) {
		fclose(fp[file_stack]);
		if(token) {
		       	env_read = 1;
		 	goto rescan;
		}
	}
	mem_free(Sspace);

	if (retval == EOF)				/* EOF is normal end */
		return(0);
	else {
#ifdef	DEBUG
	fprintf(stderr,"retval is %x\n",retval);
#endif
		return(retval);
      	}
}


/************************************************************************/
/*  ncstrcmp
*   No case string compare.
*   Only returns 0=match, 1=no match, does not compare greater or less
*   There is a tiny bit of overlap with the | 32 trick, but shouldn't be
*   a problem.  It causes some different symbols to match.
*/
ncstrcmp(sa,sb)
	char *sa,*sb;
	{

	while (*sa && *sa < 33)		/* don't compare leading spaces */
		sa++;
	while (*sb && *sb < 33)
		sb++;

	while (*sa && *sb) {
		if ((*sa != *sb) && ((*sa | 32) != (*sb | 32)))
			return(1);
		sa++;sb++;
	}
	if (!*sa && !*sb)		/* if both at end of string */
		return(0);
	else
		return(1);
}
/************************************************************************/
/*  Serrline
*   prints the line number of the host file error and posts the event
*   for the line number error and posts the hosts file error.
*/

Serrline(n)
	int n;
	{
	char *p;
	nprintf(CONSOLE,"Config file: error in line %4d\n",lineno+1);
	nprintf(CONSOLE,"%s\n",neterrstring(n));
}

/************************************************************************/
/* Scontoken
*  tokenize the strings which get passed to Sconfile.
*  Handles quotes and uses separators:  <33, ;:=
*/
Scontoken(c)
	int c;
	{
	int retval;

	if (c == EOF) {
		Sspace[position++] = '\0';
		Sconfile(Sspace);
		if (!Sflags[0]) {			/* make sure last entry gets copied */
			if (Smachlist == NULL) {
				Smachlist = (struct machinfo *)mem_calloc(sizeof(struct machinfo),1);
				Smptr = Smachlist;
				Smptr->sname = NULL;
				Smptr->hname = NULL;
			}

			if (ncstrcmp("default",Smptr->sname))
				Scopyfrom("default");
			else
				Scopyfrom("==");
		}
		return(-1);
	}

	if (!position && Sissep(c))		/* skip over junk before token */
		return(0);

	if (inquote || !Sissep(c)) {

		if (position > 200) {
			Serrline(903);
			return(1);
		}
/*
*  check for quotes, a little mixed up here, could be reorganized
*/
		if (c == '"' ) {
			if (!inquote) {			/* beginning of quotes */
				inquote = 1;
				return(0);
			}
			else
				inquote = 0;		/* turn off flag and drop through */

		}
		else {						
			if (c == '\n') {			/* check for EOL inside quotes */
				Serrline(904);
				return(1);
			}
			Sspace[position++] = c;    /* include in current string */
			return(0);
		}
				
	}

	Sspace[position++] = '\0';

	retval = Sconfile(Sspace);			/* pass the token along */

	position = 0;
	inquote = 0;
	Sspace[0] = '\0';

	return(retval);
}

/************************************************************************/
/*  Sconfile
*   take the characters read from the file and parse them for keywords
*   which require configuration action.
*/
Sconfile(s)
	char *s;
	{
	int i,a,b,c,d;
	char	*cp;
	unsigned int destport;

	switch (constate) {
		case 0:								/* lookup keyword */
			if (!(*s))						/* empty token */
				return(0);


			for (i=1; *Skeyw[i] && ncstrcmp(Skeyw[i],s); i++)
					;
			if (!(*Skeyw[i])) {			/* not in list */
				Serrline(902);
				return(0);				/* don't die - helps backward compatibility */
			}
			constate = 100+i;	/* change to state for keyword */
/*
*  check if this is a machine specific parm without a machine to
*  give it to.  "name" being the only machine specific parm allowed, of course
*/
			if (Smptr == NULL && constate > 101 && constate <= NUMSPECS) {
				Serrline(905);
				return(1);
			}
			break;

		case CONNAME:
/*
*  allocate space for upcoming parameters
*/
			if (Smachlist == NULL) {
				Smachlist = (struct machinfo *)mem_calloc(sizeof(struct machinfo),1);
				Smptr = Smachlist;
				Smptr->sname = NULL;
				Smptr->hname = NULL;
			}
			else {
				if (!Sflags[0]) {
					if (ncstrcmp("default",Smptr->sname))
						Scopyfrom("default");
					else
						Scopyfrom("==");	/* to make sure 'default' gets set */
				}
				Smptr->next = 
					(struct machinfo *)mem_calloc(sizeof(struct machinfo),1);
				Smptr = Smptr->next;
			}
		        Smptr->destport = 0;    /* never copy this */
			Smptr->flags = 0;
		 	Smptr->keymap= NULL;
			Smptr->next = NULL;
			Smptr->hname = NULL;				/* guarantee to be null */
			Smptr->sname = mem_malloc(position);	/* size of name string */
			strcpy(Smptr->sname,s);				/* keep name field */
			constate = 0;						/* back to new keyword */
			for (i=0; i<NUMSPECS-99; i++)
				Sflags[i] = 0;					/* we have no parms */
			Smptr->mno = ++mno;					/* new machine number */
			break;

		case CONHOST:							/* also a name */
		   	destport = 0;
#ifdef	YDEBUG
	printf("conhost (%s) %lp\n",s,strchr(s,':'));
#endif
	                if(cp = strchr(s,':')) {
				cp++;
	
	                        if(isdigit(*cp)) {
	                                if(*(cp+1) == 'x' || *(cp+1) == 'X')
	                                        sscanf(cp+2,"%x",&destport);
	                                else
	                                   if(*cp == '0')
	                                        sscanf(cp+1,"%o",&destport);
	                                else
	                                        sscanf(cp,"%u",&destport);
				     	cp = strchr(s,':');
					*cp = 0;
	                        }
	               }
	               if(destport) {
#ifdef	YDEBUG
	printf("port %u\n",destport);
#endif
        	                Smptr->destport = destport;
			     	Smptr->flags |= TWIN_FLAGS_CONFIG_PORT;
			}
			Smptr->hname = mem_malloc(strlen(s)+1);
			strcpy(Smptr->hname,s);
			constate = 0;
			Sflags[CONHOST-100] = 1;
			break;

		case CONIP:								/* IP number for host */
			if ( 4 != sscanf(s,"%d.%d.%d.%d",&a,&b,&c,&d)) {
				Serrline(906);
				return(3);
			}
			Smptr->hostip[0]=a; Smptr->hostip[1] =b; 	/* keep number */
			Smptr->hostip[2]=c; Smptr->hostip[3] =d;
			Smptr->mstat = HFILE;
			constate = 0;
			Sflags[CONIP-100] = 1;
			break;

		case CONGATE:
			Smptr->gateway = atoi(s);			/* gateway level */
			constate = 0;
			Sflags[CONGATE-100] = 1;
			break;
#ifndef	MINITEL
		case CONCOLOR:					/* support old format */
			Smptr->nfcolor[0] = s[1]-48;
			Smptr->nbcolor[0] = s[0]-48;
			Smptr->bfcolor[0] = s[5]-48;
			Smptr->bbcolor[0] = s[4]-48;
			Smptr->ufcolor[0] = s[3]-48;
			Smptr->ubcolor[0] = s[2]-48;
			constate = 0;
			Sflags[CONNF-100] = 1;		/* sets them all at one shot */
			Sflags[CONNB-100] = 1;
			Sflags[CONBF-100] = 1;
			Sflags[CONBB-100] = 1;
			Sflags[CONUF-100] = 1;
			Sflags[CONUB-100] = 1;
			break;
#endif
		case CONNF:						/* foreground normal color */
			if (Scolorset(Smptr->nfcolor,s))
				Sflags[CONNF-100] = 1;
			constate = 0;
			break;
		case CONNB:						/* background normal color */
			if (Scolorset(Smptr->nbcolor,s))
				Sflags[CONNB-100] = 1;
			constate = 0;
			break;
		case CONRF:
		case CONBF:						/* blink foreg color */
			if (Scolorset(Smptr->bfcolor,s))
				Sflags[CONBF-100] = 1;	/* in copyfrom, r's are really b's */
			constate = 0;
			break;
		case CONRB:
		case CONBB:						/* blink bg color */
			if (Scolorset(Smptr->bbcolor,s))
				Sflags[CONBB-100] = 1;
			constate = 0;
			break;
		case CONUF:						/* foreground underline color */
			if (Scolorset(Smptr->ufcolor,s))
				Sflags[CONUF-100] = 1;
			constate = 0;
			break;
		case CONUB:						/* bg underline color */
			if (Scolorset(Smptr->ubcolor,s))
				Sflags[CONUB-100] = 1;
			constate = 0;
			break;
#ifndef	MINITEL
		case CONBKSP:
			if (!ncstrcmp(s,"backspace"))
				Smptr->bksp = 8;
			else
				Smptr->bksp = 127;
			constate = 0;
			Sflags[CONBKSP-100] = 1;
			break;

		case CONBKSC:
			Smptr->bkscroll = atoi(s);
			constate = 0;
			Sflags[CONBKSC-100] = 1;
			break;
#endif
		case CONRETR:
			Smptr->retrans = atoi(s);
			constate = 0;
			Sflags[CONRETR-100] = 1;
			break;

		case CONWIND:
			Smptr->window = atoi(s);
			constate = 0;
			Sflags[CONWIND-100] = 1;
			break;

		case CONSEG:
			Smptr->maxseg = atoi(s);
			constate = 0;
			Sflags[CONSEG-100] = 1;
			break;

		case CONMTU:
			Smptr->mtu = atoi(s);
			constate = 0;
			Sflags[CONMTU-100] = 1;
			break;
#ifndef	MINITEL
		case CONNS:
			Smptr->nameserv = atoi(s);
			if (!Sns || (Sns->nameserv > Smptr->nameserv))	/* keep NS */
				Sns = Smptr;
			constate = 0;
			Sflags[CONNS-100] = 1;
			break;
#endif
		case CONTO:
			i = atoi(s);
			if (i > 2) {
				Smptr->conto = i;
				Sflags[CONTO-100] = 1;
			}
			constate = 0;
			break;

		case CONCRMAP:
#ifdef  TN3270
                        if (!ncstrcmp(s,"TN3270"))
                                Smptr->crmap = -1;
			 else
			    if(!ncstrcmp(s,"FLAGGED")) /* vestigal mistake in docs needs support now */
				 Smptr->crmap = -1;
                        else
#endif
			if (!ncstrcmp(s,"4.3BSDCRNUL")) 
				Smptr->crmap = 0;
			else
				Smptr->crmap = 10;
			Sflags[CONCRMAP-100] = 1;
			constate = 0;
			break;
#ifndef	MINITEL
		case CONDUP:
			if (!ncstrcmp(s,"half")) {
				Smptr->halfdup = 1;
				Sflags[CONDUP-100] = 1;
			}
			constate = 0;
			break;

		case CONWRAP:
		   	if(islower(s[0]))
			   	s[0] = toupper(s[0]);
			if ('Y' == s[0])
				Smptr->vtwrap = 1;
			else if ('T' == s[0])	/* vtwrap=T for load measurement */
			   	Smptr->vtwrap = 2;
			else
				Smptr->vtwrap = 0;
			Sflags[CONWRAP-100] = 1;
			constate = 0;
			break;

		case CONCLMODE:
			if ('N' == toupper(s[0])) 
				Smptr->clearsave = 0;
			else
				Smptr->clearsave = 1;
			Sflags[CONCLMODE-100] = 1;
			constate = 0;
			break;

		case CONFONT:
			Smptr->font = mem_malloc(position);
			strcpy(Smptr->font,s);
			Sflags[CONFONT-100] = 1;
			constate = 0;
			break;

		case CONFSIZE:
			Smptr->fsize = atoi(s);
			Sflags[CONFSIZE-100] = 1;
			constate = 0;
			break;

		case CONWIDE:	       /* aka vtmargin */
		        if(s[0] == 'y' || s[0] == 'Y')
				Smptr->vtmargin = 0xff;

			Sflags[CONWIDE-100] = 1;
			constate = 0;
			break;
#endif
/*
*  now the one-time entries
*  Generally this information goes into the "Scon" structure for later
*  retrieval by other routines.
*
*/
#ifdef PC
		case CONMASK:
			if ( 4 != sscanf(s,"%d.%d.%d.%d",&a,&b,&c,&d)) {
				Serrline(907);
				return(3);
			}
			Scon.netmask[0]=a; Scon.netmask[1] =b; 	
			Scon.netmask[2]=c; Scon.netmask[3] =d;
			Scon.havemask=1;
			constate = 0;
			break;

		case CONMYIP:
			constate = 0;
			if (!ncstrcmp(s,"rarp")) {
				movebytes(Scon.myipnum,s,4);
				netsetip("RARP");
				break;
			}
#ifdef  BOOTP
			if (!ncstrcmp(s,"bootp")) {
				movebytes(Scon.myipnum,"BOOT",4);
				netsetip("BOOT");
				break;
			}
#endif
			if ( 4 != sscanf(s,"%d.%d.%d.%d",&a,&b,&c,&d)) {
				Serrline(908);
				printf("s=[%s]\n",s);
				return(3);
			}
			Scon.myipnum[0]=a; Scon.myipnum[1] =b; 	/* put number back in s */
			Scon.myipnum[2]=c; Scon.myipnum[3] =d;
			netsetip(Scon.myipnum);		/* make permanent set */
			break;
#endif
#if		!defined(MINITEL) || defined(NI5210ONLY) || defined(ODIONLY)
		case CONME:				/* what my name is  */
#ifndef	PCNFS
			strncpy(Scon.me,s,30);
			Scon.me[30] = '\0';
#endif
			constate = 0;
			break;

		case CONHW:				/* what hardware are we using? */
			i = strlen(s);
			if (i > 9) i = 9;
			s[i] = '\0';
			i--;
			while (i--)
				s[i] = tolower(s[i]);
			strcpy(Scon.hw,s);
			constate = 0;
			break;

#ifdef PC
		case CONINT:			/* what IRQ to use */
			sscanf(s,"%x",&i);
			Scon.irqnum = i;
			constate = 0;
			break;

		case CONBIOS:
			if (toupper(*s) == 'Y') {
				Scwritemode(0);
				Scon.bios = 1;
			}
		 	else if(toupper(*s) == 'M') {
			       	Scon.bios = 2;
			}
			constate = 0;
			break;

		case CONADDR:				/* segment address for board */
			sscanf(s,"%x",&i);
			Scon.address = i;
			constate = 0;
			break;

		case CONIOA:				/* io address for board */
			sscanf(s,"%x",&i);
			Scon.ioaddr = i;
			constate = 0;
			break;
#endif
#endif
#ifdef MAC
		case CONCKEYS:
			if (toupper(*s) == 'Y') {
				Scon.comkeys = 1;
			}
			constate = 0;
			break;

		case CONZONE:
			Scon.zone = mem_malloc(position);	/* space for name */
			strcpy(Scon.zone,s);			/* copy it in */
			constate = 0;
			break;

		case CONJTIME:				/* Time slice */
			i = atoi(s);
			if (i > 1)
				Scon.timesl = i;
			constate = 0;
			break;
#endif		
#ifndef	MINITEL
		case CONTEK:
			if (toupper(*s) == 'N') {
				Stekmode(0);
				Scon.tek = 0;
			}
			constate = 0;
			break;

		case CONVIDEO:
			i = strlen(s);
			if (i > 9) i = 9;
			s[i] = '\0';
			strcpy(Scon.video,s);
			i--;
			while (i--)
				s[i] = tolower(s[i]);
			constate = 0;
			break;

		case CONTTYPE:
			Scon.termtype = mem_malloc(position);
			strcpy(Scon.termtype,s);
			constate = 0;
			break;

		case CONCCOL:
			for (i=0; i<3; i++)
				Scon.color[i] = ((s[i*2]-48)<<4) + (s[i*2+1]-48);
			constate = 0;
			break;

		case CONFTP:
			if (toupper(*s) == 'N') 
				Scon.ftp = 0;	
			constate = 0;
			break;

		case CONRCP:
			if (toupper(*s) == 'N')
				Scon.rcp = 0;
			constate = 0;
			break;

		case CONPASS:
			Scon.pass = mem_malloc(position);	/* space for name */
			strcpy(Scon.pass,s);			/* copy it in */
			constate = 0;
			break;

		case CONDEF:						/* default domain */
			Scon.defdom = mem_malloc(position);	/* space for name */
			strcpy(Scon.defdom,s);			/* copy it in */
			constate = 0;
			break;
#endif
		case CONCAP:						/* capture file name */
			Snewcap(s);
			constate = 0;
			break;
		case CONFROM:						/* copy the rest from another */
											/* entry in the table */
			if (Scopyfrom(s))
				return(1);
			Sflags[0] = 1;					/* indicate did copy from */
			constate = 0;
			break;

		case CONARPTO:				/* need to lengthen arp time-out (secs) */
			i = atoi(s);
			if (i > 0)
				netarptime(i);
			constate = 0;			/* don't forget me! */
			break;
#ifndef	MINITEL

		case CONDOMTO:				/* DOMAIN timeout value */
			i = atoi(s);
			if (i > 1)
				Scon.domto = i;
			constate = 0;
			break;

		case CONNDOM:				/* DOMAIN number of retries */
			i = atoi(s);
			if (i > 1)
				Scon.ndom = i;
			constate = 0;
			break;

		case CONHPF:				/* File name for HP dump */
			Snewhpfile(s);
			constate = 0;
			break;

		case CONPSF:				/* File name for PS dump */
			Snewpsfile(s);
			constate = 0;
			break;

		case CONTEKF:				/* File name for Tek dump */
			Snewtekfile(s);
			constate = 0;
			break;
                                                /* following add by bkc 10/21/88 for domain search list */
                case CONDOMPATH:                        /* domain name path */
			Scon.domainpath = mem_malloc(position+1);	/* space for path */
			strcpy(Scon.domainpath,s);			/* copy it in */
                        removejunk(Scon.domainpath);  /* remove all spaces, leading and trailing commas, 
                                        converts commas to nulls .. defined in util.c */
			constate = 0;
			break;
#endif
                case MAP3270:           /* added to handle 3270 support */
#ifndef TN3270
                        netposterr(909);
#else
                        Scon.map3270 = mem_malloc(position+1);
                        strcpy(Scon.map3270,s);
#endif
                        constate = 0;
                        break;
                case CONTNMODE:         /* how to connect to tn3270 hosts */
#ifndef TN3270
                        netposterr(909);
#else

                        if(islower(*s))
                                *s = toupper(*s);
                        switch (*s) {

                           case 'O' :
                                Scon.tnmode = TNMODE_OFF;
                                break;
                           case 'A' :
                                Scon.tnmode = TNMODE_AUTO;
                                break;
                           case 'F' :
                                Scon.tnmode = TNMODE_FLAGGED;
                                break;
                           case 'N' :
                                Scon.tnmode = TNMODE_NOTFLAGGED;
                                break;
                           default :;

                         }
#endif
                        constate = 0;
                        break;
		case CONVJC :
#ifndef	VJC
			netposterr(910);
#else
			switch (*s) {
				case 'Y' :
				case 'y' :
				       enable_vjc = -1;
					break;
				default:;
			}
#endif
		 	constate=0;
			break;
		case CONSPLAYC :
#ifndef	VJC
			netposterr(911);
#else
#ifndef	SPLAYC
			netposterr(911);
#else
			switch (*s) {
				case 'Y' :
				case 'y' :
				       	enable_splayc = -1;
				default:;
			 }
#endif
#endif
			constate=0;
		 	break;
		case CONCLOCK :
#ifndef	CLOCK
			netposterr(912);
#else
		{
		   char tbuff[65];
		   char *cp;

		   cp = strchr(s,':');
		   if(cp) {
			  *cp = 0;
#ifdef	_MSC_
			cp++;
			if(strlen(cp) > 50)
			       	cp[50] = 0;
			sprintf(tbuff,"TZ=%s",cp);
			putenv(tbuff);
			tzset();
#else
			netposterr(913);
#endif
		    }
	     	    clockmode = atoi(s);
		}     
#endif
			constate=0;
		 	break;
		case CONKEYMAP :		/* set the machine keymap */
#ifdef	DEBUG
	cprintf("Keymap for host %s, is %s was %s\n",Smptr->sname,
	        s,Smptr->keymap);
#endif
		        if(Smptr)
				Smptr->keymap = mem_strdup(s);
		 	constate = 0;
			break;
		case CONFLAGS :
		       	if(Smptr) {
				unsigned rflags = 0;
			       	sscanf(s,"%x",&rflags);
				Smptr->flags |= rflags;
			}
		 	constate = 0;
			break;
		case CONNOARPME :
#ifndef	PCNFS

			if(s[0] == 'y' || s[0] == 'Y')
			 	no_arpme = 1;
#endif
			constate = 0;
			break;
		case CONINCLUDE :
		       {
		       	char *yz = mem_strdup(s);
			       	Shostfile(yz);
			}
		 	constate = 0;
			return(INCLUDE_FILE);
#ifndef	MINITEL
		case CONVISBELL :
		       	if(s[0] == 'y' || s[0] == 'Y')
			       	Scon.sys_flags |= SYS_FLAGS_VISUAL_BELL;
			constate = 0;
			break;
#endif
		case CONSOUND :
		       {
		         SOUNDS tmp[MAX_STEPS+1],*S;
			 int step,sound,duration,freq;
			 char	*c,*p;
			 static char *tags[]={"bell","badkey","ftp","margin",NULL};
		     	 	if(c = strchr(s,':')) {
					*c = 0;
					for(sound=0; tags[sound]; sound++) {
#ifdef	DEBUGXS
	nprintf(CONSOLE,"P %s, sound %d\n",tags[sound],sound);
#endif
					        if(!stricmp(tags[sound],s))
						       	break;
					}
				 	if(!tags[sound])
					        goto syntax_error;
					for(step=0; c && (step < MAX_STEPS); step++) {
						c++;
					        freq = duration = -1;
						sscanf(c,"%d,%d",&duration,&freq);
#ifdef	DEBUGXS
		nprintf(CONSOLE,"Scanned step %d sound %d %d,%d from (%s)\n",step,sound,duration,freq,c);
#endif
						if((freq == -1) || (duration == -1))
						        break;
						tmp[step].s_duration = duration;
						tmp[step].s_frequency = freq;
						c = strchr(c,':');
					}
				 	if(!step)
					        goto syntax_error;
					tmp[step].s_duration = 0;
					tmp[step].s_frequency = 0;
					step++;
					if(S = mem_malloc(step * sizeof(SOUNDS))) {
					        memcpy(S,tmp,step * sizeof(SOUNDS));
						sounds[sound] = S;
					}
				 	else
					       	nprintf(CONSOLE,"Not enough memory to allocate sound buffer\n");
			        }
			 	else {
syntax_error:;
				       	Serrline(914);
				}

			 }
		  	constate = 0;
			break;
		default:
			constate = 0;
			break;
	}

	return(0);
}

/************************************************************************/
/*  Scopyfrom
*   Look at the Sflags array to determine which elements to copy from
*   a previous machine's entries.  If a machine name as been given as
*   "default", the state machine will fill in the fields from that
*   machine's entries.
*
*   If the machine name to copyfrom is not present in the list, set the
*   program default values for each field.
*/
Scopyfrom(s)
	char *s;
	{
	struct machinfo *m;
	int i;

	m = Shostlook(s);			/* search list */

	for (i=3; i <= NUMSPECS-100; i++) 		/* through list of parms */
		if (!Sflags[i]) {
			if (m) 							/* copy old value */
			switch (100+i) {
				case CONHOST:
					Smptr->hname = m->hname;
					break;
#ifdef	STUPID
				case CONIP:
					movebytes(Smptr->hostip,m->hostip,4);
					Smptr->mstat = m->mstat;
					break;
#endif
				case CONGATE:			/* gateways cannot be copied from */
					Smptr->gateway = 0;
					break;
				case CONNS:					/* can't copy nameservers either */
					Smptr->nameserv = 0;
					break;

				case CONBKSP:
					Smptr->bksp = m->bksp;
					break;
				case CONBKSC:
					Smptr->bkscroll = m->bkscroll;
					break;
				case CONCLMODE:
					Smptr->clearsave = m->clearsave;
					break;
				case CONRETR:
					Smptr->retrans = m->retrans;
					break;
				case CONWIND:
					Smptr->window = m->window;
					break;
				case CONSEG:
					Smptr->maxseg = m->maxseg;
					break;
				case CONMTU:
					Smptr->mtu = m->mtu;
					break;

				case CONTO:
					Smptr->conto = m->conto;
					break;
				case CONCRMAP:
					Smptr->crmap = m->crmap;
					break;
				case CONDUP:
					Smptr->halfdup = m->halfdup;
					break;
				case CONWRAP:
					Smptr->vtwrap = m->vtwrap;
					break;
				case CONWIDE:
					Smptr->vtmargin = m->vtmargin;
					break;

				case CONNF:
					movebytes(Smptr->nfcolor,m->nfcolor,3*sizeof(int));
					break;
				case CONNB:
					movebytes(Smptr->nbcolor, m->nbcolor,3*sizeof(int));
					break;
				case CONBF:
					movebytes(Smptr->bfcolor,m->bfcolor,3*sizeof(int));
					break;
				case CONBB:
					movebytes(Smptr->bbcolor,m->bbcolor,3*sizeof(int));
					break;
				case CONUF:
					movebytes(Smptr->ufcolor,m->ufcolor,3*sizeof(int));
					break;
				case CONUB:
					movebytes(Smptr->ubcolor,m->ubcolor,3*sizeof(int));
					break;

				case CONFONT:
					Smptr->font = m->font;
					break;
				case CONFSIZE:
					Smptr->fsize = m->fsize;
					break;

				default:
					break;
			}
			else
			switch (100+i) {		/* m=NULL, install default values */
				case CONHOST:
					Smptr->hname = NULL;
					break;
				case CONIP:
					Smptr->mstat = NOIP;
					break;
				case CONGATE:			/* gateways cannot be copied from */
					Smptr->gateway = 0;
					break;
				case CONBKSP:
					Smptr->bksp = 127;
					break;
				case CONBKSC:
					Smptr->bkscroll = 0;
					break;
				case CONCLMODE:
					Smptr->clearsave = 1;
					break;
				case CONRETR:
					Smptr->retrans = SMINRTO;
					break;
				case CONWIND:
#ifdef MAC
					Smptr->window = 512;
#else
					Smptr->window = DEFWINDOW;
#endif
					break;
				case CONSEG:
#ifdef MAC
					Smptr->maxseg = 512;
#else
					Smptr->maxseg = DEFSEG;
#endif
					break;
				case CONMTU:
#ifdef MAC
					Smptr->mtu = 512;
#else
					Smptr->mtu = TSENDSIZE;
#endif
					break;

				case CONNS:					/* can't copy nameservers either */
					Smptr->nameserv = 0;
					break;
		
				case CONTO:
					Smptr->conto = CONNWAITTIME;
					break;

				case CONCRMAP:
					Smptr->crmap = 10;
					break;

				case CONDUP:
					Smptr->halfdup = 0;
					break;
				case CONWRAP:
					Smptr->vtwrap = 0;
					break;
				case CONWIDE:
					Smptr->vtmargin = -1;
					break;
				case CONNF:
					movebytes(Smptr->nfcolor,Sxxnf,3*sizeof(int));
					break;
				case CONNB:
					movebytes(Smptr->nbcolor,Sxxnb,3*sizeof(int));
					break;
				case CONBF:
					movebytes(Smptr->bfcolor,Sxxbf,3*sizeof(int));
					break;
				case CONBB:
					movebytes(Smptr->bbcolor,Sxxbb,3*sizeof(int));
					break;
				case CONUF:
					movebytes(Smptr->ufcolor,Sxxuf,3*sizeof(int));
					break;
				case CONUB:
					movebytes(Smptr->ubcolor,Sxxub,3*sizeof(int));
					break;

				case CONFONT:
					Smptr->font = "Monaco";
					break;
				case CONFSIZE:
					Smptr->fsize = 9;
					break;
				default:
					break;
			}
		}
#ifdef	DEBUG
	cprintf("Scopy from '%s' returns %lp (%s) keymap %s, my keymap %s\n",
	       s,m, m ? m->sname : "none", m ? m->keymap : "none", Smptr->keymap);
#endif
	Sflags[0] = 1;					/* set that this machine was copied */
	return(0);
}

/************************************************************************/
/*  Smadd
*   If machine is there, just returns pointer, else
*   Add a machine to the list. Increments machine number of machine.
*   Puts in parameters copied from the "default" entry.
*
*/
struct machinfo 
*Smadd(mname)
	char *mname;
	{
	int i;
	struct machinfo *m;
/*
*  First, do we have the name already?
*/
	m = Shostlook(mname);
	if (m)
		return(m);
/*
*   Don't have name, add another record
*/
	Smptr = (struct machinfo *)mem_calloc(sizeof(struct machinfo),1);
	if (Smptr == NULL)
		return(NULL);

	for (i=0; i < NUMSPECS-99; i++)
		Sflags[i] = 0;					/* we have no parms */
	Scopyfrom("default");

	Smptr->sname = NULL;
	Smptr->hname = mem_malloc(strlen(mname)+1);
	if (Smptr->hname)
		strcpy(Smptr->hname,mname);		/* copy in name of machine */
	Smptr->mno = ++mno;
	Smptr->mstat = NOIP;
        Smptr->destport = 0;                    /* why doesn't mem_calloc clear this? */
	Smptr->next = Smachlist;			/* add to front of machlist */
	Smachlist = Smptr;

	return(Smptr);

}


/************************************************************************/
/* Shostfile
*   if the user wants to change the host file name from 'config.tel' to
*   something else.
*/
Shostfile(ptr)
	char *ptr;
	{
	Smachfile = ptr;	
/*
*  note that the area with the file name must stay allocated for
*  later reference, typically it is in some argv[] parm.
*/
   	return(0);
}

/************************************************************************/
/*  get host by name
*   Given the name of a host machine, search our database to see if we
*   have that host ip number.  Search first the name field, and then the
*   hostname field.  If the IP # is given, returns a ptr to the
*   default machine record with that IP # installed.
*   Returns the pointer to a valid record, or NULL if the IP # cannot
*   be deciphered.  
*/
struct machinfo 
*Sgethost(machine)
	char *machine;
	{
	int i,j,k,l;
	unsigned char ipto[4],myipnum[4],xmask[4];
	unsigned long hnum;
	struct machinfo *m;

	m = NULL;
/*
*  First, check for the pound sign character which means we should use
*  the current netmask to build an IP number for the local network.
*  Take the host number, install it in the ipto[] array.  Then mask
*  in my IP number's network portion to build the final IP address.
*/

	if ('#' == machine[0]) {		/* on my local network */
		netgetip(myipnum);
		netgetmask(xmask);			/* mask of network portion of IP # */

		sscanf(&machine[1],"%ld",&hnum);/* host number for local network */
		for (i=3; i >= 0; i--) {
			ipto[i] = hnum & 255L;	/* take off a byte */
			hnum >>= 8;				/* shift it over */
		}

		for (i=0; i < 4; i++) 
			ipto[i] |= (myipnum[i] & xmask[i]);		/* mask new one in */

	}
/*
*  next, is it an IP number?  We take it if the number is in four
*  parts, separated by periods.
*/
	else 
	if (4 == sscanf(machine,"%d.%d.%d.%d",&i,&j,&k,&l)) {	/* given ip num */
		ipto[0] = i;
		ipto[1] = j;
		ipto[2] = k;
		ipto[3] = l;
	}
/*
*  lastly, it must be a name, first check the local host table
*  A first number of 127 means that it doesn't have an IP number, but
*  is in the table (strange occurrence)
*/
	else {									/* look it up */

		m = Shostlook(machine);
		if (m == NULL) {
			netposterr(805);			/* informative */
			return(NULL);
		} 
		if (m->mstat < HAVEIP) {
			netposterr(806);			/* informative */
			return(NULL);
		}
	}

	if (!m) {
		m = Shostlook("default");
		movebytes(m->hostip,ipto,4);		/* copy in newest host # */
		m->mstat = HAVEIP;					/* we have the IP # */
	}

	return(m);
}

/************************************************************************/
/*  Shostlook
*   The straightforward list searcher.  Looks for either the
*   session name matching or the host name matching.  NULL if neither.
*/
struct machinfo 
*Shostlook(hname)
	char *hname;
	{
	struct machinfo *m;
	m = Smachlist;
	while (m != NULL) {

		if (m->sname && !ncstrcmp(hname,m->sname)) 
			return(m);

		m = m->next;
	}

	m = Smachlist;
	while (m != NULL) {
		if (m->hname && !ncstrcmp(hname,m->hname))
			return(m);

		m = m->next;
	}

	return(NULL);

}

/************************************************************************/
/*  Slooknum
*   get the host record by machine number, used primarily in DOMAIN name
*   lookup.
*/
struct machinfo 
*Slooknum(num)
	int num;
	{
	struct machinfo *m;

	m = Smachlist;
	while (m) {
		if (m->mno == num)
			return(m);
		m = m->next;
	}

	return(NULL);

}

/**************************************************************************/
/*  Slookip
*   For FTP to look up the transfer options to use when running
*
*/
struct machinfo 
*Slookip(ipnum)
	unsigned char *ipnum;
	{
	struct machinfo *m;

	m = Smachlist;
	while (m) {
		if (comparen(m->hostip,ipnum,4))
			return(m);
		m = m->next;
	}

	return(NULL);

}

/**************************************************************************/
/*  Sissep
*   is the character a valid separator for the hosts file?
*   separators are white space, special chars and :;=
*
*/
Sissep(c)
	int c;
	{
	if (c < 33)
		return(1);
#ifdef	OLDDEF	     
	if (c == ':' || c == ';' || c == '=')
#else
	if (c == ';' || c == '=')
#endif
		return(1);
	return(0);
}

#ifndef	MINITEL
/*********************************************************************/
/*  Snewns()
*   Rotate to the next nameserver
*   Chooses the next highest number from the nameserv field
*/
Snewns()
	{
	struct machinfo *m,*low;
	int i;

	if (!Sns)					/* safety, should never happen */
		Sns = Smachlist;

	low = Sns;
	i = Sns->nameserv;			/* what is value now? */

	m = Smachlist;
	while (m) {
		if (m->nameserv == i+1) {
			Sns = m;
			return(0);
		}
		if ((m->nameserv > 0) && (m->nameserv < low->nameserv))
			low = m;
		m = m->next;
	}

	if (Sns == low)
		return(1);				/* no alternate */
	else
		Sns = low;

	return(0);
}


Ssetns(ipn)
	unsigned char ipn[4];
	{
	struct machinfo *m;
	int i;

	i = 0;
	if (NULL == (m = Slookip(ipn))) {		/* have already? */
		m = Smadd("=nameserv=");
		movebytes(m->hostip,ipn,4);
		m->mstat = FROMKIP;
		i = 1;
	}

	m->nameserv = 1;
	Sns = m;

	return(i);
}
#endif
/************************************************************************/
/*  setgates
*   set up the gateway machines and the subnet mask after netinit()
*   and start up ftp and rcp for them.
*/
Ssetgates()
	{
	struct machinfo *m;
	int level,again;

	if (Scon.havemask)					/* leave default unless specified */
		netsetmask(Scon.netmask);
/*
*  Search the list of machines for gateway flags.
*  Invoke netsetgate in increasing order of gateway level #s.
*  Terminates when it gets through list without finding next higher number.
*/
	level = 0;
	do {
		level++;
		again = 0;
		m = Smachlist;
		while (m != NULL) {
			if (m->gateway == level && m->mstat >= HAVEIP) 
				netsetgate(m->hostip);
			if (m->gateway == level+1)
				again=1;
			m = m->next;
		}
	} while (again);

	Sftpmode(Scon.ftp);
#ifdef PC
	Srcpmode(Scon.rcp);
#endif
	return(0);
}

/**********************************************************************/
/*  Scolorset
*  setup the color value from the config file string
*/
Scolorset(thecolor,st)
	int thecolor[3];
	char *st;
	{
	thecolor[0] = lookcolor(st);

	return(1);
}

/**********************************************************************/
/* lookcolor
*  search a list for the given color name
*/

static char *colist[] = {
	"black",
	"blue",
	"green",
	"cyan",
	"red",
	"magenta",
	"yellow",
	"white",
        "BLACK",
        "BLUE",
        "GREEN",
        "CYAN",
        "RED",
        "MAGENTA",
        "YELLOW",
        "WHITE" };

lookcolor(s)
	char *s;
	{
	int i;

	for (i=0; i<16; i++)
		if (!strcmp(colist[i],s))
			return(i);

	return(7);
}

char *colorlook(cl)
	int cl;
	{
	return(colist[cl]);
}


