/* hfile.inc - placed into all .h files to set up for PVCS 
   $Header:   E:/pcdirs/vcs/windat.h_v   1.0   15 Jan 1990 19:29:14   bkc  $
   Revision History ----------------------------------------------------
   $Log:   E:/pcdirs/vcs/windat.h_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:29:14   bkc
*/



/*
*  Windat -- window data structures for NCSA Telnet
****************************************************************************
*                                                                          *
*                                                                          *
*      NCSA Telnet                                                         *
*      by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
*                                                                          *
****************************************************************************
*  Tim Krauskopf
*
*  structure to save capabilities of windows, in addition to the
*  virtual vt102 screen driver.
*/
/*  
*  terminal modes, can be changed by external program
*  VTEK is a VT terminal that can accept graphics
*  TEK  is a tek graphics mode for a VT
*  VT   is a VT-only type, cannot be changed to graphics mode 
*/
#define DUMBTYPE 2
#define VTEKTYPE 1
#define TEKTYPE 4
#define VTTYPE 3
#define RASTYPE 5
#define	LOADTYPE	6
/* extra terminal states */
#define	RLOGIN		256		/* used in telstate */
#define	RSHELL		257		/* escape found */

#define NCOLORS 4

#ifdef  TN3270
#define TNBUFFSIZE      512            /* maximum data ever expected from network */
#define TNSHOVE	 128		/* amount to wait for before shove */
#endif
#ifndef  NTELOPTS
#include "arpa/telnet.h"
#endif

#ifdef	NEWKEY
#include "newkeys.h"
#endif

struct twin {
	struct twin *next,*prev;

	unsigned short colors[NCOLORS];
	unsigned char 
		mname[16],				/* name of the machine connected to */
		linemode[82];			/* line mode buffer for session */
	int pnum,					/* port number associated */
	vs,							/* virtual screen associated with it */
	telstate,					/* telnet state for this connection */
	termstate,					/* terminal type for this connection */
	teks,						/* tektronix window number */
	binary,						/* negotiate for binary traffic */
	igoahead,					/* negotiation for suppress go-ahead */
	ugoahead,					/* neg. for his suppress go-ahead */
	echo,						/* line mode or echo mode? */
	halfdup,					/* half duplex mode overrides line mode */
	crfollow,					/* what is supposed to follow a CR? NUL or LF? */
	capon,						/* does this session own a capture file? */
	sstat,						/* stat box on screen */
	bksp,						/* what keycode for backspace ?*/
	del,						/* for delete? */
        tnmode;                                         /* true if in tn3270 mode */
        char    myopts[NTELOPTS+1];
        char    hisopts[NTELOPTS+1];
	FILE *capfp;
	long	bytes;
	long	starttime;
	KeyLib	*key_map;				/* pointer to keymap */
	unsigned int key_prefix;
	unsigned long  flags;				/* finally, a flags structure */
#define	TWIN_FLAGS_LASTTYPE_VT102	0x1	/* last ttype sent was vt102 */
#define	TWIN_FLAGS_SENT3270_TYPE	0x2	/* we said we were a 3270 */
#define	TWIN_FLAGS_SENTANY_TYPE		0x4	/* we sent any naws type */
#define	TWIN_FLAGS_3270TO_CAPFILE	0x8	/* send 3270 data to capture file */
#define	TWIN_FLAGS_3270MODE_ON		0x10	/* always go into 3270 mode */
#define	TWIN_FLAGS_CONFIG_PORT		0x20	/* don't clear port number */
#define	TWIN_FLAGS_NOSHOW_PORT		0x40	/* don't show port number */
#define	TWIN_FLAGS_RLOGIN_PORT		0x80	/* its an RLOGIN PORT */
#define	TWIN_FLAGS_RSHELL_PORT		0x100	/* an rshell */
#define	TWIN_FLAGS_RCMD_MASK		0x180
#define	TWIN_FLAGS_MARGIN_BELL		0x200	/* ring margin bell */
#define	TWIN_FLAGS_NOBINARY		0x400	/* don't allow binary mode */
#define	TWIN_FLAGS_SCRIPT_ACTIVE	0x800	/* script file active */
#define	TWIN_FLAGS_CLOSE_NOWAIT		0x1000	/* don't do the 'press a key' on close */
#define	TWIN_FLAGS_DISCARDING		0x2000	/* currently discarding output, waiting for WILL_TM */

#ifdef  TN3270
        unsigned char   *tn3270_data;                           /* pointer to a structure w/ tn3270 data extensions */
        unsigned char   *tn3270_front;
        unsigned char   *tn3270_base;                   /* where data is sent from */
#endif
#ifdef	SCRIPT
		void	*Script;			/* ptr to script function */
#endif
};

#ifndef NPORTS
#define NPORTS  30
#endif

#ifdef WINMASTER
	struct twin *screens[30],*current=NULL,*console,*curdisp=NULL,
		*wins[NPORTS];
#else
	extern struct twin *screens[30],*current,*console,*curdisp,
		*wins[NPORTS];
#endif


