/* hfile.inc - placed into all .h files to set up for PVCS 
   $Header:   E:/pcdirs/vcs/whatami.h_v   1.0   15 Jan 1990 19:30:02   bkc  $
   Revision History ----------------------------------------------------
   $Log:   E:/pcdirs/vcs/whatami.h_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:30:02   bkc
*/


/*
*    Whatami.h
*  Machine specific information for NCSA Telnet TCP/IP kernel
****************************************************************************
*                                                                          *
*                                                                          *
*      NCSA Telnet                                                         *
*      by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
****************************************************************************
*   Defines for TCP/IP library, are you a Mac or a PC?
*/

#ifndef MAC
#define PC 1
#define ETHER 1
#define UB 1 
#endif

#if defined(__TURBOC__)||defined(__TCPLUSPLUS__)||defined(__BORLANDC__)
#define FTPVERSION "2.2/TC" REL
#else
#ifdef	PCNFS
#define FTPVERSION "2.2/NFS" REL
#else
#define FTPVERSION "2.2/MSC" REL
#endif
#endif

#ifdef	TN3270
#if defined(__TURBOC__)||defined(__TCPLUSPLUS__)||defined(__BORLANDC__)
#define	VERSION	"2.2TN/TC" REL
#else
#ifdef	PCNFS
#define	VERSION	"2.2TN/NFS" REL
#else
#define	VERSION	"2.2TN/MSC" REL
#endif
#endif
#else
#if defined(__BORLANDC__)
#define	VERSION	"2.2D/BC" REL
#else
#if defined(__TURBOC__)||defined(__TCPLUSPLUS__)
#define	VERSION	"2.2D/TC" REL
#else
#ifdef	PCNFS
#define	VERSION "2.2D/NFS" REL
#else
#define	VERSION "2.2D/MSC" REL
#endif
#endif
#endif
#endif

#ifndef ETHER
#define ATALK 1
#endif

/*
*   Defines which have to do with Ethernet addressing versus Appletalk
*   addressing.  Ethernet has 6 bytes of hardware address, ATALK has 4
*/
#ifdef ETHER
#define DADDLEN 6
#ifndef	SMALL_PACKETS
#define WINDOWSIZE 4096
#define TSENDSIZE 1024
#define DEFWINDOW 4096
#define DEFSEG	1024   
#else
#ifdef	MINITEL
#define WINDOWSIZE 1024
#define TSENDSIZE 1024
#define DEFWINDOW 1024
#define DEFSEG	1024
#else
#define WINDOWSIZE 2048
#define TSENDSIZE 1024
#define DEFWINDOW 2048
#define DEFSEG	2048   
#endif
#endif
#define TMAXSIZE 1500
#define UMAXLEN 1096
#define TUMAXLEN       8800             /* maximum fragmented udp transmission */
#define ICMPMAX 300 
#else
/*  define for AppleTalk */
#define DADDLEN 4
#define WINDOWSIZE 4096
#define TSENDSIZE 512
#define DEFWINDOW 512
#define DEFSEG	512
#define TMAXSIZE 512
#define UMAXLEN 512
#define ICMPMAX 300 
#endif


#ifdef PC
/*
*  define length of an integer - can be 16 or 32, we need to know which
*/
typedef char int8;
typedef unsigned char uint8;
typedef int int16;
typedef long int int32;
typedef unsigned int uint16;
typedef unsigned int uint;
typedef unsigned long int uint32;
#ifndef	MINITEL
uint32 longswap();
#endif

#define TICKSPERSEC 18
#define SMINRTO 5
#define WRAPTIME 86400L				/* in seconds, only for PC */
#define ALARM	120					/* alarm timeout in seconds */
#ifndef MINITEL
#define NPORTS	30
#else
#define NPORTS 4
#endif

#define CONNWAITTIME 20				/* default contime in seconds */

#define NFDEF {2,0,0}
#define NBDEF {0,0,0}
#define BFDEF {0,0,0}
#define BBDEF {2,0,0}
#define UFDEF {1,0,0}
#define UBDEF {0,0,0}

#else
#define TICKSPERSEC 60
#define SMINRTO 25
#define NPORTS	30
#define CONNWAITTIME 20				/* default contime in seconds */


#define	longswap(x) x
#define intswap(x) x
#define movebytes(x,y,z) movmem(y,x,z)
#define movenbytes(x,y,z) movmem(y,x,z)
#define n_putchar(x) putchar(x)
#define n_puts(x) putln(x)
#define NPORTS	30

#endif
#include "netevent.h"
#ifdef  __TURBOC__
#include <mem.h>
#endif
