/* newkeys.h --- new keyboard functions ... bkc 2/26/90 */


/* keymaps are contained in a dual table configuration...
   The first table has the list of codes that have been mapped.

   If mapped to a single character, then Is_char is true and Key_char has
   the actual character.

   Otherwise, key_offset is the byte offset into the second table of
   the definition.   (this allows for 4K of defs per table ) 
   All key definitions are at most 255 characters in length..

*/

#ifndef	_NEW_KEYS_DEF
#define	_NEW_KEYS_DEF	1
typedef struct S_Keylist {
	unsigned int 	Key_keycode;		/* the raw keycode we found */
	union {
		unsigned int U_Key_offset;	/* offset into def table */
#define	KEY_OFFSET_MASK	0xfff
#define	KEY_PREFIX1_MASK	0x8000
#define	KEY_PREFIX2_MASK	0x4000
#define	KEY_PREFIX3_MASK	0x2000
#define	KEY_PREFIX_MASK		(KEY_PREFIX1_MASK|KEY_PREFIX2_MASK|KEY_PREFIX3_MASK)
#define	KEY_NOPREFIX_MASK	0x1fff
		struct 	S_Flags {
			unsigned  U_Key_char : 8;	/* 8-bit char */
			unsigned  Filler   : 4; /* wastem */
			unsigned  U_Has_Macros : 1;
			unsigned  U_Key_mode : 2;	/* mode type */
#define	KEYMODE_ANY	0
#define	KEYMODE_APPL	1
#define	KEYMODE_NOTAPPL	2
#define	KEYMODE_CURSET	3
			unsigned  U_Is_char : 1;	/* set if its just a single char */
		} U_Key_Flags;
	} Key_union;
} KeyList;

#define	Key_char	Key_union.U_Key_Flags.U_Key_char
#define	Key_offset	Key_union.U_Key_offset
#define	Key_Is_char	Key_union.U_Key_Flags.U_Is_char
#define	Key_mode	Key_union.U_Key_Flags.U_Key_mode
#define	Key_Macros	Key_union.U_Key_Flags.U_Has_Macros

typedef struct S_Keydefs {
	unsigned char	Key_length;
	unsigned char	Key_data[1];
} KeyDefs;

typedef struct S_Keylib {
	struct S_Keylib	*Key_next;		/* next key library */
	char	*Key_name;		/* file name of key library */
	KeyList	*Key_List;		/* where the keylist is stored */
	int	 Key_Entries;		/* how many keys are in table */
	KeyDefs *Key_Defs;		/* where the defs for the keys are stored */
	int	 Key_Size;		/* size of def table in bytes */
	int	 Key_Refs;		/* how many references to this entry */
	int	 Key_Flags;		/* bit flags */
#define	KEY_FLAG_DYNAMIC	1
#define	KEY_FLAG_TNMODE		2
#define	KEY_FLAG_SHIFTS		4	/* has two key sequences */
	unsigned int Key_Active_Prefix;
} KeyLib;


typedef struct S_Macros {
	char	*M_Ident;		/* the macro name identifier */
	unsigned int	M_code;		/* the keycode or function arg */
#define  MCODE_COMMAND 0x8000 		/* macro is a command */
#define  MCODE_STRING  0x4000		/* macro produces a string */
#define  MCODE_FUNCTION 0x2000		/* macro calls a function */
	void	*M_func;		/* pointer to function, or char string */
} Macro;

extern KeyLib *Default_Key_Config;
KeyLib	*Key_Load_File(char *fname);
KeyLib *Key_Read_Keyfile(FILE *fptr, char *fname);
#endif

