/* testkey.c  -- test new key routines */
#include "config.h"
#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>

#ifdef	_MSC_
#include <stdarg.h>
#endif

#define	MAXLINES	25
#include "newkeys.h"
#include "windat.h"
#include "vsdata.h"

extern	unsigned int n_chkchar();
extern unsigned kbcodes;
extern int Key_silent;

struct VSscrn	V, *VSIw = &V;
struct 	twin t, *current=&t;
char	*TransPointer;
void	*Scon = NULL;

VSmarginbell()
{
}

Shostlook()

{

}

VSvalids()
{
	return(0);
}

int
XDataFromTerminal(win, str, len)
	struct twin *win;
	unsigned char *str;
	int len;
{
	printf("tn3270 ");
	netwrite(win,str,len);
	return(len);
}

int
cprintf(char *format,...)
{
	va_list list;
	char	tbuff[256],xbuff[256],*c,*o;
	int	len;

	va_start(list,format);
	vprintf(format,list);
	va_end(list);
	return(0);
}

int
nprintf(int x,char *format,...)
{
	va_list list;
	char	tbuff[256],xbuff[256],*c,*o;
	int	len;

	va_start(list,format);
	vprintf(format,list);
	va_end(list);
	return(0);
}
ncstrcmp(a,b)
	char	*a, *b;
{
	return(ncstrncmp(a,b,strlen(a)));
}

netwrite(x,buff,c)
	int	x;
	unsigned char	*buff;
	int	c;
{

	while(c) {
	       	if(isascii(*buff) && isalnum(*buff))
		       	printf("%c",*buff & 0xff);
		else
		        printf("<%x>",*buff & 0xff);
		buff++;
		c--;
	}
}

main(argc, argv)
	int	argc;
	char	*argv[];
{
	unsigned int c;
	KeyLib	*KL;
	KeyList	*kl;
	FILE	*outfile;

	n_chkchar();
	if(argc > 2 && !strcmp("-c",argv[2])) {
	        Key_silent = -1;

	       if(argc >=3) {
		      	if(!(outfile = fopen(argv[3],"w"))) {
			       	fprintf(stderr,"Can't open output file %s\n",argv[3]);
				exit(1);
			}
	       }
	       else
		      	outfile = stdout;
	       fprintf(outfile,"/*  Extended Keymaps from file %s\n",argv[1]);
	       kbcodes = 0x10;
	       KL = Key_Load_File(argv[1]);
	       if(!KL)
		      	exit(0);
	       fprintf(outfile,"*/\n\n");
	       Create_Code(outfile,"Ext",KL);
	       Key_Free_Lib(KL);
	       kbcodes = 0;
	       fprintf(outfile,"\n/* Non Extended Keymaps from file %s\n",argv[1]);
	       KL = Key_Load_File(argv[1]);
	       if(!KL)
		      	exit(0);
	       fprintf(outfile,"*/\n\n");
	       Create_Code(outfile,"",KL);
	       fclose(outfile);
	       exit(0);
	}

	if(kbcodes & 0x10)
	       	printf("Extended Keyboard\n");
	else
	        printf("Not an extended Keyboard\n");


	if(argc > 1) {
	       KL = Key_Load_File(argv[1]);
	       if(!KL)
		      	exit(0);
	 	current->key_map = KL;
	}
	while(1) {
	       c = n_chkchar();
	       if(c != 0xffff) {
		      printf("%x\n",c,c);
		      if((c & 0xff) == 27)
			     	break;
		      if(KL) {
			     	printf("Write:");
			     	vt100key(c);
				printf("\n");
		      }
		}
	}
	return(0);
}


Create_Code(fptr,subname,KL)			/* write out keyfile as code */
	FILE	*fptr;
	char 	*subname;
	KeyLib *KL;
{

	char	basename[80];
	KeyDefs	*kd;
	KeyList *kl;
	int	x,d;
	unsigned int *u;
	unsigned char	*c;

	c = KL->Key_name;
	while(*c) {
	        if(isascii(*c) && !isalnum(*c))
		       	*c = '_';
		c++;
	}
	sprintf(basename,"%s_%s",KL->Key_name,subname);

	fprintf(fptr,"unsigned char %s_KeyDefs[]={\n\t",basename);
	c = (unsigned char * ) KL->Key_Defs;
	d = 0;
	for(x=0; x < KL->Key_Size; x++) {
	        if((*c > 32) && (*c < 126) && (*c != 39) && (*c != 92) && (x != d))
		        fprintf(fptr,"'%c'",*c++);
		else
		       	fprintf(fptr,"% 3d",*c++);
		if(x == d) {
		       	d = x + *(c-1) + 1;
		}
		if(x + 1 != KL->Key_Size)
		       	fprintf(fptr,",");
		if(!((x+1) % 16))
		       	fprintf(fptr,"\n\t");
	}
	if(!KL->Key_Size)
	        fprintf(fptr,"0");
	fprintf(fptr,"\n};\n\n");
	fprintf(fptr,"unsigned int %s_KeyList[]={\n\t",basename);
	u = (unsigned int *) KL->Key_List;
	for(x=0; x < KL->Key_Entries*2; x++) {
	       	fprintf(fptr,"0x%04x",*u++);
		if(x + 1 != KL->Key_Entries*2)
		       	fprintf(fptr,",");
		if(!((x+1) % 8))
		       	fprintf(fptr,"\n\t");
	}
	fprintf(fptr,"\n};\n\n");

	fprintf(fptr,"KeyLib  %s_KeyLib={\n",basename);
	fprintf(fptr,"\tNULL,\n\t");
	fprintf(fptr,"\"%s_KeyLib\",\n\t",basename);
	fprintf(fptr,"%s_KeyList,\n\t",basename);
	fprintf(fptr,"%d,\n\t",KL->Key_Entries);
	fprintf(fptr,"%s_KeyDefs,\n\t",basename);
	fprintf(fptr,"%d,\n\t0,\n\t0\n};\n\n",KL->Key_Size);
}

