/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/telpass.c_v   1.0   15 Jan 1990 19:26:06   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/telpass.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:26:06   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   telpass.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/


/*
*   NCSA Telpass - edit password files for NCSA Telnet.
*   Tim Krauskopf 6/88
*
*   This program is rough-cut but functional.
*   If you improve it substantially, let me know.
*/
/************************************************************************/

#include "stdio.h"
#include "string.h"

char space[256];
char space2[256],*p;
char *lines[200],*malloc();

FILE *fout,*fin;

int nnames;

main(argc,argv)
	int argc;
	char *argv[];
	{
	int i,choice;

	nnames=0;

	n_clear();
	n_cur(0,0);
	n_puts("National Center for Supercomputing Applications\n\r");
	n_puts("Password file editor for NCSA Telnet\n\r");
	n_puts("Note:  This encryption of passwords is to hide clear text from casual viewing,\n\r");
	n_puts("       not to protect them from decryption.  You must assume that anyone with\n\r");
	n_puts("       access to the password file can decrypt the passwords.\n\r");

	if (argc < 2) {
		n_puts("A filename is required.  Usage: telpass filename\n\r");
		exit(0);
	}

	passlist(argv[1]);

	do {
		n_puts("List of names:");
		for (i=0; i< nnames; i++) {
			sprintf(space,"%3d. %s\n\r",i+1,lines[i]);
			n_puts(space);
		}
		n_puts("Enter the number of a user to change the password for,\n\r");
		n_puts("'a' to add a user, 'd #' to delete a user, 'e' to exit:\n\r");
		gets(space);
		n_row();
		choice = atoi(space);
		if (choice)
			dochoice(choice-1);
		else if (*space == 'a') {
			n_puts("Enter the username to add:\n\r");
			gets(space);
			n_row();
			lines[nnames] = malloc(strlen(space)+1);
			strcpy(lines[nnames++],space);
			dochoice(nnames-1);		/* get the password */
		}
		else if (*space == 'd') {
			choice = atoi(space+1);
			if (choice <= nnames && choice > 0) {
				for (i=choice-1; i<nnames; i++)
					lines[i] = lines[i+1];		/* shuffle down */
				nnames--;
			}
		}
		else if (*space == 'e')
			choice = -1;
	} while (choice >= 0);

	passwrite(argv[1]);

	exit(0);
}
/****************************************************************************/
/* dochoice
*  prompt for a certain password
*/
dochoice(c)
	int c;
	{
	char *p;
	char pwd[256],ver[256];

	strcpy(space,lines[c]);

	do {
		p = strchr(space,':');
		if (!p)
			strcat(space,":");
	} while (!p);						/* make sure we get a : */

	*p = '\0';
	p++;
	sprintf(space2,"Enter new password for user: %s \n\r",space);
	n_puts(space2);
	noecho(pwd);	
	n_puts("Verify password by entering again:\n\r");
	noecho(ver);
	if (strcmp(pwd,ver)) {
		n_puts("Password not verified\n\r");
		return(0);
	}
	Sencompass(pwd);					/* take password */
	sprintf(ver,"%s:%s",space,space2);
	lines[c] = malloc(strlen(ver)+1);
	strcpy(lines[c],ver);
	
}

noecho(s)
	char *s;
	{
	unsigned int c;

	do {
		c = n_chkchar();
		if (c > 31 && c < 128)
			*s++ = c;
	} while ( (c & 0xff) != 13);

	*s = '\0';
}

/****************************************************************************/
/* passwrite
*  write them out
*/
passwrite(s)
	char *s;
	{
	int i;

	if (NULL == (fout = fopen(s,"w"))) {
		n_puts("Cannot open file to write passwords.\n\r ");
		exit(0);
	}

	for (i=0; i < nnames; i++) {
		fputs(lines[i],fout);
		fputs("\n",fout);
	}

	fclose(fout);
	
}

/****************************************************************************/
/*  passlist
*   List the current file
*/
passlist(s)
	char *s;
	{

	if (NULL == (fin = fopen(s,"r"))) {
		n_puts("Starting new file.\n\r");
		return(0);
	}

	while (NULL != fgets(space,250,fin)) {
		space[strlen(space)-1] = '\0';
		lines[nnames] = malloc(strlen(space)+1);
		strcpy(lines[nnames++],space);
	}

	fclose(fin);
	
}

/****************************************************************************/
/* Scompass
*  compute and check the encrypted password
*/
Sencompass(ps)
	char *ps;
	{
	int i,ck;
	char *p,c,*en;

	en = space2;
	ck = 0;
	p = ps;
	while (*p)				/* checksum the string */
		ck += *p++;

	c = ck;

	for (i=0; i<10; i++) {
		*en =  (((*ps ^ c) | 32) & 127); 	/* XOR with checksum */
		if (*ps)
			ps++;
		else
			c++;		/* to hide length */
		en++;
	}

	*en = 0;

}
