/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/tn3270.c_v   1.0   15 Jan 1990 19:25:42   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/tn3270.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:25:42   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   tn3270.c  $ $Revision:   1.0  $"};
/* #define	DEBUG	1 */
#include <stdio.h>
#include <dos.h>
#include <setjmp.h>
#include <conio.h>
#include <time.h>
/* #define XDEB    1 */
#ifdef	_MSC_
#include <bios.h>
#endif

#include "windat.h"
#include "newwin.h"
#include "netevent.h"

#include "screen.h"
#include "oia.h"

#include "globals.h"
#include "general.h"


struct twin      *to3270,*fromconsole;
int    capon=0,viewmode;
extern int    extended;      /* defined in ncsaio.asm */
/* here are some ugly assumptions.
   we assume that input from the keyboard could send data to network or screen
   but any data from network could result in output to screen and network.

   so, we use to3270 to hold the twin of the active io channel
*/

extern	unsigned char	*TransPointer;

static char attrib;
static int oldkey;
static jmp_buf tn3270_jump;
unsigned long bytecount;
int	onscreen=1;		/* true if we are currently displaying */
extern unsigned video_seg;
int	row, column;
static int	initialized;

int
TN_status()

{
        if(!oia_modified) {
#ifdef  __TURBOC__
                if((bioskey(2 + extended) & 0x63) != oldkey)
                        return(1);
                else
		   	return(0);
#endif
#ifdef	_MSC_
		if((_bios_keybrd(2 + extended) & 0x63) != oldkey)
		   	return(1);
		else
		   	return(0);
#endif
                        return(0);
        }
        return(1);
}

ClearScreen()			/* clear our display screen */
{

	if(onscreen) {
		clrscr();
		gotoxy(1,1);
	}
}

capstat(s)
	char	*s;
{
	int x,y;

	if(!onscreen)
	       	return;
	x = wherex();
	y = wherey();
	gotoxy(79-strlen(s),25);
	cprintf("%s",s);
	gotoxy(x,y);
}

Report_Error(s)		/* bell... ? */
	char *s;
{
	int	x,y;	

	if(!onscreen)
	       	return;
	x = wherex();
	y = wherey();

	gotoxy(1,25);
	cprintf("%s",s);
	n_play(sounds[SOUND_BADKEY]);
	gotoxy(x,y);

}

SetAttrib(at)
        char at;
{

   if(!at)
        attrib = to3270->colors[0];
   else
        attrib = at;
   if(onscreen)
	   textattr(attrib);
}


int
Get_OIA(str)                    /* get OIA into the string, return its length */
        unsigned char *str;
{

static union status {
                struct fred {
                        char  rule;
                        char  space;
                        char  syswait[4];
                        char  space2;
                        char  terminalwait[2];
                        char  space3;
                        char  messedup[4];
                        char  insertmode;
                        char  shiftmode;
                        char  num;
                        char  terminator;
                 } byte_values;
                char raw_data[1];
        } *p;

       int      x;

#define CONNECTED       219

       p = (union status *) str;

       for(x=0; x < sizeof(union status); x++)
                p->raw_data[x] = 32;
       p->byte_values.terminator = 0;

       p->byte_values.rule = 'A';
       if(IsOiaSystemLocked(&OperatorInformationArea))
                strncpy(p->byte_values.syswait,"\130SYS",4);
       if(IsOiaTWait(&OperatorInformationArea))
                strncpy(p->byte_values.terminalwait,"\130\354",2);
       if(OperatorInformationArea.input_inhibited[1] & OIA_TOO_MUCH_ENTERED)
                strncpy(p->byte_values.messedup,"\130\001>",3);
       else if(OperatorInformationArea.input_inhibited[1] & OIA_NUMERIC_FIELD)
                strncpy(p->byte_values.messedup,"\130\001NUM",5);
       else if(OperatorInformationArea.input_inhibited[2] & OIA_OP_UNAUTHORIZED)
                strncpy(p->byte_values.messedup,"\130\001\130",3);
       else if(OperatorInformationArea.input_inhibited[2] & OIA_OP_UNAUTHORIZED_MIN)
                strncpy(p->byte_values.messedup,"\130\001\130",3);
       else if(OperatorInformationArea.input_inhibited[2] & OIA_WRONG_PLACE)
                strncpy(p->byte_values.messedup,"\130\032\001\033",4);

       p->byte_values.insertmode = IsOiaInsert(&OperatorInformationArea) ? '^' : ' ';

#if  defined(__TURBOC__)||defined(_MSC_)
#ifdef	__TURBOC__
       oldkey = bioskey(2 + extended) & 0x63;
#else
	oldkey = _bios_keybrd(2 + extended) & 0x63;
#endif
       if(oldkey & 0x43)
          p->byte_values.shiftmode = 24;
       if(oldkey & 0x20)
          p->byte_values.num = '#';

#endif
        oia_modified = 0;
        return(sizeof(union status));

}


NCSA_TransStart()

{
        int transmode;

        transmode = (to3270->tnmode >> 1) & 3;
#ifdef	DEBUG
	cprintf("Transstart %x\n",to3270->tnmode);
#endif
        if(!(to3270->tnmode & 128)) {    /* switch into transparent mode */
                to3270->tnmode |= 128;
             switch (transmode) {
#ifndef	MINITEL
                case 0:         /* tek mode */
		        vprint(console->vs,"\n\r Transparent Data Entering Tek mode \n\r");
			to3270->termstate = TEKTYPE;
			VGgmode(rgdevice);
			VGuncover(temptek);
			current=to3270;
			VGwrite(temptek,"\033\014",2);
                        break;

                case 1:         /* vt mode */
			to3270->termstate = VTEKTYPE;
                        break;
#endif
                case 2:         /* capfile */
				if (capon) {	/* already on */
                                        /* leave it on */
				}
				else if (!capon) {				/* I want one */
					FILE *Sopencap();
					if (NULL == (to3270->capfp = Sopencap())) {
						RingBell("Cannot open capture file");
						break;
					}
					capstat("Capture on ");
					bytecount = 0;
					to3270->capon = capon = 1;
				}

                        break;
                default :;      /* huh? */
             }
       }
}


NCSA_TransStop()
{
        int transmode;

        transmode = (to3270->tnmode >> 1) & 3;
#ifdef	DEBUG
	cprintf("Transtop! %x\n",to3270->tnmode);
#endif

        if((to3270->tnmode & 128)) {    /* switch out of transparent mode */
                to3270->tnmode &= 127;

             switch (transmode) {
#ifndef	MINITEL
                case 0:         /* tek mode */
#ifdef	JUNK
                                VSwrite(to3270,"\007\007",1);       /* ring bell */
                                   /* make em hit ALTR themselves */
#endif
#ifndef  NOTUSED
				if (!leavetek()) {
					if (current->capon) {
						fclose(current->capfp);
						current->capon = capon = 0;
					}
					VSreset(current->vs);		/* reset's emulator */
				}
				wrest(current);
#endif
                        break;

                case 1:         /* vt mode */
                        break;
#endif
                case 2:         /* capfile */
				if (capon) {	/* already on */
#ifdef	DEBUG
	cprintf("Turning off capture file\n");
#endif
                                        /* turn it off */
					capstat("     Capture off");
					fclose(to3270->capfp);		/* close the capture file */
					capstat("                ");
					to3270->capon = capon = 0;
					bytecount = 0 ;

				}

                        break;

             }
       }


}

void
tn_cursor(xrow,col)              /* position and turn on the cursor */
        int xrow;
        int col;

{

	 row = xrow;
	 column = col;
	 if(!onscreen)
		return;
	 gotoxy(column+1, row+1);
}

tn_vsreset(vs)
        int vs;

{
}

void
ScreenWrite(position, buff, count)      /* write string into VS buffer and screen using attrib */
        int position;           /* position in Host[] */
        unsigned char *buff;
        int count;
{
        /* the 3270 stuff seems to want to write the same data over the screen even after
           its been written to the screen, so we scan through and only draw over
           new stuff that hasn't yet been written to the screen. */

        int x,y;
	 unsigned int a;
	 unsigned int far	*video;

	 if(!onscreen)
		return;
        x = position % NumberColumns;
        y = position/NumberColumns;
#ifdef	JUNK
	 row = (position + count+1)/NumberColumns;
	 column = (position + count+1) % NumberColumns;
#endif
	 video = (unsigned char far *) MK_FP(video_seg, (y * 80 + x) << 1);
	 a = attrib << 8;
	 while(count--) 
		*video++ = a | *buff++;

        return;

}
void
EmptyTerminal()                 /* make sure all chars to terminal are output */
{
/*	tn_cursor(row,column); */
}


suspend()                       /* ^Z not available under msdos */
{

}


ExitString(string, returnCode)  /* kill the program... have to look at this */
        char    *string;
        int     returnCode;
{
	 char buff[80];

        sprintf(buff,"Exit String :Error code %d (%s)\n",returnCode, string);
	 ScreenWrite(0, buff,strlen(buff));
	 /* now force the connection closed */
	 netputuev(CONCLASS,CONCLOSE,to3270->pnum);
 	longjmp(tn3270_jump,1);
}

void
StringToTerminal(s)
        char    *s;
{
        int count;

        count = strlen(s);
        if(count)
                DataToTerminal(s,count);
}

void
command(top)
        int top;                        /* enter command mode */
{

}


int
DataToTerminal(buffer, count)
        char    *buffer;
        int     count;
{
       /*  parsewrite(to3270,buffer,count); */
	char	tbuff[40];
	 if(capon && to3270->capfp) {
	 	fwrite(buffer, 1, count, to3270->capfp);
		if(onscreen) {
		       	sprintf(tbuff,"Capture:%ld ",bytecount += count);
		 	capstat(tbuff);
		}
	 }
 	 else {
	        if(*buffer == 7 && count == 1) {
		        n_play(sounds[SOUND_BELL]);
		}
	 	else if(onscreen)
			cprintf("%*.*s",count,count,buffer);
	 }
        return(count);
   
}

void
quit()

{
        ExitString("From Quit",0);
}


int
DataToNetwork(buffer, count, doneflag)  /* send the data to the network connection
                                           if doneflag is set, add IAC EOR to after the
                                           last byte sent. Compensate for IAC's in the field
                                           by adding an extra IAC 
                                              
                                           see tn3270.c    
                                          */

        unsigned char *buffer;
        int     count;
        int     doneflag;

{
        unsigned char xbuff[2];        /* 8K out of the stack, wow! */
        int     x,z,ocount;
        unsigned char *c,iac;
        
#ifdef	MEM_DEBUG
	char ibuff[80];

	sprintf(ibuff,"DataToNetwork %d/%d to port %d at %lp\n\r",count,doneflag,to3270->pnum,to3270);
	vprint(console->vs,ibuff);
#endif
        
        ocount = count;
        while(count > 0) {
           x = 0;
           c = buffer;

#ifdef  XDEB
        printf("top loop count %d x %d z %d\n",count,x,z);
#endif
           while( (*(c) != IAC) && (x < count)) { /* skip to next iac  or end */
                c++;
                x++;
           }
           while(x > 0) {
#ifdef  XDEB
        printf("first loop count %d x %d z %d\n",count,x,z);
#endif
                z = netwrite(to3270->pnum,buffer,x);
/*                netpush(to3270->pnum); */
                if(z < 1) {
                        netsleep(0);    /* try and empty the queue */
                        continue;
                }
                x -= z;
                buffer += z;
                count -= z;
           }
           if(count) {             /* if true, there was an IAC */
                iac = IAC;
                z = 0;
                while(z < 1) {
#ifdef  XDEB
        printf("second loop (iac) count %d x %d z %d\n",count,x,z);
#endif

                        z = netwrite(to3270->pnum,&iac,1);
/*                        netpush(to3270->pnum); */
                        if(z < 1) {
                                netsleep(0);    /* try and empty the queue */
                                continue;
                        }
                }
           }
        }
        if(doneflag) {
                xbuff[0] = IAC;
                xbuff[1] = EOR;
                x = 0;
                count = 2;
                while(count > 0) {                          /* this is an unfair
                                                           recursion to force data
                                                           out the network if it won't
                                                           all fit */
#ifdef  XDEB
        printf("third loop (EOR) count %d x %d z %d\n",count,x,z);
#endif

                        z = netwrite(to3270->pnum,&xbuff[x], count);
/*                        netpush(to3270->pnum); */
                        if(z < 1) {
                                netsleep(0);    /* try and empty the queue */
                                continue;
                        }
                        count -= z;
                        x += z;
                }
        }
        return(ocount);      /* say we sent it all */

}


int
XDataFromNetwork(tw,mode )    /* calls special data from network */
        struct twin *tw;
        int     mode;

{
        int  x;
        to3270 = tw;
 
	 if(setjmp(tn3270_jump)) {
		char xbuff[32];
		while(netread(tw->pnum,xbuff, 32) > 0);	/* discard all data */
		return(FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_base)); /* pretend we read it all */
        }
        x = DataFromNetwork(tw->tn3270_base, FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_base), mode);
	 if(mode) { 
	        while(!DoTerminalOutput());
	        if(TN_status())
       	         statline();
	 } 
        return(x);
}


int
XDataFromTerminal(tw, buff, count )
        struct twin *tw;
        char    *buff;
        int     count;
{
        int x;
#ifdef	NEWKEY
	 char *c,*i;

	 i = c = buff;
	 if(!TransPointer)
	 for(x=count; x > -1; x--) {
		switch (*i) {
		       case '\r' :
			       *c = '\300';
				break;
			case '\n' :
			        i++;
			 	count--;
				continue;
				break;
			case '\040' :
			       	*c = '\226';
			 	break;
			default:;
		}
	 	i++;
	 	c++;
	}
#endif
        to3270 = tw;
        x = DataFromTerminal(buff, count);
        while(!DoTerminalOutput());
        if(TN_status())
                statline();
        return(x);
}

void
setconnmode()
{

}

#ifdef  MAIN
main()
#else
tn3270_init()
#endif
{

   MaxNumberLines = NumberLines = 24;
   MaxNumberColumns = NumberColumns = 80;
   ScreenSize = NumberLines * NumberColumns;

   init_ctlr();
   init_keyboard();
   init_screen();
   init_system();
        
}

void
show_clock(int mode)
{

#ifdef	CLOCK
static	 long	last_time;
#ifdef	__TURBOC__	
   struct time t;
#else
   struct tm *t;
   time_t  ti;
#endif
   extern int clockmode,screenInitd;
   char buff[15];
   int l;
	 if(!onscreen || ((time(NULL) == last_time) && !mode) || !clockmode || !screenInitd || bytecount)
		return;

	 last_time = time(NULL);
#ifdef	__TURBOC__
	   gettime(&t);
	   if(clockmode == 12) {
		   	if(t.ti_hour > 12)
			       	t.ti_hour -= 12;
	   }
	   sprintf(buff,"%02d%c%02d",t.ti_hour, t.ti_sec & 1 ? ':' : ' ', t.ti_min);
#else
	   time(&ti);
	   t = localtime(&ti);
	   if(clockmode == 12) {
		   	if(t->tm_hour > 12)
			       	t->tm_hour -= 12;
	   }
	   sprintf(buff,"%02d%c%02d",t->tm_hour, t->tm_sec & 1 ? ':' : ' ', t->tm_min);
#endif
	l = attrib;

	attrib = to3270->colors[1];
	ScreenWrite(80 * 24 + 72,buff, strlen(buff));
	attrib = l;

#endif
}

statline()
{
	int x,y,l;
	char	oia[80];

	l = attrib;

	attrib = to3270->colors[1];
	for(x=0; x < 80; x++)
	       	oia[x] = 32;
	oia[78] = 0;
	strncpy(oia,current->mname,strlen(current->mname));
	Get_OIA(&oia[17]);
	x = strlen(oia);
	if(!bytecount) {
	        oia[x] = 32;
		x = 80;
	}	/* end if ! bytecount */
	ScreenWrite(80 * 24, oia,  x);
	attrib = l;
	show_clock(1);
}

