/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/tek/rge.c_v   1.0   15 Jan 1990 20:02:16   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/tek/rge.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 20:02:16   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   rge.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/



/*

rge.c by Aaron Contorer for NCSA

Thanks to Bruce Orchard for contributions to this code

graphics routines for drawing on EGA
Input coordinate space = 0..4095 by 0..4095
MUST BE COMPILED WITH LARGE MEMORY MODEL!

*/

#include <stdio.h>
	/* used for debugging only */
#include <dos.h>
	/* used for EGA init call */

#include "newwin.h"
     
#define TRUE -1
#define FALSE 0
#define INXMAX 4096
#define INYMAX 4096
#define SCRNXHI 639
#define SCRNYHI 349
#define MAXRW 32
	/* max. number of real windows */

extern char *malloc();

static int EGAactive;		/* number of currently EGAactive window */
static char *EGAname = "Enhanced Graphics Adaptor, 640 x 350";
#define EGAxmax 640
#define EGAymax 350
static int EGAbytes=80;	/* number of bytes per line */

/* Current status of an EGA window */
struct EGAWIN {
	char inuse; /* true if window in use */
	int pencolor, rotation, size;
	int winbot,winleft,wintall,winwide;
		/* position of the window in virtual space */
	};


static struct EGAWIN EGAwins[MAXRW];

static  int     egastartmode;   /* what mode we started in */
extern  int     rgdevice,autovideo;

EGAsetup()
/* prepare variables for use in other functions */
{
        union REGS io;          /* modified BKC 10/12/88 to support 
                                 large window sizes, ie: 43 line mode */
        if(!egastartmode) {     /* for some reason this is called
                                   after entering tekmode, so if set
                                   already, we skip it 
                                */
                io.x.ax=0x0f00;
                int86(0x10,&io,&io);
                egastartmode = io.x.ax & 0xFF;        
        }                        
}


RGEgmode()
/* go into EGA graphics mode */
{
	union REGS in;
	in.x.ax = 0x10;
	int86(0x10,&in,&in);
}

RGEtmode()
/* go into EGA 80x25 color text mode */
{
	union REGS in;
	in.x.ax = 3;
	int86(0x10,&in,&in);
        ega43();                        /* go into ega 43 line mode if they requested it */
	EGAactive = -1;
}

egareset()
{
   	union REGS in;
        unsigned char far *b;

        if((rgdevice != 1) || ((NUMLINES != 41) && (NUMLINES != 33)) || !autovideo)
           return;

        in.x.ax = 3; /* egastartmode;    */    /* put back to what it was when
                                           we started, might be in hi-res
                                           mode anyway
                                        */
	int86(0x10,&in,&in); 

}

RGEclrscr(w)
int w;
/*
	Clear the screen.
*/
{
	if (w == EGAactive) {
		EGAsetup();
		RGEgmode();
	}
}


int RGEnewwin()
/*
	Set up a new window; return its number.
	Returns -1 if cannot create window.
*/
{
	int w=0;

	while (w<MAXRW && EGAwins[w].inuse) w++;
	if (w==MAXRW) return(-1); /* no windows available */
	EGAwins[w].pencolor = 7;
	EGAwins[w].winbot = 0;
	EGAwins[w].wintall = 3120;
	EGAwins[w].winleft = 0;
	EGAwins[w].winwide = 4096;
	EGAwins[w].inuse = TRUE;
	return(w);
}


RGEclose(w)
int w;
{
	union REGS in;
#ifdef  REDICULOUS
	in.x.ax = 3;
#else
        in.x.ax = egastartmode;        /* put back to what it was when
                                           we started, might be in hi-res
                                           mode anyway
                                        */
#endif        
	int86(0x10,&in,&in);

	if (EGAactive==w) {
		RGEclrscr();
		EGAactive=-1;
	}
	EGAwins[w].inuse = FALSE;
}


RGEpoint(w,x,y)
int w,x,y;
/* set pixel at location (x,y) -- no range checking performed */
{
	int x2,y2; /* on-screen coordinates */

	if (w == EGAactive) {
		x2=(int) ((EGAxmax*(long)x)/INXMAX);
		y2=SCRNYHI-(int) (((long)y*EGAymax)/INYMAX);
		EGAset (x2, y2, EGAwins[w].pencolor);
	}
}


RGEpagedone(w)
int w;
/*
	Do whatever has to be done when the drawing is all done.
	(For printers, that means eject page.)
*/
{
	/* do nothing for EGA */
}


RGEdataline(w,data,count)
int w,count;
char *data;
/*
	Copy 'count' bytes of data to screen starting at current
	cursor location.
*/
{
	/* Function not supported yet. */
}


RGEpencolor(w,color)
int w,color;
/*
	Change pen color to the specified color.
*/
{
#ifdef	OLDSTUFF
	if (!color)
		color = 1;
	color &= 0x7;
				/* flip color scale */
	EGAwins[w].pencolor = 8 - color;
#else
	EGAwins[w].pencolor = color & 0xf;
#endif
}


RGEcharmode(w,rotation,size)
/*
	Set description of future device-supported graphtext.
	Rotation=quadrant.
*/
{
	/* No rotatable device-supported graphtext is available on EGA. */
}

/* Not yet supported: */
RGEshowcur() {}
RGElockcur() {}
RGEhidecur() {}

#ifndef	_MSC_
static int abs(x)
int x;
{
  if (x>=0) return(x);
  else return(-x);
}
#endif

RGEdrawline(w,x0,y0,x1,y1)
int w,x0,y0,x1,y1;
/* draw a line from (x0,y0) to (x1,y1) */
/* uses Bresenham's Line Algorithm */
{
	int x,y,dx,dy,d,temp,
	dx2,dy2,		/* 2dx and 2dy */
	direction;		/* +1 or -1, used for slope */
	char transpose;	/* true if switching x and y for vertical-ish line */

	if (w != EGAactive) return;

	x0 = (int) (((long) x0 * EGAxmax) / INXMAX);
	y0 = EGAymax - 1 - (int) ((EGAymax*(long) y0) / INYMAX);
	x1 = (int) (((long) x1 * EGAxmax) / INXMAX);
	y1 = EGAymax - 1 - (int) ((EGAymax*(long) y1) / INYMAX);

	if (abs(y1-y0) > abs(x1-x0)) {
		/* transpose vertical-ish to horizontal-ish */
		temp=x1; x1=y1; y1=temp;
		temp=x0; x0=y0; y0=temp;
		transpose=TRUE;
	} else transpose=FALSE;

	/* make sure line is left to right */
	if (x1 < x0) {
		temp=x1; x1=x0; x0=temp;
		temp=y1; y1=y0; y0=temp;
	}

	/* SPECIAL CASE: 1 POINT */
	if (x1==x0 && y1==y0) {
		EGAset (x1, y1, EGAwins[w].pencolor);
		return(0);
	}


	/* ANY LINE > 1 POINT */

	x=x0;
	y=y0;
	dx=x1-x0;
	if (y1 >= y0) {
		dy=y1-y0;
		direction=1;
	} else {
		dy=y0-y1;
		direction= -1;
	}
	dx2=dx<<1;
	dy2=dy<<1;

	d = (dy<<1) - dx;

	if (transpose) {	
		/* CASE OF VERTICALISH (TRANSPOSED) LINES */
		while (x <= x1) {
			if (y>=0 && y<EGAxmax && x>=0 && x<EGAymax)
				EGAset (y, x, EGAwins[w].pencolor);
			while (d >= 0) {
				y += direction;
				d -= dx2;
			}
			d += dy2;
			x++;
		}

	} else {
		/* CASE OF HORIZONTALISH LINES */
		while (x <= x1) {
			if (x>=0 && x<EGAxmax && y>=0 && y<EGAymax)
				EGAset (x, y, EGAwins[w].pencolor);
			while (d >= 0) {
				y += direction;
				d -= dx2;
			}
			d += dy2;
			x++;
		}
	} /* end horizontalish */

} /* end RGEdrawline() */


RGEbell(w)
int w;
/* Ring bell in window w */
{
	if (w == EGAactive) putchar(7);
}


char *RGEdevname()
/* return name of device that this RG supports */
{
	return(EGAname);
}


RGEinit()
/* initialize all RGE variables */
{
	int i;
	EGAsetup();
	for (i=0; i<MAXRW; i++) {
		EGAwins[i].inuse = FALSE;
	}
	EGAactive = -1;
}


RGEuncover(w)
int w;
/*
	Make this window visible, hiding all others.
	Caller should follow this with clrscr and redraw to show the current
	contents of the window.
*/
{
	EGAactive = w;
}

RGEinfo(w,a,b,c,d,v) {}
