;/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
;   Notice:
;        Portions of this file have been modified by
;        The Educational Resources Center of Clarkson University.
;
;        All modifications made by Clarkson University are hereby placed
;        in the public domain, provided the following statement remain in
;        all source files.
;
;        "Portions Developed by the Educational Resources Center, 
;                Clarkson University"
;
;        Bugs and comments to bkc@omnigate.clarkson.edu
;                                bkc@clgw.bitnet
;
;        Brad Clements
;        Educational Resources Center
;        Clarkson University
;*/


ifdef   TURBOC
Microsoft EQU 1
else
Lattice EQU 1
endif
ifndef Microsoft
  ifndef Lattice
	if2
	%out
	%out ERROR: You have to specify "/DMicrosoft" OR "/DLattice" on the
	%out        MASM command line to determine the type of assembly.
	%out
	  endif
	end
endif
endif
        X EQU   6                               ;  for the large model programs



		page	55,132
		title	EGAset:  Set bit in EGA raster
;
;  Function to set a bit in the EGA raster
;
;  Bruce Orchard, April 29, 1988
;
;  The EGA must be in 640x350 graphics mode (mode 10) before
;  this function is called.  Its arguments are not checked.
;
;  EGA equates
E_refresh_seg	segment	at 0a000h
E_refresh	db	?
E_refresh_seg	ends
E_graph_ad	equ	3ceh
E_bit_mask	equ	3cfh
E_bit_mask_i	equ	8h
E_seq_ad	equ	3c4h
E_map_mask_i	equ	2
E_map_mask	equ	3c5h


ifdef Microsoft
	_DATA   segment public 'DATA'
k80		dw	80

else
	INCLUDE DOS.MAC
	DSEG

k80		dw	80
endif

ifdef Microsoft
_DATA   ends
else
	ENDDS
endif

ifdef Microsoft
EGAset_text	segment	public 'CODE'
		assume	cs:EGAset_text,ds:_DATA,es:E_refresh_seg
		public	_EGAset
		public	_EGAget
else
	PSEG
	public EGAset
endif

x		equ	6		; x coordinate (0-649, left to right)
y		equ	x+2		; y coordinate (0-349, top to bottom)
color		equ	y+2		; color (0-15, black to white)

ifdef Microsoft
_EGAset		proc	far
else
EGAset		proc 	far
endif
		push	bp		; save bp
		mov	bp,sp		; bp -> frame
		push	ds		; save ds
		push	es		; save es
;		mov	ax,seg EGAset_data ; ax -> data segment
;		mov	ds,ax		; ds -> data segment
		mov	ax,seg E_refresh ; ax -> refresh segment
		mov	es,ax		; es -> refresh segment
		mov	dx,E_graph_ad	; dx -> graphics address register
		mov	al,E_bit_mask_i	; bit mask index -> al
		out	dx,al		; select bit mask register
		mov	dx,E_bit_mask	; dx -> bit mask register
		mov	cx,[bp+x]	; x -> cx
		and	cx,7		; keep bit number in byte
		mov	al,80h		; 1 -> al
		shr	al,cl		; shift mask bit to right bit
		out	dx,al		; set mask
		mov	dx,E_seq_ad	; dx -> sequencer address register
		mov	al,E_map_mask_i	; Map mask index -> al
		out	dx,al		; select map mask
		mov	dx,E_map_mask	; dx -> map mask register
		mov	al,0fh		; mask all planes
		out	dx,al		; write enable all planes
		mov	bx,[bp+x]	; x -> bx
		shr	bx,1		; / 2
		shr	bx,1		; / 2
		shr	bx,1		; / 2
		mov	ax,[bp+y]	; y -> ax
		mul	k80		; compute row address
		add	bx,ax		; byte address -> bx
		mov	al,es:[bx]	; latch byte to get other bits
		mov	al,0		; 0 -> al
		mov	es:[bx],al	; clear all planes of right bit
		mov	dx,E_seq_ad	; dx -> sequencer address register
		mov	al,E_map_mask_i	; Map mask index -> al
		out	dx,al		; select map mask
		mov	dx,E_map_mask	; dx -> map mask register
		mov	al,[bp+color]	; color -> al
		out	dx,al		; write enable planes for right color
		mov	al,es:[bx]	; latch byte to get other bits
		mov	al,0ffh		; 1 in right bit -> al
		mov	es:[bx],al	; set right bit in all color planes
		mov	dx,E_seq_ad	; dx -> sequencer address register
		mov	al,E_map_mask_i	; Map mask index -> al
		out	dx,al		; select map mask
		mov	dx,E_map_mask	; dx -> map mask register
		mov	al,0fh		; mask all planes
		out	dx,al		; write enable all planes
		mov	dx,E_graph_ad	; dx -> graphics address register
		mov	al,E_bit_mask_i	; bit mask index -> al
		out	dx,al		; select bit mask register
		mov	dx,E_bit_mask	; dx -> bit mask register
		mov	al,0ffh		; ff -> al
		out	dx,al		; set mask to all bits
		pop	es		; restore es
		pop	ds		; restore ds
		pop	bp		; restore bp
		ret			; return
ifdef Microsoft
_EGAset		endp
else
EGAset	endp
endif


ifdef Microsoft
_EGAget		proc	far
else
EGAget		proc 	far
endif


		push	bp
		mov	bp,sp
		push	di
		push	es
		mov	bx,seg E_refresh
		mov	es,bx
		mov	cx,[bp+x]
		mov	dx,[bp+y]
		mov	ax,80
		mul	dx
		mov	bx,cx
		shr	bx,1
		shr	bx,1
		shr	bx,1
		add	bx,ax
		and	cl,7
		xor	cl,7
		mov	ch,1
		shl	ch,cl

; set the bit mask register
		mov	ah,3
lec1:	mov	dx,3ceh
		mov	al,4
		out	dx,al

		mov	dx,3cfh
		mov	al,ah
		out	dx,al

; latch all four bit planes
		mov	al,es:[bx]

; gather the bits together in CL
		shl	cl,1
		and	al,ch
		jz	lec2
		or	cl,1
lec2:	dec	ah
		jge	lec1

		and	cl,0fh
		mov	al,cl
		xor	ah,ah
		les	bx,dword ptr[bp+color]
		mov	es:word ptr[bx], ax

		pop	es
		pop	di
		pop	bp
		ret

ifdef Microsoft
_EGAget		endp
else
EGAget	endp
endif

ifdef Microsoft
EGAset_text	ends
else
		ENDPS
endif
		end
