/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char sccsid[] = "@(#)termout.c	4.1 (Berkeley) 12/4/88";
#endif /* not lint */

#define	FIELDDEBUG	0	/* set non zero to show field attr */

#ifdef	NCSA
#include "config.h"
#endif

#include <stdio.h>
#include <dos.h>
#include "general.h"

/* #include "../telnet.ext" */

#include "disp_asc.h"
/* #include "../ascii/map3270.ext" */

#include "hostctlr.h"
#include "externs.h"
#include "declare.h"
#include "oia.h"
#include "screen.h"

#include "globals.h"

#include "video.h"

extern void EmptyTerminal();

#define CorrectTerminalCursor() ((TransparentClock == OutputClock)? \
		terminalCursorAddress:UnLocked? CursorAddress: HighestScreen())


static int terminalCursorAddress;	/* where the cursor is on term */
int screenInitd; 		/* the screen has been initialized */
static int screenStopped;		/* the screen has been stopped */

static int needToRing;			/* need to ring terinal bell */

typedef struct {
    char
	data,		/* The data for this position */
	attr;		/* The attributes for this position */
} ScreenBuffer;

/* ScreenBuffer Screen[MAXNUMBERLINES*MAXNUMBERCOLUMNS];
ScreenBuffer saveScreen[sizeof Screen/sizeof Screen[0]]; */


/* OurExitString - designed to keep us from going through infinite recursion */

#ifdef  NCSA
#include "windat.h"
#include "newwin.h"
extern struct twin *to3270;
#define XBUFFSIZE       64
static    char xbuff[XBUFFSIZE+1];

#endif


static void
OurExitString(file, string, value)
FILE	*file;
char	*string;
int	value;
{
    static int recursion = 0;

    if (!recursion) {
	recursion = 1;
	ExitString(file, string, value);
    }
}


static void
GoAway(from, where)
char *from;		/* routine that gave error */
int	where;		/* cursor address */
{
	char foo[100];

	sprintf(foo, "ERR from %s at %d (%d, %d)\n",
		from, where, ScreenLine(where), ScreenLineOffset(where));
	OurExitString(stderr, foo, 1);
	/* NOTREACHED */
}

/*
 * Routines to deal with the screen.  These routines are lifted
 * from mskermit.
 */

#define	CRT_STATUS	0x3da		/* Color card */
#define	DISPLAY_ENABLE	0x08		/* Enable */
#define	scrseg()	((crt_mode == 7)? 0xb800 : 0xb800)
#ifdef  JUNK
#define	scrwait()	if (crt_mode != 7) { \
			    while ((inp(CRT_STATUS)&DISPLAY_ENABLE) == 0) { \
				; \
			    } \
			}
#else
#define scrwait() inp(CRT_STATUS)
#endif

static int
    		crt_mode,
		crt_cols,
		crt_lins,
		curpage;

/*
 * Set the cursor position to where it belongs.
 */

static void
setcursor(row, column, page)
int
    row,
    column,
    page;
{

#ifdef  NCSA
    /* this is a crock, but at least everything works as expected */
    tn_cursor(row,column);

#else
    union REGS inregs, outregs;


    inregs.h.dh = row;
    inregs.h.dl = column;
    inregs.h.bh = page;
    inregs.h.ah = SetCursorPosition;

    int86(BIOS_VIDEO, &inregs, &outregs);
#endif
}
/*
 * Read the state of the video system.  Put the cursor somewhere
 * reasonable.
 */

static void
scrini()
{
#ifdef  NCSA

        crt_mode = 0;
        crt_cols = 80;
        crt_lins = 25;
#else
    union REGS inregs, outregs;

    inregs.h.ah = CurrentVideoState;
    int86(BIOS_VIDEO, &inregs, &outregs);

    crt_mode = outregs.h.al;
    crt_cols = outregs.h.ah;
    crt_lins = 25;
    curpage = outregs.h.bh;

    inregs.h.ah = ReadCursorPosition;
    inregs.h.bh = curpage;

    int86(BIOS_VIDEO, &inregs, &outregs);

    if (outregs.h.dh > crt_lins) {
	outregs.h.dh = crt_lins;
    }
    if (outregs.h.dl > crt_cols) {
	outregs.h.dl = crt_cols;
    }
    inregs.h.dh = outregs.h.dh;
    inregs.h.dl = outregs.h.dl;
    inregs.h.bh = curpage;

    inregs.h.ah = SetCursorPosition;
    int86(BIOS_VIDEO, &inregs, &outregs);
#endif
}

#ifndef	MINITEL
static void
scrwrite(source, length, offset)
ScreenBuffer *source;
int
	length,
	offset;
{


#ifdef  NCSA

        return;
#else
    struct SREGS segregs;
    

    segread(&segregs);		/* read the current segment register */
    scrwait();
    movedata(FP_SEG(source), FP_OFF(source), scrseg(), sizeof(*source)*offset,
#endif						sizeof(*source)*length);
}

static void
scrsave(buffer)
ScreenBuffer *buffer;
{
    struct SREGS segregs;

/*    segread(&segregs);	       */	/* read the current segment register */
#ifdef  NCSA
        return;
#else
    scrwait();
    movedata(scrseg(), 0, FP_SEG(buffer), FP_OFF(buffer), crt_cols*crt_lins*2);
#endif
}

static void
scrrest(buffer)
ScreenBuffer *buffer;
{
#ifndef  NCSA
    scrwrite(buffer, crt_cols*crt_lins, 0);
#endif
}
#endif
	/* end ifndef MINITEL */

static void
TryToSend()
{
#define	STANDOUT	to3270->colors[2]	/* Highlighted mode */
#define	REVERSE		to3270->colors[1]
#define	NORMAL		to3270->colors[0]	/* Normal mode */
#define	NONDISPLAY	0
                        	/* Don't display */

#define	DoAttribute(a) 	    \
			    if (screenIsFormatted) { \
				if (IsNonDisplayAttr(a)) { \
				    a = NONDISPLAY; 	/* don't display */ \
				} else if (IsHighlightedAttr(a)) { \
				    a = STANDOUT; \
				} else { \
				    a = NORMAL; \
				} \
			    } else  { \
				a = NORMAL;	/* do display on unformatted */\
			    }
    ScreenImage *p, *upper;
#ifndef NCSA
    ScreenBuffer *sp;
#endif
    int fieldattr;		/* spends most of its time == 0 or 1 */
    int screenIsFormatted = FormattedScreen();
#ifdef  NCSA
    char c;
    int x,y;
#endif
/* OK.  We want to do this a quickly as possible.  So, we assume we
 * only need to go from Lowest to Highest.  However, if we find a
 * field in the middle, we do the whole screen.
 *
 * In particular, we separate out the two cases from the beginning.
 */

    if ((Highest != HighestScreen()) || (Lowest != LowestScreen())) {
#ifndef NCSA
	sp = &Screen[Lowest];
#endif
	p = &Host[Lowest];
	upper = &Host[Highest];
	fieldattr = FieldAttributes(Lowest);
	DoAttribute(fieldattr);	/* Set standout, non-display status */
#ifdef  NCSA
        y = x = Lowest;
        SetAttrib(fieldattr);
#endif
	while (p <= upper) {
	    if (IsStartFieldPointer(p)) {	/* New field? */
#ifdef  NCSA
                if(x != y)
                        ScreenWrite(y, xbuff, x - y);
#endif
		Highest = HighestScreen();
		Lowest = LowestScreen();
		TryToSend();		/* Recurse */
		return;
	    } else if (fieldattr) {	/* Should we display? */
				/* Display translated data */
#ifdef  NCSA
                c = disp_asc[GetHostPointer(p)];
#else
		sp->data = disp_asc[GetHostPointer(p)];
#endif
	    } else {
#ifdef  NCSA
                c = ' ';
#else
		sp->data = ' ';
#endif
	    }
#ifdef  NCSA
            xbuff[(x++) - y] = c;
            if((x - y) >= XBUFFSIZE) {
                    ScreenWrite(y, xbuff, x - y);
                    y = x;
            }
#else
	    sp->attr = fieldattr;
	    sp++;
#endif
	    p++;
	}
    } else {		/* Going from Lowest to Highest */
	ScreenImage *End = &Host[ScreenSize-1];
#ifndef NCSA
	sp = Screen;
#endif
	p = Host;
	fieldattr = FieldAttributes(LowestScreen());
	DoAttribute(fieldattr);	/* Set standout, non-display status */
#ifdef  NCSA
        SetAttrib(fieldattr);
        y = x = LowestScreen();
#endif

	while (p <= End) {
	    if (IsStartFieldPointer(p)) {	/* New field? */
		fieldattr = FieldAttributesPointer(p);	/* Get attributes */
		DoAttribute(fieldattr);	/* Set standout, non-display */
#ifdef  NCSA
                if(x != y)
                        ScreenWrite(y, xbuff, x - y);
#if	FIELDDEBUG
		SetAttrib(REVERSE);
		ScreenWrite(x, &GetHostPointer(p), 1);
#else
                SetAttrib(NONDISPLAY);
                ScreenWrite(x," ", 1);  /* this is a crock to be sure to not show
                                           the field attr chars if attrib is highlight
                                           and we have set highlight to be reverse video */
#endif
                y = ++x;
                p++;
                SetAttrib(fieldattr);
                continue;
#endif
	    }
	    if (fieldattr) {	/* Should we display? */
			    /* Display translated data */
#ifdef  NCSA
                c = disp_asc[GetHostPointer(p)];
#else
		sp->data = disp_asc[GetHostPointer(p)];
#endif
	    } else {
#ifdef  NCSA
                c = ' ';
#else
		sp->data = ' ';
#endif
	    }
#ifdef  NCSA
            xbuff[(x++) - y] = c;
            if((x - y) >= XBUFFSIZE) {
                    ScreenWrite(y,xbuff, x - y);
                    y = x;
            }
#else
	    sp->attr = fieldattr;
	    sp++;
#endif                
	    p++;
	}
    }
#ifdef  NCSA
    if(x != y) {
        ScreenWrite(y, xbuff, x - y);
    }
#endif
    terminalCursorAddress = CorrectTerminalCursor();
    /*
     * We might be here just to update the cursor address.
     */
#ifndef NCSA
    if (Highest >= Lowest) {
	scrwrite(Screen+Lowest, (1+ ((char near *) Highest)- ((char near *) Lowest)), Lowest);
    }
#endif
    setcursor(ScreenLine(terminalCursorAddress),
		    ScreenLineOffset(terminalCursorAddress), 0);
    Lowest = HighestScreen()+1;
    Highest = LowestScreen()-1;
    if (needToRing) {
	DataToTerminal("\7", 1);
	needToRing = 0;
    }
    return;
}

/* InitTerminal - called to initialize the screen, etc. */

void
InitTerminal()
{
    InitMapping();		/* Go do mapping file (MAP3270) first */
    if (!screenInitd) { 	/* not initialized */
	scrini();
#ifndef NCSA
	scrsave(saveScreen);	/* Save the screen buffer away */
	ClearArray(Screen);
#endif
	terminalCursorAddress = SetBufferAddress(0,0);
	screenInitd = 1;
	screenStopped = 0;		/* Not stopped */
    }
}


/* StopScreen - called when we are going away... */

void
StopScreen(doNewLine)
int doNewLine;
{
    if (screenInitd && !screenStopped) {
#ifndef NCSA
	scrrest(saveScreen);
#endif
	setcursor(NumberLines-1, 1, 0);
	if (doNewLine) {
	    StringToTerminal("\r\n");
	}
	EmptyTerminal();
	screenStopped = 1;
    }
}


/* RefreshScreen - called to cause the screen to be refreshed */

void
RefreshScreen()
{
    Highest = HighestScreen();
    Lowest = LowestScreen();
    TryToSend();
}


/* ConnectScreen - called to reconnect to the screen */

void
ConnectScreen()
{
    if (screenInitd) {
	RefreshScreen();
	screenStopped = 0;
    }
}

/* LocalClearScreen() - clear the whole ball of wax, cheaply */
void
LocalClearScreen()
{
#ifdef  NCSA
#ifndef	MINITEL
    VSwrite(to3270->vs,"\033[2J",4);
#else
    ClearScreen();
#endif
#endif
    Clear3270();
    Lowest = LowestScreen(); /* everything in sync... */
    Highest = HighestScreen();
    TryToSend();
}

/*
 * Implement the bell/error message function.
 */

int
	bellwinup = 0;		/* If != 0, length of bell message */
static int
	bell_len = 0;		/* Length of error message */


void
BellOff()
{
    ScreenBuffer a[100];
    int i;

    if (bellwinup) {
#ifdef  NCSA
        statline();
#else
	unsigned char blank = ' ';

	for (i = 0; i < bell_len; i++) {
	    a[i].attr = NORMAL;
	    a[i].data = ' ';
	}
    scrwrite(a, bell_len, 24*80);		/* XXX */
#endif
    }
}


void
RingBell(s)
char *s;
{
    needToRing = 1;
    if (s) {
	int i;
	ScreenBuffer bellstring[100];

	bell_len = strlen(s);
	bellwinup = 1;
	if (bell_len > sizeof bellstring-1) {
	    OurExitString(stderr, "Bell string too long.", 1);
	}
#ifdef  NCSA
#ifndef	MINITEL
        {
                int rw,cl,sm,c;
        	c = n_color(current->colors[1]);			/* save current color */
        	rw = n_row();
	        cl = n_col();
        	sm = scmode();
                n_cur(NUMLINES+1,0);
                if(sm) 
                        n_cheat(s, bell_len);
                else
                        n_draw(s, bell_len);
                n_cur(rw,cl);
                n_color(c);
        }
#else
	Report_Error(s);
#endif
#else

	for (i = 0; i < bell_len; i++) {
	    bellstring[i].attr = STANDOUT;
	    bellstring[i].data = s[i];
	}
	scrwrite(bellstring, bell_len, 24*80);		/* XXX */
#endif
    }
}

/*
 * Update the OIA area.
 */

void
ScreenOIA(oia)
OIA *oia;
{
}


/* returns a 1 if no more output available (so, go ahead and block),
    or a 0 if there is more output available (so, just poll the other
    sources/destinations, don't block).
 */

int
DoTerminalOutput()
{
	/* called just before a select to conserve IO to terminal */

    if (!(screenInitd||screenStopped)) {
	return 1;		/* No output if not initialized */
    }
    if ((Lowest <= Highest) || needToRing ||
			(terminalCursorAddress != CorrectTerminalCursor())) {
	TryToSend();
    }
    if (Lowest > Highest) {
	return 1;		/* no more output now */
    } else {
	return 0;		/* more output for future */
    }
}

/*
 * The following are defined to handle transparent data.
 */

void
TransStop()
{
#ifdef  NCSA
    NCSA_TransStop();
#endif
    RefreshScreen();
}

void
TransOut(buffer, count, kind, control)
unsigned char	*buffer;
int		count;
int		kind;		/* 0 or 5 */
int		control;	/* To see if we are done */
{
    char *ptr;

    while (DoTerminalOutput() == 0) {
	;
    }
    for (ptr = buffer; ptr < buffer+count; ptr++) {
	*ptr &= 0x7f;		/* Turn off parity bit */
    }
#ifdef  NCSA
    NCSA_TransStart();          /* start transparent output mode if
                                   not already transparent */
#endif
    (void) DataToTerminal(buffer, count);
    if (control && (kind == 0)) {		/* Send in AID byte */
	SendToIBM();
    } else {
	TransInput(1, kind);			/* Go get some data */
    }
}

/*
 * init_screen()
 *
 * Initialize variables used by screen.
 */

void
init_screen()
{
    bellwinup = 0;
}


