/* hfile.inc - placed into all .h files to set up for PVCS 
   $Header:   E:/pcdirs/vcs/ftppi.h_v   1.0   15 Jan 1990 19:30:14   bkc  $
   Revision History ----------------------------------------------------
   $Log:   E:/pcdirs/vcs/ftppi.h_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:30:14   bkc
*/


#define NCMDS	48

#define	QMARK   1
#define BANG	2
#define ASCII	3
#define BELL	4
#define BGET	5
#define BINARY  6
#define BPUT	7
#define BYE  	8
#define CD   	9
#define CLOSE	10
#define DEL     11
#define DEBUG	12
#define DIR  	13
#define GET  	14
#define GLOB 	15
#define HASH 	16
#define HELP 	17
#define INTERACTIVE 18
#define LCD  	19
#define LLS	20
#define LS	21
#define MDELETE 22
#define MDIR 	23
#define MGET 	24
#define MKDIR	25
#define MLS  	26
#define MODE 	27
#define MPUT 	28
#define NONINTERACTIVE 29
#define OPEN 	30
#define PROMPT  31
#define PUT  	32
#define PWD  	33
#define QUIT 	34
#define QUOTE	35
#define RECV 	36
#define REMOTEHELP 37
#define RENAME  38
#define RM	39
#define RMDIR	40
#define SEND 	41
#define SENDPORT 42
#define SLASHFLIP 43
#define STATUS  44
#define STRUCT  45
#define TYPE	46
#define USER 	47
#define VERBOSE 48

static char *ftp_cmdlist[] = {
	"?",
	"!",
	"ascii",
	"bell",
	"bget",
	"binary",
	"bput",
	"bye",
	"cd",
	"close",
	"delete",
	"debug",
	"dir",
	"get",
	"glob",
	"hash",
	"help",
	"interactive",
	"lcd",
	"lls",
	"ls",
	"mdelete",
	"mdir",
	"mget",
	"mkdir",
	"mls",
	"mode",
	"mput",
	"noninteractive",
	"open",
	"prompt",
	"put",
	"pwd",
	"quit",
	"quote",
	"recv",
	"remotehelp",
	"rename",
	"rm",
	"rmdir",
	"send",
	"sendport",
	"slashflip",
	"status",
	"struct",
	"type",
	"user",
	"verbose"
	};

static char *helpstrings[] = {
	"?		print local help information",
	"!		escape to the shell",
	"ascii     	set ascii transfer type",
	"bell      	beep when command completed - toggle",
	"bget		get a file in binary mode",
	"binary    	set binary transfer type",
	"bput		put a file in binary mode",
	"bye       	terminate ftp session and exit",
	"cd        	change remote working directory",
	"close     	terminate ftp session",
	"delete    	delete remote file - inquires if prompting is on",
	"debug     	toggle/set debugging mode",
	"dir       	list contents of remote directory",
	"get       	receive file",
	"glob      	toggle metacharacter expansion of local file names",
	"hash      	toggle printing `#' for each buffer transferred",
	"help      	print local help information",
	"interactive    turn on prompting for multiple commands",
	"lcd       	change local working directory",
	"ls        	nlist contents of remote directory",
	"lls		list contents of local directory",
	"mdelete   	delete multiple files",
	"mdir      	list contents of multiple remote directories",
	"mget      	get multiple files",
	"mkdir     	make directory on the remote machine",
	"mls       	nlist contents of multiple remote directories",
	"mode      	set file transfer mode",
	"mput      	send multiple files",
	"noninteractive turn off prompting on multiple commands",
	"open      	connect to remote tftp",
	"prompt    	toggle interactive prompting on multiple commands",
	"put       	send one file",
	"pwd       	print working directory on remote machine",
	"quit      	terminate ftp session and exit",
	"quote     	send arbitrary ftp command",
	"recv      	receive file",
	"remotehelp	get help from remote server",
	"rename    	rename file",
	"rm		remove file",
	"rmdir     	remove directory on the remote machine",
	"send      	send one file",
	"sendport  	toggle use of PORT cmd for each data connection",
	"slashflip	toggle changing / to \ on outgoing commands",
	"status    	show current status",
	"struct    	set file transfer structure",
	"type      	set file transfer type",
	"user      	send new user information",
	"verbose   	toggle verbose mode"
	};
