/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/rspc.c_v   1.0   15 Jan 1990 19:27:22   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/rspc.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:27:22   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   rspc.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/


/*  RSpc
*   real screen interface for Gaige Paulsen's 
*   Virtual screen driver
*
*   Tim Krauskopf
*
*   Date      Notes
*  --------------------------------------------
*  11/25/86   Start -TKK
*/

#include <stdio.h>
#include <dos.h>
#include "whatami.h"
#include "windat.h"
#include "vskeys.h"
#include "newwin.h"
#include "hostform.h"

extern struct config Scon;
#ifdef	_MSC_
#define MK_FP(seg,ofs)	((void far *) \
			   (((unsigned long)(seg) << 16) | (unsigned)(ofs)))

#include <malloc.h>
#else
#include <alloc.h>
#endif
static int lastatt=255,lastw=255,	/* last attribute value written to screen*/
	thevis=0;						/* which window is visible */

/*************************************************************************/

RSbell(w)
	int w;
	{
/*
*  might add something to indicate which window
*/
	n_play(sounds[SOUND_BELL]);

	if(Scon.sys_flags & SYS_FLAGS_VISUAL_BELL) {
	       if(w == thevis)
		       	Visbell(0);
		else
		       	Visbell(1);  /* only stat line */
	}
}

Visbell(int mode)
{
	 long clicks;
	 Swap_Atts(mode);
	 for(clicks = n_clicks(); clicks + 2 > n_clicks(); );
	 Swap_Atts(mode);
}

Swap_Atts(int mode)
{
	register unsigned char far *att;
extern	char	dotop;
extern	int	regen;
	register int	x;
	int	limit,start;

	if(dotop)
	       	return;
	if(mode) {
	       	start = (rows -1) * cols * 2;
		limit = start + cols;
	}
	else {
	       	start = 0;
		limit = (rows -1 )* cols;
	}
	att = MK_FP(regen,start + 1);
	for(x=start; x < limit; x++) {
	       	*att = (*att >> 4) + ((*att & 0xf) << 4);
		att += 2;
	}

}

RSvis(w)
	int w;
{
	thevis = w;				/* this is visible window */
}

RSinitall() {}
RSinsstring() {}
RSdelchars() {}
RSbufinfo() {}
RSdrawsep() {}
RSmargininfo() {}
RSdelcols() {}
RSinscols() {}

RScursoff(w)
	int w;
	{
		/* do nothing, MAC routine */
}

RScurson(w,y,x)
	int w,x,y;
	{

	if (w != thevis)
		return(0);							/* not visible */
/*
*  this is really the cursor positioning routine.  If cursor is turned off,
*  then it needs to be turned back on.
*/
	n_cur(x,y);
/*  add code to save cursor position for a given window */

}

RSdraw(w,y,x,a,len,ptr)
	int w,x,y,a,len;
	char *ptr;
	{
	int i;

	if (w != thevis) {
	/*  indicate that something happened */
		x = n_row(); y = n_col();
		if (screens[w]->sstat != '*') {
			if (screens[w]->sstat == 47)
				screens[w]->sstat = 92;
			else
				screens[w]->sstat = 47;
		}

		statline();
		n_cur(x,y);							/* restore cursor where belongs */
		return(0);							/* not visible */
	}
/*
* call my own draw routine
*/
	if (w != lastw || a != lastatt) 		/* need to parse attribute bit */
		RSsetatt(a,w);

	n_cur(x,y);
#ifdef	TRASH
	if (VSisgrph(lastatt)) {
		for (i=0; i<len; i++)
			ptr[i] = translate(ptr[i]);			
	}
#endif
	if (scmode())
		n_cheat(ptr,len);
	else
		n_draw(ptr,len); 
}

RSsetatt(a,w)
	int a,w;
	{
	int c;
#ifdef  OLDJUNK
		if (VSisundl(a))
			c = screens[w]->colors[1];
		else if (VSisrev(a))
			c = screens[w]->colors[2];
		else
			c = screens[w]->colors[0];

		if (VSisblnk(a))
			c |= 128;				/* set blink bit */
		if (VSisbold(a))
			c |= 8;					/* set brightness bit */
                n_color(c);
#else
		n_color(a);  /* #### */
#endif
		lastatt = a;
		lastw = w;

}

RSdellines(w,t,b,n,select)
	int w,t,b,n,select;
	{
	int c;

	if (w != thevis || n < 1)
		return(0);							/* not visible */

	c = n_color(screens[w]->colors[0]);

	n_scrup(n,t,0,b,cols-1);

	n_color(c);

}

RSerase(w,y1,x1,y2,x2)
	int w,x1,y1,x2,y2;
	{
	int c;

	if (w != thevis)
		return(0);							/* not visible */

	c = n_color(screens[w]->colors[0]);

	n_scrup(0,x1,y1,x2,y2);

	n_color(c);

}

RSinslines(w,t,b,n,select)
	int w,t,b,n,select;
	{
	int c;

	if (w != thevis || n < 1)
		return(0);							/* not visible */

	c = n_color(screens[w]->colors[0]);

	n_scrdn(n,t,0,b,cols-1);

	n_color(c);
}

RSsendstring(w,ptr,len)
	int w,len;
	char *ptr;
	{

	netwrite(screens[w]->pnum,ptr,len);

}

/*
*  VT100 code still needed, waiting for Gaige's routines
*/

#include "nkeys.h"

int transtable[] = {     /*  Graphics translation set  */
            32, 4, 177, 9, 12, 13, 10, 248, 241,
            10, 10, 217, 191, 218, 192, 197, 196,
            196, 196, 196, 95, 195, 180, 193, 194, 
            179, 243, 242, 227, 168, 156, 250, 32, 32,
            32, 32, 32, 32, 32, 32, 32, 32, 32, 32 };


/***************************************************************************/
/*   translate:
*       Takes a character and converts it to the IBM PC extended character
*   set which, in the transtable array, is mapped to the VT100 graphics
*   characters, with minor conflicts.
*/
translate(ch)
    int ch;
    {
    if (ch > 94) 
        return(transtable[ ch - 95 ]);
    else
        return(ch);
}


/*   Keyboard translations from the PC to VT100
*      Tim Krauskopf               Sept. 1986
*
*      original: ISP 1984
*/

#ifndef	NEWKEY
/***************************************************************************/
/*  takes a key value and sends it to the TCP port in 'pnum'
*   First, translates all special keys to VT100 key sequences.
*/
/*  see vskeys.h for keys in this trans table
*/
unsigned char vttrans[128] = {
	19,20,21,22,  16,15,  17,11,23,18,0, 4, 0, 1,2,0,
	0,0,0,0,0,0,0,0,0,0,0, 3, 0,0, 17, 0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 
	6,7,8,9,10,11,12,13,14,5, 0,0,0, 16, 15, 0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	};

vt100key(c)
	int c;
	{
	int i;

	if (c < 128) {
		netwrite(current->pnum,&c,1);
		return(0);
	}
	else {
		i = vttrans[c-128];
		if (i)
			VSkbsend(current->vs,i+128,!(current->echo));
		else {
			switch(c) {
				case HOME:
					netwrite(current->pnum,"\010",1);
					break;
				case ENDKEY:
					VSkbsend(current->vs,VSK4,0);
					VSkbsend(current->vs,VSK2,0);
					break;
				case CTRLHOME:
					VSkbsend(current->vs,VSF1,0);
					VSkbsend(current->vs,VSK5,0);
					break;
				case CTRLEND:
					VSkbsend(current->vs,VSF1,0);
					VSkbsend(current->vs,VSK4,0);
					break;
				case PGUP:
					VSkbsend(current->vs,VSK5,0);
					VSkbsend(current->vs,VSK8,0);
					break;
				case PGDN:
					VSkbsend(current->vs,VSK4,0);
					VSkbsend(current->vs,VSK8,0);
					break;
				case CTRLPGUP:
					VSkbsend(current->vs,VSK5,0);
					VSkbsend(current->vs,VSK7,0);
					break;
				case CTRLPGDN:
					VSkbsend(current->vs,VSK4,0);
					VSkbsend(current->vs,VSK7,0);
					break;
				case F9:
					netwrite(current->pnum,"\032exit\r\n",7);
					break;
				default:
		/* key is not mapped to anything */
					break;
			}
		}
	}
	return(0);
}
#endif
/***********************************************************************/
/*  non-blocking RSgets()
*   This routine will continually add to a string that is re-submitted
*   until a special character is hit.  It never blocks.
*
*   As long as editing characters (bksp, Ctrl-U) and printable characters
*   are pressed, this routine will update the string.  When any other special
*   character is hit, that character is returned.  
*/
char bk[] = {8,' ',8};

RSgets(w,s,lim)
	int w;
	char *s;
	int lim;
	{
	unsigned int c;
	int count,i;
	char *save;

	count = strlen(s);
	save = s;
	s += count;

	while (0xffff != (c = n_chkchar())) {

		switch (c) {				/* allow certain editing chars */
			case 8:					/* backspace */
			case BACKSPACE :
				if (count) {
					VSwrite(w,bk,3);
					count--;		/* one less character */
					s--;			/* move pointer backward */
				}
				break;
			case 21:
				for (i=0; i < s-save; i++) {
					VSwrite(w,bk,3);
				}
				s = save;
				break;
			case 13:
			case 9:
				*s = '\0';			/* terminate the string */
				return(c);
			default:
				if (count == lim) {			/* to length limit */
					RSbell();
					*s = '\0';				/* terminate */
					return(0);
				}

				if (c > 31 && c < 127) {
					VSwrite(w,&c,1);
					*s++ = c;				/* add to string */
					count++;				/* length of string */
				}
				else {
					if (c > 0 && c < 27) {
						c += 64;
						VSwrite(w,"^",1);
						VSwrite(w,&c,1);
						c -= 64;
					}
					*s = '\0';			/* terminate the string */
					return(c);
				}

			break;
		}

	}

	*s = '\0';			/* terminate the string */
	return(c);

}

/***********************************************************************/
/*  non-blocking gets()
*   This routine will call netsleep while waiting for keypresses during
*   a gets.  Replaces the library gets.
*
*   As long as editing characters (bksp, Ctrl-U) and printable characters
*   are pressed, this routine will continue.  When any other special
*   character is hit, NULL is returned.  the return key causes a normal return.
*/
char *nbgets(s,lim)
	char *s;
	int lim;
	{
	unsigned int c;
	int count,i;
	char *save;

	count = 0;
	save = s;

	while (1) {
		c = n_chkchar();

		if (c == 0xffff) {
			Stask();			/* keep communications going */
			c = 0;
		}

		switch (c) {				/* allow certain editing chars */
			case 8:					/* backspace */
			case BACKSPACE:
				if (count) {
					nprintf(SCREEN,"\010 \010");
					count--;		/* one less character */
					s--;			/* move pointer backward */
				}
				break;
			case 13:				/* carriage return, = ok */
				nprintf(SCREEN,"\n");
				*s = '\0';			/* terminate the string */
				return(save);		/* return ok */
				break;
			case 21:
				for (i=0; i < s-save; i++) {
					nprintf(SCREEN,"\010 \010");
				}
				s = save;
				break;
			case 0:					/* do nothing */
				break;
			default:
				if (c > 31 && c < 127) {
					if (count < lim) {
						nprintf(SCREEN,"%c",c);
						*s++ = c;				/* add to string */
						count++;				/* length of string */
					}
				}
				else {
					nprintf(SCREEN,"\n");
					*s = '\0';			/* terminate the string */
					return(NULL);
				}

			break;
		}

	}
}

/************************************************************************/
/*  nbgetch
*   check the keyboard for a character, don't block to wait for it,
*   but don't return to the caller until it is there.
*/
nbgetch()
	{
	int c;

	while (0 >= (c = n_chkchar())) 		/* there is a key? */
		Stask();					/* no key yet, update everything */

	return(c);

}

/************************************************************************/
/* nbget
*   demux at least one packet each time, check the keyboard for a key, 
*   return any key pressed to the caller.
*/
nbget()
	{
	int c;

	demux(0);				/* only one packet */

	if (0 >= (c = n_chkchar()))
		return(-1);			/* no key ready */

	return(c);
}
