/* ping.c - send icmp packets */
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <dos.h>
#include <values.h>

#include "time.h"

#include "protocol.h"

#include "hostform.h"
#include "newwin.h"

extern struct config Scon;
struct config def;				/* Default settings obtained from host file */
extern	char	*env_config;
unsigned char 	myipnum[4];
int	foundbreak;

#define	NS_TIMEOUT	10
#define	SINGLE_TIMEOUT	5

int	singlemode = 1;
int	floodmode = 0;

long	pings_sent, pings_received;
unsigned 	min_rto = MAXINT,
		max_rto = 0;
long	rto_avg = 0;

#define	PING_CSUM	0xabcd

struct	ping_info {
	unsigned	p_csum;
	long		p_clicks_when_sent;
	long		p_sequence_number;
	char		p_data[54];
} Ping_Packet;

#define DOMAININFO      1

typedef struct { 
	int x;
} KeyLib;

struct twin {
		char	buff[128];
};


int numberoflines;

struct twin x,*console={&x},*current = {&x};
unsigned long  vj_packets_in, vj_packets_out, ftppassword;
unsigned long  splay_packets_in, splay_packets_out;
int	com_port;
int	sendsize = sizeof(Ping_Packet);

nprintf(int dest, char *format,...)
{
	va_list list;
	char	xbuff[128],*c,*o;
	int	len;
extern	unsigned char att;
	c = xbuff;
	o = format;
	while(*o) {
	       if(*o == '\n')
		      	*c++ = '\r';
		*c++ = *o++;
	}
	*c = 0;

	va_start(list,format);
	vprintf(xbuff,list);
	va_end(list);
}

breakstop()
{
	foundbreak = 1;
        ctrlbrk(breakstop);
        return(1);
}

vprint(int d, char *s)
{
	nprintf(SCREEN,"%s",s);
}

void
D_Debug(int level, char *format, ...)
{
	va_list	list;

	va_start(list, format);
	printf("Error %d: ",level);
	vprintf(format, list);
	va_end(list);
}


VSwrite()		/* called from PCutil.c LoadWrite */
{
}


int
ftpd()
{
}

int
setftp()
{
}

unsetftp()
{
}

rftpd()
{
}

setrshd()
{
}

void
n_bioswrite()
{
}

void
n_sound()
{
}

unsetrshd()
{
}

rshd()
{
}

status_setup()
{
}

program_status()
{
}


unsigned long
n_clicks()
{
	unsigned long	value;
	unsigned far *u=(unsigned int far *) MK_FP(0x40,0x6c);

	value = *(u++);
	value |= (*u << 16);
	return(value);

}



char
*inet_ntoa(unsigned char *c)
{
	static	char	buff[36];

	sprintf(buff,"%d.%d.%d.%d",*c,*(c+1),*(c+2),*(c+3));
	return(buff);
}

void
ICMP_Handler(ICMPKT *pl, int len)
{
	struct ping_info	*p;
	long	msecs;
	long	endclicks = n_clicks();

	p = (struct ping_info *) pl->data;

	if(len < 10 || p->p_csum != PING_CSUM)
	       	return;
	msecs = (endclicks - p->p_clicks_when_sent)*10000/182;

	if(msecs < min_rto)
	       	min_rto = msecs;
	if(msecs > max_rto)
	       	max_rto = msecs;
	rto_avg += msecs;

	if(!(singlemode | floodmode))
		nprintf(SCREEN,"ICMP Echo Reply: %d bytes from %s sequence %ld time %ld msec\n",len - 8, inet_ntoa(pl->i.ipsource),
		       	p->p_sequence_number, msecs);

	pings_received++;
	if(floodmode)
	       	nprintf(SCREEN,"\010");
	return;
}




struct	machinfo
*gethostbyname(char *name)
{
	struct machinfo	*mp;
	int	mnum;
	unsigned long	now;

	mp = Shostlook(name);
	if(!mp || (!mp->hostip[0])) {	/* DNS lookup */
		nprintf(SCREEN,"Domain name lookup of %s\n", name);
		mnum = Sdomain(name);		/* start a DNS lookup */
		now = time(NULL) + NS_TIMEOUT;
		while(now > time(NULL)) {
			int	i, class, dat;

			if(foundbreak)
			       	return(NULL);
			Stask();
			i = Sgetevent(USERCLASS, &class, &dat);
			if(i == DOMOK) {	/* domain lookup ok */
				mp = Slooknum(mnum);
				break;
			}
		}
		if(!mp)	{	/* get here if timeout */
			nprintf(SCREEN, "Domain name lookup of %s Failed\n", name);
			return(NULL);
		}
	}
	return(mp);

}

int
sendping(struct machinfo *mp)
{

	pings_sent++;

	Ping_Packet.p_sequence_number++;
	Ping_Packet.p_clicks_when_sent = n_clicks();
	if(floodmode)
	       	nprintf(SCREEN,".");

	return(neticmpsend(mp->hostip, 8, 0, (char *) &Ping_Packet,sendsize));
}

int
main(argc, argv)
	int	argc;
	char	*argv[];
{
	int	machparm = 1000;
	int	rc = 0, i, j;
	struct	machinfo	*mp;
	long	now;
	long	start, startclicks, endclicks;
	unsigned limit = 0;
	int	interval = 18;

       ctrlbrk(breakstop);

	nprintf(SCREEN,"CUTCP/CUTE PING " VERSION  "\n");

	if(getenv("CONFIGTEL"))
		if(Shostfile(getenv("CONFIGTEL")) < 0) {
			nprintf(SCREEN,"Error, couldn't open configtel file %s\n",getenv("CONFIGTEL"));
			exit(1);
		}

#define  USAGE   printf("\n\nUsage: Ping [-repeat] [-flood] [-n count] [-i interval (clicks)] [-s size]\
 [-e 'config_data']  [-h hostfile] target\n");

	if (*argv[1] == '?' || argc < 2) {
		USAGE;
		exit(1);
	}

	for (i=1; i<argc; i++) {        /* look at each parm */
		if (*argv[i] == '-') {
			switch ( *(argv[i]+1)) {
				case 'e' :			/* config.tel data */
				       	 env_config = argv[++i];
				  	 break;
				case 'h':
					Shostfile(argv[++i]);	/* set new name for host file */
					break;
				case 'f' :
				       	floodmode = 1;
				 	break;
				case 's' :
				       	sendsize = atoi(argv[++i]);
				 	if(sendsize < 10)
					       	sendsize = 10;
					break;
				case 'i' :
				       	interval = atoi(argv[++i]);
				 	break;
				case 'r' :
				       	singlemode = 0;
				 	break;
				case 'n' :
				       	limit = atoi(argv[++i]);
				 	break;
				default:
usage:;
					USAGE;
					exit(1);
			}
		}
		else {
			if (i < machparm)
				machparm = i;			/* where first machine name is */
		}

	}

	if(machparm == 1000) {
	       	USAGE;
		exit(1);
	}

	if (j = Snetinit()) {
		nprintf(SCREEN,"Error initializing network or getting configuration file\n");
		if (j == -2)	/* RARP failure, special case */
			netshut();
		exit(1);
	}


	Stask();					/* any packets for me? (return ARPs) */

	mp = gethostbyname(argv[machparm]);

	if(!mp)	{		/* not in configuration file */
	     	netshut();
	 	return(2);
       }
	Ping_Packet.p_csum = PING_CSUM;
	Set_ICMP_Handler(ICMP_Handler);
	if(!singlemode)
		nprintf(SCREEN,"Sending %d byte packets to %s\n",sendsize,
		       	inet_ntoa(mp->hostip));
	now = 0;
	time(&start);
	startclicks = n_clicks();
	while(!foundbreak)	{	/* forever */
	       	Stask();
	 	if(limit && pings_sent >= limit)
		       	break;
	       	if(!floodmode) {
		       	if(n_clicks() > now) {
			       	sendping(mp);
				now = n_clicks() + interval;
			}
		}
	 	else
		       	sendping(mp);
	 	if(singlemode && !floodmode) {
		       	if(pings_received) {
			       	nprintf(SCREEN,"host %s is alive\n",argv[machparm]);
				netshut();
				return(0);
			}
		 	if(time(NULL) > start + SINGLE_TIMEOUT) {
			       	nprintf(SCREEN,"No answer from %s\n",argv[machparm]);
				netshut();
				return(100);
			}
		}
       }
	endclicks = n_clicks();
	nprintf(SCREEN, "\n%ld packets sent, %ld packets received, %d%% lost\n",
	       	pings_sent, pings_received, (int) (pings_sent - pings_received)*100/pings_sent);
	nprintf(SCREEN, "round-trip (ms) min/avg/max = %d/%d/%d\n",
	       	min_rto, (int) (rto_avg/pings_received), max_rto);
	if(floodmode) {
	       	long	dclicks = endclicks - startclicks;

		nprintf(SCREEN,"%ld transmitted/second, %ld received/second\n",
		       	(pings_sent*18)/dclicks, (pings_received*18)/dclicks);
       }
	netshut();
	return(rc);
}

