/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/minitel.c_v   1.0   15 Jan 1990 19:27:08   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/minitel.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:27:08   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   minitel.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/

/* #define	DEBUG	1
#define	JUNK	1 */
/*
*   minitel
*   Example TCP/IP program for the NCSA TCP/IP kernel
*/
#include <stdio.h>
#include <alloc.h>
#include <dos.h>
#include <time.h>
#include <stdarg.h>
#include <stdlib.h>
#include "whatami.h"
#include "hostform.h"
#include "windat.h"
#include "mem.h"
#include "nkeys.h"
#include "newwin.h"
extern unsigned n_chkchar();

#define TELCMDS 1
#define TELOPTS 1

#include "arpa/telnet.h"
#define	NUMLINES	23
#define	cols		80
extern struct config Scon;

struct machinfo *mp;
#define	BUFFSIZE	256
unsigned char *neterrstring(),buf[BUFFSIZE];
struct twin	mywin;
struct twin	*current = &mywin,*console = &mywin;
extern int	slip_mode;
unsigned char 		colors[NCOLORS] = {7,5,0x70,0};	/* base colors */
extern unsigned n_chkchar();
long	ftppassword=0;
unsigned int	save_row,save_page;

extern unsigned _heaplen = 17 * 1024;
extern unsigned _stklen = 1 * 1024;
unsigned mysp;
extern	unsigned char	extended;
unsigned video_seg = 0xb800;

int	foreground=1;
int	popback;		/* set if we try to pop back quickly */
extern	int	onscreen;
enum states {CLOSED=0,
	      OPENING,
	      OPEN,
	      CLOSING,
	      ASKING,
	      LOOKING
};

enum commands {
		NONE=0,
		UNLOAD,
		BACKGROUND,
		POPBACK
};

#undef	TNBUFFSIZE
#undef	TNSHOVE
#define TNSHOVE    128
#define TNBUFFSIZE 256			/* tiny! */
char *msg="Clarkson University MicroTN " VERSION;
char 	abuff[32];
int	state=CLOSED;
unsigned char TN_Buff[TNBUFFSIZE];

VSwrite(d, c, l)
	int d;
	char *c;
	int l;
{
	if(onscreen)
		cprintf("VSwrite%*.*s",l,c,l);
}

int
nprintf(int dest, char *format,...)
{
	va_list list;
	char	tbuff[128],xbuff[128],*c,*o;
	int	len;
extern	unsigned char att;
	c = xbuff;
	o = format;
	while(*o) {
	       if(*o == '\n')
		      	*c++ = '\r';
		*c++ = *o++;
	}
	*c = 0;

	va_start(list,format);
	cprintf(tbuff,xbuff,list);
	va_end(list);
}

n_play(SOUNDS *s)
{
	while((s != NULL) && (s->s_duration != 0)) {
	       n_sound(s->s_frequency,s->s_duration);
	       s++;
       }
}


vprint(d,c)
	int d;
	char	*c;
{
	if(!onscreen || current->tnmode || !c)	/* don't print DO TIMING MARK */
	       	return;

	cprintf("%s",c);
}

Get_Capture()
{
	char fbuff[80];
	int   cnt;
	unsigned char c;
	int	x,y;

	if(!current->tnmode || !onscreen)
	        return;
	x = wherex();
	y = wherey();

	gotoxy(1,25);

	strcpy(fbuff,Scon.capture);
	cnt = strlen(fbuff);
	cprintf("Capture File: %s",fbuff);
	clreol();

	while(1) {
	        Stask(0);
	        c = n_chkchar();

		switch (c) {

		       case 27 :
			       goto out;
		       case 13 :
			       fbuff[cnt] = 0;
			       Snewcap(fbuff);
out:
			       gotoxy(x,y);
			       statline();
			       return;
		       case 8 :
		       case BACKSPACE :	
		       case 127 :
			       if(cnt) {
			       		cnt--;
					cprintf("\010 \010");
				}
			 	break;
		       case 20 :	/* ^U */
			       while(cnt) {
			       		cnt--;
					cprintf("\010 \010");
				}
			 	break;
			default :;
				if(c < 127 && cnt < 63) {
					fbuff[cnt++] = c;
					cprintf("%c",c);
				}
		 }	/* end switch */
	} /* end while */
}

int
process(mode)
	int mode;			/* set if on screen */
{
	unsigned int c;
	int i,cnt,ev,pnum,what,dat;
	char *errmsg;


	dat = current->pnum;

	do {
	        Stask(0);
#ifdef	CLOCK
		show_clock(0);
#endif
	       	if(mode)
		       	switch (c = n_chkchar()) {

			        case 0xffff :
				      	break;
				case ALTB  :		/* go to background mode */
					return(BACKGROUND);
				case ALTP :
				        Get_Capture();
				 	continue;
				case ALTX :
				        state = CLOSED;
				 	netclose(dat);
					Stask();
					if(foreground)
					       	return(UNLOAD);
					return(NONE);
				case ALTM :	/* memory check */
				       	cprintf("coreleft %u state %d mode %d Stuffbuff %d ext 0x%x\n",coreleft(),state,mode,
					       	FP_OFF(current->tn3270_front) - FP_OFF(current->tn3270_data),extended);
				 	continue;
				default :;
					if(state == OPEN)
						vt100key(c);
			}

	/*
	*  get event from network, these two classes return all of the events
	*  of user interest.
	*/
			ev = Sgetevent(USERCLASS | CONCLASS | ERRCLASS,&what,&dat);
			if (!ev) {
			        if(popback)
				       	return(POPBACK);
				continue;
			}

			if (what == ERRCLASS) {				/* error event */
				errmsg = neterrstring(dat);
				vprint(0,errmsg);
			}
			else if (what == CONCLASS) {		/* event of user interest */
				switch (ev) {
					case CONOPEN:				/* connection opened or closed */
						state = OPEN;
#ifdef	JUNK
						/* netpush(dat); */			/* negotiation */
						netwrite(dat,"\377\375\001\377\375\003\377\374\030",9);
#endif
						break;
					default:
						break;
					case CONDATA:				/* data arrived for me */
					        state = OPEN;
						cnt = netread(dat,buf,BUFFSIZE);
						if(cnt < 0) {
						        state = CLOSED;
							netclose(dat);
							return(NONE);
						}
					 	parse(current,buf,cnt);
						break;
					case CONFAIL:
						cprintf("\n\rConnection attempt failed\n\r");
						/* drop through to exit */

					case CONCLOSE:
					        state = CLOSED;
					 	netclose(dat);
				}
			}
		if(mode == 2)
		       	break;
		} while (state == OPEN && mode); 		/* Ctrl-P, arbitrary escape */
	return(NONE);
}

int
ScreenSwap()			/* copies page 2 to one, etc */
{
	unsigned long far *low;
	unsigned long far *hi;
	unsigned long  hold;
	int	count;
	struct REGPACK regs;
	unsigned char far *pageptr;
	unsigned int	row,page;

	pageptr = (unsigned char far * ) MK_FP(0x40, 0x62);
	page = *pageptr & 0xff;
	regs.r_ax = 0x0300;
	regs.r_bx = page * 256;
	intr(0x10, &regs);
	row = regs.r_dx;

	low = (unsigned long far * ) MK_FP(video_seg,0);
	hi = (unsigned long far * ) MK_FP(video_seg, 0x3000);

	for(count=0; count < 1000; count++) {
	       	hold = *low;
		*low = *hi;
		*hi = hold;
		low++;
		hi++;
	}
	regs.r_ax = 0x0500 | (save_page);
	intr(0x10, &regs);
	regs.r_ax = 0x0200;
	regs.r_bx = save_page * 256;
	regs.r_dx = save_row;
	intr(0x10, &regs);
	save_row = row;
	save_page = page;
}

int
ScreenSave()			/* copies page 1 to 2, etc */
{
	unsigned long far *low;
	unsigned long far *hi;
	unsigned long  hold;
	int	count;
	struct REGPACK regs;

	unsigned int	row;

	regs.r_ax = 0x0300;
	regs.r_bx = 0;
	intr(0x10, &regs);
	save_row = regs.r_dx;
	save_page = 0;
	low = (unsigned long far * ) MK_FP(video_seg,0);
	hi = (unsigned long far *) MK_FP(video_seg, 0x3000);

	for(count=0; count < 1000; count++) {
	       	*hi = *low;
		low++;
		hi++;
	}
}

Unload()
{
	struct REGPACK regs;
	extern int capon;

	if(capon || state == OPEN || state == OPENING) {
	        n_play(sounds[SOUND_BADKEY]);
		return;
	}
	if(!foreground) {
	       	ScreenSwap();
		stop_back();
	}
	netshut();
	if(foreground) {
	       	clrscr();
	       	exit(0);
	}
	regs.r_ax = 0x4900;
	regs.r_es = _psp;
	intr(0x21, &regs);
}

int
cycle(mode)
	int	mode;			/* set if user wanted a pop up */
{
	unsigned int c;
	int command,pnum;
static	char	cnt=0;
static	int	popback_on;

	if(!mode) {	/* not onscreen */
	       	onscreen = 0;
	 	if(state == OPEN || state == OPENING) {
		       	process(mode);
		}
	 	else
		       	Stask(0);
		return(0);
	}
	else {
	        if(popback_on) {
		       	popback_on = 0;
		}
	 	else {
		       	onscreen = 1;	/* swap screens */
			ScreenSwap(); 
			if(state == OPEN && current->tnmode) {
			       	RefreshScreen();
			 	statline();
			}
		}
 	}
	while(1) {
restart:;
		Stask(0);
		switch  (state) {
		       case OPEN :
		       case OPENING :
				switch (process(mode)) {
					case NONE :
					       	break;
					case UNLOAD :
					       	Unload();
					 	return(0);
					case BACKGROUND :
					        if(!foreground) {
						        ScreenSwap();
						        return(0);
						}
					 	break;
					case POPBACK :
					       	popback_on = 1;
					 	return(18);
				 }
			  	break;
			default :;		/* any other state */
			        clrscr();
tryagain:
				cprintf("%s\r\nEnter Host Name: ",msg);
			 	state = ASKING;
			case ASKING :
			        c = n_chkchar();
				switch (c) {

					case 0xffff :
					       	continue;
					case ALTB :
					        if(!foreground) {
						       	ScreenSwap();
						       	return(0);
						}
					 	break;
					case ALTX :
					case 27 :
					       	if(!foreground)
						       	continue;
					case ALTU :
					       	Unload();
					 	return(0);

					default :;
						if(c < 128)
						        switch (c) {

								case 8 :
								case 127 :
								       if(cnt) {
								       		cnt--;
										cprintf("\010 \010");
									}
								 	break;
								case 13 :
								        if(cnt == 0) {
										state = CLOSED;
										goto restart;
									}
								       	abuff[cnt] = 0;
									cnt = 0;
								 	state = LOOKING;
									goto restart;
								default :;
									if(cnt < 31) {
									       	abuff[cnt++] = c & 0xff;
										cprintf("%c",c);
									}
							  } /* end switch c */
				  } /* end switch chkchar */
				  break;
			case LOOKING :
			        cprintf("\r\nLooking for:%s\r\n",abuff);
				mp = Sgethost(abuff);		/* look up in hosts cache */
				if (!mp) {
					cprintf("name not in config.tel file\r\n");
					state = CLOSED;
					goto tryagain;
				}
				else {
					if (0 > (pnum = Snetopen(mp,23))) {
					       	cprintf("Error %d opening connection\r\n",pnum);
						state = CLOSED;
						goto tryagain;
					}
					current->pnum = pnum;
					Setwindow(current, mp);
					state = OPENING;
				}
				break;
		 } /* end switch */
		 if(!mode || mode == 2)
			break;		/* one loop each time */
	 } /* end while */
	 return(0);
}

main(argc,argv)
	int	argc;
	char	*argv[];
{
	unsigned int far *z;
	int	x;
	long	endtime;

	if(getenv("CONFIGTEL"))
		if(Shostfile(getenv("CONFIGTEL")) < 0) {
			fprintf(stderr,"Can't open config.tel file %s\n",getenv("CONFIGTEL"));
			exit(1);
		}
	for(x=1; x < argc; x++) {
	       	if(!strcmp(argv[x],"-?")) {
		       	fprintf(stderr,"Usage: %s [-r] [-h config_file] [-p]\n",argv[0]);
			exit(0);
		}
	 	if(!strcmp(argv[x],"-r")) {
		       	foreground = 0;
		}
	 	else if(!strcmp(argv[x],"-p")) {
		        popback = 1;
		}
		else if(!strcmp(argv[x],"-h"))  {
		       	Shostfile(argv[++x]);
		}
		else {
		       	strncpy(abuff,argv[x],31);
		       	abuff[31] = 0;
			state = LOOKING;
		}
	}
	if(foreground)
	       	popback = 0;
	z = MK_FP(0x40, 0x63);
	if(*z == 0x3b4)		   	/* look for monochrome screen */
	       	video_seg = 0xb000;
	clrscr();
	puts(msg);
	n_chkchar();
	ScreenSave();

	if (Snetinit()) {			/* call session initialization */
		errhandle();			/* Snetinit() reads config.tel file */
		exit(1);
	}
	cprintf("Keyboard is %s\r\n", extended ? "extended" : "not extended");
	Key_Init();
	if(foreground) {
	       	while(1)
		       	cycle(1);
		exit(0);
	}
	endtime = time(NULL) + 5;
	while(endtime > time(NULL)) {
	       	if(state == OPEN) {
		       	cycle(2);
			cycle(2);
		       	break;
		}
		cycle(2);
	}

	if(start_back()) {			/* now ready to pop up */
		keepme();
       }
	netshut();
	fprintf(stderr,"Unable to start background code\n");
}

int
keepme()
{
	extern unsigned _stklen;
	unsigned keep_amount;
	extern unsigned _heaptop;
	struct REGPACK regs;
	unsigned int far *up;

/*	keep_amount = _DS - _CS + (__heaptop + _heaplen + _stklen)/16 + 16; */
	keep_amount = _DS - _CS + (_SP + 128)/16 + 16;

#ifdef	DEBUG
	printf("cs 0x%x ds 0x%x heaplen 0x%x stklen 0x%x SS 0x%x sp 0x%x keeping %d\n",
	       	_CS, _DS, _heaplen, _stklen, _SS, _SP,keep_amount);
#endif
	cprintf("MicroTN Resident.. Press <ALT>-<RIGHT_SHIFT> to activate\n\r\n\r");
	mysp = _SP - 32;
	regs.r_ax = 0x4900;
	up = MK_FP(_psp, 0x2c);
	regs.r_es = *up;
	intr(0x21, &regs);
	keep(0,keep_amount);

}

/*********************************************************************/
/*  errhandle
*   write error messages to the console window
*/
errhandle()
	{
	char *errmsg;
	int i,j;

	while (ERR1 == Sgetevent(ERRCLASS,&i,&j)) {
		errmsg = neterrstring(j);
		puts(errmsg);
	}

}
#define	IGNORE	(WILL+4)

printoption(mode, option, result)
        char    *mode;
        int     option;
        int     result;

{
        char buff[80];
static  char *results[]={"WILL","WONT","DO","DONT","IGNORE"};


        sprintf(buff,"%s Option %s (%s)\n\r",mode, option < NTELOPTS ? telopts[option] : "Unknown Option",results[result-WILL]);
        vprint(console->vs, buff);
}

int
checkoption(option)
        int     option;         /* return > -1 if option is valid */
{

        if(option > -1)  {
                if(option > NTELOPTS)
                        option = NTELOPTS;
        }
        return(option);
}

sendoption(tw, option, result)
        struct twin *tw;
        int     option;
        int     result;
{
        char buff[6];

        sprintf(buff,"%c%c%c",IAC,result, option);
        netwrite(tw->pnum, buff, 3);
}

send3270_type(tw)
        struct twin *tw;

{
       char buff[64];
        int mode;
static  char *mode_types[]={"VT102","IBM-3278-2","IBM-3278-4","IBM-3278-3", "IBM-3278-5"};
#ifndef TN3270
        mode = 0;
#else
       extern int NumberLines, NumberColumns, ScreenSize,MaxNumberLines, MaxNumberColumns;

        /* if they aren't doing SGA by now assume its a VM machine */
        if(!tw->hisopts[TELOPT_EOR])
                mode = 0;
        else
           mode = 1;


        /* now we change our answer based on config.tnmode and crfollow */
        if(Scon.tnmode == TNMODE_OFF)
                mode = 0;
        else
                if(Scon.tnmode == TNMODE_FLAGGED)  {
                        if(tw->crfollow == 255)
                                mode = 1;
                        else
                                mode = 0;

                }
        else
                if(Scon.tnmode == TNMODE_NOTFLAGGED) {
                        if(tw->crfollow == 255)
                                mode = 0;
                        else
                                mode = 1;

                }
        else 
                if(Scon.tnmode == TNMODE_AUTO) {
                        if(tw->flags & TWIN_FLAGS_LASTTYPE_VT102)             /* if auto and linemode[4], we sent vt102 last time */
                                mode = 1;
                        else
                           tw->flags |= TWIN_FLAGS_LASTTYPE_VT102;

                }
	 if(tw->flags & TWIN_FLAGS_3270MODE_ON)
		mode = 1;		/* always does 3270 mode */

#endif
        sprintf(buff,"%c%c%c%c%s%c%c",IAC,SB,TELOPT_TTYPE,TELQUAL_IS,
                        mode_types[mode],IAC,SE);
        /* listen to this!
                type VT102 is not in the assigned numbers RFC, the closest
                recognized terminal  is DEC-VT100  however, nobody has
                DEC-VT100 in their termcap! What a waste to have assigned
                numbers but not use them!
        */

	if(mode)
	       	tw->flags |= TWIN_FLAGS_SENT3270_TYPE;
	 else
		tw->flags &= ~TWIN_FLAGS_SENT3270_TYPE;

             /* stash record of sending
                                        3270 type terminal in linemode buffer */
        netwrite(tw->pnum, buff, strlen(mode_types[mode]) + 6);
        sprintf(buff,"IAC SB Sent type %s\n\r",mode_types[mode]);
        vprint(console->vs,buff);
#ifdef  TN3270
        switch (mode) {

           case 0 :
                break;

           case 1 :
                MaxNumberLines = 24;
                MaxNumberColumns = 80;
                break;

           case 2 :
                MaxNumberLines = 43;
                MaxNumberColumns = 80;
                break;

           case 3 :
                MaxNumberLines = 32;
                MaxNumberColumns = 80;
                break;
	    case 4 :
		 MaxNumberLines = 27;
	  	 MaxNumberColumns = 132;
		 break;
           default:;

        }
        if(mode) {
                NumberLines = 24;
                NumberColumns = 80;
                ScreenSize = NumberLines * NumberColumns;
        }
#endif
}

tnsuboption(tw, suboption,subsize)  /* handle sub option negotiation */
        struct twin *tw;
        unsigned char *suboption;
        int     subsize;
{

        switch (*suboption) {

           case TELOPT_TTYPE :
                if(*(suboption+1) == TELQUAL_SEND) {
                        send3270_type(tw);
                }
                if(!(tw->flags & TWIN_FLAGS_SENT3270_TYPE)) {
                        if(!(tw->flags & TWIN_FLAGS_SENTANY_TYPE)) {
                                tw->flags |= TWIN_FLAGS_SENTANY_TYPE;
                                sendoption(tw,TELOPT_NAWS,WILL);        /* tell them we are willing to naws */
                        }
                }
                break;

          default:
                break;
       }

}

set3270_mode(tw)                        /* decide if we should enter 3270 mode */
        struct twin *tw;

{
#ifdef  TN3270
extern struct twin *to3270;
       struct twin *next;

                  
   if((tw->flags & TWIN_FLAGS_SENT3270_TYPE) && tw->myopts[TELOPT_BINARY] && tw->hisopts[TELOPT_BINARY]) {
        if(!tw->tnmode) {
                vprint(console->vs,"Entering 3270 Data Mode\n\r");
                tw->tnmode = 1;
				tw->tnmode |= (2 << 1);

#ifndef	MINITEL
                VSscreens[tw->vs].loc->DECAWM = 1;
#endif

                tw->tn3270_base = tw->tn3270_front = tw->tn3270_data = TN_Buff;
                        to3270 = tw;
                        tw->echo = 1;           /* pretend host is echo'ing chars for us */
                        Init3270();

                        InitTerminal();

        }
   }
#endif
}


dooption(tw, option)
        struct twin *tw;
        int option;
{
        int result;

        if((option = checkoption(option)) > -1) {
                result = WILL;
                tw->myopts[option] = 1;
                switch (option) {
                        case TELOPT_EOR :
                                break;
                        case TELOPT_BINARY :
                               tw->binary = 1;
                                break;
                        case TELOPT_TTYPE:
                                tw->flags &= ~TWIN_FLAGS_LASTTYPE_VT102;
                                break;
                        case TELOPT_SGA :  /* supress go ahead */
                                tw->igoahead = 1;
                                break;
                        case TELOPT_TM :
                                break;
                        case TELOPT_NAWS :              /* do naws */
                                break;
			case TELOPT_ECHO :		/* won't echo when told to */
                        default:
                                result = WONT;
                                tw->myopts[option] = 0;
                                break;
                }
                printoption("DO",option,result);
                sendoption(tw, option, result);
#ifdef	DONTDOTYPE
                if(option == TELOPT_SGA) {
                         sendoption(tw,TELOPT_TTYPE,WILL);
                }
#endif
                if(option == TELOPT_NAWS) {
                        unsigned char wbuff[80];

                        sprintf(wbuff,"%c%c%c%c%c%c%c%c%c",
                                IAC,SB,TELOPT_NAWS,0,cols,0,NUMLINES+1,IAC,SE);
                        netwrite(tw->pnum,wbuff,9);
                        sprintf(wbuff,"IAC SB NAWS %d %d \n\r",cols,NUMLINES+1);
                        vprint(console->vs,wbuff);
                }
        }
}

wontoption(tw, option)
        struct twin *tw;
        int option;
{
        int result;

        if((option = checkoption(option)) > -1) {
                result = DONT;
                tw->hisopts[option] = 0;
                switch (option) {
                        case TELOPT_ECHO:
                                tw->echo = 0;
                                break;

                        case TELOPT_SGA :  /* supress go ahead */
                                tw->igoahead = 0;
                                break;

                        case TELOPT_TM :
                                return;

                        default:
                                break;
                }
                printoption("WONT",option,result);
                sendoption(tw, option, result);
        }
}


willoption(tw, option)
        struct twin *tw;
        int option;
{
        int result;

        if((option = checkoption(option)) > -1) {

                result = DONT;
                switch (option) {

                        case TELOPT_ECHO :  
			   	result = DO;    
                                tw->echo = 1;
                                tw->hisopts[option] = 1;
			 case TELOPT_EOR :
                                tw->hisopts[option] = 1;
                                result = DO;
                                break;
                        case TELOPT_BINARY :
                                result = DO;
                                tw->hisopts[option] = 1;
                                break;
                        case TELOPT_SGA :
                                tw->hisopts[option] = 1;
                                result = DO;
                                break;
                        case TELOPT_TM :
                                return;
                        case TELOPT_NAWS:       /* server will do naws, has no meaning */
                        default:
                                result = DONT;
                }
                printoption("WILL",option,result);
                sendoption(tw, option, result);
        }
}

dontoption(tw, option)
        struct twin *tw;
        int option;
{
        int result;

        if((option = checkoption(option)) > -1) {
                tw->myopts[option] = 0;
                result = WONT;
		if(option == TELOPT_ECHO) {
		   	result = IGNORE;
		}
                printoption("DONT",option,result);
		if(result != IGNORE)
	                sendoption(tw, option, result);
#ifdef	TN3270
                if(option == TELOPT_BINARY) {

			 if(tw->tnmode) {	/* was in 3270 mode, get out */
#ifndef	MINITEL
				VSreset(tw->vs);
#endif
			 	mem_free(tw->tn3270_data);	/* free the tnbuffer */
				tw->tnmode = 0;
			 	tw->tn3270_data = NULL;
			 	if(!tw->hisopts[TELOPT_ECHO])
				       	tw->echo = 0;	/* indicate that he's not echoing */
				vprint(console->vs,"Leaving 3270 mode\n\r");
			 }

	 	 }
#endif
        }
}




#define STNORM	0
#define GOAHEAD 249
#define WILLTEL 251
#define WONTTEL 252
#define DOTEL	253
#define DONTTEL 254
#define ESCFOUND 5
#define IACFOUND 6

#define SUBSIZE 32
/*  parse
*   Do the telnet negotiation parsing.
*
*   look at the string which has just come in from outside and
*   check for special sequences that we are interested in.
*
*   Tries to pass through routine strings immediately, waiting for special
*   characters ESC and 255 to change modes.
*/


parse(tw,st,cnt)
	struct twin *tw;
	int cnt;
	unsigned char *st;
	{
	int i,cv, option;
	unsigned char *mark,*orig;

static  char suboption[SUBSIZE];
static  int  subsize,iaccount;
        char xbuff[80];


	cv = console->vs;
	orig = st;				/* remember beginning point */
	mark = st + cnt;		/* set to end of input string */

/*
*  traverse string, looking for any special characters which indicate that
*  we need to change modes.
*/
	while (st < mark) {

		switch (tw->telstate) {
			case ESCFOUND:

				parsewrite(tw,"\033",1);        /* send the missing ESC */

				tw->telstate = STNORM;
				break;
			case IACFOUND: 		/* telnet option negotiation */
#ifdef  TN3270
                                if(tw->tnmode) {
                                        if(*st == IAC)  {
                                                *(tw->tn3270_front++) = *st;
                                                tw->telstate = STNORM;
                                        }
                                        else {
                                                tw->telstate = *st;
                                                if(*st == EOR)
                                                        continue;  /* loop to get eor in this shot */
                                        }
                                        orig = ++st;
                                        continue;
                                }
#endif
				if (*st == 255) {		/* real data = 255 */
					st++;				/* real 255 will get sent */
					tw->telstate = STNORM;
					break;
				}
				if ( 238 < *st ) {
					tw->telstate = *st;		/* by what the option is */
					st++;
					break;
				}
				vprint(cv,"\n\r strange telnet option\r\n");
				orig = st;
				tw->telstate = STNORM;
				break;
			case GOAHEAD:
				tw->telstate = STNORM;
				orig = st;
				break;
			case DOTEL:
                                dooption(tw, *st++);
                                set3270_mode(tw);
				tw->telstate = STNORM;
				orig = st;
				break;
			case DONTTEL:
                                dontoption(tw, *st++);
                                set3270_mode(tw);
				tw->telstate = STNORM;
				orig = st;
				break;
			case WILLTEL:
                                willoption(tw, *st++);
                                set3270_mode(tw);
				tw->telstate = STNORM;
				orig = st;
				break;
							
			case WONTTEL:
                                wontoption(tw, *st++);
                                set3270_mode(tw);
				tw->telstate = STNORM;
				orig = st;
				break;
                        case  SB :      /* sub negotiation */
				tw->telstate = SE;
                                iaccount = subsize = 0;
                                break;
                                        /* since we use a single static buffer,
                                           if two windows try sub negotiation at the
                                           same time there will be trouble */
                        case  SE :
                                if(*st == SE) {
                                        tnsuboption(tw, suboption,subsize);
                                        set3270_mode(tw);
                                        tw->telstate = STNORM;
                                }
                                else if(*st == IAC) {
                                        if(iaccount) {
                                                if(subsize < SUBSIZE-1) {
                                                        suboption[subsize++] = IAC;
                                                }
                                                iaccount = 0;
                                        }
                                        else
                                                iaccount = 1;
                                }
                                else {
                                        if(subsize < SUBSIZE-1) {
                                                suboption[subsize++] = *st;
                                        }
                                }
                                orig = ++st;
                                break;
#ifdef  TN3270
                        case    EOR :           /* end of record */
                                orig = ++st;    /* remember to do this */
                                if(tw->tnmode) {
                                        unsigned char *x;
                                        
/* ### */
                                        x = tw->tn3270_base;
                                        x += XDataFromNetwork(tw,1);    /* calls special data from network */
                                        if(x == tw->tn3270_front) {
                                                tw->tn3270_base = tw->tn3270_front = tw->tn3270_data;
                                        }
                                        else {
#ifdef	DEBUGMEM
	if(x > tw->tn3270_front)
	       printf("\n\r\007 Data From network overflow!\n\r");
#endif
                                                tw->tn3270_base = x;
                                        }
                                }
                                tw->telstate = STNORM;
				 if(slip_mode && current == tw)
						statline();
                                break;
#endif
			default:
				tw->telstate = STNORM;
				break;
		}

/*
* quick scan of the remaining string, skip chars while they are
* uninteresting
*/
		if (tw->telstate == STNORM) {
/*
*  skip along as fast as possible until an interesting character is found
*/
#ifdef  TN3270
                        if(tw->tnmode) {
                                unsigned char c;
                                while(st < mark) {
                                        c = *st++;
                                        if(c == IAC) {
                                                tw->telstate = IACFOUND;
                                                break;
                                        }
                                        *(tw->tn3270_front++) = c;
					if((FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_base)) > TNSHOVE) {
					       unsigned char *x = tw->tn3270_base;
						x += XDataFromNetwork(tw,0);
						if(x == tw->tn3270_front) {
	                                                tw->tn3270_base = tw->tn3270_front = tw->tn3270_data;
	                                        }
	                                        else {
#ifdef	DEBUGMEM
	if(x > tw->tn3270_front)
	       printf("\n\r\007 Data From network overflow!\n\r");
#endif

	                                                tw->tn3270_base = x;
	                                        }
					}

                                        if((FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_data)) >= TNBUFFSIZE-2) {
						memmove(tw->tn3270_data, tw->tn3270_base, (FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_base)));
						tw->tn3270_front = tw->tn3270_data + (FP_OFF(tw->tn3270_front) - FP_OFF(tw->tn3270_base));
						tw->tn3270_base = tw->tn3270_data;
#ifdef	TRASH
						 char buff[100];
						 sprintf(buff,"\n\rFatal: TNBUFF overflow. Data %lp, base %lp, front %lp\n\r",
							tw->tn3270_data, tw->tn3270_base, tw->tn3270_front);
                                                vprint(tw->vs,buff);
                                                netshut(0);
                                                exit(1);
#endif
                                        }
                               }	 
                               orig = st;
				if(slip_mode && current == tw)
				       	statline();
                               continue;
                        }
#endif                        
/*			while (st < mark && *st != 27 && *st < 255) { */
			if (!tw->binary) {
				register int cnt = mark - st;
				while(cnt-- && *st != 255) {
					*(st++) &=127;
				}
			 }
		  	else {
			       	register int cnt = mark - st;

				while(cnt-- && *st != 255)
				       	st++;
			 }

			parsewrite(tw,orig,st-orig);

			orig = st;				/* forget what we have sent already */

			if (st < mark)
			switch (*st) {
				case 255:			/* telnet IAC */
					tw->telstate = IACFOUND;
					st++;
					break;
				default:
					vprint(cv," strange char > 128\r\n");
					st++;
					break;
			}

		}

	}  /* end while */

}

parsewrite(tw, buff, count)
	struct twin *tw;
	char	*buff;
	int	count;

{
	cprintf("%*.*s",count,count,buff);
/*	fwrite(buff,count,1, stdout); */
}

/***********************************************************************/
/*  creatwindow
*   returns a pointer to a new window
*/
setwindow(p,mp)
	struct twin *p;
	struct machinfo *mp;
{
	int i;
        char errbuf[90];

	if (!p)
		return
	p->telstate = 0;
	p->termstate = DUMBTYPE;
	p->linemode[0] = 0;
	p->mname[0] = 0;
	p->flags = 0L;
	p->echo = 0;
	p->next = NULL;
	p->prev = NULL;
	p->sstat = '*';				/* connection not opened yet */
	for(i=0; i < NTELOPTS+1; i++) {
		p->hisopts[i] = p->myopts[i] = 0;
	}
	p->tnmode =0;
	p->key_map = NULL;

	if (mp == NULL) {
		p->bksp = 127;
		p->del = 8;
		p->crfollow = 10;
		p->halfdup = 0;

		for (i=0; i<3; i++)					/* start default colors */
			p->colors[i] = colors[i];

	}
	else {
#ifdef	NEWKEY
		if(mp->keymap) 
			p->key_map = Key_Load_File(mp->keymap);
#endif
	        p->flags = mp->flags;
	 	strncpy(p->mname,mp->sname,15);
		p->mname[15] = 0;

		p->bksp = mp->bksp;
		if (p->bksp == 127)
			p->del = 8;
		else
			p->del = 127;
		p->crfollow = mp->crmap;
	        if(p->halfdup = mp->halfdup)
                        p->echo = 0;
        
		p->colors[0] = mp->nfcolor[0] + (mp->nbcolor[0]<<4);
		p->colors[2] = mp->bfcolor[0] + (mp->bbcolor[0]<<4);
		p->colors[1] = mp->ufcolor[0] + (mp->ubcolor[0]<<4);
	}
}

int
Command_Key()
{
		return(0);
}
