#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "futil.h"

void main(void)
{
  int  RetCode, Stop = 0;
  FILE *IniFile;
  char InBuf[255];

  if ((IniFile = fopen("FUTTEST.INI", "r")) == NULL) {
    printf("File 'FUTTEST.INI' not ready for reading\n");
    exit(1);
    }
  if ((RetCode = FFindSection(IniFile, "ipdos")) < 0) {
    printf("Error finding section 'ipdos'\n");
    exit(1);
    }
  if ((RetCode = FFindSection(IniFile, "ROUTES")) < 0) {
    printf("Error finding section 'ROUTES'\n");
    exit(1);
    }
  printf("Section 'ROUTES' found at line %d\n", RetCode);

  while(!Stop) {
    if ((RetCode = FGetNext(IniFile, InBuf, 255, MIX)) < 0) {
      printf("Error finding next line. Code: %d\n", RetCode);
      Stop = 1;
      }
    else {
      printf("%s\n", InBuf);
      }
    }

 if ((RetCode = FFindSection(IniFile, "IPDOS")) < 0) {
    printf("Error finding section 'IPDOS'\n");
    exit(1);
    }
  printf("Section 'IPDOS' found at line %d\n", RetCode);

  if ((RetCode = FGetVar(IniFile, "L0address", InBuf, 255, MIX)) < 0) {
    printf("Error finding variable 'L0address. Code: %d\n", RetCode);
    }
  else {
    printf("Variable 'L0address found at line %d\n", RetCode);
    printf("%s\n", InBuf);
    }

  if ((RetCode = FGetVar(IniFile, "L0mask", InBuf, 255, MIX)) < 0) {
    printf("Error finding variable 'L0mask. Code: %d\n", RetCode);
    }
  else {
    printf("Variable 'L0mask found at line %d\n", RetCode);
    printf("%s\n", InBuf);
    }

}
