/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dog.c
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1
**     CREATION DATE:       1991/1/14
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DOG.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/DOG/VCS/DOG.C_V  $
**              
**                 Rev 1.0   31 Jan 1991 16:47:02   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/DOG/VCS/DOG.C_V   1.0   31 Jan 1991 16:47:02   etstjan  $";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <beholder.h>
#include <error.h>
#include <futil.h>

static int  ProcessEvent (DPEVENT Event);
static void ReceivePkt (void);
static void Init (void);
static void Start (void);
static void Stop (void);
static void FreeTime (void);
static void EverySecond (void);
static void Boot (void);    



static int SecondsSindsReceivePkt=0;
static int SecondsSindsFreeTime=0;
static int SecondsWithoutReceivePkt=120;
static int SecondsWithoutFreeTime=120;

DPAPPS DpaDog = {
    "Dog",
    ProcessEvent,
    0,                                     
    DPE_START | DPE_STOP | DPE_RECEIVEPKT | DPE_EVERYSECOND | DPE_FREETIME | DPE_INIT,
    DPE_START,
    0,
    -1,
    0,
    0,
    0,
    0,
    {0}     
};

static int ProcessEvent (DPEVENT Event)
{
    switch (Event)
    {
        case DPE_INIT:          Init ();        break;
        case DPE_START:         Start ();       break;
        case DPE_STOP:          Stop ();        break;
        case DPE_RECEIVEPKT:    ReceivePkt();   break;
        case DPE_EVERYSECOND:   EverySecond();  break;
        case DPE_FREETIME:      FreeTime();     break;
    }
    return 0;
}

static void Init (void)
{
    char Variable[6];
    FILE *Cfg;

    if ((Cfg = fopen (ConfigFile,"r")) == NULL)
    {
        ERR_ERR (ERR_MAT, ERR_CRITICAL, "Cannot open configfile\n");
        return;
    }
    if (FFindSection (Cfg, "DOG") >= 0)
    {
        if (FGetVar (Cfg, "SECSWITHOUTFREETIME", Variable, 5, UPC) >= 0)
            SecondsWithoutFreeTime=atoi(Variable);
        else
            ERR_ERR (ERR_MAT, ERR_WARNING, "Cannot find SecsWithoutFreeTime");
        if (FGetVar (Cfg, "SECSWITHOUTRECEIVEPKT", Variable, 5, UPC) >= 0)
            SecondsWithoutReceivePkt=atoi(Variable);
        else
            ERR_ERR (ERR_MAT, ERR_WARNING, "Cannot find SecsWithoutReceivePkt");
    }
    else
    {
        ERR_ERR (ERR_MAT, ERR_WARNING, "Cannot find section DOG");
    }
    fclose (Cfg);

}

static void Start (void)
{
    SecondsSindsReceivePkt=0;
    SecondsSindsFreeTime=0;
}

static void Stop (void)
{
    SecondsSindsReceivePkt=0;
    SecondsSindsFreeTime=0;
}

static void ReceivePkt (void)
{
    SecondsSindsReceivePkt=0;
}

static void FreeTime (void)
{
    SecondsSindsFreeTime=0;
}

static void EverySecond (void)
{
    SecondsSindsReceivePkt++;
    SecondsSindsFreeTime++;
    if (SecondsSindsReceivePkt==SecondsWithoutReceivePkt ||
        SecondsSindsFreeTime  ==SecondsWithoutFreeTime)
        Boot();    
}


static void Boot (void)
{
    unsigned far *BootFlag      = (unsigned far *)     0x00400072;
    void (far *BootFunc) (void) = (void (far *)(void)) 0xFFFF0000;
    
    *BootFlag=0x1234;
    BootFunc();
}
