
unit Graph;

interface

const
  grOk               =   0;
  grNoInitGraph      =  -1;
  grNotDetected      =  -2;
  grFileNotFound     =  -3;
  grInvalidDriver    =  -4;
  grNoLoadMem        =  -5;
  grNoScanMem        =  -6;
  grNoFloodMem       =  -7;
  grFontNotFound     =  -8;
  grNoFontMem        =  -9;
  grInvalidMode      = -10;
  grError            = -11;
  grIOerror          = -12;
  grInvalidFont      = -13;
  grInvalidFontNum   = -14;
  grInvalidDeviceNum = -15;
  Detect   = 0;
  CGA      = 1;
  MCGA     = 2;
  EGA      = 3;
  EGA64    = 4;
  EGAMono  = 5;
  RESERVED = 6;
  HercMono = 7;
  ATT400   = 8;
  VGA      = 9;
  PC3270   = 10;
  CGAC0      = 0;
  CGAC1      = 1;
  CGAC2      = 2;
  CGAC3      = 3;
  CGAHi      = 4;
  MCGAC0     = 0;
  MCGAC1     = 1;
  MCGAC2     = 2;
  MCGAC3     = 3;
  MCGAMed    = 4;
  MCGAHi     = 5;
  EGALo      = 0;
  EGAHi      = 1;
  EGA64Lo    = 0;
  EGA64Hi    = 1;
  EGAMonoHi  = 3;
  HercMonoHi = 0;
  ATT400C0   = 0;
  ATT400C1   = 1;
  ATT400C2   = 2;
  ATT400C3   = 3;
  ATT400Med  = 4;
  ATT400Hi   = 5;
  VGALo      = 0;
  VGAMed     = 1;
  VGAHi      = 2;
  PC3270Hi   = 0;
  Black        = 0;
  Blue         = 1;
  Green        = 2;
  Cyan         = 3;
  Red          = 4;
  Magenta      = 5;
  Brown        = 6;
  LightGray    = 7;
  DarkGray     = 8;
  LightBlue    = 9;
  LightGreen   = 10;
  LightCyan    = 11;
  LightRed     = 12;
  LightMagenta = 13;
  Yellow       = 14;
  White        = 15;
  SolidLn    = 0;
  DottedLn   = 1;
  CenterLn   = 2;
  DashedLn   = 3;
  UserBitLn  = 4;
  NormWidth  = 1;
  ThickWidth = 3;
  DefaultFont   = 0;
  TriplexFont   = 1;
  SmallFont     = 2;
  SansSerifFont = 3;
  GothicFont    = 4;
  HorizDir      = 0;
  VertDir       = 1;
  UserCharSize  = 0;
  ClipOn  = true;
  ClipOff = false;
  TopOn  = true;
  TopOff = false;
  EmptyFill       = 0;
  SolidFill       = 1;
  LineFill        = 2;
  LtSlashFill     = 3;
  SlashFill       = 4;
  BkSlashFill     = 5;
  LtBkSlashFill   = 6;
  HatchFill       = 7;
  XHatchFill      = 8;
  InterleaveFill  = 9;
  WideDotFill     = 10;
  CloseDotFill    = 11;
  UserFill        = 12;
  NormalPut  = 0;
  XORPut     = 1;
  OrPut      = 2;
  AndPut     = 3;
  NotPut     = 4;
  LeftText   = 0;
  CenterText = 1;
  RightText  = 2;
  BottomText = 0;
  TopText    = 2;
  MaxColors  = 15;

type
  PaletteType = record
      Size   : byte;
      Colors : array[0..MaxColors] of shortint;
    end;

  LineSettingsType = record
      LineStyle : word;
      Pattern   : word;
      Thickness : word;
    end;

  TextSettingsType = record
      Font      : word;
      Direction : word;
      CharSize  : word;
      Horiz     : word;
      Vert      : word;
    end;

  FillSettingsType = record
      Pattern : word;
      Color   : word;
    end;

  FillPatternType = array[1..8] of byte;

  PointType = record
      X, Y : integer;
    end;

  ViewPortType = record
      x1, y1, x2, y2 : integer;
      Clip           : boolean;
    end;

  ArcCoordsType = record
      X, Y           : integer;
      Xstart, Ystart : integer;
      Xend, Yend     : integer;
    end;

var
  GraphGetMemPtr  : Pointer;
  GraphFreeMemPtr : Pointer;

function  GraphErrorMsg(ErrorCode : integer) : String; @
function  GraphResult : integer; @
procedure DetectGraph(var GraphDriver, GraphMode : integer); @
procedure InitGraph(var GraphDriver : integer;
                    var GraphMode   : integer;
                        PathToDriver : String); @
function  RegisterBGIfont(font : pointer) : integer; @
function  RegisterBGIdriver(driver : pointer) : integer; @
procedure SetGraphBufSize(BufSize : word); @
procedure GetModeRange(GraphDriver : integer; var LoMode, HiMode : integer); @
procedure SetGraphMode(Mode : integer); @
function  GetGraphMode : integer; @
procedure GraphDefaults; @
procedure RestoreCrtMode; @
procedure CloseGraph;  @
function  GetX : integer; @
function  GetY : integer; @
function  GetMaxX : integer; @
function  GetMaxY : integer; @
procedure ClearDevice;  @
procedure SetViewPort(x1, y1, x2, y2 : integer; Clip : boolean); @
procedure GetViewSettings(var ViewPort : ViewPortType); @
procedure ClearViewPort; @
procedure SetVisualPage(Page : word); @
procedure SetActivePage(Page : word); @
procedure PutPixel(X, Y : integer; Pixel : word); @
function  GetPixel(X, Y : integer) : word; @
procedure LineTo(X, Y : integer); @
procedure LineRel(Dx, Dy : integer); @
procedure MoveTo(X, Y : integer); @
procedure MoveRel(Dx, Dy : integer); @
procedure Line(x1, y1, x2, y2 : integer); @
procedure GetLineSettings(var LineInfo : LineSettingsType); @
procedure SetLineStyle(LineStyle : word;
                       Pattern   : word;
                       Thickness : word); @
procedure Rectangle(x1, y1, x2, y2 : integer); @
procedure Bar(x1, y1, x2, y2 : integer); @
procedure Bar3D(x1, y1, x2, y2 : integer; Depth : word; Top : boolean); @
procedure DrawPoly(NumPoints : word; var PolyPoints); @
procedure FillPoly(NumPoints : word; var PolyPoints); @
procedure GetFillSettings(var FillInfo : FillSettingsType); @
procedure GetFillPattern(var FillPattern : FillPatternType); @
procedure SetFillStyle(Pattern : word; Color : word); @
procedure SetFillPattern(Pattern : FillPatternType; Color : word); @
procedure FloodFill(X, Y : integer; Border : word); @
procedure Arc(X, Y : integer; StAngle, EndAngle, Radius : word); @
procedure GetArcCoords(var ArcCoords : ArcCoordsType); @
procedure Circle(X, Y : integer; Radius : word); @
procedure Ellipse(X, Y : integer;
                  StAngle, EndAngle : word;
                  XRadius, YRadius  : word); @
procedure GetAspectRatio(var Xasp, Yasp : word); @
procedure PieSlice(X, Y : integer; StAngle, EndAngle, Radius : word); @
procedure SetBkColor(Color : word); @
procedure SetColor(Color : word); @
function  GetBkColor : word;   @
function  GetColor : word;     @
procedure SetAllPalette(var Palette); @
procedure SetPalette(ColorNum : word; Color : shortint); @
procedure GetPalette(var Palette : PaletteType); @
function  GetMaxColor : word; @
function  ImageSize(x1, y1, x2, y2 : integer) : word; @
procedure GetImage(x1, y1, x2, y2 : integer; var BitMap); @
procedure PutImage(X, Y : integer; var BitMap; BitBlt : word); @
procedure GetTextSettings(var TextInfo : TextSettingsType); @
procedure OutText(TextString : string); @
procedure OutTextXY(X, Y : integer; TextString : string); @
procedure SetTextJustify(Horiz, Vert : word); @
procedure SetTextStyle(Font, Direction : word; CharSize : word); @
procedure SetUserCharSize(MultX, DivX, MultY, DivY : word); @
function  TextHeight(TextString : string) : word; @
function  TextWidth(TextString : string) : word;  @

implementation
end.
