unit Dos;

interface

const
  FCarry     = $0001;
  FParity    = $0004;
  FAuxiliary = $0010;
  FZero      = $0040;
  FSign      = $0080;
  FOverflow  = $0800;

  fmClosed = $D7B0;
  fmInput  = $D7B1;
  fmOutput = $D7B2;
  fmInOut  = $D7B3;

  ReadOnly  = $01;
  Hidden    = $02;
  SysFile   = $04;
  VolumeID  = $08;
  Directory = $10;
  Archive   = $20;
  AnyFile   = $3F;

type
  Registers = record
                case Integer of
                  0: (AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags: Word);
                  1: (AL,AH,BL,BH,CL,CH,DL,DH: Byte);
              end;

  FileRec = record
              Handle: Word;
              Mode: Word;
              RecSize: Word;
              Private: array[1..26] of Byte;
              UserData: array[1..16] of Byte;
              Name: array[0..79] of Char;
            end;

  TextBuf = array[0..127] of Char;
  TextRec = record
              Handle: Word;
              Mode: Word;
              BufSize: Word;
              Private: Word;
              BufPos: Word;
              BufEnd: Word;
              BufPtr: ^TextBuf;
              OpenFunc: Pointer;
              InOutFunc: Pointer;
              FlushFunc: Pointer;
              CloseFunc: Pointer;
              UserData: array[1..16] of Byte;
              Name: array[0..79] of Char;
              Buffer: TextBuf;
            end;

  SearchRec = record
                Fill: array[1..21] of Byte;
                Attr: Byte;
                Time: Longint;
                Size: Longint;
                Name: string[12];
              end;

  DateTime = record
               Year,Month,Day,Hour,Min,Sec: Word;
             end;

var
  DosError: Integer;

procedure Intr(IntNo: Byte; var Regs: Registers);       @
procedure MsDos(var Regs: Registers);                   @
procedure GetDate(var Year,Month,Day,DayOfWeek: Word);  @
procedure SetDate(Year,Month,Day: Word);                @
procedure GetTime(var Hour,Minute,Second,Sec100: Word); @
procedure SetTime(Hour,Minute,Second,Sec100: Word);     @
function DiskFree(Drive: Byte): Longint;                @
function DiskSize(Drive: Byte): Longint;                @
procedure GetFAttr(var F; var Attr: Word);              @
procedure SetFAttr(var F; Attr: Word);                  @
procedure GetFTime(var F; var Time: Longint);           @
procedure SetFTime(var F; Time: Longint);               @
procedure FindFirst(Path: String; Attr: Word; var F: SearchRec); @
procedure FindNext(var F: SearchRec);                   @
procedure UnpackTime(P: Longint; var T: DateTime);      @
procedure PackTime(var T: DateTime; var P: Longint);    @
procedure GetIntVec(IntNo: Byte; var Vector: Pointer);  @
procedure SetIntVec(IntNo: Byte; Vector: Pointer);      @
procedure Keep(ExitCode: Word);                         @
procedure Exec(Path,CmdLine: String);                   @
function DosExitCode: Word;                             @

implementation

end.
