/*   crtdos.c <-- crtdos.pc1  (REORDER  1.0.2)  */
/*   crtdos.pc1 <-- crtdos.pas  (PCPC 1.0) */
#include "convpac.h"


typedef struct _gRegisters {
    Word Ax;
    Word Bx;
    Word Cx;
    Word Dx;
    Word Bp;
    Word Si;
    Word Di;
    Word Ds;
    Word Es;
    Word Flags;
  } Registers;
void Intr(Byte Nb,Registers *Regs)
;
void MsDos(Registers *Regs)
;
typedef enum {BW40=0} _nBW40;
typedef enum {CO40=1} _nCO40;
typedef enum {BW80=2} _nBW80;
typedef enum {CO80=3} _nCO80;
typedef enum {Mono=7} _nMono;
typedef enum {Font8x8=256} _nFont8x8;
typedef enum {C40=1} _nC40;
typedef enum {C80=3} _nC80;
typedef enum {Black=0} _nBlack;
typedef enum {Blue=1} _nBlue;
typedef enum {Green=2} _nGreen;
typedef enum {Cyan=3} _nCyan;
typedef enum {Red=4} _nRed;
typedef enum {Magenta=5} _nMagenta;
typedef enum {Brown=6} _nBrown;
typedef enum {LightGray=7} _nLightGray;
typedef enum {DarkGray=8} _nDarkGray;
typedef enum {LightBlue=9} _nLightBlue;
typedef enum {LightGreen=10} _nLightGreen;
typedef enum {LightCyan=11} _nLightCyan;
typedef enum {LightRed=12} _nLightRed;
typedef enum {LightMagenta=13} _nLightMagenta;
typedef enum {Yellow=14} _nYellow;
typedef enum {White=15} _nWhite;
typedef enum {Blink=128} _nBlink;
Boolean CheckBreak;
Boolean CheckEOf;
Boolean DirectVideo;
Boolean CheckSnow;
Word LastMode;
Byte TextAttr;
Word WindMin;
Word WindMax;
Pointer SaveInt1b;
void AssignCrt(Text *F)
;
Boolean KeyPressed(void)
;
Char ReadKey(void)
;
void TextMode(Word Mode)
;
void Window(Byte X1,Byte Y1,Byte X2,Byte Y2)
;
void GotoXy(Byte X,Byte Y)
;
Byte Wherex(void)
;
Byte Wherey(void)
;
void ClrScr(void)
;
void ClrEol(void)
;
void InsLine(void)
;
void DelLine(void)
;
void TextColor(Byte Color)
;
void TextBackground(Byte Color)
;
void LowVideo(void)
;
void HighVideo(void)
;
void NormVideo(void)
;
void Delay(Word Ms)
;
void Sound(Word Hz)
;
void NoSound(void)
;
void _wN(void)
;
void _wR(String S)
;
void _wC(Char C)
;
void _wK(Char C,Integer Fmt)
;
void _wS(String S,Integer Fmt)
;
void _wI(Longint I,Integer Fmt)
;
void _wF(Real R,Integer F1,Integer F2)
;
void _rN(void)
;
void _rC(Char *C)
;
void _rS(String S)
;
void _rI(Longint *I)
;
void _rF(Real *R)
;


#include <dos.h>
#define Intr(x,y) intr(x,(struct REGPACK *)y)


void MsDos(Registers *Regs)
{
  Intr(33, (Regs));
}

static Registers Regs;
static Byte Minx,Miny,Maxx,Maxy,Posx,Posy;
static Byte ScanCode;
static String RdBuffer;
void Window(Byte X1,Byte Y1,Byte X2,Byte Y2)
{
  Boolean Err;
  Err = (X1 < 1) || (X1 > 80) || (X2 < 1) || (X2 > 80) || (X2 < X1
  ) || (Y1 < 1) || (Y1 > 25) || (Y2 < 1) || (Y2 > 25) || (Y2 < Y1
  );
  if(!Err) {
    Minx = X1;
    Miny = Y1;
    Maxx = X2;
    Maxy = Y2;
    WindMin = (X1-1)+((Y1-1) << 8);
    WindMax = (X2-1)+((Y2-1) << 8);
  }
}

void TextColor(Byte Color)
{
  if(Color > 15) Color = (Color & 15) | 128;
  TextAttr = (TextAttr & 112) | Color;
}

void TextBackground(Byte Color)
{
  Color = Color & 7;
  TextAttr = (TextAttr & 143) | (Color << 4);
}

void LowVideo(void)
{
  TextAttr = (short)LightGray;
}

void HighVideo(void)
{
  TextAttr = (short)White;
}

void NormVideo(void)
{
  TextAttr = (short)LightGreen;
}

void GotoXy(Byte X,Byte Y)
{
  Byte Px,Py;
  Boolean Err;
  Px = Minx+X-1;
  Py = Miny+Y-1;
  Err = (Px > Maxx) || (Py > Maxy) || (Px < Minx) || (Py < Miny
  );
  if(!Err) {
    {
      Regs.Ax = 512;
      Regs.Bx = 0;
      Regs.Dx = WindMin+(X-1)+((Y-1) << 8);
    }
    Intr(16, &Regs);
    Posx = Px;
    Posy = Py;
  }
}

Byte Wherex(void)
{
  Byte _gWherex;
  _gWherex = Posx-Minx+1;
  return _gWherex;
}

Byte Wherey(void)
{
  Byte _gWherey;
  _gWherey = Posy-Miny+1;
  return _gWherey;
}

void ClrScr(void)
{
  Word N;
  GotoXy(1, 1);
  N = ((Word)((WindMax-WindMin))>> 8)+1;
  {
    Regs.Ax = 1536+N;
    Regs.Bx = TextAttr << 8;
    Regs.Cx = WindMin;
    Regs.Dx = WindMax;
  }
  Intr(16, &Regs);
}

void ClrEol(void)
{
  {
    Regs.Cx = Maxx-Posx+1;
    Regs.Bx = TextAttr;
    Regs.Ax = 2304;
    Intr(16, &Regs);
  }
}

void InsLine(void)
{
  {
    Regs.Cx = WindMin+((Posy-Miny) << 8);
    Regs.Dx = WindMax;
    Regs.Bx = TextAttr << 8;
    Regs.Ax = 1793;
    Intr(16, &Regs);
  }
}

void DelLine(void)
{
  {
    Regs.Cx = WindMin+((Posy-Miny) << 8);
    Regs.Dx = WindMax;
    Regs.Bx = TextAttr << 8;
    Regs.Ax = 1537;
    Intr(16, &Regs);
  }
}

static void ScrolLine(void)
{
  {
    Regs.Cx = WindMin;
    Regs.Dx = WindMin+((Posy-Miny) << 8)+(Maxx-Minx);
    Regs.Bx = TextAttr << 8;
    Regs.Ax = 1537;
    Intr(16, &Regs);
  }
}

void TextMode(Word Mode)
{
  Regs.Ax = Mode & 255;
  Intr(16, &Regs);
}

Boolean KeyPressed(void)
{
  Boolean _gKeyPressed;
  if(ScanCode > 0) _gKeyPressed = TRUE;
  else {
    Regs.Ax = 256;
    Intr(22, &Regs);
    _gKeyPressed = (Regs.Flags & 64) == 0;
  }
  return _gKeyPressed;
}

Char ReadKey(void)
{
  Byte K;
  Char _gReadKey;
  if(ScanCode > 0) {
    _gReadKey = Chr(ScanCode);
    ScanCode = 0;
  }
  else {
    Regs.Ax = 0;
    Intr(22, &Regs);
    K = (Regs.Ax & 255);
    if(K == 0) ScanCode = ((Word)(Regs.Ax)>> 8);
    _gReadKey = Chr(K);
  }
  return _gReadKey;
}

static void Beep(void)
{
  Regs.Ax = 3591;
  Regs.Bx = 0;
  Intr(16, &Regs);
}

void _wC(Char C)
{
  Byte Wx,Wy;
  Wx = Posx-Minx+1;
  Wy = Posy-Miny+1;
  if(C == '\007') Beep();
  else if(C == '\015') {
    GotoXy(1, Wy);
  }
  else if(C == '\012') {
    if(Posy < Maxy) GotoXy(Wx, (Wy+1));
    else ScrolLine();
  }
  else if(C == '\010') {
    if(Posx > Minx) GotoXy((Wx-1), Wy);
    {
      Regs.Ax = 2304+Ord(' ');
      Regs.Bx = TextAttr;
      Regs.Cx = 1;
      Intr(16, &Regs);
    }
  }
  else if(Lo(C)>Lo('\000')) {
    {
      Regs.Ax = 2304+Ord(C);
      Regs.Bx = TextAttr;
      Regs.Cx = 1;
      Intr(16, &Regs);
    }
    if(Posx < Maxx) GotoXy((Wx+1), Wy);
    else if(Posy < Maxy) GotoXy(1, (Wy+1));
    else {
      GotoXy(1, Wy);
      ScrolLine();
    }
  }
}

void _wN(void)
{
  _wC('\015');
  _wC('\012');
}

void _wR(String S)
{
  Integer K;
  String _gS;
  _mY(_gS,S);
  for(K= 1;K<= Length(_gS);K++) _wC(_gS[K-1]);
}

void _wS(String S,Integer Fmt)
{
  Integer K;
  String _gS;
  _mY(_gS,S);
  for(K= 1;K<= Fmt-Length(_gS);K++) _wC(' ');
  _wR(_gS);
}

void _wK(Char C,Integer Fmt)
{
  Integer K;
  for(K= 1;K<= Fmt-1;K++) _wC(' ');
  _wC(C);
}

void _wI(Longint I,Integer Fmt)
{
  String S;
  sprintf(S,"%*ld",Fmt,I);
  _wR(S);
}

void _wF(Real R,Integer F1,Integer F2)
{
  String S;
  sprintf(S,"%*.*f",F1,F2,R);
  _wR(S);
}

void _rS(String S)
{
  Char C;
  Boolean Stop,Echo;
  Integer I;
  String _s1;
  _sM(S,"",255);
  Stop = FALSE;
  do {
    Echo = (ScanCode == 0);
    C = ReadKey();
    if(Echo) {
      if((C == '\033') || (C == '\001')) {
        for(I= 1;I<= Length(S);I++) _wC('\010');
        _sM(S,"",255);
      }
      else if(C == '\004') {
        I = Length(S)+1;
        if(I <= Length(RdBuffer)) {
          C = RdBuffer[I-1];
          _sM(S,(_sI(_s1,S),_sC(_s1,C)),255);
          _wC(C);
        }
      }
      else if(C == '\006') {
        I = Length(S)+1;
        while(I <= Length(RdBuffer)) {
          C = RdBuffer[I-1];
          _sM(S,(_sI(_s1,S),_sC(_s1,C)),255);
          _wC(C);
          I = I+1;
        }
      }
      else {
        if(C == '\032') {
          C = '\015';
          if(CheckEOf) _sM(S,(_sI(_s1,S),_sC(_s1,C)),255);
        }
        Stop = (C == '\015');
        if(!Stop) {
          if((C == '\023') || (C == '\177') || (C == '\010')) {
            Delete(S, Length(S), 1);
            _wC('\010');
          }
          else if((Lo(C)>=Lo(' '))) {
            _sM(S,(_sI(_s1,S),_sC(_s1,C)),255);
            I = Length(S);
            if(I > Length(RdBuffer)) _sM(RdBuffer,S,255);
            else RdBuffer[I-1] = C;
            _wC(C);
          }
        }
      }
    }
  } while(!(Stop));
  _wC('\015');
  _wC('\012');
  _sM(RdBuffer,S,255);
}

void _rN(void)
{
  String S;
  _rS(S);
}

void _rC(Char *C)
{
  String S;
  _rS(S);
  *C = S[Length(S)-1];
}

void _rI(Longint *I)
{
  String S;
  Integer Err;
  do {
    _rS(S);
    VAl(S, (I), &Err);
    if(Err != 0) Beep();
  } while(!(Err == 0));
}

void _rF(Real *R)
{
  String S;
  Integer Err;
  do {
    _rS(S);
    VaL(S, (R), &Err);
    if(Err != 0) Beep();
  } while(!(Err == 0));
}

void Delay(Word Ms)
{
  ;
}

void Sound(Word Hz)
{
  Beep();
}

void NoSound(void)
{
  ;
}

void AssignCrt(Text *F)
{
  ;
}


void _gCrt(void) {
  CheckEOf = FALSE;
  _sM(RdBuffer,"",255);
  ScanCode = 0;
  Window(1, 1, 80, 25);
  LowVideo();
  {
    Regs.Ax = 0;
    Regs.Bx = 0;
    Regs.Cx = 0;
    Regs.Dx = 0;
  }
  GotoXy(1, 25);
}

void _gDos(void) {}


