{
  CBULK.PAS   (c) Copyright 1991  by Georg Post

 -  code generator for PCPC: translator from Turbo Pascal to K&R C
 -  Only stdio.h, stdlib.h and math.h are included via "convpac.h"
 -  library: convpac.c (and crtdos.c), to be linked with all the rest .

  BUGS:
     - bogus "errors" if identifiers of System unit are re-defined
     - very complicated nested types aren't supported
     - integer constants make #define --> risk of scope errors.
     - Nested procedure/function: aux parameter passing defects for recursion?
     - semilocal Const and Type aren't de-embedded
     - qualified identifiers ignored
     - array bounds with const Id: only upper bound symbolic
     - type A=record B:^A; C:^A end ;  --> C gets WRONG p chaining
     - type D=^A; A=record B,C: D end; --> works fine !
     - local copies for array,record Value parameters: made even if not used !
     - convoluted translation of string and set expression !
     - the sizeof in Compare operations applies to Expressions: inefficient ?

Unit Coding:

    No "*.h" files made. Interface parts of Used units are re-translated and
    become the "import part" of the current file.
    Global Var declarations and Typed Constants get prefixes:
      "static" in implemPart, "extern" in importPart ( imported declarations)
    Global non-interface proc/funct get prefix "static"  in implemPart.
    Local proc/funct always get prefix "static".

Reserved identifiers for Convpac library functions:

Set operators:
 _eI _eU _eD  -> intersection union difference
 _eV _eC      -> voidSet constructSet
 _eE _eR      -> addElement addRange (to a set)

String operators:
  _sK _sI  -> kharInit  Init
  _sA _sM  -> Arraycopy  stringMove (with cutoff)
  _sC _sS  -> CharAdd  StringAdd (concatenation)

Console operations if usesCrt=True  (calls IBM PC BIOS!)
  _rN _wN     -> read/write Newline,
  _rC _wC _wK -> read/write 1 char,
  _rS _wS     -> read/write a string,    default fmt <=0
  _rI _wI     -> read/write a (long) integer, def.fmt<=0
  _rF _wF     -> read/write a (double) float, def.decimals -1
}

unit cBulk;  { compiler: Turbo Pascal 4.0 }
{$S+,R+}

interface

uses pcpcdata, { global data }
     pascannr, { the source code scanner }
     semanti6, { needs: bitset, machineInfo.bs, semanticAction}
     cDeclara, { output formatter & declaration parts}
     cNesting; { untangles procedure nesting}

var  importPart: boolean; {TRUE while handling "interface" part of a Unit}

procedure initCbulk( path,Cfile,srcName,ref: str40);
procedure CheaderEnd;
procedure CunitEnd(i:integer);
procedure termCbulk;
procedure compilerAction(choice: char; var stat:scanStatus);

implementation

const
  maxWith=10; {max. number of simultaneous active With records}
  maxRdWr=30; {max. length of Read/Write lists}
  maxUnit=30; {max. number of used units (direct and indirect) }

var
    withItem: array[1..maxWith] of str80;  withIx: integer;
    withMarker,  {0: secondary, 1: primary record}
    withRecord: array[0..maxWith] of integer; {record serial numbers}
    exitCall: array[1..maxNest] of boolean;  {flag use of TP's Exit--> goto..}

    formOne,formTwo: boolean; {formatting system}
    fmt01,fmt02: array[1..maxRdWr] of boolean; {stack copies of formOne/Two}
    IOtype: array[0..maxRdWr] of ptpel;  {type of IO list entries}
    IOcount: integer; {current length of  Rd/Wr IO lists}
    constA,constB: longInt; {the last constant pair in statementPart}
    intvType:ptpel;  {if <>Nil, a Case interval is pending}
    usesCrt,         {if True, produce special console IO calls}
    console: boolean; {IO goes to stdio yes/no ? }
    units: array[0..maxUnit] of symbol; {at 0, own name. Suppose eightchr.PAS }
    nUnit: integer;


procedure initCbulk( path,Cfile,srcName,ref: str40);
{ ACTION: open the output file. Initialise globals. Init Cdeclara,Cnesting
  CALLER: Pcpc.translate, once per PC1 file.
}
var i:integer;
begin
  assign (listing, path+Cfile);
  rewrite(listing);
  writeln(listing,'/*   ',Cfile,' <-- ',srcName,'  (',ref,') */');
  writeln(listing,'#include "convpac.h"'); writeln(listing);
  writeln(listing,'#if 0'); writeln(listing);
  initCdeclara;
  initNesting;
  for i:=1 to maxNest do exitCall[i]:=false;
  withIx:=0; withRecord[0]:=0;
  IOcount:=0;
  console:=true; usesCrt:=false;
  nUnit:=0;
end;

procedure  CheaderEnd;
{ ACTION: end of header part in output file
  CALLER: Pcpc.translate
}
begin writeln(listing); writeln(listing,'#endif'); writeln(listing);
end;

procedure termCbulk;
{ ACTION: end of output file
  CALLER: Pcpc.translate
}
begin writeln(listing); close(listing);
  termNesting; {heap cleanup}
end;

{--------------------------------------------------------------}

procedure insertUnit(i:integer; var nam: symbol; var isNew:boolean);
{ ACTION: add unit "nam" to units[]  before position i, if it DOESNT exist.
          if i>nUnit, simply add to end, else insert.
  CALLER: compilerAction_useUnit
  OUTPUT: isNew if "nam" was unknown up to now.
}
var k: integer;
    test:array[1..4] of char;
begin isNew:=true;
  for k:=1 to 4 do test[k]:=nam[k];
  if test[4]<' ' then test[4]:=' ';
  if test='Crt ' then usesCrt:=true; {switch code generator to BIOS calls}
  for k:=1 to nUnit do isNew:=isNew and (nam<>units[k]);
  if isNew then begin
    for k:=nUnit downto i do units[k+1]:=units[k];
    nUnit:=nUnit+1;
    if i>nUnit then i:=nUnit;
    units[i]:=nam;
  end;
end;

{ cf GETUNITS imported by PCPC: a recursive algorithm to get the whole tree of
  units indirectly used by the main program, in some kind of depth-first order.
}

procedure callUnitCode(var nam:symbol);
{ ACTION: make code to call the unit's init procedures in main()
  CALLER: mainProgram
  INPUT : "nam" = the name of the unit
}
var s:str80;  k:integer; c:char;
begin
  s:='  '+auxPrefix;
  for k:=1 to lenIde do begin c:=nam[k];
    if c>' ' then s:=s+c;
  end;
  outC( s + '();`' );
end;

procedure mainProgram;
{ ACTION: make main(): first do global copies of "argc,argv", then call
          all unit init functions from 1 to nUnit, then itself = units[0]
  CALLER: compilerAction_mainPrgr
}
var i:integer;
begin
  outC('`int main(int paramcount, char * paramstr[]) {`');
  outC('  { int i; for(i=0;i<paramcount;i++) _paramstr[i]=paramstr[i]; }`');
  outC('  _paramcount=paramcount-1;`'); {globalize the cmd line arguments}
  for i:=1 to nUnit do callUnitCode(units[i]);
  callUnitCode(units[0]);
  outC('  return 0;`}`');
end;

procedure CunitEnd(i:integer);
{ ACTION: end of imported interface part: declare the unit's init function
          PCPC does NOT create a  *.h file for each imported unit
  CALLER: Pcpc.translate
  INPUT : i is never used ???
}
var s:str80;  k:integer; c:char;
begin
  s:='`extern void  '+auxPrefix;   {typical name is : _gMyUnit }
  for k:=1 to lenIde do begin c:=units[0,k];
    if c>' ' then s:=s+c;
  end;
  outC( s + '(void);`' );
  outC('/*----------------------------*/``');
end;

procedure toWithStack(mark: integer);
{ ACTION: transfer last item from expression stack to the WITH stack
          To keep record prefixes, and also loop variables, for later.
  CALLER: compilerAction _forDef _withFirst _withNext
  INPUT : mark= 1:first With item, 0:later item, 2:For loop variable
}
begin withIx:=succ(withIx);  withMarker[withIx]:=mark; {0 or 1 }
  with withStack do begin {copy serial nb for cases 0,1 }
    if mark<2 then withRecord[withIx]:=snb[wsp] else withRecord[withIx]:=0;
  end;
  withItem[withIx]:=expStack[lastExp];
  lastExp:=pred(lastExp); {pop from expression stack }
end;

procedure setConst(var s:bitSet);
{ ACTION: output a Set = array constant in C , 113 letters of hex codes
  CALLER: compilerAction_setcoTerm
}
var i,p,q,k: word; c:char;
    aux:string[5];
    st:str255;
begin
  for i:=0 to 15 do begin
    p:=s[i]; aux:='';
    for k:=1 to 4 do begin
      q:=p and 15;
      if q<10 then c:=chr(q+ord('0')) else c:=chr(q-10+ord('a'));
      aux:=c+aux;
      p:=p shr 4;
    end;
    if i=0 then st:='{0x'+aux else st:=st+',0x'+aux;
  end;
  st:=st+'}';
  outC(st);
end;

procedure numberString;
{ ACTION: code  formatted integer/real -> string conversion (Pascal: Str())
  CALLER: compilerAction_numToStr
  INPUT : If global FormOne=true, expr. stack has Format on top, Data beneath
}
var fmt:str20; dix: integer; tpc:char;
begin
  outC('sprintf(');
  outCexp(1); {destination string, reverse the Pascal order !}
  if formOne then dix:=lastExp-1 else dix:=lastExp; {the data index}
  tpc:=expTypes[dix]^.cl;             {the number's type and class}
  if (tpc='d')or(tpc='r') then  fmt:='f' {double,real}
  else if tpc='l' then fmt:='ld' {longint}
  else if tpc='w' then fmt:='u'  {word}
  else fmt:='d';  {all the rest}
  if formTwo then fmt:='*.*'+fmt
  else if formOne then fmt:='*'+fmt;
  outC(',"%'+fmt+'",');
  if formOne then begin
    outCexp(1); {pop off the format list }  outC(',');
  end;
  outCexp(1); {pop off the data}
  outC(')');
  formOne:=false; formTwo:=false;
end;

{----------  array handling ------------}

procedure arraySize(var s:str40; pt:ptpel);
{ ACTION: make code for size of an array of bytes
  CALLER: compare, codeAssign
  INPUT : pt points to the array, set or string type
  OUTPUT: s = expression sizeof(name) or integer const
          if type name is of level y>2, put _t (cf. Cdeclara.getTypeName)
}
var px:ptpel; pid:pide; i:longint;  t:str20;
begin
  pid:=pt^.tname;
  if pid<>Nil then begin {named object}
    getIdent(pid,t);
    if pid^.y>2 then t:='_t'+t; {local type made global}
    s:='sizeof('+t+')';
  end else if pt^.cl='e' then begin {Set}
    s:='sizeof(Set)';
  end else if pt^.cl='s' then begin {string type}
    str(pt^.l, s);
  end else begin  {support Enum or Subrange, Bug for Boolean,Byte,Char...?}
    px:=pt^.p;
    if px^.cl='E' then i:=px^.l+1
    else {if px^.cl='S' then} i:=px^.m-px^.l+1;
    str(i, s);
  end;
end;

procedure getArrayIndex;
{ ACTION: transform top of expr. stack into an array index
          normalize to 1st index = 0, trap the popular PascalString[0] trick
  CALLER: compilerAction_arrayAddr
}
var ix,off: longint; err: integer;  pt,px:ptpel; suff:str80;
begin
  pt:=expTypes[lastExp-1]; {string or array}
  if pt^.cl='s' then off:=1 else begin
    px:=pt^.p; {suppose: index type is Subrange or: Enum,Boolean,Byte,Char}
    if px^.cl<>'S' then off:=0 else off:=px^.l; {array offset for Subrange}
  end;
  val(expStack[lastExp], ix, err); {error check if constant index}
  if (err=0) and (ix<off) then error('Negative array index.');
  if off>0 then begin str(off,suff); suff:='-'+suff+']' end
  else suff:=']';
  binaryOp('','[',suff,0); {Bug: MUST typecast ? }
  expTypes[lastExp]:=pt^.q; {follow subarray chain ! }
end;

{---------  formatted IO ------------}

procedure outField(s:str20);
{ ACTION: quick-and-dirty version of Cdeclara.pointerOp
  CALLER: printIOlist, scanIOlist: for File identifiers only
}
var r:str255;
begin
  r:=expStack[lastExp];
  if r[1]='*' then begin delete(r,1,1); r:=r+'->'+s end else r:=r+'.'+s;
  outC(r); lastExp:=lastExp-1;
end;

procedure extendOutList (tp:ptpel; f1,f2:boolean);
{ ACTION: extend the output list in BigBuff by 1 formatted item of type tp
  CALLER: compilerAction_wrFmt
  INPUT : f1,f2 are format flags: If f1, format data on top of expr. stack
}
var tcl,typ:char; s2:str80; s1:str40;
begin
  if (not console) and (IOtype[0]^.cl='F') then begin
    outC('Write(');    {assume record var on TOS, file var on TOS-1 }
    lastExp:=lastExp-1; outField('s,'); lastExp:=lastExp+2; {kludge}
    outCexp(1); outC(');`');
  end else if (usesCrt and console) then begin
    if IOcount=0 then outC('{');
    tcl:=tp^.cl;
    if tcl='c' then begin
      if f1 then typ:='K' else typ:='C'   {formatted/ unformatted char}
    end else if (tcl='s')or(tcl='Y') then typ:='S'  {string, array of char}
    else if (tcl='r')or(tcl='d') then typ:='F' {float}
    else typ:='I'; {integer}
    if f1 then begin
      if (typ='F') and (not f2) then s2:=',-1' else s2:='';
      binaryOp('',',',s2,0);
    end else begin
      if typ='F' then s2:=',17,-1'
      else if tcl='Y' then begin {need sizeof}
        arraySize(s1,tp); s2:=','+s1;
      end else if typ<>'C' then s2:=',0'
      else s2:='';
      unaryOp('',s2,0,0);
    end;
    outC('_w'+typ+'(');
    if tcl='w' then outC('(long)'); {type cast unsigned --> long}
    outCexp(1); outC(');`');
  end else begin
    if BBix>0 then putBigBuff(', ');
    if f1 then begin bufferExp; putBigBuff(','); end;
    bufferExp;  {pop off the IO data expression AFTER the format! }
  end;
  IOcount:=succ(IOcount); IOtype[IOcount]:=tp;
  fmt01[IOcount]:=f1; fmt02[IOcount]:=f2;
end;

procedure extendInList (tp:ptpel);
{ ACTION: add item tp to BigBuff = input list: must "pointerize" for scanf
  CALLER: compilerAction_rdVar
}
var tcl,typ: char;
begin
  if (not console) and (IOtype[0]^.cl='F') then begin
    outC('Read(');
    lastExp:=lastExp-1; outField('s,'); lastExp:=lastExp+2;
    outCexp(1); outC(');`');
  end else if (usesCrt and console) then begin
    tcl:=tp^.cl;
    if tcl='c' then typ:='C'   {char}
    else if tcl='s' then typ:='S'  {string}
    else if (tcl='r')or(tcl='d') then typ:='F' {float}
    else typ:='I'; {integer}
    if typ<>'S' then unaryOp('&','',1,1);
    outC('_r'+typ+'('); outCexp(1); outC(');`');
  end else begin
    if BBix>0 then putBigBuff(', ');
    if tp^.cl<>'s' then unaryOp('&','',1,1); {string IS its own pointer}
    bufferExp; {top of expression stack goes to buffer}
  end;
  IOcount:=succ(IOcount); IOtype[IOcount]:=tp;
end;

procedure printIOlist(newLine:boolean);
{ ACTION: translate Pascal write(ln) as  (f)printf, using BigBuff,IOtype[]
  CALLER: compilerAction _doWrite _doWriLn
  INPUT : newLine=True if source code had writeLn
}
var i,k:integer; tp:char; f1,f2:boolean;
    fmt:str20; pix:ptpel;
begin
  if (not console) and (IOtype[0]^.cl='F') then begin
    {nothing, nontext file}
  end else if (usesCrt and console) then begin
    if newLine then outC('_wN();');
    if IOcount>0 then outC('}');
    outC('`');
  end else if IOcount=0 then begin {issue a writeln}
    outC('Writeln(');
    if console then outC('stdout)') else begin
      outField {file Id} ('s)');
    end;
  end else if (IOcount=1)and (IOtype[1]^.cl='c') then begin {1 character}
    if not newline then begin
      if console then outC('putchar(') else outC('putc(');
      BigBuffToC(1);
      if not console then begin outC(','); outField('s') end;
    end else begin {newline}
      if console then outC('printf("') else begin
        outC('fprintf('); outField('s, "');
      end;
      outC('%c\n",'); BigBuffToC(1);
    end;
    outC(')');
  end else begin
    if console then outC('printf("') else begin
      outC('fprintf('); outField('s, "');
    end;
    for i:=1 to IOcount do begin
      tp:=IOtype[i]^.cl; f1:=fmt01[i]; f2:=fmt02[i];
      if (tp='r')or(tp='d') then fmt:='f'
      else if (tp='c')or(tp='s') then fmt:=tp {char, string }
      else if (tp='l') then fmt:='ld'
      else if (tp='w') then fmt:='u'
      else if (tp='Y') then begin {array of char, %.nns format}
        pix:=IOtype[i]^.p; {index type}
        str(pix^.m-pix^.l+1, fmt);
        fmt:='.'+fmt+'s';
      end else fmt:='d'; {integer, all the rest}
      if f2 then outC('%*.*')
      else if f1 then outC('%*') else begin
        if fmt='f' then outC('%12') else outC('%');
      end;
      outC(fmt);
    end;
    if newLine then outC('\n'); outC('", ');
    BigBuffToC(1); outC(')');
  end;
  IOcount:=0; console:=true;
end;

procedure scanIOlist(newLine:boolean);
{ ACTION: does its best to mimic Pascal READ(LN if newLine)
  CALLER: compilerAction _doRead _doRdLn
  INPUT : using Globals: console,BigBuff,IOcount,IOtype[]
}
var i:integer; class:char;
    format:str80;
begin
(*  if IOcount=0 then begin {issue a readln}
    outC('Readln(');
    if console then outC('stdin)') else begin
      outField {file Id} ('s)');
    end;
  end else
*)
  if (not console) and (IOtype[0]^.cl='F') then begin
    {nothing, nontext file}
  end else if (usesCrt and console) then begin
    if newLine and (IOcount=0) then outC('_rN()');
  end else if (IOcount=1)and (IOtype[1]^.cl='c') and (not newLine) then begin
    {one-character read is unformatted, thus faster}
    BigBuffToC(2);  {from position 2: skip the leading & ! }
    if console then outC('= (char)getchar()') else begin
      outC('= (char)getc('); outField('s)')
    end;
  end else begin
    if console then outC('scanf(') else begin
      outC('fscanf('); outField {file Id} ('s, ');
    end;
    if IOcount=0 then begin
      if console then format:=' "%*c%*[^\n]" ' else format:=' "%*c" ';
      outC( format+')'); {swallow 1 char anyway, Console up to Cr, else Lf ?}
    end else begin
      format:='"';
      for i:=1 to IOcount do begin
        class:=IOtype[i]^.cl;
        if (class='y')or(class='w')or(class='h') then class:='i';
        case class of
        {the leading blank swallows preceding Newline ! }
         'c': format:=format+' %c';
         's': format:=format+' %[^\n]'; {read to Newline, exclusive}
         'i': format:=format+' %hd'; {short}
         'l': format:=format+' %ld'; {long}
         'r': format:=format+' %lf'; {double float! }
        else{otherwise} format:=format+' %dBUG';
        end; {case}
      end;
      if newLine and (IOtype[IOcount]^.cl<>'s') then format:=format+'%*[^\n]';
      outC(format+'", ');
      BigBuffToC(1); outC(')'); {Bug: the & operators for c,i,l,r ! }
    end;
  end;
  IOcount:=0; console:=true;
end;

{-------  compares and copies ------------}

procedure compare(how: char; pwhat,ptoWhat:ptpel);
{ ACTION: code for compare operations, including string,set,array,record
          enum  -->  short (I use "enum" for values -32767..32767 only) !
  CALLER:  compilerAction_equal, and following
  INPUT :  how=the operator EULGlg ,
           type element  pwhat=the 2nd, ptoWhat=the 1st operand
  Bugs: for array Parameters, wrong sizeof by macro expansions ?
        Since "unsigned short" is not K&R, revise Word order comparisons
          with a sign extension killer, like Lo() for Char ?
        the comparison following a "for" should call this, too.
}
var s1,s2,s3,s4: str80;   s:str40;
    pt: ptpel;
    what,towhat:char;
begin
  what:=pwhat^.cl; toWhat:=pToWhat^.cl;
  if (what='c')and(toWhat='s') then begin { compare(String,Char)}
    pushAuxString; { convert TOS (a char expression) to string }
    binaryOp('_sL(',',',')', 0);
    what:='s';
  end;
  if what in ['P','S','E','b','c','y','i','w','l','r','d','p','h']
  then begin {numeric, pointer, or finite type}
    if what='c' then begin {transform signed chars with Lo() for ordering }
      s1:='Lo('; s2:=')'; s3:='Lo('; s4:=')';
    end else if what='E' then begin {typecast genuine Enum types before cmp}
      s1:='(short)('; s2:=')'; s3:='(short)('; s4:=')';
    end else begin
      s1:=''; s2:=' ';s3:=' '; s4:='';
    end;
    case how of
    'E':  binaryOp('',' == ','',6);
    'U':  binaryOp('',' != ','',6);
    'L':  binaryOp(s1,s2+'<' +s3,s4,5);
    'G':  binaryOp(s1,s2+'>' +s3,s4,5);
    'l':  binaryOp(s1,s2+'<='+s3,s4,5);
    'g':  binaryOp(s1,s2+'>='+s3,s4,5);
    else{otherwise} end;
  end else begin   {composite types: arrays,sets, strings, records.}
    s1:='_cA'; s2:=','; s3:=')';
    if toWhat='s'      then s1:='_cS' { string compare, null-terminated}
    else if toWhat='e' then s1:='_cE' { bitset compare 16 Words}
    else if what='R'   then s1:='_cR' { better use _cF for named record?}
    else if (toWhat='Y') {or(toWhat='e')} then begin  { Array  }
      pt:=expTypes[lastExp-1]; {same as ptoWhat ? }
      arraySize(s,pt);
      s3:=','+s+')';
      if (pt^.cl='Y')and(pt^.q^.cl='c') then s1:='_cL'
        {lexical compare for character arrays }
      else {if toWhat='e' then} s1:='_cF';
        {hybrid compare, fixed number of bytes}
    end; {now _cA should never occur }
      {arrays,strings,sets: put no &. Records macro _cR will put & }
    s1:=s1+'('''+how+''',' ;
    binaryOp(s1,s2,s3 , 0);
  end;
end;

(*    do not yet use following strOptimize: overflow bugs!?

procedure substitute(var s:str255; var a,b: str20);
{ ACTION: substitute in S all occurrences of A by B
  CALLER: strOptimize
}
var t:str255; i,ls,la: integer;
begin ls:=length(s); la:=length(a);
  i:=1; t:='';
  while i<=ls do begin
    if copy(s,i,la)=a then begin
      t:=t+b; i:=i+la;
    end else begin
      t:=t+s[i]; i:=i+1;
    end;
  end;
  s:=t;
end;

procedure strOptimize(var ok: boolean);
{ ACTION: simplify a string concatenation expression
  CALLER: codeAssign
  INPUT : TOS: string expression (_sI(......._sC(...))
          TOS-1: string variable stv for assignment.
          If first arg is _sI(aux,stv) we may substitute all "aux" --> "stv"
  OUTPUT: ok if simplification was possible
}
const len=5;
var aux, stv: str20; b,d:str255;
    i,j,lb: integer;
begin
  b:=expStack[lastExp]; {the string expression }
  d:=copy(b,1,len);
  ok:= (d='(_sI(');
  if ok then begin
    i:=len+1; repeat i:=succ(i) until b[i]=',';  {skip over _s1 }
    aux:=copy(b,len+1,i-len-1); { the aux string variable}
    i:=i+1; j:=i; repeat j:=succ(j) until b[j]=')'; {walkto next ) }
    stv:=copy(b,i,j-i);   {copy may overflow in C version! }
    ok:=(stv=expStack[lastExp-1]); {stv is the assignment destination}
  end;
  if ok then begin
    {copy b from j+2 to end; all  aux  become  stv, BUG: outside quotes ! }
    j:=j+2;
    d:='('+copy(b,j,length(b));
    substitute(d, aux,stv);
    lastExp:=lastExp-1; expStack[lastExp]:=d;
  end;
end;

********)

procedure codeAssign(what:char; pRef:ptpel);
{ ACTION: code for assignment statements, including composite type memcopies
          strings,arrays,records,sets...
  CALLER: compilerAction_assignmt
  INPUT : what=type tag of the expression , pref= destination type reference
  Beware: if pRef is an Array Parameter, its sizeof under C is not that of
          the array but that of a pointer!
}
var s1,s2,s3: str80; s:str40;
    toWhat,rcl:char; {type tag of the variable}
    auxSuppress: boolean; {for s:=s+... expressions, no aux variable ! }
    ref:ptpel;
begin
  ref:=pref; rcl:=ref^.cl;
  if rcl='U' then begin ref:=ref^.p; rcl:=ref^.cl end; {function result}
  if (rcl='S')or(rcl='A')or(rcl='L') then ref:=ref^.p; {subr. or param.}
  toWhat:=ref^.cl;  {ref is destination type element after type reduction }
  s1:='('; s2:=','; s3:=')';
  auxSuppress:=false;
  if (toWhat='s') then begin {assign char,PAC or string to string}
    if what='c' then begin {assign Char to String}
      s1:='_sK(';
    end else if what='s' then begin
      s1:='_sM('; {size-limited string move}
      {arraySize(s, ref); is overkill here}
      str(ref^.l,s);  s3:=','+s+')';
      { buggy: strOptimize(auxSuppress); }
    end else if what='Y' then begin {array-to-string copy}
      s1:='_sA(';
      arraySize(s,expTypes[lastExp]);
      s3:= ','+s+')';
    end;
    if not auxSuppress then binaryOp(s1,s2,s3, 0);
  end else if what in ['P','S','E','b','c','y','i','w','l','r','d','p','h']
  then begin {numeric, pointer, or finite}
    binaryOp('',' = ','',13)
  end else begin
    if what='R' then s1:='_mR(' else begin {array,set}
      rcl:=pref^.cl; {type class of destination}
      if (rcl='A')or(rcl='L') then begin {parameter array, sizeof quirk in C!}
        s1:='_mA('; {move array}
        arraySize(s, ref);  s3:=','+s+')';
      end else begin
        s1:='_mY(';  { naive sizeof Ok for non-parameter arrays }
      end;
    end;
    binaryOp(s1,s2,s3, 0);
  end;
  outCexp(1);
end;

procedure stringCat(cl2:char);
{ ACTION: concatenate  char or string to expr stack
  CALLER: compilerAction_addit
  INPUT : TOS-1: is char, string or fragment (_sI(x),_sS(x,...),.(..))
          TOS  : is string or char (cl2= s/c ) or arrayOfChar (Y)
}
const len=5;
var cl1:char;  t:ptpel; a,b,c:str255;
    s:str40;
    fragment:boolean;  i,lx,lb: integer;
begin
  b:=expStack[lastExp-1]; {the first string }
  c:=copy(b,1,len);
  fragment:=(c='(_sK(') or (c='(_sI(');
  if not fragment then begin
    cl1:=expTypes[lastExp-1]^.cl; {may be s or c}
    pushAuxString; a:=expStack[lastExp]; lastExp:=lastExp-1;
    if cl1='c' then c:='(_sK(' else c:='(_sI(';
    expStack[lastExp-1]:=c+a+','+b+'))'; {init code Ok}
  end else begin
    i:=len+1; repeat i:=succ(i) until b[i]=',';
    a:=copy(b,len+1,i-len-1); {a is the aux variable}
  end;
   {now insert new element between the last "))" }
(*
  b:=expStack[lastExp-1]; {a valid fragment, add expStack[lastExp] ! }
  lb:=length(b); lx:=lb; repeat lx:=pred(lx) until b[lx]=','; lx:=lx+1;
  a:=copy(b,lx,lb-lx);   {the aux string identifier}
*)
  if cl2='c' then c:=',_sC('
  else if cl2='Y' then begin
    c:=',_sY(';
    arraySize(s,expTypes[lastExp]);
    unaryOp('',','+s,0,0);
  end else c:=',_sS(';
  c:=c+a+','+expStack[lastExp]+')';  {the new string to add }
  lastExp:=pred(lastExp);
  lx:=length(expStack[lastExp]);
  insert(c, expStack[lastExp], lx);
end;

procedure setCalc(typ:char);
{ ACTION: code for Set functions that create a new auxiliary (result) set
  CALLER: compilerAction _multi _addit _subtr
  INPUT : typ= I:Intersection U:Union D:Difference
}
var s:str80;
begin
  pushAuxSet; s:='_e'+typ+'('+expStack[lastExp]+',';
  lastExp:=lastExp-1;
  binaryOp(s, ',' , ')',0)
end;

procedure keepConst(k:longInt);  {2-item constant stack, for intervals}
begin constA:=constB; constB:=k end;

procedure caseLabel;
{ ACTION: output a Case label. Case intervals not fully supported! Bug!
  CALLER: compilerAction _caseFirst _caseNext
  INPUT : global intvType, not Nil if there is a label interval.
}
var tl:textLine;
    vs,vt,errs,errt,k: integer;
begin  {if it's an interval: make case List!}
  {If the 2 args are integer const, code can be made, else BUG }
  if intvType=Nil then begin {standard case}
    outC('@=case '); outCexp(1); outC(':');
  end else begin {case interval: 2 constants on stack}
    outC('@=case '+expStack[lastExp-1]+':');
    { s:=expStack[lastExp-1]; t:=expStack[lastExp]; }
    { val(s,vs,errs);  val(t,vt,errt); }
    vs:=constA; vt:=constB;
    if {(errs>0)or(errt>0)or } ((vt-vs)>15) then begin
      error('CASE too complicated');
    end else begin
      for k:=vs+1 to vt-1 do begin outC('@=case ');
        if intvType^.cl='c' then begin   {char between single quotes}
          tl[1]:=chr(k); outCstring(tl,1,1);
        end else outCi(k);
        outC(':')
      end;
    end;
    outC('@=case '+expStack[lastExp]+':');
    lastExp:=lastExp-2;
    intvType:=Nil; {flip-flop action}
  end;
end;

procedure blkBegin;
{ ACTION: enter the statement part of a procedure/function.
          For a non-string function, declare a scratchpad variable
          Code for local copies of composite value parameters
  CALLER: compilerAction _blockBegin _normUnit
}
var ident:pide;pt:ptpel; result:char;
begin
  ident:=procStack[lastProc]; pt:=ident^.typof;
  {the proc/func name}
  if blockLevel=1 then begin { Main or InitUnit procedure ! }
    outC('`/*(*/`void ');
    if ident^.class=unitId then begin
      outC(AuxPrefix); putIdent(ident);
      units[0]:=ident^.name; {our own unit name is here }
    end else outC('main');
    outC('(void) {');
    outC('@+`');
  end;
  statementPart:=true;
  if ident^.class=functId then begin {make dummy variable}
    result:=pt^.p^.cl; {result type string needs no aux var, is parameter}
    if result<>'s' then begin
      putTypeName(pt^.p); outC(auxPrefix);
      putIdent(ident); outC(';`');
    end;
  end;
  initAuxVar(blockLevel);
  outC('@1/*[*/`'); {re-ordering command}
  localCopies(ident);
end;

procedure blkEnd;
{ ACTION: end of a statement block. Put Exit label and function's Return.
          Declarations for local aux. variables with "Reorder" directives
  CALLER: compilerAction _blockEnd _normUnit
}
var ident:pide;pt:ptpel;
begin
  ident:=procStack[lastProc]; pt:=ident^.typof;
  {the proc/func name: Bug for main program ! }
  if exitCall[lastProc] then begin {label required}
    outC('@=Exit:;`');  exitCall[lastProc]:=false;
  end;
  if ident^.class=functId then begin {return dummy variable}
    outC('@=return '+auxPrefix); putIdent(ident); outC(';`');
  end;
  declareAuxVar(blockLevel);
  outC('@=/*]*/');
  lastProc:=pred(lastProc); {discard funct /proc name }
  outC('@-}`'); statementPart:=false;
    {put here the revised header if blockLevel>=3 ? }
  extendHeader(ident, scope.actual+1);
    {quirk here: semantic already decremented "actual" ! }
  blockLevel:=blockLevel-1;
end;

procedure forwFunction;
{ AVTION: terminate a proc/funct declaration that's Forward/Interface/External
  CALLER: compilerAction _forwDecl _intfDecl _extDecla
}
begin
  headerDeclared:=false; outC(';`');
  outC('/*)*/`');
  { BUG: should call, only for LOCAL level Forward:
    insertGlobId(procStack[lastProc]^.name, -1);
    forward declaration neutralises one global identifier candidate?
  }
  lastProc:=pred(lastProc); {function prototype, clear stack}
  blockLevel:=blockLevel-1;
end;

procedure compilerAction(choice: char; var stat:scanStatus);
{ ACTION: select one code generating action from a giant CASE list.
          first, execute semantic function requested  by grammar rule.
          Then, do the C code generation required.
  CALLER: Pcpc.basicParser, subroutine checkElem.
  INPUT : choice= the last semantic action symbol found. Entry into Case list.
          stat= status of the scanner (last terminal, string, real const etc.)
}
var ident:pide;
    pt,expType,refType:ptpel; clas:char;
    pref,suff:str80; name:str20;
    off,k,tag: integer;
    ok:boolean;
begin
  semanticAction(choice ,stat, ident, expType,refType);
(*  semanticAction returns :
     ident  = the critical identifier, for the declaration part
     expType= the current type of expressions we're scanning, just before
       the pending operator. Reduction for Var vaL ... is done !
       Helps translating
       overloaded operators like * + - = < > And Or , assignments, ...
       Example + : integerAdd, realAdd, stringConcat, or setUnion !
     refType= a reference type (formal parameter, assignment Lvalue)
       Parameter types not always reduced to origin type!
Bug, or feature:
-    There are 3 global FLAGs telling where we are:
        StatementPart (versus declaration part)
        implemPart (versus interface part of Unit)
        importPart (interface of imported unit)
*)
  if lastExp>0 then expTypes[lastExp]:=expType; {last type seen, before
    applying the pending operator, + or <>, for example ! }
  case actionName[ord(choice)] of
{--   Declaration translator: -----
- CONST : @assignCon : ident -> new const identifier
- TYPE  : @typeEnd   : ident -> new type name
- VAR   : @tpVarList : ident -> first one of new var names
- PROC  : @procEnd   : ident -> procedure name
- FUNCT : @functEnd  : ident -> function name
}
    procEnd:   CreatePlist(ident, scope.actual, importPart); { ANSI header...}
    functEnd:  CreatePlist(ident, scope.actual, importPart);
    tpVarList: putVarList(ident, importPart,true);  {normal list}
    typConst:  begin
                 putVarList(ident, importPart,false); {1 element, typed const}
                 if importPart then outC('`#if 0`'); {mask values}
               end;
    assignTC:  begin
                 if importPart then outC('`#endif`');
                 outC(';`');
               end;
    typeEnd:   typeDeclare(ident);
{BUG:  if scope.actual>2 then keep-the-local-type-name:
     in Cnesting.GlobId:  InsertGlobId(ident^.name ,1);
     in Cnesting.checkPlist mark such Ids as Nil pointers!?
}
    assignCon: constDeclare(ident,refType, stat, importPart);
                 {refType= machineInfo.ctype, the type of the const}
    useUnit:   insertUnit(nUnit+1, stat.pp^.name, ok);
    mainPrgr:  mainProgram;
{-- control structures --}
    beginSymb: begin outC('{'); outC('@+`'); end;
    endSymb:   outC('@-}`');
    forDef:    begin  pushIdent(stat.pp); {local or global, never semilocal:
                   we do not need pushIdentL }
                 outC('for('); {use the With stack for loop var ident}
                 toWithStack(2); outC(withItem[withIx]);
               end;
    forInit:   begin outC('= '); outCexp(1); end;
    comparTo:  begin outC(';'); outC(withItem[withIx]); outC('<= ');
                 outCexp(1); outC(';'); outC(withItem[withIx]);
                 outC('++) ');
               end;
    increment: begin withIx:=pred(withIx);  end;
    comparDown:begin outC(';'); outC(withItem[withIx]); outC('>= ');
                 outCexp(1); outC(';'); outC(withItem[withIx]);
                 outC('--) ');
               end;
    decrement: begin withIx:=pred(withIx);  end;
    ifthen:    begin outC('if('); outCexp(1); outC(') '); end;
    elseDo:    begin outC('else ') end;
    endIf    : begin end;
    doLoop:    outC('while(');
    doWhile:   begin outCexp(1); outC(') '); end;
    endWhile:  begin end;
    repLoop:   outC('@+do {`');
    endRep:    begin outC('@-} while(!('); outCexp(1); outC('))'); end;
    caseSel:   begin outC('@+switch ('); outCexp(1); outC(') {');
                 intvType:=Nil;
               end;
    caseIntv:  intvType:=refType; {Keep refType of label interval globally}
    caseFirst: caseLabel;
    caseNext:  caseLabel;
    caseEnd:   begin outC('break;'); end;
    caseOther: begin outC('@=default:'); end;
    caseTerm:  begin outC('@-}`'); end;
    terminator:begin {C needs a statement terminator !}
                 nontrivialTerm;
                 resetAuxVar(blockLevel); {aux vars : 1 stmt limited scope }
                 lastExp:=0; {clear the expression stack, too? }
               end;
    blockBegin:blkBegin;
    blockEnd:  blkEnd;
    normUnit:  begin blkBegin; blkEnd; end;
    forwDecl:  forwFunction;
    intfDecl:  forwFunction;
    extDecla:  forwFunction; {Bug: comes too late to make prefix "extern" }
{--  L-values and constants --}
    getAddr:   pushIdentL(stat.pp);
    parAddr:   begin pushIdentL(stat.pp); clas:=stat.pp^.typof^.p^.cl;
                 {parameter type class. arrays get no * !}
                 if (clas<>'Y')and(clas<>'s')and(clas<>'e') then
                   unaryOp('*','',1,1);
               end;
    constRef:  if statementPart then with stat do begin
                 pushIdentL(pp); {do nothing for declaration}
                 keepConst(pp^.x);
                 if (pp^.x>=minInteg)and(pp^.x<=maxInteg) then begin
                   clas:=pp^.typof^.cl;
                   if not (clas in ['E','s','r','d']) then
                     unaryOp('(short)','',1,1);
                   {must typecast dummy "enums", precedence is 1 ?}
                 end;
               end;
    valpAddr:  begin pushIdentL(stat.pp);
                 { clas:=stat.pp^.typof^.p^.cl;
                   -- records,sets don't get *: we have a local copy!
                 if (clas='R')or(clas='e') then unaryOp('*','',1,1);
                 }
               end;
    fileAddr:  pushIdentL(stat.pp);
    intConst:  if statementPart then begin
                 {clas:=stat.pp^.typof^.cl; cla='r ??}
                 if stat.isFloat then pushLine(stat.chain,stat.chainLen)
                 else begin
                   pushIntVal(stat.ii); keepConst(stat.ii);
                 end;
               end;
    stringCon: if statementPart then begin  k:=stat.chainLen;
                 pushString(stat.chain,k);
                 if k=1 then begin unaryOp('''','''',0,0);
                   keepConst(ord(stat.chain[1]));
                 end else unaryOp('"','"',0,0);
               end;
    nilSymbol: pushExp('NULL',0);
    trueSymb:  pushExp('TRUE',0);
    falsSymb:  pushExp('FALSE',0);
    arrayAddr: getArrayIndex;
    subField:  pointerOp(stat.pp); { if operand A starts with *, tries  A->B }
    pointTo:   unaryOp('*','',1,1); {Bug: the () may be dropped ? }
    withFirst: toWithStack(1);
    withNext:  toWithStack(0);  {marker supports With lists}
    withReleas:repeat off:=withMarker[withIx]; withIx:=withIx-1;
               until (off=1); {stop after true first record mark}
    withAddr:  begin {here, stat.pp identifies a field }
                 tag:=stat.pp^.rScope; k:=withIx;
                 while (tag<>withRecord[k])and(k>0) do k:=pred(k);
                  {MUST find one, else id-not-found error already flagged}
                 if withItem[k,1]='*' then off:=1 else off:=0; {* operator!}
                 pushExp(withItem[k],off);
                 pointerOp(stat.pp);
               end;
{-- expressions ---}
    parenthes: unaryOp('(',')',0,0);
    notLog:    begin clas:=expType^.cl;
                 if clas='b' then unaryOp('!','',1,1)
                 else {bitwise} unaryOp('~','',1,1);
               end;
    negate:    unaryOp('-','',1,1);
    multi:     begin clas:=expType^.cl;
                 if clas='e' then setCalc('I')
                 else binaryOp('','* ','',2); {space -> X* *Y, not X**Y}
               end;
    divis:     binaryOp('','/ ','',2); {keep the space! Else /* bugs ! }
    modulo:    binaryOp('',' % ','',2);
    addit:     begin clas:=expType^.cl;
                 if clas='e' then setCalc('U')
                 else if (clas='s')or(clas='c')or(clas='Y') then
                   stringCat(clas)
                 else binaryOp('','+','',3);
               end;
    subtr:     begin clas:=expType^.cl;
                 if clas='e' then setCalc('D')
                 else binaryOp('','-','',3);
               end;
    andLog:    begin clas:=expType^.cl;
                 if clas='b' then binaryOp('',' && ','',10)
                 else binaryOp('',' & ','',7); {detect non-Boolean, then & }
               end;
    orLog:     begin clas:=expType^.cl;
                 if clas='b' then binaryOp('',' || ','',11)
                 else binaryOp('',' | ','',9);
               end;
    xorLog:    binaryOp('',' ^ ','',8);
    shfLeft:   binaryOp('',' << ','',4);
    shfRight:  binaryOp('(Word)(',')>> ','',4); {force unsigned shift! }
    equal:     compare('E',exptype,refType);
    less:      compare('L',exptype,refType);
    greater:   compare('G',exptype,refType);
    unEqual:   compare('U',exptype,refType);
    lessEqu:   compare('l',exptype,refType);
    greaterEqu:compare('g',exptype,refType);
    inOper:    binaryOp('In(',',',')',1); { a function call has level 1 ?}
    interval:  binaryOp('#', ',', '',1); {make A..B:   #: trigger _eR here}
    setDef:    begin pushAuxSet;
                 pushExp('(_eV('+expStack[lastExp]+'),',0);
               end;
    setList:   begin clas:=expStack[lastExp][1];
                 if clas='#' then begin delete(expStack[lastExp],1,1);
                   pref:='_eR(';         {add Range}
                 end else pref:='_eE(';  {add Element}
                 binaryOp('',pref+expStack[lastExp-2]+',', '),',1);
               end;
    setMake:   begin  {inverse unary op here: }
                 lastExp:=lastExp-1;
                 expStack[lastExp]:=expStack[lastExp+1];
                  {+expStack[lastExp]+')'; }
                 k:=length(expStack[lastExp]); expStack[lastExp][k]:=')';
               end;
    assignDef: begin  end;
    functName: begin
                 getIdent(stat.pp,name); pushExp(auxPrefix+name, 0);
               end;
    assignmt:  codeAssign(exptype^.cl,refType);
{---  input/output ---}
    formData : begin formOne:=false;formTwo:=false end;
    fmtOne   : begin formOne:=true; {binaryOp('',',','',0); No! } end;
    fmtTwo   : begin formTwo:=true; binaryOp('',',','',0); end;
    fileRef  : begin console:=false; pushIdentL(stat.pp) end;
    doRead   : scanIOlist(false);
    doRdLn   : scanIOlist(true);
    doWrite  : printIOlist(false);
    doWriLn  : printIOlist(true);
                 { if 1st param is a file VAR reference, make fileRef}
    rdVar    : if (IOcount=0) and ((expType^.cl='t')or(expType^.cl='F'))
               then begin {t= Text  F=File type }
                 IOtype[0]:=expType;
                 console:=false; pushIdentL(stat.pp);
                 if stat.pp^.typof^.cl='A' then unaryOp('(*',')',0,0);
               end else extendInList(expType);
    wrFmt    : begin
                 if (IOcount=0) and ((expType^.cl='t')or(expType^.cl='F'))
                 then begin {arg. is TEXT (FILE) id, else formatted DATA}
                   IOtype[0]:=expType;
                   console:=false; pushIdentL(stat.pp); {frequently & ! }
                   if stat.pp^.typof^.cl='A' then unaryOp('(*',')',0,0);
                 end else extendOutList(expType, formOne,formTwo);
                 formOne:=false;formTwo:=false;
               end;
    numToStr : numberString;
    memAlloc : begin outCexp(1); {the pointer reference};
                 { BUG? pt:=stat.pp^.typof;
                 if (pt^.cl='A')or(pt^.cl='L') then pt:=pt^.p; --parameter}
                 pt:=expType;
                 outC(' = New('); fullTypeName(pt^.p, 0,pref,suff);
                  {the pointed-to type, not the pointer type}
                 outC(pref);outC(suff); {the "abstract-declarator" of C}
                 outC(')');
               end;
{-- function calls --}
    mainFile  : implemPart:=false;
    unitFile  :begin  {must save the unit name here for its init block... }
                 lastProc:= 1; {or perhaps: succ(lastProc); }
                 procStack[lastProc]:=stat.pp;
                 units[0]:=stat.pp^.name; {current unit name}
                 implemPart:=false;
               end;
    implPart  :begin blockLevel:=blockLevel+1; {delayed ! }
                 implemPart:=true;
               end;
    blockEntry:begin {if stat.pp is function/procedure, push its name ! }
                 ident:=stat.pp; pt:=ident^.typof;
                 if (pt^.cl='D')or(pt^.cl='U') then begin
                   if lastProc>=maxNest then begin
                     error('Cbulk_BlockEntry: lastProc>=maxNest!');
                   end else begin
                     lastProc:=succ(lastProc);
                     procStack[lastProc]:=ident;
                   end;
                 end;
                 blockLevel:=blockLevel+1; {main has level 1, sub >1 }
               end;
    functCall: { funct call output will go to the Expression stack!}
               callCode(stat,'U');
    procCall:  callCode(stat,'D');
    pushParam: concatParam(refType, expType);
    doCall:    finishCall;
    gotoExit:  begin exitCall[lastProc]:=true; outC('@=goto Exit;`'); end;
{ -- odds and ends --}
    setcoTerm: setConst(machineInfo.bs);
    tradCons: constDeclare(Nil,refType,stat,importPart);
    tradOpen: outC('{');
    tradSepa: outC(',');
    tradClos: outC('}');
    intJump : begin outC('goto _l'); outCi(stat.ii);outC(';`'); end;
    symbJump: begin outC('goto '); putIdent(stat.pp);outC(';`'); end;
    intLabel: begin outC('_l'); outCi(stat.ii);outC(': ') end;
    symbLabel:begin putIdent(stat.pp); outC(': ') end;
    getSize:  unaryOp('sizeof(',')',0,0);
    getPtr :  unaryOp('&','',1,1); {Turbo Pascal @ operator}
    typeSize: begin pushIdent(ident); unaryOp('sizeof(',')',0,0); end;
    memArray: begin clas:=refType^.cl; name:='*Mem'; {a pointer function}
                if (clas='w')or(clas='l') then name:=name+clas;
                binaryOp(name+'(',',',')',0);
                expTypes[lastExp]:=refType;
              end;
    ioPort:   begin clas:=refType^.cl; name:='*Port';
                if (clas='w') then name:=name+clas;
                unaryOp(name+'(', ')', 0,0);
                expTypes[lastExp]:=refType;
              end;
    ignore:   lastExp:=lastExp-1; {ignore preceding const expression}
  else{otherwise} end;
end;

end. {unit Cbulk}
