{
  PASCANNR.PAS      Copyright (c) Georg Post  1991

This is the front end of the Pascal-to-C translator. It consists of 1+3 modules
 (maybe 3 smaller Units some day ) :

(1)  initialization, error messages, debugging.
(-)  builds the grammar table Gt for the LL(1)-type Pascal parser
     (absorbing the syntax and "header" file grammar5.txt)
(2)  Symbol table manager (a binary tree for each scope)
(3)  Scanner for Turbo Pascal source code

The general recursive descent parser is a related module, using the routines
Scanner and TreatSymbol. All its knowledge about Pascal stems from Gt.
It sits in the last file (pcpc.pas) of the package because it must call the
semantic action dispatcher (semanti5.pas) and the C code generator (C*.pas)
modules.

1: Warning: Run CHEKGRAM.PAS on any modified GRAMMAR5. Nothing is done here to
   detect bugs in the grammar specs !

2: The symbol manager will construct 2 "trees":
 - the identifier forest (one tree for each nested block level ("scope") )
 - the type hierarchy for compatibility checks.
 Identifier Scope Rules:
   The System Dos Crt Graph identifiers have scope Zero
   Interface parts of Units: scope 1
   Globals in Implementation, and Main Program: scope 2
   Locals of a global procedure: scope 3
   Locals of local procedures:  4,5,6,....  maximum 10 is allowed.
 - Pascal programs may legally re-use scope 0 (and other unit's scope 1)
   identifiers in its global scopes( 1,2) , using re-definition.
 - C programs MUST create new distinct identifiers, here !
 - We count such identifiers with a byte ReUse but a full collision detection
   is still missing (bug!).

3:  BUGS:
   -  parseString accepts ^C ( not: ^k ^[) ... as a char or in strings.
      Therefore, pointers to 1-letter type names are ambiguous
}
unit pascannr;

{$S+,R+}

interface
uses pcpcdata; {global const,type and data }

var  parseWarning,
     underbarLegal, {identifier may start with _ ?}
     waitReturn: boolean; {init by the main prog}
     warnBuffer: str255;

procedure initPascann(var psrc:ptextbuff);
procedure termPascann;
procedure rangeCheck(p:pointer; mess:str8);
procedure readSource(name:str40);
procedure readInterface(name:str40);
procedure error(message:str40);
procedure SyntaxBug(p:integer; q,r:char;
  var stat:scanStatus; var sDat:symbolData);
procedure treatSymbol(var ok,fatal: boolean; q,r: char; leads: boolean;
  var stat:scanStatus; var sDat:symbolData);
procedure killTree(p: pide; var total,depth:integer); {returns tree to reserve}
procedure scanner(var stat:scanStatus; var sdat:symbolData);

implementation

var
  src: ptextbuff; {the input text}
  texpo:word; {pointer to position in src^}
  olderrl, texl, otexl: word; {olderrl = the old errline}
    {pointers to line and text start in the scanner}
  OkToCompile: boolean; {TRUE if we aren't blocked by some $If... directive}
  errScreen: integer; {count error messages, at screenfull wait for RET}
  idereserve,marker: pide;
  miniHeap,maxiHeap: longInt;
  hiddenId: array[2..100] of pide;  {synonyms of global Ids which are
    chased from the symbol tree by some later unit. }
  hideIx: integer;  {last hidden Id}
  voidId: Ide; {empty identifier for quick init}
  visibleUnits: set of 0..15; {in header of unit 5, unit 4 may be invisible..}

const maxDefSymb=20;
var directive:record {compiler switches & options}
      switch: array['A'..'Z'] of boolean; {True if option is + }
      ifState: array[1..16] of boolean; {condition ON flags, <=16 nested $IF}
      ifLevel: integer; {may be 0..16}
      defSymb: array[1..maxDefSymb] of str20; {defined symbol "heap" <=20}
      nSymb: integer; {nb of defined symbols}
      incFile: str20;
      inclusion: boolean;
      mainFile:str40; {path name of input file}
      size: word;     { src^[size-1] is last valid char}
    end;

{*** (1)  ***  general stuff, debugging and error handling ********}

procedure resetScan(name:str40; t:word);
{ init line counters, init compiler directives }
var s:str20; c:char; i:integer;
begin
  texpo:=1; {start index for scanner}
  errline:=1;olderrl:=1; texl:=0;  {we are on Line # 1 }
  okToCompile:=true;
  with directive do begin
    for c:='A' to 'Z' do switch[c]:=false;
    s:='DILSV';
    for i:=1 to length(s) do switch[s[i]]:=true;
    ifLevel:=0;
    defSymb[1]:='VER40'; defSymb[2]:='MSDOS'; defSymb[3]:='CPU87';
    defSymb[4]:='PCPC'; {pre-defined symbol to single out this PCPC converter}
    nSymb:=4;
    mainFile:=name;  size:=t;
    inclusion:=false;
  end;
end;

procedure getNonTerminal(p:integer);
{ ACTION:  debugging. writes grammar symbol whose index (start address in Gt)
           is closest to p.
}
var i,ii,j,nti: integer;
begin
  nti:=0; {look for the biggest nti <= p }
  for i:=1 to 31 do begin j:=index[i];
    if (j<=p)and(j>nti) then begin nti:=j;ii:=i end;
  end;
  if nti=0 then write('000 ') else write(objectList[ii]);
end;

procedure showInData( var stat:scanStatus;  var sdat:symbolData);
{ ACTION: writes the last source code item the scanner has found.
  CALLER: syntaxBug
  INPUT : stat, sdat.
}
var a,b,i,j: integer;
begin
  with stat,sdat do begin
    {write(' ',cc);}
    if cc='?' then begin
      for i:=1 to ln do write(src^[db-1+i]);
    end else if cc='%' then begin
      write(ii:1);
    end else if cc='''' then begin
      for i:=1 to chainLen do write(chain[i]);
    end else if ord(cc)>127 then begin
      j:=ord(cc)-127; a:=smb[j].ix; b:=smb[j].len;
      for i:=a to a+b-1 do write(upcase(Gt[i]));
    end else begin
      write(cc);
    end;
  end;
end;

procedure initPascann(var psrc:ptextbuff);
{ ACTION: global var init. Reserve 50K heap space for input text.
  CALLER: pcpc.Translate; do not call me more than once !
  OUTPUT: psrc = pointer to text buffer. Nil if not enough memory.
}
var c:char; s,k:integer; sixteen,mav:longInt;
    ic:idClass; ac:action;
    marker:pide;
begin
  for s:=1 to nonterms do index[s]:=0;
  nulch:=chr(0); cr:=chr(13); tab:=chr(8); lf:=chr(10); endsym:=nulch;
  with scope do begin
    actual:=0; { the outermost level: pre-defined and used units, unit header}
    currentUnit:=0;  {the unit counter. System will be 1 , others >1}
    recIndex:=0; {no records visible at all}
    markId  :=0;
    maxRecords:=0; {global counter of ALL record definitions ! }
    for s:=0 to 20 do begin pstart[s]:=nil;
      recScope[s]:=0;
      variantNb[s]:=0;
    end;
  end;
  with withStack do begin nWith:=0; wsp:=0; snb[0]:=0; nwi[0]:=0;
  end;
  idereserve:=nil; {reserve of ide records}
  errcount:=0; warnCount:=0; fatals:=0;
  maxerr:=1; tooManyErrors:=false;
  errScreen:=0;
  ic:=constId;   {make the inverse functions to ORD, avoid typecasts }
  for s:=1 to 31 do begin className[s]:=ic;
    if ic<labelId then ic:=succ(ic);
  end;
  ac:=ifThen;
  for s:=1 to dictSize do begin actionName[s]:=ac;
    if ac<forbidden then ac:=succ(ac);
  end;
  new(marker);  {non-portable bottom-of-heap function}
  sixteen:=16;
  miniHeap:=ofs(marker^)+sixteen*seg(marker^);
  dispose(marker);
  mav:=memAvail;
  writeln('MemAvail=',mav);
  maxiHeap:=miniHeap+mav-100; {miniHeap..maxiHeap -> pointer rangecheck kludge}
  if mav>100000 then begin
    new(src);
    psrc:=src;
  end else begin
    writeln('Not enough memory to run.');
    psrc:=Nil;
  end;
  maxiStak:=SPtr; miniStak:=maxiStak; stakLine:=0;
  hideIx:=1;
  visibleUnits:=[0]; {the system unit}
  with voidId do begin
    for k:=1 to lenIde do name[k]:=nulch;
    class:=otherId; rg:=nil; lf:=nil; chain:=nil; typof:=Nil;
    x:=0; y:=0; reuse:=0; defLevel:=0;
  end; {with}
  resetScan('',1);
  parseWarning:=false; warnBuffer:='';
end;

procedure termPascann;
var pid,q:pide; ni,i:integer;
begin
  pid:=idereserve;  ni:=0;
  while pid<>Nil do begin
    q:=pid; pid:=pid^.rg; dispose(q); ni:=succ(ni);
  end;
  for i:=2 to hideIx do begin dispose(hiddenId[i]); ni:=succ(ni) end;
  dispose(src);
{  writeln('MemRecov=',memAvail,'  Ni=',ni); }
end;

procedure checkStack;
begin
  if SPtr<miniStak then begin miniStak:=SPtr; stakLine:=errline; end;
end;

function lowercase(c:char):boolean;
begin lowercase:=('a'<=c)and(c<='z') end;

function uppercase(c:char):boolean;
begin uppercase:=('A'<=c)and(c<='Z') end;

function numeric(c:char):boolean;
begin numeric:=('0'<=c)and(c<='9') end;

function alfaNum(c:char):boolean;
begin alfaNum:=lowercase(c) or uppercase(c) or (c='_') or numeric(c) end;

procedure toLower(var c:char);
begin if (c>='A')and(c<='Z') then c:=chr(ord(c)+ord('a')-ord('A')) end;
{
function upcase(c:char):char;    for non Turbo systems
begin if lowercase(c) then upc:=chr(ord(c)+ord('A')-ord('a'))
  else upc:=c
end;
}

procedure pointerr;
{ ACTION: reproduce last line of source, the hot spot Texpo is marked
  CALLER: error
  INPUT : globals: errline (line number), texl (start  of line in Src^), texpo
  OUTPUT: globals: olderrl, otexl
}
var i,k:word;
    warn:str255;
begin
  warn:='';
  if (texl<lbuf)and(texpo<lbuf) then begin
    i:=texl; if i<1 then i:=1; k:=0;
    while (i<texpo)and(k<100) do begin {from start of line to problem}
      warn:=warn+src^[i];i:=succ(i);k:=succ(k);
    end;
    warn:=warn+'??';
    while (i<lbuf)and(k<100)and(src^[i]>=' ') do begin {to end of line}
      warn:=warn+src^[i]; i:=succ(i);k:=succ(k);
    end;
    writeln(warn);
    if (length(warnBuffer)+length(warn))<255 then
      warnBuffer:=warnBuffer+warn+chr(13);
  end;
  olderrl:=errline; otexl:=texl;
end;

procedure error(message:str40);
{ ACTION:  thinks that something is wrong and tells so
  CALLER:  from almost everywhere
  INPUT :  message, global: errline
           If message ends with ?, this is a Warning only. If !, it's fatal.
  OUTPUT:  side effect on errcount, tooManyErrors.
}
var c:char; warn:str255;
begin
  c:=message[length(message)];
  if c='?' then warncount:=warncount+1 else
  if c='!' then fatals:=fatals+1 else errcount:=errcount+1;
  tooManyErrors:=(errcount>maxerr);
  writeln;
  str(errLine:4,warn); warn:='===> LINE '+warn+': '+message;
  writeln(warn);
  parseWarning:=true;
  if (length(warnBuffer)+length(warn))<255 then
    warnBuffer:=warnBuffer+warn+chr(13);
  pointerr;
  errScreen:=succ(errScreen);
  if waitReturn and (errScreen>=8) then begin
    write('<Ret>');readln; errScreen:= 0
  end;
end;

procedure rangeCheck(p:pointer; mess:str8);
{ ACTION: debug. Check if p is inside the heap address space (cf initPascann)
          Fail --> abort the program since MSDOS lacks memory protection.
  CALLER: any routines that write to pointed memory.
  INPUT : "mess" identifies the origin of the call.
}
var st,x:longInt;
begin
  st:=16; x:=ofs(p^)+st*seg(p^);
  if (x<miniHeap)or(x>maxiHeap) then begin
    error('Pointer ['+mess+'] gone wild!');
    writeln('[rangeCheck] Fatal error: ',mess,'=',x);
    halt;
  end;
end;

procedure smbReference(var mess:str40; var sb:symbol);
var i: integer;
begin
  mess:= '<'; i:=1;
  while (i<lenIde) and (sb[i]>' ') do begin
    mess:=mess+sb[i]; i:=i+1;
  end;
  mess:=mess+'>';
end;

procedure expect(p: integer; q,r:char);
{ ACTION : print (fatal) error message when the parser gets lost.
  CALLER : SyntaxBug
  INPUT  : q= code for expected nonterminal, identifier, keyword, const.
           r=complement. If p>0, ambiguity (no-name construct in Gt).
}
var i,j,l:integer; mess,pref:str40;  stapo:word;
begin
  if p>0 then pref:='Maybe here ' else pref:='Expect here ';
  if q='%' then mess:='Number'
  else if q='''' then mess:='String const'
  else if q='~' then begin {named non-terminal symbol}
    smbReference(mess, objectList[ord(r)]);
  end else if ord(q)>127 then begin {keyword}
    i:=ord(q)-127; j:=smb[i].ix; l:=j-1+smb[i].len;
    mess:='"';for i:=j to l do mess:=mess+Gt[i];mess:=mess+'"';
  end else if (q='?')or(q='&') then begin {identifier types}
{    if r='C' then mess:='Const'
    else if r='V' then mess:='Var'
    else if r='T' then mess:='Type'
    else if r='F' then mess:='Field'
    else if r='U' then mess:='Function'
    else if r='P' then mess:='Procedure'
    else if r='A' then mess:='Var-parameter'
    else if r='L' then mess:='Val-parameter';
    mess:=mess+' identifier'
}
    smbReference(mess, IdTypeList[ord(r)]);
  end else mess:='"'+q+'"';
  error(pref + mess+'!');
end;

procedure SyntaxBug(p:integer; q,r:char;
  var stat:scanStatus; var sDat:symbolData);
{ ACTION: print syntax error message: found versus expected code item.
  CALLER: treatSymbol, pcpc.BasicParser
  INPUT : if p>0, Gt[p]='{' symbol ; else (q,r) = terminal or nonterminal
          expected symbol. stat,sDat: last scanner data.
}
begin
  if p>0 then begin {approximate nonterminal by 1st symbol inside braces }
    while Gt[p]='{' do p:=succ(p); q:=Gt[p]; r:=Gt[p+1];
    write('Maybe ');
  end;
  expect(p,q,r); {mismatch message: syntax error}
  write('Cannot understand "'); showInData(stat,sdat);
  writeln('"');
end;

procedure fillBuffer(name:str40; var t:word; tmax:word);
{ ACTION: text file "name" --> memory buffer Src^, start at t, stay <= tmax.
  CALLER: readSource
  OUTPUT: t=one beyond last valid buffer character, src^[t]=#0
  BUG   : nonportable "BlockRead" would be 10 times faster.
}
var c:char;
    source:text;
begin
  assign(source,name); {$I-} reset(source); {$I+}
  if ioResult<>0 then begin
    writeln; writeln('Cannot open ',name);
    fatals:=fatals+1; {fatal error}
  end else begin
    while not (eof(source) or (t>=tmax)) do begin
      if eoln(source) then begin
        readln(source); c:=lf
      end else begin
        read(source,c);
      end;
      if c<>nulch then begin src^[t]:=c; t:=succ(t) end;
    end;
    close(source);
  end;
  src^[t]:=nulch;
end;

{*** (2)  ********  symbol table management   *****************}

(*
A given identifier I is defined to match the one at PP in the symbol list, IF:
 uppercase(I) = uppercase(PP^.name)  {the strings are the same}        AND
 ( (PP^.rscope=markId) {the same brand of field Id} OR
   (PP^.class in [typeId,forwId,constId] )  {const/type Id's are unique}
 )

The identifier compare algorithm uses  withStack and Scope:
 - If (wsp=0) OR (markId>0) (no active With, or point operation pending)
     look only at current markId.
 - Else for i:=wsp downto 0 do
     set markId to snb[i]. Exit loop if found.

 The tree search and insertion rules for identifiers:
 - first match the "name", then the "rScope", optionally the "qualif"
 - if items 1 and 2 start with the same partial string, the one introduced
   later is in the subtree of the other one.
*)

const relaxed=0; standard=1; severe=2;

procedure compare(p:pide; iUnit,ix,version:byte; var sdat:symbolData);
{ ACTION: compare routine for symbol table lookup, looks at chars db...db+ln-1.
          three Versions:
  0 relaxed : record serial numbers ignored, identifiers must match.
  1 severe  : the record number rscope MUST match ix (used for WITH search)
  2 standard: rscope=ix, OR  identifier is Const,Type,Forward. However,
              those MAY be entered as new field Ids in a type declaration.
              if iUnit>0, qualif must match.
  CALLER: searchWith, searchRest.
  INPUT : p=pointer to symbol table, ix=record marker, version= 0,1,2
  OUTPUT: sdat.found (true or false), sdat.small evaluated if NOT found.
}
var k: integer; n:word; ch:char;
begin
 with sdat do begin
  k:=1; n:=db;
  with p^ do begin {BUG: undefined name[ln+1] in the following ? }
    while (k<=ln)and(upcase(src^[n])=upcase(name[k])) do begin
      k:=succ(k);n:=succ(n)
    end;
    found:=(k>lenIde); {case of a 10-char id}
    if not found then begin
      if k>ln then begin {we are past the source code Id}
        ch:=nulch; found:=(name[k]=nulch); {listed name is longer, if NOT}
      end
      else ch:=src^[n];
    end;
    if not found then small:=(upcase(ch))<upcase(name[k]) else begin
      case version of
      standard: begin
         found:= (rscope=ix) or (class in [constId,typeId,forwId]);
         if not found then small:=(ix<rscope)
         else if (iUnit>0) then begin
           found:=(qualif=iUnit);
           if not found then small:=(iUnit<qualif);
         end;
        end;
      severe:
        begin found:=(rscope=ix); if not found then small:=(ix<rscope); end;
      else{otherwise} end; {version=relaxed: we declare it is FOUND}
    end;
    {small means: newcomer is lexically before list entry}
  end; {with p^}
 end; {with sdat}
end;

procedure searchRest(iu,ix,vs:integer; var p,pput:pide; var sdat:symbolData);
{ ACTION: Searches ident thru levels actual..0, lenIde valid upper case chars
          All variables allowed. If ix>0, we expect field id. of a record.
          Else if unit index iu>0, p^.qualif must match it.
          vs is the severity version, for compare.
  CALLER: searchId, qualIdent
  INPUT : from sdat: db,ln,  idLevel,
  OUTPUT: p is id-pointer if Found, pput is its parent with relation "smaller".
          If not Found, pput points to eventual insertion point in Actual
          level, even if Found in some more global level.
          if Found in actual level, pput is the parent of p, with "smaller" Ok.
  BUG :   if Found , check visibility of p^.qualif, if p^.reuse>0.
          Maybe look into the hiddenId table to get the last visible qualif.
          If it's not visible, annexId will be called in Mode 2.
            if found and (scop<3) and not (p^.qualif in visibleUnits) then ...
          If iu>0, p^.qualif MUST match, chances are that hiddenId
          table has the right Id.
}
var scop,act: integer; q,r:pide;
begin
 with sdat do begin
  act:=scope.actual; scop:=act; found:=false; small:=false; r:=Nil;
  repeat p:=scope.pstart[scop]; { outer loop over nested procedure blocks}
    q:=nil;              {inner loop: tree search}
    while p<>nil do begin {=nil, end of search}
      q:=p;
      compare(p, iu,ix, vs, sdat); {updates markId for With fields!? }
      if not found then begin
        r:=p;
        if small then p:=p^.lf else p:=p^.rg;
      end else p:=nil; {and q is result pointer}
    end;                     {end of inner loop}
    if scop=act then begin pput:=r; smaller:=small; end;
     {conserve pput in any event, for current scope id duplicates }
    if not found then begin scop:=pred(scop); end;
  until found or (scop<0);   {end of block loop}
  scope.idLevel:=scop; {<0 if not found}
  if found then p:=q else p:=nil;
 end;
end;

procedure insertField(ix:integer; var p,pput:pide; var sdat:symbolData);
{ ACTION: Searches for ident in actual level only!
          ix>0, we expect field id. of a record with ix value Ok.
  CALLER: annexId
  INPUT : from sdat: db,ln, idLevel,
  OUTPUT: pput points to insertion point
}
var  q,r:pide;
begin
  with sdat do begin
    found:=false; small:=false; r:=Nil;
    p:=scope.pstart[scope.actual];
    q:=nil;
    while p<>nil do begin {=nil, end of search}
      q:=p;
      compare(p, 0,ix,severe, sdat);
      if not found then begin
        r:=p;
        if small then p:=p^.lf else p:=p^.rg;
      end else p:=nil; {and q is result pointer}
    end; {while}
    pput:=r; smaller:=small;
    if found then begin p:=q;
      error('BUG InsertField!');
    end else p:=nil;
  end; {with}
end;

procedure searchWith(iw:integer; var p:pide; var sdat:symbolData);
{ ACTION: identifier search called if iw>0, search down the iw With fields
          field identifier search in active "With" records (levels actual..0)
  CALLER: searchId
  INPUT : uses sdat (db,ln)
  OUTPUT: p is id-pointer if found.  exports global scope.idLevel.
          side effect on scope.markId !
}
var scop,act,ix,rw: integer; q,root:pide;
begin
 with sdat do begin
  act:=scope.actual; scop:=act; found:=false; small:=false;
  repeat p:=scope.pstart[scop]; { outer loop over nested procedure blocks}
    q:=nil;              {inner loop: tree search}
    while p<>nil do begin {=nil, end of search}
      {first phase: get the first matching identifier. All other synonymous
       identifiers, of any record brand, are in the subtree of that one }
      q:=p; compare(p, 0,0,relaxed, sdat); {don't check record markers here}
      if not found then begin
        if small then p:=p^.lf else p:=p^.rg;
      end else p:=nil; {and q is result pointer}
    end;                     {end of inner loop}
    if found then begin {serious WITH search starting here}
      root:=q; ix:=iw;
      repeat rw:=withStack.snb[ix]; {with record's serial number}
        p:=root; q:=nil;
        while p<>nil do begin
          q:=p; compare(p, 0,rw,severe, sdat); {record marker MUST match}
          if not found then begin
            if small then p:=p^.lf else p:=p^.rg;
          end else p:=nil; {and q is result pointer}
        end;
        ix:=pred(ix);
      until found or (ix<=0);
    end;
    if not found then scop:=pred(scop);
  until found or (scop<0);   {end of block loop}
  scope.idLevel:=scop; {<0 if not found}
  if found then p:=q else p:=nil;
  if found then begin
    scope.markId:=p^.rScope; {identifier's record stamp}
  end;
 end;
end;

procedure searchId(var p,pput:pide; var sdat:symbolData);
{ ACTION: identifier search in symbol table.
  CALLER: scanner
  INPUT : symbol data in sdat. Global data Scope.
  OUTPUT: p=pointer to Id, pput its parent, or insertion point if NOT found.
}
var ix,iw, version: integer;
begin
  ix:=scope.markId; {ix>0 is Record context, match this }
  iw:=withStack.wsp;
  sdat.found:=false;
  if (ix=0) and (iw>0) then searchWith(iw,p,sdat);
    {if no point operation pending, priority for With prefixes}
  if not sdat.found then begin
    if (ix>0) and scope.fieldOnly then version:=severe else version:=standard;
    searchRest(0,ix, version, p,pput, sdat);
  end;
end;

procedure annexid( var p,pput:pide; var sdat:symbolData; mode:byte);
{ ACTION: insert new identifier into symbol table at fresh address p.
          data from Sdat: actual,db,ln, ....
  CALLER: Scanner (Mode 0), TreatSymbol (Mode 1,2)
  INPUT : pput = parent for binary tree link. global data Scope.
          Mode 0: annex with parent=pput, flag ReUse=0.
          Mode 1: like 0, but the symbol was defined elsewhere (at level 0?).
                  flag global (level 1 2) symbols with ReUse = 1.
                  (CBULK will make Suffix _ to get "unique" C symbol)
          Mode 2: remove the entry p from the tree, replace by a new one.
                  p is known at current level and has father = pput.
          Mode 3: p is known at current level. FieldId synonymous with other
                  Id of same level.
          Mode 4: like 1, but ReUse=1 in any case ("standard word").
  OUTPUT: the new p . p^.reuse is = Mode, needed in  Cbulk / Cdeclara.
  BUGS  : If two unrelated units define differently the same symbol and are
          used together later on, the search/annex system may break down !
}
var k:integer; oldp,son:pide;  bug:boolean;
begin
  if Mode=3 then begin {field Id overrides other Id of same level}
    insertField(scope.markId, p,pput, sdat);
  end;
  if Mode=2 then begin
    rangeCheck(pput,'pput:aId'); { bug here if pput=Nil !  }
    oldp:=p; {remake the links later if Mode=2: unit global override }
    if sdat.smaller then son:=pput^.lf else son:=pput^.rg;
    bug:=(son<>oldp);
    if not bug then p^.reuse:=2;
  end else bug:=false;
  if not bug then begin
   if idereserve=nil then new(p) else begin
     p:=idereserve; idereserve:=p^.rg
   end;
   rangeCheck(p,'p:annex');
   p^:=voidId;
   with sdat,p^ do begin {annex new id to actual list}
     for k:=1 to ln do name[k]:=(src^[db-1+k]);
     if name[1]<>'_' then begin {don't twiddle those special Id's}
       name[1]:=upcase(name[1]); {==> distinct from C reserved/library items}
       if ln>1 then toLower(name[ln]); {last char to lowercase: kill "NULL"..}
     end;
     defLevel:=scope.actual;
     rscope:=scope.markId;
     qualif:=scope.currentUnit;
     if (Mode=4) or ((Mode=1) and (scope.actual<3)) then reuse:=1;
      { set ReUse of Level 0 symbols always to 1,
        so that eventual C Macros will be preserved! }
   end; {with}
   if pput=nil then with scope do pstart[actual]:=p
   else begin
    {debug} rangeCheck(pput,'pput:ann');
    if sdat.smaller then pput^.lf:=p else pput^.rg:=p;
   end;
   if Mode=2 then begin
     {debug} rangeCheck(oldp,'oldp:ann');
     error('[annexId] redefined Id?');
     p^.rg:=oldp^.rg; p^.lf:=oldp^.lf;
     hideIx:=hideIx+1; hiddenId[hideIx]:=oldp;
     p^.reuse:=hideIx; {link to the hidden Id we are replacing}
   end;
  end else begin {if bug}
    error('[annexId] linkage bug ?');
  end;
end; {annexid}

procedure treatSymbol(var ok,fatal: boolean; q,r: char; leads: boolean;
  var stat:scanStatus; var sDat:symbolData);
{ ACTION : decide if current scan data matches the (q,r) terminal symbol.
           enter legally redefined symbols into the tables.
  CALLER : CheckElem from inside BasicParser.
  INPUT  : stat: the info that has just been scanned: cc,ii,pp.
           q= expected terminal symbol, r= its extension for identifiers,
           Leads says q is leading symbol of a grammar phrase:
           severe error check required if it is Not (no backtracking).
  OUTPUT : ok is returned False for non-matching symbol .
           Fatal is set for non-recoverable mismatch.
}
var cl,clq:idClass;
    mode: integer;
    recover: boolean; {allow recover from some redefined Ids}
begin
 with stat do begin
  if ((redefKey>0) and (q='?')) then begin {legal keyword redefinition}
    cc:='?'; annexId(pp,pput, sDat, 4);
  end;
  ok:=(cc=q) or ((cc='?')and(q='&')) ;
    {cc is current scanner result % ' ? etc.,  with pp and ii}
  if ((q='?')or(q='&')) and ok then begin
      {expect identifiers: error here is never fatal ?}
    cl:=pp^.class; {may be ConstId TypeId ...}
    clq:=className[ord(r)]; {class of expected Id}
    if q='&' then begin {expect a known identifier of kind ord(r) }
      ok:=(cl=clq);
      {unexpected or new Id  may match other OR clause, so no fatal break! }
    end else begin {q='?', Id Must be Unknown, or recycling be allowed }
      recover:=false;
      ok:=(cl=otherId);
        {If not, 4 other cases of Id recycling are legal: }
      if not ok then begin
        {Proc or Funct Id may be legal if  Forward or Interface}
        if ((cl=procId)or(cl=functId)) and (cl=clq) then begin
          with pp^ do begin
            ok:=(y=2)or(y=4);  {2=Forward 4=Interface}
            { existing parameter list recycled, if new one omitted}
            if (y=4) then begin {inter-unit recycling, or intra-unit Implement}
              if (qualif<scope.currentUnit) then ReUse:=1
                 { external unit's procedures are forgotten, in current unit}
              else if scope.publicPart then begin
                Ok:=false; {illegal redeclare in same Unit header}
                recover:=true;
              end;
            end;
          end;
        end;
      end;
      if not ok then begin  {local redefinition of global is Ok}
        ok:=(scope.idLevel<scope.actual) {recycling as local Id};
        if ok then begin
           { local identifier overrides a known global with same name }
          if (scope.idLevel=0)or(pp^.reuse=1) then mode:=4 else mode:=1;
           {hard or soft ReUse: system or user-defined global}
          annexid(pp,pput, sDat, mode);
        end;
      end;
      if not ok then begin {redefinition as record fieldId is Ok}
        ok:= (clq=fieldId) and (pp^.rScope<>scope.markId);
        if ok then annexId(pp,pput, sDat, 3); {Mode 3: record field}
      end;
      if not ok then begin
         { at same level but later Unit, overwrite old symbol! }
        ok:=(pp^.qualif<scope.currentUnit); {id is in some old Unit }
        if ok then annexid(pp,pput, sDat, 2); {Mode 2 =kill old pp  }
      end;
      if not ok then begin
        error('[treatsymbol] Redefined id?');
        ok:=recover; {we might recover from this redefinition }
      end;
      pp^.class:=className[ord(r)]; {in ANY case update the class}
    end;
  end else if (not ok) and (not leads) then begin
    {truly mishandled identifier, or else cc<>q}
    fatal:=True; {very severe error at this point. }
    SyntaxBug(0,q,r, stat,sdat);
  end;
    { later: if ok then genListing(q,r, cc,ii,pp); }
 end; {with stat}
end;

procedure listtree(p:pide);
var rn,ln: pide;
begin
 if p<>nil then begin
   ln:=p^.lf; rn:=p^.rg; {left and right nodes}
   write('<'); listtree(ln); write(p^.name); listtree(rn); write('>');
 end;
end;

procedure debugTree(maxLevel:integer);
var i:integer;
begin for i:=0 to maxLevel do begin
  writeln;write(i:2,':   '); listtree(scope.pstart[i]); end;
end;

procedure killTree(p: pide; var total,depth:integer);
{ ACTION: garbage collection: binary tree of symbol table --> reserve list.
  CALLER: Semanti5.Leveldown : exit a scope level.
  INPUT : root pointer p
  OUTPUT: total=number of records. depth of the old tree.
}
var highWater,treeDepth: integer;

procedure choptree(p: pide; var dp:integer); {recursive tree destruction}
var dr,dl: integer;
begin
  if p<>nil then begin
    {debug} rangeCheck(p,'p:choptr');
    choptree(p^.rg,dr); choptree(p^.lf,dl);
    p^.rg:=idereserve; idereserve:=p;
    if dr>dl then dp:=dr+1 else dp:=dl+1;
    highWater:=highWater+1;
  end else dp:=0;
end;

begin highWater:=0;
  choptree(p,treeDepth); total:=highWater; depth:=treeDepth;
end; {killTree}

{***********   compiler directives *************}

procedure ifDirective(go:boolean);
begin
  with directive do begin
   ifLevel:=succ(ifLevel);
   ifState[ifLevel]:=go;
  end;
end;

function isDefined(s:str20): integer;
var i:integer; yes:boolean;
begin
  yes:=false; i:=1;
  with directive do begin
    while (i<=nSymb) and (not yes) do begin
      yes:=(s=defSymb[i]); i:=i+1;
    end;
  end;
  if yes then isDefined:=i-1 else isDefined:=0;
end;

procedure defDirective(c:char; s:str20);
var j,k: integer;
begin
  k:=isDefined(s);
  with directive do begin
    if (c='D')and(k=0) then begin {define}
      nSymb:=nSymb+1;
      if nSymb<=maxDefSymb then defSymb[nSymb]:=s
      else error('{$define} symbol overflow!');
    end else if (k>0) then begin {undefine}
      for j:=k to nSymb-1 do defSymb[j]:=defSymb[j+1];
      nSymb:=nSymb-1;
    end;
  end;
end;

procedure doDirective(ix:word; var texpo:word;  var ok: boolean);
{ ACTION: evaluate compiler directive starting at src^[ix] (just after $)
          Switches and Def/Undef are toggled only while Ok=true.
  CALLER: skipcomment
  OUTPUT: texpo inside same comment, on last parsed char of the directive
          Ok = T/F:  Ifdef,Ifndef,Ifopt,Else,Endif allows/forbids compilation
}
var x:word; c,d,e:char; key,arg:str20;
    i,cSwitch:integer; flag:boolean;
begin
 cSwitch:=0; {count the compiler switches}
 with directive do begin
  c:=upcase(src^[ix]); x:=ix;
  if (c>='A')and(c<='Z') then begin {else, ignore the directive}
    x:=x+1; d:=upcase(src^[x]); e:=c;
    while (d='+')or(d='-') do begin {try to get a switch sequence}
      cswitch:=cswitch+1;
      if ok then begin
        if d='+' then switch[e]:=true else switch[e]:=false;
      end;
      d:=src^[x+1]; e:=upcase(src^[x+2]);
      if (d=',') and (e>='A') and (e<='Z') then begin
        x:=x+3;d:=src^[x];
      end else d:='?';
    end; {while}
    key:=c;
    while (d>='A')and(d<='Z') do begin
      key:=key+d; x:=x+1; d:=upcase(src^[x]); {multiletter keyword}
    end;
    {debug:  write('$',key); if cswitch>0 then write(cswitch:1); }
    if key='ELSE' then begin
      ifState[ifLevel]:=not ifState[ifLevel];
    end else if key='ENDIF' then begin
      ifLevel:=ifLevel-1;
    end else if cswitch=0 then begin { an argument follows ?}
      while (d<=' ') do begin x:=x+1; d:=upcase(src^[x]) end;
      arg:='';
      while (alfanum(d)) or (d='.') do begin {admit simple file names}
        arg:=arg+d; x:=x+1; d:=upcase(src^[x])
      end;
      if key='IFOPT' then begin
        if length(arg)=1 then begin
          c:=d; d:=arg[1];
          if c='+' then flag:=switch[d] else flag:=not switch[d];
        end else flag:=false;
        IfDirective(flag);
      end else if key='IFDEF' then begin
        ifDirective(isDefined(arg)>0)
      end else if key='IFNDEF' then begin
        ifDirective(isDefined(arg)=0)
      end else if key='DEFINE' then begin
        if ok then defDirective('D',arg)
      end else if key='UNDEF' then begin
        if ok then defDirective('U',arg);
      end else if key='I' then begin
        incFile:=arg; inclusion:=ok;
      end else { if not((key='U')or(key='L')or(key='M')) then } begin
        { BUG: ignores I U L M directives}
        if ok then error('Unknown Directive: '+key);
      end;
    end;
  end;
  texpo:=x-1;
  ok:=true; {new evaluation of the If stack}
  for i:=1 to ifLevel do ok:=ok and (ifState[i]);
 end;
end;

procedure doInclude(t:word);
{ACTION: Push src^[t..size]  to the end of buffer, insert Include file,
         then glue the tail again
 INPUT:  t : file insertion just before character src^[t]
}
var j,k,inc,incmax: word;
    ix: integer; c:char; stop:boolean;
    dirname:str40; { directory in Include file name}
begin
  with directive do begin
    inclusion:=false;
    error('Why include '+incFile+'?'); {debug warning}
    j:=lbuf; {last buffer index, push the buffer tail}
    for k:=size downto t do begin src^[j]:=src^[k]; j:=j-1 end;
    inc:=t; { closed interval t..j  is room for include stuff}
    incmax:=j;
    if pos('.',incFile)=0 then incFile:=incFile+'.pas';
    ix:=length(mainFile);
    repeat c:=mainFile[ix]; stop:= (c='\')or(c=':');
      if not stop then ix:=ix-1;
    until stop or (ix<=0);  {search for directory}
    if ix>0 then dirname:=copy(mainFile,1,ix) else dirName:='';
    fillBuffer(dirName+incFile,inc,incmax);
    if inc>=incmax then begin
      error('No room to Include '+incFile);
      inc:=t; {copy the tail back to where it came from}
    end;
    j:=incmax+1; {start of tail part}
    k:=inc; { here src^[k]=#0 will be overwritten}
    while j<=lbuf do begin
      src^[k]:=src^[j]; k:=succ(k); j:=succ(j);
    end;
    size:=k-1; {the final #0 char is there}
  end;
end;

{**** (3) ****   source code scanner *************}

procedure readSource(name:str40);
{ ACTION: read source code file "name" --> memory buffer Src^
  CALLER: Pcpc.Translate
  OUTPUT: initialize global line counters and buffer pointers
}
var t:word;
begin
  t:=1; fillBuffer(name,t,lbuf);
  resetScan(name,t);
  if t>=lbuf then error('Input buffer overflow!!');
end;

procedure checkKey(var key:str40; t,lk:word; var done:boolean);
var a,s:word;
begin  {check t downto t-lk+1 }
  s:=t; a:=lk;
  while (a>0)and(upcase(src^[s])=key[a]) do begin
    a:=pred(a); s:=pred(s);
  end;
  done:=(a=0);
end;

procedure readInterface(name:str40);
{ ACTION: interface of unit "name" --> memory buffer Src^
          strip all comments except $ directives
  CALLER: Pcpc.Translate
  OUTPUT: initialize global line counters and buffer pointers
}
var b,c,d:char; s,t:word; done:boolean;
    style: integer; {style controls state machine }
       { 1=brace open 2= (* open, -1,-2: same with $, 0=normal, -3=quote open }
    source:text;
    keywd:str40; lastc:char; lkey:word;
begin
  keywd:='IMPLEMENTATION'; {stop signal}
  lkey:=length(keywd);
  lastc:=keywd[lkey];
  assign(source,name); reset(source);
  s:=1; t:=1; done:=false;
  c:=nulch; d:=nulch; {two-character lookahead: current triplet = bcd}
  style:=0;
  while not done do begin
    b:=c; c:=d;
    if eof(source) then begin d:=nulch;
      done:=(b=nulch)and(c=nulch); { end of text }
    end else if eoln(source) then begin
      readln(source); d:=lf;
      if style=-3 then style:=0; {no multiline quote}
    end else read(source,d);
    if (b='''') then begin   {take ' as a switch }
      if style=0 then style:=-3
      else if (style=-3) then style:=0;
    end else if (b='{')and(style=0) then begin {strip all comments ?}
      if c='$' then style:=-1 else style:=1;
    end else if (b='}') then begin
      if style=1 then begin style:=0; b:=nulch
      end else if style=-1 then style:=0;
    end else if (b='(')and(c='*')and(style=0) then  begin
      if d='$' then style:=-2 else begin
        style:=2; b:=nulch; c:=nulch;
      end;
    end else if (b='*')and(c=')') then begin
      if style=2 then begin style:=0; b:=nulch; c:=nulch;
      end else if style=-2 then style:=0;
    end;
    if (b=lf) or ((b<>nulch)and(style<=0)) then begin {style>0 is waste }
      src^[t]:=b; t:=succ(t); done:=(t>=lbuf);
      if (upcase(b)=lastc)and(style=0) then
        if t>lkey then checkKey(keywd,t-1,lkey,done);
    end;
  end; {while}
  src^[t]:=nulch;
  close(source);
  resetScan(name,t);
  if t>=lbuf then error('Input buffer overflow!!');
end;

procedure checkline(k:char);
begin if k=lf then begin
  otexl:=texl; texl:=succ(texpo);errline:=succ(errline)
end end;

procedure skipcomment;
{ ACTION: advances global texpo in Src^ from (* to *)
          or from openig to closing brace
          invokes the compiler directive parser and skips conditional code
          will do file inclusion later
  CALLER: skipseps
  BUG   : if Not OkToCompile, must shunt String-embedded (* ...
}
var style:integer; {state machine: 0 outside comment, 1..2 inside comment}
    k,l:char;
    endQuote:boolean; {for skipping string constants}
begin  k:=src^[texpo]; {nested comments are skipped}
  style:=0;
  repeat
    l:=src^[succ(texpo)]; {next char after k}
    if (k='{')and(style=0) then begin
      style:=1; {skip until closing brace}
      if l='$' then doDirective(texpo+2,texpo, okToCompile);
    end else if (k='(')and(l='*')and(style=0) then begin
      texpo:=succ(texpo); style:=2;
      if src^[texpo+1]='$' then doDirective(texpo+2,texpo, okToCompile);
    end else if (k='}')and(style=1) then begin
      style:=0
    end else if (k='*')and(l=')')and(style=2) then begin
      style:=0; texpo:=succ(texpo)
    end else if (style=0)and(not okToCompile)and(k='''') then begin
      {skip string, assume that any masked $IF/$ELSE part is good Pascal...}
      endQuote:=false;
      repeat k:=l; texpo:=succ(texpo); l:=src^[succ(texpo)];
        if k='''' then begin
          if l='''' then begin {quote character}
            k:=l; texpo:=succ(texpo); l:=src^[succ(texpo)];
          end else endQuote:=true;
        end;
      until endQuote;
    end else checkline(k);
    texpo:=succ(texpo); k:=src^[texpo];
  until ((style=0) and okToCompile) or(k=nulch); {end of file}
  if directive.inclusion then doInclude(texpo);
end; {skipcomment}

procedure skipseps(var k:char);
{ ACTION: skips white space in Src^. filters comments and directives.
  CALLER: basicScanner
  OUTPUT: char k is next non-separator, global texpo.
}
var sep,comme: boolean;
begin repeat k:=src^[texpo]; checkline(k);
    sep:={ (k=' ')or(k=tab)or(k=cr)or(k=lf); } (k<=' ')and(k>nulch);
    if sep then texpo:=succ(texpo);
    comme:=(k='{'); if k='(' then comme:=(src^[succ(texpo)]='*');
    if comme then begin skipcomment; sep:=true end;
  until not sep;
  k:=src^[texpo];
end;

procedure parseNumber(var k:char; var texpo:word; var i:longInt;
  var db:word; var ln:integer; var r:real; var floating:boolean);
{ ACTION: suppose a numeric constant starts at k = Src^[texpo]. Fetch it!
          gets hex numbers with $, integers, or reals.
          Here is the only floating point arith of the software (:= + * ) !
  CALLER: parseString, basicScanner.
  INPUT : k = leading character.
  OUTPUT: value i (or r if floating). scanned interval db..db+ln in Src^,
          updated texpo and k.
}
var j,pos,x,y:integer; q,p:real;
begin
  i:=0; db:=texpo; pos:=0;   floating:=false; p:=0.0;
  if k='$' then begin {hex integer}
    repeat texpo:=succ(texpo);k:=src^[texpo]; j:=-1; {digit marker}
      pos:=succ(pos);
      if (k>='0')and(k<='9') then j:=ord(k)-ord('0')
      else if (k>='a')and(k<='f') then j:=ord(k)-ord('a')+10
      else if (k>='A')and(k<='F') then j:=ord(k)-ord('A')+10;
      if j>=0 then i:=16*i+j;
    until j<0; {i is integer result}
    {if pos=1 then invalid format ! }
  end else begin {decimal numeric}
    repeat j:=ord(k)-ord('0'); i:=10*i+j; p:=10.0*p+j;
      texpo:=succ(texpo);k:=src^[texpo];
      pos:=succ(pos);
    until ((k<'0')or(k>'9')); {if NOT floating, i is valid longInt result}
    floating:=(pos>10); {we cheat somewhat}
    if (k='.')and(src^[texpo+1]<>'.')  then begin {MUST look ahead for ..}
      floating:=true; q:=1.0;
      repeat texpo:=succ(texpo);k:=src^[texpo]; j:=-1;
        if (k>='0') and (k<='9') then j:=ord(k)-ord('0');
        if j>=0 then begin q:=0.1*q; p:=p+q*j; end;
      until j<0;
    end;
    if (k='e')or(k='E') then begin floating:=true; {exponent}
      x:=1; pos:=0; y:=0;
      repeat texpo:=succ(texpo);k:=src^[texpo]; j:=-1; pos:=pos+1;
        if (pos=1) and (k='-') then begin j:=0;x:=-1; end
        else begin
          if (k>='0')and(k<='9') then j:=ord(k)-ord('0');
          if j>=0 then y:=10*y+j;
        end;
      until j<0;
      y:=x*y; {slow exponent algorithm, replace by 10^(2^n)-type }
      while y<0 do begin p:=p*0.1; y:=succ(y) end;
      while y>0 do begin p:=10.0*p; y:=pred(y) end;
    end;
  end;
  ln:=texpo-db;  if floating then r:=p; {else no change ! }
end;

procedure parseString(var texpo:word; var ln:integer; var s:textLine);
{ ACTION: suppose a string const starts at Src^[texpo]. Copy it into s.
          Parses # and ^ codes for special characters.
  CALLER: basicScanner
  OUTPUT: update texpo. ln = length.
}
var eostring,ctrlChar,ptrChar:boolean;
    k:char;
    dbx:word; ps,lnx: integer; ix:longInt; floating: boolean;  rx:real;
begin  ps:=0;
  eostring:=false; k:=src^[texpo];
  ctrlChar:=(k='#'); ptrChar:=(k='^');
  if k='''' then begin
    texpo:=succ(texpo); k:=src^[texpo];
  end; {skip quote}
  repeat
    if ctrlChar then begin {embedded control char}
      texpo:=succ(texpo); k:=src^[texpo];
      parseNumber(k,texpo, ix,dbx,lnx, rx,floating);
      if floating then ix:=0; if (ix<0)or(ix>255) then ix:=0;
      ps:=succ(ps); if ps<=maxLine then s[ps]:=chr(ix);
      ctrlChar:=(k='#'); ptrChar:=(k='^');
      eostring:=(k<>'''')and not (ctrlChar or ptrChar);
      if k='''' then begin texpo:=succ(texpo); k:=src^[texpo] end;
    end else if ptrChar then begin
      texpo:=succ(texpo); k:=src^[texpo];
      ps:=succ(ps); if ps<=maxLine then s[ps]:=chr(ord(k) mod 32);
      texpo:=succ(texpo); k:=src^[texpo];
      ctrlChar:=(k='#'); ptrChar:=(k='^');
      eostring:=(k<>'''')and not (ctrlChar or ptrChar);
      if k='''' then begin texpo:=succ(texpo); k:=src^[texpo] end;
    end else if k='''' then begin {# ^ or ' must follow}
      texpo:=succ(texpo); k:=src^[texpo];
      ctrlChar:=(k='#'); ptrChar:=(k='^');
      eostring:=(k<>'''')and not (ctrlChar or ptrChar);
      if k='''' then begin ps:=succ(ps);
        if ps<=maxLine then s[ps]:=k;
        texpo:=succ(texpo); k:=src^[texpo];
      end;
    end else begin {normal string char}
      ps:=succ(ps); if ps<=maxLine then s[ps]:=k;
      texpo:=succ(texpo); k:=src^[texpo];
    end; {if, strings may have cr,lf,... ! }
  until eostring or (k=nulch);
  ln:=ps;
end;

procedure basicScanner(var c:char; var i:longInt; var db:word;
  var ln: integer; var r:real; var isFloat:boolean; var s:textLine);
{ ACTION: fetch next item from buffer Src^. Does some recognition:
          gets char c, parses unsigned integers into i, reals into r,
          identifiers and strings (db and ln are start and length markers)
  CALLER: scanner
  INPUT : global texpo, updated.
  OUTPUT: char c is a litteral char OR a type flag of other recognized data.
}
var k:char; j:integer;
begin skipseps(k); {put k on next valid char}
  if k='^' then begin {shameless trickery: guess a control character}
    if uppercase(src^[texpo+1]) and not alfanum(src^[texpo+2]) then k:='#';
  end;
  if k=nulch then c:='$' {done with EOF}
  else if (((k>='0')and(k<='9')) or (k='$')) then begin {unsigned integer}
    c:='%'; parseNumber(k,texpo, i, db,ln, r, isFloat);
    if isFloat then begin {must copy the float number string}
      for j:=1 to ln do s[j]:=src^[db+j-1];
    end;
  end else if uppercase(k) or lowercase(k) or (underbarLegal and (k='_'))
  then begin {identifier, leading underbar is permissive Pascal }
    c:='?'; db:=texpo; ln:=0;
    repeat ln:=succ(ln);texpo:=succ(texpo);k:=src^[texpo]
    until not alfaNum(k);
    if ln>lenIde then ln:=lenIde; {truncate!}
  end else if (k='''')or(k='#') then begin {string constant follows}
    c:=''''; {ln will be length , null strings admitted}
    db:=texpo;
    parseString(texpo,ln,s);
  end else begin {neither integer nor id nor string}
    c:=k; texpo:=succ(texpo);
    if c='(' then begin
      if src^[texpo]='.' then begin { "(." becomes "[" }
        c:='['; texpo:=succ(texpo);
      end;
    end else if c='.' then begin
      if src^[texpo]=')' then begin { ".)" becomes "]" }
        c:=']'; texpo:=succ(texpo);
      end;
    end;
  end; {if}
  checkStack;
end; {basicScanner}

procedure dichotomic(d:char; var first:integer; last,n:integer);
{ ACTION: search in the alphabetic table Smb of Pascal "reserved symbols".
  CALLER: scankeywd
  INPUT : d=1st letter of a candidate identifier
  OUTPUT: First=start index in the table, for a closer look.
}
var k,l,m: integer;
begin  l:=last;
  for k:=1 to n do begin
    m:=(first+l) div 2;
    if d>gt[smb[m].ix] then first:=m else l:=m;
  end; {we guarantee that d comes AFTER first}
end;

procedure scankeywd(var c:char; db:word; ln:integer; var status:integer);
{ ACTION: identifier at Src^[db...db+ln] may be a Pascal symbol. Check!
  CALLER: scanner, after the basicScanner to intercept reserved symbols
  OUTPUT: c > #127 code of the symbol if found.
          Status =0 if Truly Reserved (BEGIN) , >0 if only pre-defined (WRITE)
}
var k,d:char; i,j,u: integer; v:word;
    found,break:boolean;
begin
  status:=0; { redefinable keyword will make this >0 }
  i:=0; k:=src^[texpo];
  if (c='.')and(k='.') then i:=1
  else if (c=':')and(k='=') then i:=2
  else if (c='>')and(k='=') then i:=3
  else if (c='<') then begin
    if k='=' then i:=4 else if k='>' then i:=5
  end; {two-letter symbols}
  if i>0 then begin texpo:=succ(texpo);c:=chr(i+127) end
  else if c='?' then begin {verify if id is a keyword}
    j:=5; d:= upcase(src^[db]);
    dichotomic(d,j,lastSymbol,4); {"fast" pre-search}
    repeat j:=succ(j);
      with smb[j] do begin break:=(len=0);
        if not break then break:=(gt[ix]>d); {we are too far}
        found:=(not break) and (ln=len) and (gt[ix]=d);
        if found then begin
          v:=db; u:=0; {offset from ix}
          repeat found:=(upcase(src^[v])=gt[ix+u]);v:=succ(v);u:=succ(u)
          until (u=len) or (not found);
        end; {if found}
      end; {with}
    until found or break;
    if found then begin c:=chr(127+j); status:=smb[j].flag; end;
  end; {if c='?'}
end; {scankeywd}

procedure qualIdent(var stat:scanStatus; var sDat:symbolData);
{ ACTION: extracts qualified identifier if we have a "." here.
          expect known Const Type Var Proc Funct Id
  CALLER: scanner
  OUTPUT: stat, sdat
}
var ok:boolean;  iUnit: byte;
begin
  if src^[texpo]='.' then begin
    texpo:=succ(texpo);
    with sDat,stat do begin
      iUnit:=pp^.x; {pp is unitId, x is the unit number}
      basicScanner(cc,ii,db,ln, rr, isFloat, chain);
      if cc='?' then begin {search identifier MUST be successful}
        searchRest(iUnit,0, standard, pp,pput, sDat);
          {do NOT search for record fieldIds here! }
        ok:=found;
      end else ok:=false;
    end; {with}
    if not ok then error('QualIdent not found!');
  end;
end;

procedure scanner(var stat:scanStatus; var sDat:symbolData);
{ ACTION: extracts the next source text item. Recognizes strings, qualified
          Ids, numbers, predefined symbols. Identifiers are looked up in the
          symbol tables, new ones are automatically inserted.
  CALLER: pcpc.BasicParser
  OUTPUT: stat, sdat
}
begin
 with sDat,stat do begin
  basicScanner(cc,ii,db,ln, rr, isFloat, chain);
  chainLen:=ln;
  scankeywd(cc,db,ln, redefKey); {search for reserved symbol}
  (* has the following dangerous side effects on pp,pput ? *)
  if redefKey>0 then begin {perhaps a redefined keyword ? }
    searchid(pp,pput, sDat);
    if found then begin cc:='?'; redefKey:=0 end; {discard as a keyword}
  end else if cc='?' then begin {classify identifier}
    searchid(pp,pput, sDat);
    if not found then annexid(pp,pput, sDat, 0); { tree insertion}
  end;
  if (cc='?')and(pp^.class=unitId) then qualIdent(stat,sDat);
 end;
end; {scanner}

{ debug code
var a,b: integer;
begin
  initPascann;
  readgram('grammar5.txt', a,b, src^);
  showGt;
}
end. {unit pascannr}
