program NestedExample;
{$R+,S+}

{uses deeply nested Pascal procedures with self- and mutual recursion,
 sort of caricature of a recursive descent parser for logical expressions.
 Nobody would write like this, it's just a test of PCPC.
 Converts stuff into reverse polish (postfix) notation.
}

type str255=string[255];

procedure parser(var s:str255);
var i,ls:integer;

 procedure nextI;
 var ok:boolean;
 begin
   repeat i:=succ(i); ok:=(i>ls);
     if not ok then ok:=(s[i]<>' ');
   until ok;
 end;

 procedure logExpr;  {logical expression: OR operator has least priority}

  function confirm(c:char):boolean;
  var ok:boolean;
  begin
    ok:=(i<=ls);
    if ok then ok:=(s[i]=c);
    if ok then nexti;
    confirm:=ok;
  end;

  procedure andExpr;  {higher binding priority for AND}

   procedure comparison;  {more priority for < > = }

    procedure mathExpr;   {at this level come  + - }

     procedure term;      { * / operations stil higher precedence }

      procedure factor;   { ^ power operator has top priority}

       procedure atom;    { absolute precedence for () [] and identifiers }

        procedure mustFind(c:char);
        begin
          if not confirm(c) then writeln('Syntax error');
        end;

        procedure letter;  { innermost procedure ! }

         procedure confirmRange(a,b:char);
         begin
           if (s[i]>=a)and(s[i]<=b) then begin
             write(' ',s[i]);
           end else writeln('Out of Range: ',s[i]);
           nexti;
         end;

        begin  {letter}
          confirmRange('A','Z');
        end;

       begin  {atom}
         if confirm('(') then begin mathExpr; mustFind(')') end
         else if confirm('[') then begin logExpr; mustFind(']') end
         else letter;
       end;

      begin {factor}
        atom;
        if confirm('^') then begin factor; write(' Pwr') end;
      end;

     begin {term}
       factor;
       if confirm('*') then begin term; write(' Mul') end;
       if confirm('/') then begin term; write(' Div') end;
     end;

    begin {mathExpr}
      term;
      if confirm('+') then begin mathExpr; write(' Add'); end;
      if confirm('-') then begin mathExpr; write(' Sub'); end;
    end;

   begin {comparison}
     mathExpr;
     if confirm('<') then begin mathExpr; write(' Lss'); end;
     if confirm('=') then begin mathExpr; write(' Equ'); end;
     if confirm('>') then begin mathExpr; write(' Gtr'); end;
   end;

  begin {andExpr}
    comparison;
    if confirm('&') then begin andExpr; write(' And'); end;
  end;

 begin  {logExpr}
   andExpr;
   if confirm('|') then begin logExpr; write(' Or'); end;
 end;

begin {parser}
  i:=0; ls:=length(s); nexti;
  logExpr;
  writeln;
end;

var test:str255;
begin
  test:='[A+D=B & B=C] | [(A+B*C+(D^E))>(F-G)] | H<I';
  writeln(test);
  parser(test);
end.
