unit killAnsi; {  (c) Copyright 1991 by  Georg Post }

{$R+,S+}    {Used by reord2.pas.  Comments: see AnsiKill.pas}

interface

var  killem: boolean; {if false, do not kill anything}
procedure initLbuffer;
procedure resetLbuffer;
procedure termLbuffer(var t:text; i0:word);
procedure fwrite(var t:text; c:char);

implementation

const killVoid=FALSE;  {very old K&R C had no "void" keyword }
type str255=string[255];{ longest source line allowed }
     headerData=record
       lbuffer: array[1..20] of str255;
       ixlbf: word; {index of line buffer}
       nstart,hstart, nstop,hstop,
        {the arg list goes from (line,column)=(nstart,hstart)...(nstop,hstop)}
       ntail,htail : word;  { position of "next" }
       next:char; {the token following the ")" }
     end;
var header: headerData; {data structure for the ANSI killer}

procedure initLbuffer;
{ ACTION: the ANSI killer machine is initialized
}
begin
  with header do begin
    ixlbf:=1; lbuffer[ixlbf]:='';
    hstart:=0;nstart:=0; hstop:=0;nstop:=0;
    ntail:=0;
  end;
end;

procedure resetLbuffer;
{ ACTION: scratch the ANSI killer's line buffer
  CALLER: putCode
}
begin
  with header do begin
    ixlbf:=0;
    hstart:=0;nstart:=0; hstop:=0;nstop:=0;
    ntail:=0;
  end;
end;

procedure termLbuffer(var t:text; i0:word);
{ ACTION: flush the ANSI killer's buffer to output file
  CALLER: putCode, cycle
}
var i:word;
begin
  with header do begin  {expect ixlbf= 2 or 3 ?}
    for i:=i0 to ixlbf do writeln(t,lbuffer[i]);
    ixlbf:=0;
    hstart:=0;nstart:=0; hstop:=0;nstop:=0;
    ntail:=0;
 end;
end;

procedure outNonAnsi(var t:text; noArgs:boolean);
{ ACTION: output an ANSI function declaration in pre-ANSI syntax
          In particular, maybe eliminate "void" keywords
  CALLER: putCode
  INPUT : s is something like "static void * Foo(arguments)"
          s[a] is the '(' , s[b] is the ')' character
}
var h,i,j,k,n, ls,ln,m, a: integer;
    c,d,lnj:char;
    bug,voidlist:boolean;
    s,name:str255;
begin
 with header do begin
  s:= lbuffer[1]; ls:=length(s); a:=hstart;
  j:=0;
  repeat {loop over all names before "("}
    repeat j:=succ(j) until (j>=a)or(s[j]>' ');
    name:='';
    if j<a then repeat
      name:=name+s[j]; j:=succ(j)
    until (s[j]=' ') or (j>=a); {first name}
    if killVoid and (name='void') then write(t,'   ') else
    write(t,name,' ');
  until j>=a;
  j:=a; write(t,'('); {j may be =ls, here! }
  repeat j:=succ(j) until (j>ls)or(s[j]>' ');
  name:='';
  k:=j;
  if k<=ls then repeat
    name:=name+s[k]; k:=succ(k)
  until (k>ls)or(s[k]=',')or(s[k]=')')or(s[k]=' '); {first parameter }
  voidList:=( name='void');
  if voidList then begin
    write(t,')');
  end else if noArgs then begin
    write(t,')'); {external function declared}
  end else begin {output the arglist with type prefixes stripped off}
    n:=nstart; j:=hstart;
    repeat  {now skip any type or type* stuff}
      ls:=length(lbuffer[n]);
      if j<ls then begin {else, do nothing}
        repeat {move to next , or ) or [] suffix }
          j:=j+1; lnj:=lbuffer[n,j];
        until (j>ls)or(lnj=',')or(lnj=')')or(lnj='['); { [] suffixes !! }
        i:=j-1;
        if i>0 then begin  {move back to start of identifier}
          while lbuffer[n,i]=' ' do i:=i-1;
          repeat i:=i-1 until (i<=0) or (lbuffer[n,i] in ['(',' ','*']);
        end;
        i:=i+1;  { interval i..j is the identifier}
        if j>ls then m:=ls else if lnj='[' then m:=j-1 else m:=j;
        for k:=i to m do write(t,lbuffer[n,k]);
        if lnj='[' then begin {  must skip the array symbol}
          repeat {move to next , or )  }
            j:=j+1; lnj:=lbuffer[n,j];
          until (j>ls)or(lnj=',')or(lnj=')');
          if j<=ls then write(t,lnj);
        end
      end else j:=j+1; {to trigger what follows}
      if j>ls then begin  {go to next line }
        n:=n+1; j:=0; writeln(t);
      end;
    until (j>0)and(lbuffer[n,j]=')');
  end;
  if not (voidlist or noArgs) then begin {dump the arg list once again}
    writeln(t);
    n:=nstart; i:=hstart+1;
    ln:=length(lbuffer[n]);
    repeat {for i:=a+1 to b do begin}
      if i<=ln then begin
        c:=lbuffer[n,i];
        if (c=',')or(c=')') then d:=';' else d:=c;
        write(t,d);
      end;
      i:=i+1;
      if i>ln then begin {next line}
        n:=n+1; i:=1; writeln(t);
        ln:=length(lbuffer[n]);
      end;
    until c=')';
  end;
  for i:=htail to length(lbuffer[ntail]) do write(t,lbuffer[ntail,i]);
  {the tail section may come at hstop+1 or 1 line later}
 end; {with}
  writeln(t);
end;

procedure oneToken(var s:str255; ls:integer; var i,j:integer;
  var symb,asterisk:boolean);
{ ACTION: extract next Symbol-or-Separator (Token) from string s.
  CALLER: findHeader, putCode
  INPUT : start parsing at s[i+1]. ls is length(s).
  OUTPUT: Symb=True on alphanumeric token.  Return i=0 if end of string,
          else i..j is the index interval of token substring.
          In any case, j>(initial i) at output
}
var stop:boolean; c:char;
begin
  symb:=false; asterisk:=false;
  repeat i:=succ(i);
    stop:=(i>ls);
    if stop then j:=i; {signal  j > stringLength}
    if not stop then stop:=(s[i]>' ');
  until stop; {skip blank space}
  if i>ls then i:=0 {nothing follows} else begin {i is on token start}
    j:=i; c:=s[j];
    stop:=c in ['(',',',';',')','{','}'];
    if stop then begin
      j:=i; {separator token end}
    end else if c in ['A'..'Z','a'..'z','_'] then begin
      symb:=true;         {word symbol}
      repeat j:=succ(j);
        stop:=(j>ls);
        if not stop then stop:= not (s[j] in ['0'..'9','A'..'Z','a'..'z','_']);
      until stop;
      j:=j-1; {j is on last letter of identifier}
    end else if c='*' then begin {pointer symbol is special}
      asterisk:=true;
    end else begin       {any other stuff}
      repeat j:=succ(j);
        stop:=(j>ls);
        if not stop then stop:= (s[j] in [' ','(',',',';',')','{','}']);
      until stop;
      j:=j-1;
    end;
  end;
end;

procedure findHeader(var s:str255; n:integer;
  var a,b,c: word; var nextChar:char);
{ ACTION: decide if the string s is line n of an ANSI function header.
          header is anything with 2..4 symbols before (, column 1 <> ' '.
          example:   static int *bla_bla( ..... )
  CALLER: putCode
  OUTPUT: a = position of "(" and b = that of ")". a=0 if no header found.
          If a>0 but b=0, header continues on next line.
          nextChar is the one following the ")": "{" or ";" .
          findHeader is repeatedly called until nextChar appears valid.
}
var i,j,ls,icount,bug: integer;
    ok, okay,aster,inArgList:boolean;
begin
  ls:=length(s);
  if n=1 then begin {go to the ( symbol on 1st line of a header}
    j:=0; icount:=0;
    ok:=(ls>0)and(s[1]<>' ');  {function declarations start at column 1 !}
    if ok then begin
      repeat    {read at most 4 symbols}
        i:=j;
        oneToken(s,ls,i,j, ok,aster);
        icount:=succ(icount)
      until (not (ok or aster)) or (icount>5);
      ok:=(icount>=3)and(icount<=5)and(i<=ls); {last char read is at i}
    end;
    if ok then  ok:=s[i]='(';
    if ok then a:=i else a:=0; {start of param list detected or not}
    inArglist:=ok; {flag that we are inside the arg list, starting at i }
  end else begin {we are on line 2,3..}
    inArglist:=(b=0); {b is 0  while closing ")" not yet detected}
    ok:=true;
    i:=0; j:=0;
  end;
  if inArglist then begin {parse the arg list, start at i+1}
    bug:=0; j:=i;
    repeat
      bug:=succ(bug);
      i:=j;
      oneToken(s,ls,i,j,okay,aster) {this "okay" is not used anywhere}
    until (j>ls) or (s[i]=')') or (bug>200);
    if bug>200 then begin writeln('Endless loop Bug');halt end;
    if (s[i]=')') then b:=i else b:=0;
    {b=0 says: header continues next line}
  end;
  c:=0; nextChar:=' ';
  if ok and (b>0) then begin {try to look beyond the ")" }
    i:=j; oneToken(s,ls,i,j, ok,aster);
    {keep track of char following the header}
    if i>0 then begin
      nextChar:=s[i]; c:=i; {position of nextChar}
    end;
  end;
end;

procedure putCode(var t:text; n: integer);
{ ACTION: flush Header.Lbuffer to file T. If killem=True, in Non-ANSI form.
          ANSI Prototypes reduce to "<type> <name>(); " declarations.
  CALLER: fwrite
  INPUT : n= last complete line in Lbuffer to be tested.
          if n=1, try to detect a header start, else a multiline header end
}
var i,j,ln: integer;
    kill,ident,aster:boolean;
begin
  with header do begin
   if not killem then begin {simply echo 1st line: }
     termLbuffer(t,1);
   end else begin
    findHeader(lbuffer[n], n, hstart,hstop,htail, next);
    if (nstop=0)and(hstop>0) then nstop:=n; {keep nb of last arglist line}
    if htail>0 then ntail:=n; {the next valid token found}
    if n=1 then begin
      if hstart=0 then begin { no header line ! }
        termLbuffer(t,1); {dump the output}
      end else nstart:=1;
    end;
    if (hstart>0)and(hstop>0)and (ntail>0) then begin
      { we do have some valid header, and a valid "next" character }
      outNonAnsi(t, next=';'); {if ; follows, "forward" declaration }
      resetLbuffer;
      if not ((next='{')or(next=';')or(next='/')) then
       writeln('Bug: Next char ="',next,'"');
    end;
   end; {if}
  end; {with header}
end;

procedure fwrite(var t:text; c:char);
{ ACTION: buffered output of character C to file T: "filtered write(t,c)".
          Uses the Header buffer to intercept ANSI syntax.
  CALLER: dumpMacro, dumpStuff, dumpBracket.
}
begin
 with header do begin
  if c<' ' then begin {all control characters are endLine marks }
    putCode(t,ixlbf); { lines in buffer are transformed and output }
    ixlbf:=ixlbf+1; lbuffer[ixlbf]:='';
  end else begin
    lbuffer[ixlbf]:=lbuffer[ixlbf]+c;
  end;
 end;
end;

end. {unit}

---------  test  code  ----------

type  str40=string[40];
var   dataDir: str40;

procedure cycle(fname:str40);
var inp,otp: text;
    ext: str40;
    ninp,notp: str255;
    lin,ix,k:word;
    ok:boolean;  c:char;
begin
  write(dataDir,fname);
  initLbuffer;     { the line buffer }
  ninp:=fname; {analyse name of input file}
  lin:=length(ninp); ix:=lin;
  repeat ix:=pred(ix) until (ninp[ix]='.')or((lin-ix)>=3)or(ix<=1);
  if ninp[ix]='.' then begin {extension found}
    ext:=copy(ninp,ix+1,lin-ix);
    notp:=copy(ninp,1,ix-1);
  end else begin
    ext:='c'; {assume .c file}
    notp:=ninp;
    ninp:=ninp+'.c';
  end;
  ext:=copy('kr'+ext,1,3); {transform c->krc  h->krh   pas->krp ...}
  notp:=notp+'.'+ext;
  assign(inp,dataDir+ninp); {$I-}  reset(inp); {$I+}
  ok:=(ioResult=0);
  if not ok then begin
    writeln(' Cannot find ',dataDir,ninp);
  end else begin
    write(' --> ',notp,' ');
    assign(otp,dataDir+notp); rewrite(otp);
    ix:=0; {buffer index}
    while not eof(inp) do begin
      if eoln(inp) then begin readln(inp); c:=#13; end else read(inp,c);
      fwrite(otp,c);
    end;
    termLbuffer(otp,1);
    close(otp);
    close(inp);
  end;
  if ok then writeln(' Ok') else writeln;
end;

var j,n: integer;
begin
  dataDir:='';
  killem:=true;
  writeln('--- From ANSI back to K&R-C ---');
  n:=paramCount;
  if n<1 then begin
    writeln ('Usage  :  ansikill <filename> ...');
  end else begin
    for j:=1 to n do cycle(paramStr(j));
  end;
end.


