/*
**                ---  simple.c ---
**
**  EXAMPLE CODE: This example is meant to be the simpliest
**  possible terminal emulator. Whatever is typed is sent out
**  over the selected serial port, and whatever is received from
**  the serial port is displayed on the screen.
**
**  This example program (not the PCL4C library) is donated to
**  the Public Domain by MarshallSoft Computing, Inc. It is
**  provided as an example of the use of the PCL4C.
**
*/

#include <stdio.h>
#include "pcl4c.h"

#define FALSE 0
#define TRUE !FALSE
#define ESC 0x1b

/*** Global Variables ***/

int Port = 0;             /* COM port # 0 ( COM1 ) */
int BaudCode = Baud2400;  /* Code for 2400 baud  */
char RxBuf[128];          /* PCL receive buffer  */


/*** Main ***/

main(argc,argv)
int argc;
char *argv[];
{
 char c;
 int i, rc;
 if(argc!=2)
   {printf("Usage: SIMPLE port\n");
    exit(1);
   }
 /* get port number from command line */
 Port = atoi(argv[1]) - 1;
 if((Port<0) || (Port>3))
     {printf("Port must be COM1 to COM4\n");
      exit(1);
     }
 /* setup transmit & receive buffer */
 ErrorCheck( SioRxBuf(Port,RxBuf,Size128) );
 /* set port parmameters */
 ErrorCheck( SioParms(Port,NoParity,OneStopBit,WordLength8) );
 /* reset the port */
 ErrorCheck( SioReset(Port,BaudCode) );

 printf("Enter terminal loop ( COM%d @ 2400 Baud )\n",1+Port);
 printf("Type ESC to quit !\n");
 /* enter terminal loop */
 while(TRUE)
     {/* was key pressed ? */
      if(SioKeyPress())
          {i = SioKeyRead();
           if((char)i==ESC)
              {/* restore COM port status & exit */
               SioDone(Port);
               exit(1);
              }
           else SioPutc(Port,(char)i);
          } /* end if */
      /* any incoming over serial port ? */
      i = SioGetc(Port,0);
      if(i>-1) SioCrtWrite((char)i);
     } /* end while */
} /* end main */

int ErrorCheck(Code)
int Code;
{/* trap PCL error codes */
 if(Code<0)
     {SioError(Code);
      SioDone(Port);
      exit(1);
     }
 return(0);
} /* end ErrorCheck */