unit toymenu;
{$R+,S+}
interface
uses Crt,Dos;
{
Colors are chosen for readable output even on monochrome video.
There are 4 menu & box styles available.
}
type str20=string[20];
     str40=string[40];
     str10=string[10];
     str80=string[80];
     str255=string[255];

procedure functionKey(var fk:integer);
procedure videoMode(t,b:byte); {set Text and Background video colors}
procedure frame(x0,y0, x1,y1, thick{1,2,3}, txt,bak: integer;
  prompt,footNote:str80);
procedure fileMenu( disc:str80; fiche: str20; var fchoice:str80);
procedure rollMenu(prompt:str80; opt:str255;
  x,y:integer; var lastchoice: integer);
procedure barMenu(prompt:str80; opt:str255; x,y:integer;
  var lastchoice: integer; refresh: boolean);
procedure tickMenu(prompt:str80; opt:str255;
  x,y:integer; var ticks:str80; var lastchoice: integer);

implementation

procedure functionKey(var fk:integer);
{ wait for  key Esc=0, f1..f10 return integer 1..10
  Cursor codes are 11..19 (numPad+10), 20=Ins, 21=Del
}
var f,g,esc:char;
begin esc:=#27; fk:=-1;
  repeat
    repeat
      f:=readkey; if f=#0 then f:=esc;
      if keyPressed then g:=readkey else g:=#0;
    until (f=esc);
    if g=#0 then fk:=0 { ESC = touche F0 }
    else if (g>=#59)and(g<=#68) then  fk:=ord(g)-58
    else if g=#72 then fk:=18  {up}
    else if g=#80 then fk:=12  {down}
    else if g=#75 then fk:=14  {left}
    else if g=#77 then fk:=16  {right}
    else if g=#82 then fk:=20  {Ins}
    else if g=#83 then fk:=21  {Del}
    else if g=#71 then fk:=17  {home}
    else if g=#79 then fk:=11  {end}
    else if g=#85 then fk:=19  {PgUp}
    else if g=#86 then fk:=13  {PgDn} ;
  until fk>=0;
end;

procedure getchar(var c:char);
begin c:=upcase(readkey); Writeln(c); end;

{**********  MSDOS stuff *************}

var regs:  registers; {must be global ?}

procedure getDate(var y,m,d,h, mn, s, fs: integer); {second, centi-second}
begin
  with regs do begin
    ax:=$2a00; msdos(regs); { date }
    y:=cx; m:=hi(dx); d:=lo(dx);
    ax:=$2c00; msdos(regs); { time }
    h:=hi(cx); mn:=lo(cx); s:=hi(dx); fs:=lo(dx);
  end;
end;

function Secondes: real;
begin
  with regs do begin
    ax:=$2c00; msdos(regs); { time }
    secondes:=3600.0*hi(cx)+60.0*lo(cx)+hi(dx) { +0.01*lo(dx)  };
  end;
end;

const maxList=100;
type  bigList=array[1..maxList] of str20;

procedure directory( disk:str80; var dirbuf:bigList);
{ returns file list from wildcard spec such as  disk='A:\PROCS\*.PAS'
  Size limit: 100 entries!
  uses hardware-specifics:   ofs,seg,ptr, msdos
}
type
   pac=packed array[1..50] of char; {Never use strings for DOS interface!}
var i,j,ldisk: integer;
   filename: pac;
   name: str20;
   fn: ^pac;
   carry: boolean;
begin
  ldisk:=length(disk);
  for i:=1 to ldisk do filename[i]:=disk[i];
  filename[ldisk+1]:=#0; {make "ASCIIZ" string}
  with regs do begin
    ax:=$2f00;
    msdos(regs); { get Disk Transfer Address es:bx }
    fn:=ptr(es,bx+30);
    ds:=seg(filename);
    dx:=ofs(filename);
    cx:=0; { null attribute: standard files }
    ax:=$4e00; msdos(regs); { search first }
    carry:=odd(flags); {error signal by DOS }
    j:=0;
    while not carry do begin
      i:=1; name:=''; { copy file name Pac -> Pascal string}
      while fn^[i]<>#0 do begin
        name:=name+fn^[i]; i:=i+1;
      end;
      j:=j+1; dirBuf[j]:=name;
      ax:=$4f00; msdos(regs); {search next }
      carry:=(odd(flags)) or (j=maxList);
    end; { while }
    if j<maxList then begin {terminate dirBuf }
      j:=j+1; dirBuf[j]:='*';
    end;
  end; { with regs  }
end;

{***************  Menu boxes ************}

procedure videoMode(t,b:byte);
begin
  textcolor(t); textbackground(b);
end;

procedure frame(x0,y0, x1,y1, thick{1,2,3}, txt,bak: integer;
  prompt,footNote:str80);
var x,y,lp:integer;
    up,low,left,right, ul,ur, ll,lr: char;
begin
  if thick=2 then begin
    up:=#205; low:=up; left:=#186;right:=left;
    ul:=#201;ll:=#200; ur:=#187;lr:=#188;
  end else if thick=1 then begin
    up:=#196; low:=up; left:=#179; right:=left;
    ul:=#218;ur:=#191; ll:=#192;lr:=#217;
  end else begin {thick=3}
    up:=#220; low:=#223; left:=#221; right:=#222;
    ul:=up; ur:=up; ll:=low; lr:=low;
  end;
  videoMode(txt,bak);
  for y:=y0 to y1 do begin
    gotoxy(x0,y);
    if y=y0 then Write(ul) else if y=y1 then Write(ll) else Write(left);
    for x:=x0+1 to x1-1 do begin
      if y=y0 then Write(up) else if y=y1 then Write(low)
      { else if init then WrC(' '); }
    end;
    gotoxy(x1,y);
    if y=y0 then Write(ur) else if y=y1 then Write(lr) else Write(right);
  end;
  lp:=length(prompt);
  gotoxy((x1-x0-lp)div 2 + x0,y0); Write(prompt);
  lp:=length(footNote);
  gotoxy((x1-x0-lp)div 2 + x0,y1); Write(footNote);
end;

type screenBox=record
       x0,y0, x1,y1, entries, nperLine, wide : integer;
       thick,ink,redInk,paper: byte;
       choice: integer; {last cursor choice}
       volatile, {if must kill it at exit}
       tickItem: boolean; {if multiple items may be checked}
       marked: set of 1..100;
     end;

procedure chkBounds(var sb:screenBox);
const xmin=1; xmax=80; ymin=1; ymax=25;
begin
  with sb do begin
    if x1<=x0 then x1:=x0+1
    else if x1>(x0+xmax-xmin) then x1:=x0+xmax-xmin;
    if x0<xmin then begin x1:=x1-x0+xmin; x0:=xmin; end
    else if x1>xmax then begin x0:=x0-x1+xmax; x1:=xmax end;
    if y1<=y0 then y1:=y0+1
    else if y1>(y0+ymax-ymin) then y1:=y0+ymax-ymin;
    if y0<ymin then begin y1:=y1-y0+ymin; y0:=ymin; end
    else if y1>ymax then begin y0:=y0-y1+ymax; y1:=ymax end;
  end;
end;

procedure popupMenu(var list:bigList; prompt,foot:str80;
  var sb:screenBox; doInput:boolean);
{ makes a window with frame rectangle x0 y0 x1 y1
 puts bigList of n items into it, nPerLine each one having Wide characters.
 allows selection with arrow, space bar toggle, RET and ESC (=cancel=0).
 Letter: search for next list item starting with that one, but doesn't select!
 Useful space per line is x1-x0-1, used: nperline * (wide+2)
 Number of lines is (entries-1)div nperline + 1
}
const ESC=#27; CR=#13; UP=#72; DN=#80; LF=#75; RT=#77;
var
   hotKey,x,y,z,i,j,oldi,lp:integer;
   c,d:char;
   help:str80;

procedure putItem(i:integer; invert: boolean);
var co,li: integer;
begin
 with sb do begin
  if invert then videoMode(black,lightgray);
  li:=y0+((i-1) div nperline)+1; co:=x0+(wide+2)*((i-1)mod nperline) +1;
  gotoxy(co,li);
  if tickItem and (i in marked) then Write(#2) else Write(' ');
  if i<=entries then Write(list[i]:wide) else Write('':wide);
  if invert then videoMode(ink,paper);
  Write(' ');
 end;
end;

begin
  chkBounds(sb);
  with sb do begin
    if entries>0 then begin
      if tickItem then
        help:='Use Arrows to move, <space> select/unselect, <ESC> exit '
      else help:='Use Arrows to move, <RET> select, <ESC> quit '
    end else help:='No data here: Press <ESC> ';
    frame(x0,y0, x1,y1, thick, redink,paper,prompt,foot);
      {init the window , textmode in highlight color now}
    gotoxy(1,25);Write(help);
    videoMode(ink,paper);
    if entries>0 then begin
      x:=nperline*((entries-1)div nperline + 1); {number of boxes, some blank}
      for i:=1 to x do putItem(i, false);
      x:=x0+1+(wide+2)*nperline;
      if x<x1 then for y:=y0+1 to y1-1 do begin {fill blank space left}
        gotoxy(x,y); for z:=x to x1-1 do Write(' ');
      end;
      if (choice>0)and(choice<=entries) then i:=choice else i:=1;
      putItem(i,true);
      if doInput then begin
       hotKey:=0;
       repeat oldi:=i; {selection loop: quit with choice, Esc , or hotkey}
        repeat c:=upcase(readkey);
          if tickItem then begin
            if c=CR then c:=' '; {CR acts as space}
          end else begin
            if c=' ' then c:='?'; {space does nothing}
          end;
        until (c=ESC)or(c=CR)or(c=#0)or(c=' ')or((c>='A')and(c<='Z'));
        if c=#0 then begin
          d:=readkey;
          if (d>=#59)and(d<=#68) then  hotKey:=ord(d)-58;
        end else d:=#0;
        if c=' ' then begin {tick/untick operation}
          if i in marked then marked:=marked-[i] else marked:=marked+[i];
          putItem(i,true);
        end else if (c>='A')and(c<='Z') then begin
          j:=i;
          repeat
            j:=succ(j); if j>entries then j:=1;
          until (upcase(list[j,1])=c) or (j=i); {round trip}
          i:=j;
        end else if d=UP then begin
          i:=i-nperLine; if i<1 then i:=i+nperline;
        end else if d=DN then begin
          i:=i+nperline; if i>entries then i:=i-nperline;
        end else if d=LF then begin
          i:=i-1; if i<1 then i:=i+1;
        end else if d=RT then begin
          i:=i+1; if i>entries then i:=i-1
        end;
        if oldi<>i then begin putItem(oldi,false);putItem(i,true); end;
       until (c=CR)or(c=ESC)or(hotKey>0);
       if hotKey>0 then choice:=-hotKey
       else if (c=ESC)and (not tickItem) then choice:=0
       else choice:=i;
      end; {if doInput}
    end else begin
      repeat c:=readkey until c=ESC; choice:=0;
    end;
    frame(x0,y0, x1,y1, thick, lightGray,paper,prompt,foot);
      {dim the window, don't clear the interior}
  end; {with sb}
  textBackground(black);
  gotoxy(1,25);Write('':length(help));
  gotoxy(1,25);  {exit with grey-on-black cursor on last line }
end; {popupMenu}

procedure fileMenu( disc:str80; fiche: str20; var fchoice:str80);
{makes a popup window for file selection with template fiche (DOS wildcards).
 If the user says ESC
 or if no file exists, fchoice='' , else fchoice = valid full path filename.
 Example call: showDir('C:\usr\Post\data', '*.MES', fname);
}
var i,k, np, lines,gotit:integer;
   note,fname,fext,nom: str20; dirbuf:bigList;
   sb:screenBox;
begin
  note:='';
  for i:=1 to length(fiche) do fiche[i]:=upcase(fiche[i]);
  if disc[length(disc)]<>'\' then disc:=disc+'\';
  directory(disc+fiche,dirbuf);
  i:=1;  fchoice:='';
  while (i<=maxList) and (dirBuf[i][1]<>'*') do i:=succ(i);
  i:=i-1; {nb of valid entries}
  if i>=maxList then note:='Too many files!'
  { else if i<=0 then note:='Press <ESC>' } ;
  with sb do begin
    tickItem:=false; thick:=2;
    paper:=black; ink:=lightgreen; redInk:=white;
    x0:=5; x1:=x0+70+1; entries:=i;
    nperline:=5; wide:=12; { 5*(12+2)=70 }
    gotit:=0;
    if i>0 then begin {files are 1...i. Put 5 names/line, 20*5=100}
      lines:=(i-1)div 5 +1;
      y0:=11-(lines div 2); y1:=y0+lines+1;
      popupMenu(dirBuf,' Files '+fiche+'  found: ',note, sb,true);
      if choice>0 then fchoice:=disc+dirBuf[choice];
    end else begin
      y0:=11;y1:=12;
      popupMenu(dirBuf,' No files '+fiche+' ! ',note,  sb,true);
    end;
  end;
end;

procedure tickMenu(prompt:str80; opt:str255; {Format: item|item|....|item }
  x,y:integer; var ticks:str80; var lastchoice: integer);
{If ticks array has chars >=' ', we have a tick menu.
  Else tick[1]= the type of the menu: #1 Bar, #2 Roll.
  lastChoice returns -1 ...-10 if F1...F10 are hit: accelerator keys?
}
var list:bigList;
    k,lk,n, dx,dy,wmin: integer;
    done,doInput:boolean; c:char;
    sb:screenBox;
begin
  k:=0;  n:=1; list[1]:='';
  repeat
    k:=k+1; done:=(k>length(opt));
    if not done then begin c:=opt[k];
      if c='|' then begin n:=n+1; list[n]:='';
      end else list[n]:=list[n]+c;
    end;
  until done;
  with sb do begin
    choice:=lastChoice;
    tickItem:=(ticks[1]>=' ');
    doInput:=(ticks[1]<>#2);
    nperline:=1;
    if tickItem then begin
      thick:=3;
      paper:=red; ink:=yellow;  redInk:=lightCyan;
    end else begin
      thick:=1;
      if (ticks[1]=#1)or(ticks[1]=#2) then begin {barMenu}
        nperline:=n;
        paper:={cyan}magenta; ink:=lightCyan; redInk:=yellow;
      end else begin  {rollMenu}
        paper:=blue; ink:=lightGreen; redInk:=yellow;
      end;
    end;
    marked:=[];
    if tickItem then for k:=1 to n do begin
      if ticks[k]>' ' then marked:=marked+[k];
    end;
    entries:=n;
    dx:=length(prompt)+1; wide:=0;
    for k:=1 to n do begin
      lk:=length(list[k]); if lk>wide then wide:=lk;
    end;
    wmin:=nperline*(wide+2)+1;
    if wmin > dx then dx:=wmin;
    if nperline=1 then dy:=n else dy:=1;
    x0:=x;y0:=y;
    y1:=y0+dy+1;
    x1:=x0+dx+1;
    popupMenu(list,prompt,'', sb,doInput);
    lastChoice:=sb.choice;
    ticks:='';
    if tickItem then for k:=1 to n do begin
      if k in marked then ticks:=ticks+'!' else ticks:=ticks+' ';
    end;
  end;
end;

procedure rollMenu(prompt:str80; opt:str255; {Format like tickMenu }
  x,y:integer; var lastchoice: integer);
var ticks:str80;
begin
  ticks:=#0;
  tickMenu(prompt,opt,x,y,ticks,lastChoice);
end;

procedure barMenu(prompt:str80; opt:str255; x,y:integer;
  var lastchoice: integer; refresh: boolean);
var ticks:str80;
begin
  if refresh then ticks:=#2 else ticks:=#1;
  tickMenu(prompt,opt,x,y,ticks,lastChoice);
end;

end.
