{
  SEMANTI6      Copyright (c) Georg Post  1991

  - semantic actions for  Post's Conservative Pascal-C Converter: PCPC
    accumulation of "knowledge" about the source code to analyse
  - relies on scanner and parser in PASCANNR and PCPCPARS
  - the main routine SemanticAction is essentially a jumbo CASE statement:
    the label (_-marker in the grammar definition) selects what to do.
  - Builds a complicated type checking network and manages intricate (that is,
    error-prone) data structures.  Beware of erratic pointers !
    System may hang if rangeCheck calls removed before all(?) bugs are dead.
}

unit semanti6;
{$S+,R+}

interface
uses pcpcdata, {global data}
     pascannr; {the source code scanner}

type bitset=array[0..15] of word; {256 bits}

var
  traceMode:boolean;
  machineInfo: record
       {things that semanticAction passes on to stackMachine}
       { ... and persistent data for successive semanticAction calls }
     offset: longint;
     frameSize: longInt;
     strings,sets,floating: boolean;
     class:char; {Bug: ambiguous with ide.class }
     ix1,ix2: integer; {for compare operators }
     cval:longInt; {ord value of last constants, length if string ?}
     bs:bitSet; {accumulates set constants}
     bs1,bs2: byte; {interval inside set}
     cName,procName :pide; {cName=Nil except for named constants }
     ctype: ptpel; {type of last const}
     nParam: integer; {counts number of OPTIONAL parameters}
     optPart: boolean;
     full: boolean; {do full part or only interface? }
  end;

procedure initSemantic;
procedure semanticAction( c:char; var stat:scanStatus;
  var ident:pide; var exprType,refType:ptpel);
procedure termSemantic;

implementation

    { Convention for pascannr.error call argument:
      - start with [procedureName] or [-labelName] to locate its origin
      - last char ? if it is a Warning only
      - last char ! for a Fatal Error
     }
const {standard type indexes}
     maxTypeIx=17;
     tbool=1; tchar=2; tbyte=3; tinte=4; tword=5;
     tlong=6; treal=7; tdoub=8; tstri=9; ttext=10;
     unipo=11; {universal pointer}
     tset=12; tshor=13;  tNull=14; {wildcard type}
     tFile=15; {untyped file}
     tcomp=16; texte=17;

       { expression stacks for types and identifiers }
type
  ptstak=^tstak;
  tstak = record t:ptpel; last:ptstak end; {stack of type pointers}
  pistak=^istak; {identifier stack}
  istak= record pi:pide; last:pistak end;
var
  ttos, treserve: ptstak; {type element stack}
  itos,ireserve: pistak; {identifier stack}
  TpParam,  {last created parameter Ptpel, hook list survives scope changes}
  TpScratch: ptpel; {start of hook list for type element heap management}
  newrec:boolean; {start of a record definition}
  newsCount,  {count number of New calls, debug}
  newenu,   {start of Enumeration type}
  nbenu: integer; {global counter of distinct Enum types}
  cide,listIde: pide; {last const, first list element, identifier}
  cplus,cminus:boolean; {sign flag of constants}
  stdType: array[1..maxTypeIx] of ptpel;  {the standard types}
  stdTide: array[1..maxTypeIx] of pide; {their identifiers}
  varspace: array[0..20] of longInt;  {local stack space per level}
  maxIdent,maxdepth: array[0..20] of integer; {for symbol tree statistics}
  heapBefore,heapAfter: longInt;

procedure makeType(i,len:integer; marq:char; id: symbol);
{ ACTION: create standard type element on the heap. Part of the init phase.
  CALLER: initSemantic
  INPUT : index, size in bytes, class marker, type name
}
begin
  new(stdType[i]);
  new(stdTide[i]);
  newsCount:=newsCount+2;
  with stdType[i]^ do begin
    cl:=marq;l:=len; m:=0; p:=nil;q:=nil; tname:=stdTide[i];
  end;
  with stdTide[i]^ do begin
    typof:=stdType[i]; name:=id; class:=typeId; y:=0;
    reUse:=0; defLevel:=0;
  end;
end;

procedure initSemantic;
{ ACTION: global var initialization of this module
  CALLER: Pcpc.Translate
}
var i:integer;
begin
  heapBefore:=memAvail;  {the 50 k source buffer already allocated ! }
  newrec:=false; newEnu:=0; {id-number of first enum type encountered}
  newsCount:=0;
  nbenu:=0;
  for i:=0 to 20 do begin
    maxIdent[i]:=0; {max number of id's used at level i}
    maxDepth[i]:=0;
    scope.tstart[i]:=Nil;
  end;
  cminus:=false; cplus:=false;
  ttos:=Nil; treserve:=Nil;
  itos:=Nil; ireserve:=Nil;
  makeType(tbool,  1,'b','Boolean        ');
  makeType(tchar,  1,'c','Char           ');
  makeType(tbyte,  1,'y','Byte           ');
  makeType(tinte,  2,'i','Integer        ');
  makeType(tword,  2,'w','Word           ');
  makeType(tlong,  4,'l','Longint        ');
  makeType(treal,  6,'r','Real           ');
  makeType(tdoub,  8,'d','Double         ');
  makeType(tstri,255,'s','String         ');
  makeType(ttext,  0,'t','Text           ');
  makeType(unipo,  4,'p','Pointer        ');
  makeType(tset,  32,'e','Set            ');
  makeType(tshor,  1,'h','Shortint       ');
  makeType(tNull,  2,'*','VAR            ');
  makeType(tFile,  0,'F','File           ');
  makeType(tcomp,  8,'k','Comp           ');
  makeType(texte, 10,'x','Extended       ');
  stdType[tstri]^.q:=stdType[tchar] ; {link string --> char }
  stdType[tstri]^.ixName:=Nil; {BUG: named string length not yet allowed! }
  stdType[unipo]^.p:=stdType[tNull] ; {universal pointer --> Null type}
  stdType[tFile]^.p:=stdType[tNull] ; {no base type}
  TpScratch:=Nil;  TpParam:=Nil;
end;

procedure newType(var pt:ptpel; ref:ptpel);
{get heap memory for a type element. If ref<>Nil, make copy}
begin
  if TpScratch<>Nil then begin
    pt:=TpScratch;
    {debug} rangeCheck(pt,'NewType');
    TpScratch:=pt^.hook;
  end else begin
    new(pt); newsCount:=newsCount+1;
  end;
  if ref<>Nil then pt^:=ref^; {init the contents, but beware of Hook! }
  with scope do begin { non-parameter type }
    pt^.hook:=tstart[actual]; tstart[actual]:=pt;
  end;
  (* pt^.hook:=TpParam; TpParam:=pt;  *)
end;

procedure newParam(var pt:ptpel); { heap memory for a parameter type }
begin
(*  if TpScratch<>Nil then begin
    pt:=TpScratch;
    {debug} rangeCheck(pt,'NewParam');
    TpScratch:=pt^.hook;
  end else *)
  new(pt); newsCount:=newsCount+1;
  pt^.hook:=TpParam; TpParam:=pt;
end;

procedure leveldown(q:pide);
{ ACTION: at exit of a block, forget latest id-scope symbol table or keep it
          for later, at q^.chain (forward declarations)
  CALLER: showStatisics, semanticAction _blockEnd _forwDecl
  OUTPUT: acts on global record Pascannr.Scope
}
var count,depth: integer;
    pt,pp: ptpel;
begin
 with scope do begin
   if q<>Nil then begin
     q^.chain:=pstart[actual];
     {forward function arg lists: keep the Id tree and type list somewhere}
     {Bug: tree and tstart[actual] may get lost later, heap cleanup problem! }
   end else begin
     killTree(pstart[actual],count,depth);
     if count>maxIdent[actual] then maxIdent[actual]:=count;
     if depth>maxDepth[actual] then maxDepth[actual]:=depth; {tree depth}
     pt:=tstart[actual];
     while pt<>Nil do begin {transfer type elements to the reserve}
       pp:=pt; pt:=pt^.hook;
       pp^.hook:=TpScratch; TpScratch:=pp;
     end;
   end;
   pstart[actual]:=nil;
   tstart[actual]:=Nil;
   actual:=pred(actual); markId:=0; {superfluous ? }
 end;
end;

procedure levelup(q:pide);
{ ACTION: scope level goes up  (just after the proc or function name)
  CALLER: semanticAction _blockEntry _implPart
}
begin
  with scope do begin actual:=succ(actual);
    if q<>Nil then pstart[actual]:=q^.chain else pstart[actual]:=nil;
      {q^.chain may still be Nil, however}
    tstart[actual]:=Nil; {irreversible loss of arg type list ? }
    recIndex:=0; recScope[recIndex]:=0;
    markId:=0;
    varSpace[actual]:=0; {no stack allocated}
  end;
end;

procedure termSemantic;
{ ACTION: kill all remaining symbols, show heap and stack statistics
  CALLER: Pcpc.Translate, to be called before termPascann
}
var break:boolean; i,n,nt,nstk:integer;
    q:ptstak; p:pistak;
    qi,ri: pistak;
    qt,rt: ptstak;
    pt,pp: ptpel;
begin
  break:=false; i:=0;   n:=0;
  heapAfter:=memAvail;
  while scope.actual>=0 do begin
    levelDown(Nil); {kill all Ids}
  end;
  repeat
    { writeln('Level=',i:2,'   Max. Symbols: ',maxIdent[i]:4,
      '  Depth: ',maxDepth[i]:4); }
    n:=n+maxIdent[i];
    i:=succ(i); break:=(i>=20) or (maxIdent[i]=0);
  until break;
  writeln(errline,' Lines.  ',n,'  Symbols.   ',
    errcount,' Errors.  ',warnCount,' Warnings.');
  if fatals>0 then writeln(fatals,'  FATAL ERRORS !');
  writeln('Heap  use: ',Lbuf+heapBefore-heapAfter);
  { writeln('       Stack use: ',(-miniStak+maxiStak),' at line ',stakLine); }
  n:=0; q:=ttos;
  while q<>Nil do begin n:=n+1;
    {dbg: write(q^.t^.cl,' '); }
    qt:=q; q:=q^.last; dispose(qt);
  end;
{ n:=0; p:=itos; while p<>Nil do begin n:=n+1; p:=p^.last; end;
  debug writeln('Ident stack waste: ',n);  -- is always 0, Ok
}
  nstk:=0;
  qi:=ireserve;
  while qi<>Nil do begin ri:=qi; qi:=ri^.last; dispose(ri); nstk:=nstk+1 end;
  qt:=treserve;
  while qt<>Nil do begin rt:=qt; qt:=rt^.last; dispose(rt); nstk:=nstk+1 end;
  nt:=0; {count collected type elements}
  pt:=TpScratch;
  while pt<>Nil do begin pp:=pt; pt:=pp^.hook; dispose(pp);nt:=succ(nt) end;
  pt:=TpParam;
  while pt<>Nil do begin pp:=pt; pt:=pp^.hook; dispose(pp);nt:=succ(nt) end;
  { write(' Type waste=',n,'.   '); }
  writeln(nt,' type elements.');
  for i:=maxTypeIx downto 1 do begin  {kill in reverse order of creation}
    dispose(stdTide[i]); dispose(stdType[i]);
  end;
end;

procedure recordup;
{ ACTION: enter a new record definition in the current scope
  CALLER: semanticAction _recordDef
  OUTPUT: gobal Pascannr.Scope
}
begin
  with scope do begin
    recIndex:=recIndex+1; maxRecords:=maxRecords+1;
    markId:=maxRecords; recScope[recIndex]:=markId;
    variantNb[recIndex]:=0; {count CASE variants if any}
    fieldOnly:=false; {search rules not restricted to field Ids}
  end;
end;

procedure recorddown;
{ ACTION: leave a record context
  CALLER: semanticAction _recordEnd
}
begin
  with scope do begin
    recIndex:=recIndex-1; markId:=recScope[recIndex];
  end;
end;

procedure setFlags(pt:ptpel);
{ pt is a first field element (Record Type). Alter the m>0 along the chain:
  If 1st one =0, add 128. If NOT isolated value, add 64. For C code generator
}
var f1,f2,prev,self,next,toobig: integer; ok:boolean; pp:ptpel;
begin
  self:=0; pp:=pt; toobig:=0; {safety against infinite loop bugs}
  if pp^.m=0 then f1:=128 else f1:=0;
  repeat ok:=pp<>Nil;
    if ok then ok:=(pp^.cl='R');
    toobig:=toobig+1; ok:=ok and (toobig<100); {arbitrary}
    if ok then begin
      prev:=self; self:=pp^.m;
      if pp^.q<>Nil then next:=pp^.q^.m else next:=0;
      if (prev<>self)and(self<>next) then f2:=0 else f2:=64;
      rangeCheck(pp,'setFlags');
      if self>0 then pp^.m:=self +f1+f2;
      pp:=pp^.q;
    end;
  until not ok;
end;

procedure pointSymbol(tp:ptpel);
{ ACTION:  look up a record type's internal number, at point operator.
  CALLER:  semanticAction _dotSymb
  INPUT :  tp references the last record type encountered
  OUTPUT:  scope.markId = the "serial number" of the record
}
var c:char;
begin          {Bug for noname records ? }
  c:=tp^.cl;
  while (c='A')or(c='L') do begin
    tp:=tp^.p; c:=tp^.cl; rangeCheck(tp,'pointSmb');
  end;
  with scope do begin
    if c='R' then begin
      markId:=tp^.tname^.chain^.rScope; {take the 1st subfield name}
      fieldOnly:=true; {is toggled back in getField}
    end else error('[pointSymbol] Dot not allowed');
  end;
end;

procedure voidSet(var s:bitSet);
var i:integer;
begin for i:=0 to 15 do s[i]:=0 end;

procedure addRange(var s:bitSet; a,b:byte);
{ if a=b, add 1 element only}
var k,p:byte;
begin
  for k:=a to b do begin
    p:=k shr 4; s[p]:=s[p] or (1 shl (k and 15));
  end;
end;

procedure setCoOp(code:integer; var stat:scanStatus);
{setConstantOperation: 0= Init, 1= add 1, 2= add interval, 3=end of set const}
var cx:longInt;
begin
  with machineInfo,stat do begin
    if code=0 then voidSet(bs)
    else if code<=2 then begin {consider integer const or char const}
      if cc='?' then cx:=pp^.x {const Id}
      else if (cc='''')and(chainLen=1) then cx:=ord(chain[1]) {char}
      else cx:=cval; {last const value parsed}
      if code=1 then begin bs1:=cx and 255; bs2:=bs1 end
      else if code=2 then bs2:=cx and 255;
      addRange(bs,bs1,bs2);
    end else ctype:=stdType[tSet];
  end;
end;

function integ(a:char): boolean;
begin integ:= a in ['h','y','i','w','l'];  end;

function bigNumb(a:char):boolean;
begin bigNumb:= a in ['r','d','k','x'] end;

function numbr(a:char): boolean;
begin numbr:=integ(a) or bigNumb(a) end;

function mayAssign(a,b:char): boolean;
{ ACTION: assignment compatibility (assign type a to var of type b "b:=a")
  CALLER: assignCheck
  INPUT : a,b type identifying letters
  BUG: relax for succ and pred functions: any integ to any Enum
       make a 2 dim array to speed things up, here !
}
var ok:boolean;
begin
  ok:=(b='s')and((a='c')or(a='s')or(a='a')); {char,string,arrayChar-->string}
  if not ok then ok:=((a='e')and(b='e')); {any sets }
  if not ok then ok:=bignumb(b) and numbr(a);
  if not ok then ok:=((b='P')and (a='p')) or ((b='p')and(a='P'));
    {NEVER both lowercase p ? genericP:=goodPtr; goodPtr:=Nil allowed !  }
  if not ok then ok:=(b='E') and integ(a);
  mayAssign:=ok;
end;

procedure runTypeChain(var t:ptpel);
{ ACTION: for subrange, val/var parameter types, get down to the original one
  CALLER: tequiv indexCompatible arithbin arithuna logop comparop manageWith
          semanticAction (near Begin) _pointTo _arrayAddr _memAlloc
  OUTPUT: updated input t
}
var class:char; goon:boolean;
begin
  repeat class:=t^.cl; goOn:=(class='S')or(class='A')or(class='L');
    if goon then begin rangeCheck(t,'t:runTpC'); t:=t^.p;  end;
  until not goon;
end;

function tequiv( t,r:ptpel):boolean;
{ ACTION: recursive check for (relaxed) type equivalence
  CALLER: comparop assignCheck checkProcPar (getField)
  INPUT : 2 pointers to  type elements
  OUTPUT: t and r are equivalent if t=r or all substrucures are equiv.
}
var eq:boolean; tloc,rloc:ptpel;
begin eq:=(t=r);
  if not eq then begin
    eq:=(t<>nil)and(r<>nil);
    if eq then begin
      tloc:=t; runTypeChain(tloc);
      rloc:=r; runTypeChain(rloc);
    end;
    if eq then eq:=(tloc^.cl=rloc^.cl)and
      (tloc^.l=rloc^.l)and(tloc^.m=rloc^.m);
    if eq then eq:=tequiv(tloc^.p,rloc^.p);
    if eq then eq:=tequiv(tloc^.q,rloc^.q);
  end; tequiv:=eq;
end;

function indexCompatible(t,r:ptpel): boolean;
{ ACTION: check compatibility of declared array index and index expression
  CALLER: semanticAction _arrayAddr
  INPUT : 2 type elements
}
var eq:boolean; tloc,rloc:ptpel; a,b:char;
begin
  tloc:=t; runTypeChain(tloc); a:=tloc^.cl;
  rloc:=r; runTypeChain(rloc); b:=rloc^.cl;
  indexCompatible:=(integ(a) and integ(b)) or     {weak integer}
   ((a='c')and(b='c')) or ((a='b')and(b='b')) or  {char, boolean}
   ((a='E')and(b='E') and(tloc^.m=rloc^.m)); { same enumerate type }
end;

procedure tpush(pt: ptpel);
{ ACTION: push pt on the type element stack (accompanies expression parsing)
  CALLER: from everywhere
}
var q:ptstak;
begin
  if treserve=nil then begin
    new(q); newsCount:=newsCount+1;
  end else begin
    q:=treserve; treserve:=treserve^.last
  end;
  {debug} rangeCheck(q,'q:tpush');
  q^.t:=pt; q^.last:=ttos; ttos:=q
end;

procedure tpop(var p:ptpel);
{ ACTION: pop type info pt from the type stack
}
var q:ptstak;
begin q:=ttos;
  {debug} rangeCheck(q,'q:tpop');
  p:=q^.t; ttos:=q^.last;q^.last:=treserve;treserve:=q;
  {debug} rangeCheck(p,'p:tpop');
end;

procedure qtpop(var p:ptpel);
{ ACTION: relaxed version of tpop without heap check, q may legally be Nil
  CALLER: semanticAction _pushParam _doCall
}
var q:ptstak;
begin q:=ttos;
  rangeCheck(q,'q:qtpop');
  p:=q^.t; ttos:=q^.last;q^.last:=treserve;treserve:=q;
end;

procedure ipush(p: pide);
{ ACTION: push identifier info p on identifier stack
  CALLER: semanticAction _paramDef,midIndex,lastIndex,newField,typeDef,
          _firstVar,nextVar
}
var q:pistak;
begin
  if ireserve=nil then begin
    new(q); newsCount:=newsCount+1;
  end else begin q:=ireserve;ireserve:=q^.last end;
  {debug} rangeCheck(q,'q:ipush');
  q^.pi:=p; q^.last:=itos; itos:=q
end;

procedure ipop(var p:pide);
{ ACTION: inverse of ipush
}
var q:pistak;
begin q:=itos;
  {debug} rangeCheck(q,'q:ipop');
  p:=q^.pi;itos:=q^.last;q^.last:=ireserve;ireserve:=q;
  {debug rangeCheck(p,'p:ipop');}
end;

procedure arithbin(c:char);
{ ACTION: type check for binary operators. Push result type on stack.
  CALLER: semanticAction _addit,subtr,multi,divis,modulo,shfLeft,shfRight
  INPUT : c= operator Add Sub Div Mult mOd
  OUTPUT: updated top of type stack
}
var ta,tb: ptpel; a,b:char; s:string[10];
    ok, floata,floatb, intega,integb: boolean;
begin tpop(ta); tb:=ttos^.t; {the 2 operand types}
  runTypeChain(ta); a:=ta^.cl;
  runTypeChain(tb); b:=tb^.cl; {types i and s only !}
  floata:=(a='r')or(a='d'); intega:=(a='y')or(a='i')or(a='w')or(a='l');
  floatb:=(b='r')or(b='d'); integb:=(b='y')or(b='i')or(b='w')or(b='l');
  ok:=(floata or intega) and(floatb or integb);
  with machineInfo do begin
    if not ok then begin
      strings:=((a='c')or(a='s'))and((b='c')or(b='s'));
      sets:=(a='e')and(b='e');
      ok:=(sets and (c in ['A','S','M'])) or (strings and (c='A'));
    end else begin
      strings:=false; sets:=false;
    end;
    if not ok then
      error('[arithbin] illegal arith ('+a+'+'+b+')')
    else begin
      floating:=floata or floatb;
      if floating then ttos^.t:=stdtype[treal] else begin
        if(a='l')or(b='l') then ttos^.t:=stdType[tlong]
        else if (a='w')or(b='w') then ttos^.t:=stdType[tword]
        else if strings then ttos^.t:=stdType[tstri]
        else if sets then ttos^.t:=stdType[tset]
        else ttos^.t:=stdtype[tinte];
      end;  {force  result to some basic type}
    end;
  end;
end;

procedure arithuna; {Addi Subi Muli Neg}
{ ACTION: check that top of type stack is Numeric
  CALLER: semanticAction _negate
}
var ta:ptpel; a:char;
begin ta:=ttos^.t;
  runTypeChain(ta); a:=ta^.cl;
  if not numbr(a) then error('[arithuna] illegal arith');
end;

procedure logop(c:char);
{ ACTION: type check for logical operations,
  CALLER: semanticAction _andLog,orLog,notLog,xorLog
  INPUT :  c= operator And Or Not Xor: extended to Integer types
  OUTPUT:  top of type stack: Boolean.
}
var ta,tb:ptpel; isBool,isInt,boolerr:boolean;
    arg1,arg2:integer; a,b:char;
begin
  arg1:=0; {no 1st arg}  a:='-';
  if (c='A')or(c='O')or(c='X') then begin
    tpop(ta); runTypeChain(ta); a:=ta^.cl;
    if a='b' then arg1:=1
    else if integ(a) then arg1:=2
    else arg1:=3;
  end;
  tpop(tb); runTypeChain(tb); b:=tb^.cl;
  if b='b' then arg2:=1
  else if integ(b) then arg2:=2
  else arg2:=3;
  isBool:=(arg1<=1)and(arg2=1);
  isInt:=((arg1=0)or(arg1=2)) and (arg2=2);
  boolErr:=not (isBool or isInt);
  if boolerr then error('[logop] '+a+b+' operands');
  if isBool then tpush(stdType[tbool]) else tpush(stdType[tword]);
end;

procedure comparop(c:char; var arg1:ptpel );
{ ACTION: check type compatibility for comparisons
          3 types of compares: Signed integers, Unsigned arbitrary types,
          strings or pacs. Pacs are filled with Null chars after valid part
  CALLER: semanticAction _equal (and 5 other compare operators)
  INPUT : c values:  Equal Unequal Greater Less grequ lessequ
          arg1: type of 1st argument
  OUTPUT: Boolean on top of type stack
}
var ta,tb:ptpel; a,b:char;
begin
  tpop(ta); runTypeChain(ta);
  a:=ta^.cl; if (a='Y') and (ta^.q^.cl='c') then a:='a'; {array of char}
  tpop(tb); runTypeChain(tb);
  b:=tb^.cl; if (b='Y') and (tb^.q^.cl='c') then b:='a';
  arg1:=tb;
  if integ(a) and integ(b) then begin {integer compare}
    machineInfo.class:='I';
  end else if numbr(a) and numbr(b) then begin
    machineInfo.class:='N';
  end else if (a='E')and(b='E')and((ta^.m)=(tb^.m)) then begin {enumerates}
    machineInfo.class:='I';
  end else if (a='a')and(b='a') then begin {array-of-char comparison}
    machineInfo.class:='A';
  end else if (a='c')or(a='s') then begin {string or char comparison}
    if (b='c')or(b='s')or(b='a') then begin
      {we allow (non-symmetric) comparison: arrayChar OP String ! }
      with machineInfo do begin class:='S'; ix1:=ta^.l; ix2:=tb^.l end;
    end else error('[comparop] String comparison')
  end else if (a='e')and(b='e') then {any sets are comparable? } begin
  end else if ( ((upcase(a)='P')and (upcase(b)='P')) or tequiv(ta,tb) )
    and ((c='U')or(c='E')) then begin {anytype = or <>}
      with machineInfo do begin class:='?'; ix1:=ta^.l; ix2:=tb^.l end;
    end
  else error('[comparop] illegal comparison');
  tpush(stdType[tbool]);
end;

procedure assignCheck(var tb,ta:ptpel; var b,a:char; var ok: boolean);
{ ACTION: check if we may assign " b := a ", strip down tb,ta to basic types
          Assignments i<-->s and (char,arrayOfChar) to a string are allowed:
          arrayChar := String IF length match; String:=ArrayChar always.
  CALLER: checkProcPar, assignment
  INPUT : 2 type elements
  OUTPUT: ok if assignment compatibility , b,a = adjusted type markers
}
var la,lb: integer;
begin
  a:=ta^.cl;  {expression type: goto sybrange or param. type}
  while (a='S')or(a='A')or(a='L') do begin  ta:=ta^.p; a:=ta^.cl end;
  if (a='Y') and (ta^.q^.cl='c') then a:='a'; {means: array of char}
  if tb^.cl='U' then tb:=tb^.p; {function result type}
  if (tb^.cl='S')or(tb^.cl='A')or(tb^.cl='L') then tb:=tb^.p;
    {subrange, var/val parameter}
  b:=tb^.cl; {destination address' type}
  ok:= (integ(a) and integ(b));
  if not ok then ok:= mayAssign(a,b) or tequiv(ta,tb);
  if not ok then if (b='Y')and(tb^.q^.cl='c') then begin
    la:=ta^.l; lb:=tb^.p^.m-tb^.p^.l+1;
    ok:=(a='s')and(la=lb); {array of char := string}
  end;
end;

procedure checkProcPar(actual,formal:ptpel);
{ ACTION: Check a parameter of procedure/function call for compatibility.
          WEAK type checking for system procedures as follows:
          VAR weak File -> Text,File,File of...
          VAR weak Integer -> all integers, char, enum, subrange, boolean.
          VAR weak String -> string of any length
          weak Char -> any 8-bit type
          weak Word -> any 16-bit type
          weak Real -> any numeric type
          VAR weak Pointer -> any pointer
  CALLER: semanticAction _pushParam
  INPUT : actual is expression result type, formal is of 'vAr' or 'vaL' type,
          formal^.p is the formal parameter's expected type.
  OUTPUT: error message
}
var act,expect:ptpel;
    weakType,byValue,ok: boolean;  a,b:char;
begin
  if formal=Nil then error('[checkProcPar] Too many params')
  else begin
    expect:=formal^.p;
    byValue:=(formal^.cl='L');
    weakType:=(formal^.m=1);
    if byValue then begin
      assignCheck(expect,actual, b,a, ok);
    end else begin {by reference}
      ok:=tequiv(expect,actual) or (expect=stdType[tNull]);
    end;
    if not ok and weakType then begin {relaxed check}
      b:=expect^.cl;
      act:=actual; runTypeChain(act); a:=act^.cl;
      if b='F' then ok:=(a='t')or(a='F')
      else if b='i' then ok:=(a in ['b','c','y','i','w','l','h','E'])
      else if b='c' then ok:=(a in ['c','y','h','E'])
      else if b='w' then ok:=(a in ['i','w'])
      else if b='r' then ok:=numbr(a)
      else if b='s' then ok:=(a='s')
      else if b='p' then ok:=(a='P')or(a='p');
    end;
    if not ok then error('[checkProcPar] param mismatch?');
  end;
end;

procedure subtypeUpdate(var start:pide);
{ ACTION: build up the data type network at the end of an Array,Record,
          Procedure, of Function declaration.
  CALLER: semanticAction _paramEnd,arrayEnd,recordEnd
  INPUT : list of items on top of type and identifier stacks.
  OUTPUT: pointer to the identifier of the declared object

 Array ,proc and record parsers leave a chain of type elements on the stack.
 They must be popped and updated in lengths and subtypes, the latest
 to be handled is marked by l=-1.
 q is a link to the follower, p is NIL or original type .
 There is a parallel chain of Identifiers, NILs for the array case .
 These id's get their Chain pointer defined, here.
 The 1st one is returned in Start.
 Values of number fields defined here:
   l  = added data length
   m  = length of an element for array
        variant number for record: 0 if prior to CASE part, else 1 2 3 ...
        0 for val/var parameters, 1 for "weakly typed" parameters.
   x  = offset for parameters
   y = order number in chain
}
var nbr,offset: longint; {offset is for framepointer-relative addressing}
    ta,oldfield:ptpel; pid,follow: pide;
    last:boolean;
begin follow:=nil;
  repeat ta:=ttos^.t; last:=(ta^.l=-1); ipop(pid);
    if pid<>nil then if pid^.chain=nil then pid^.chain:=follow;
    follow:=pid;
    {for A R L cases, pid^.typof should be = ta}
    {debug if pid<>NIL then if (pid^.typof<>ta) then write('ERR:typof<>ta!');}
    {debug  write(ta^.cl,ta^.l,'|'); }
    {ta may be subarray, subrecord or confirmed type with l>0}
    with ta^ do if l<=0 then begin {not yet confirmed A or R}
      if (cl='R')or(cl='L') then begin {record field, val parameter}
        if p<>nil then oldfield:=p else p:=oldfield;
        { if cl='R' then m:=p^.l; ? but do NOT keep length of val parameter}
        l:=p^.l;  if q<>nil then l:=l+q^.l;  {l = added lengths}
        offset:={offset} -l; pid^.x:=offset;
      end else if cl='A' then begin {var parameter}
        if p<>nil then oldfield:=p else p:=oldfield;
        { m:=2; }
        if q<>nil then l:=q^.l+2 else l:=2; {pointer is 2 bytes}
        offset:={offset}-l; pid^.x:=offset;
      end else if cl='Y' then begin {subarray}
        m:=q^.l; {length of rest array}
        if p^.cl='E' then nbr:=p^.l {order of index if enumeration}
        else if p^.cl='S' then nbr:=p^.m-p^.l+1 {subrange index}
        else error('[subtypeUpdate] illegal index type');
        l:=nbr*m;
        if (q^.cl='c')and(p^.cl='S')and(p^.l=1) then
          if p^.p^.cl='y' {shortint} then cl:='s'; {qualify a string}
      end; {record,array}
    end; {with, if}
    if not last then tpop(ta); {discard what is done}
  until last;
  start:=pid;  nbr:=1;
  while pid<>Nil do begin
    rangeCheck(pid,'Pid:stup');
    pid^.y:=nbr; nbr:=nbr+1; pid:=pid^.chain;
  end;
  {specialize array of char as 'a'? simplifArray(ttos^.t); }
end; {here top of typeStack = updated array or record type}

procedure assignment(var toWhat:ptpel);    { b <-- a }
{ ACTION: validates the assignment statement being parsed
  CALLER: semanticAction _assignmt,forInit
  OUTPUT: pops 2 items from type stack, returns type of the overwritten var.
}
var ta,tb:ptpel; a,b:char;  ok:boolean;
begin
  tpop(ta);  {expression type: goto sybrange or param. type}
  tpop(tb); { where to put the result }
  toWhat:=tb; {do NOT reduce S A L to underlying type! }
  assignCheck(tb,ta, b,a, ok);
  if ok then begin
    if integ(a) and integ(b) then begin
      with machineInfo do begin class:='I'; ix1:=ta^.l; ix2:=tb^.l end;
    end else begin {assignment compatible}
      with machineInfo do begin class:='?'; ix1:=ta^.l; ix2:=tb^.l end;
    end;
  end else begin
    error('[assignment] type conflict '+b+'<--'+a);
    machineInfo.class:='$';
  end;
end;

procedure getAddress(pp:pide);
{ ACTION: push the type of identifier pp^ onto type stack
  CALLER: semanticAction, everywhere...
              more work for code generators:
  pp points to a var or parameter id, generate code to get the addr.
  Make Actual-Lev frame pointer indirections, then add the offset in
  pp^.x, another indirection if it's a Var parameter.
  pp may be a function result identifier,too.
}
begin  tpush(pp^.typof); {new type on type ref stack}
end;

procedure getField(pp:pide);
{ ACTION: check if current field Id is compatible with selected record.
  CALLER: semanticAction _subField
  INPUT : pp is a field identifier, on top of type stack  tp: record type
  OUTPUT: update top of type stack, cancel global scope.markId
}
var i,decal:integer;
    tp:ptpel; c:char;
begin
  tp:=ttos^.t; c:=tp^.cl;
  while (c='A')or(c='L') do begin
    tp:=tp^.p; c:=tp^.cl; rangeCheck(tp,'getField');
  end;
  with pp^ do begin
    if class<>fieldId then error('[getField] No field')
    else begin {y is field's position in the subrecord chain}
      decal:=0; {each subrecord gives m=subfield length}
      for i:=1 to y-1 do {maybe we are done, on 1st entry} begin
        decal:=decal+tp^.m; if tp<>Nil then tp:=tp^.q;
      end;
      if not (tp=typof) {tequiv(tp,typof)} then begin
        error('[getField] Rec.Field not compatible');
        {debug} writeln('Y=',x,' Classes: ', tp^.cl,' ',typof^.cl);
      end;
      tp:=tp^.p; {get field type} ttos^.t:=tp;
      machineInfo.offset:=decal;
    end;
  end;
  scope.markId:=0; {cancel the record mark activated by  pointSymbol}
  scope.fieldOnly:=false;
end;

procedure manageWith(d:integer);
{ ACTION: a new With record argument is registered
  CALLER: semanticAction _withFirst,withNext
  INPUT : d= 1 for first With argument , 0 for next one
}
var ta:ptpel;
begin
  tpop(ta); runTypeChain(ta);
  with withStack do begin
    nWith:=nWith+d; {number of pending With}
    wsp:=succ(wsp);
    typ[wsp]:=ta; {record type}
    if ta^.cl<>'R' then error('[manageWith] no record argument');
    snb[wsp]:=ta^.tname^.chain^.rScope; {the record's serial number }
    nwi[wsp]:=nWith; {copy of nWith used by WithReleas}
  end;
end;

function position(var x:symbol; s:str40): integer;
{ ACTION: primitive search for x in the list s
  CALLER: enterFile
  INPUT : s string of alphanum symbols separated by ' '
  OUTPUT: 0 if x is Not one of the symbols, the ordinal number else.
}
var i,j,k,lx,ls: integer;
    goOn, found: boolean;
begin  ls:=length(s); i:=1; j:=1;
  while (x[i]>' ') and (i<lenIde) do i:=succ(i);
  if x[i]<=' ' then i:=pred(i);
  lx:=i;  {clumsy length(x) evaluation}
  k:=0; {list counter}
  repeat    k:=k+1;
    i:=1; {position in x}
    repeat goOn:=(i<=lx)and(j<=ls);
      if goOn then goOn:=(x[i]=s[j]);
      if goOn then begin i:=succ(i);j:=succ(j); end;
    until not goOn;
    found:=(i>lx)and((s[j]=' ')or(j>ls));
    if not found then begin
      while (j<ls)and(s[j]>' ') do j:=succ(j);
      if s[j]=' ' then j:=succ(j);
    end;
  until found or (j>ls);
  if found then position:=k else position:=0;
end;

procedure enterFile(var stat: scanStatus; isUnit: boolean);
{ACTION: System Unit interfaces start off at level 0, user Unit Interfaces
         at level 1, full units and programs at level 2.
         For programs, the Levelup call is after the dummy parameters.
 CALLER: semanticAction _mainFile,unitFile
}
begin
  with scope do begin
    publicPart:=isUnit; {a Unit starts with a public part}
    actual:=1;   {for Program, grows to 2 at main header }
    if isUnit then begin
      if position(stat.pp^.name,'System Crt Dos Graph ') > 0 then actual:=0;
         { scope start 0 for System,Dos,Crt,Graph units ! }
      if machineInfo.full then levelup(Nil); {want to scan Implementation part}
    end;
    currentUnit:=succ(currentUnit);
    stat.pp^.x:=currentUnit; { handle of Qualified Ids }
  end;
end;

procedure defFunct(pp:pide);
{ACTION : define new proceDure or fUnction named pp^.name. If pp^.y=2, a
          Forward declaration exists
 CALLER : semanticAction _blockEntry }
var ta:ptpel;
begin { crepush(l1); new label for the entry point}
  newType(ta,Nil); { ta is dummy if function already known! }
  tpush(ta); { ta^.q --> chain for param list, p=result type if function}
  if pp^.class=procId then ta^.cl:='D' else ta^.cl:='U';
  ta^.tname:=pp;
   { pp^.x:=l1; transferred to assembly code generator! }
   { pp^.y:=0; for normal function. will be =1 for nonimplemented,
     2: forward 3: external 4: interface}
  ta^.q:=nil;ta^.p:=nil;
  ta^.m:=0;  { number of optional parameters}
  machineInfo.nParam:=0; machineInfo.optPart:=false;
  ta^.l:=-2; {marker}
  if (pp^.y=2)or   { 4=UnitInterface->Implementation, 2=Forward}
   ((pp^.y=4)and (not scope.publicPart) and (pp^.qualif= scope.currentUnit))
   then begin
    levelup(pp);  { establish link to ancient parameter tree, for later}
    levelup(Nil); { put repeated param declaration into the waste here }
  end else begin
    pp^.typof:=ta; {pp^.typof:= another type which may override old one }
    levelup(Nil);  {The id-level goes up}
  end;
  cide:=NIL; {for chaining with parameters, see paramEnd }
end;

procedure endDeff(isFct: boolean; var ident:pide);
{ end of proc or funct definition}
{CALLER: _procEnd _functEnd}
var ta,tp,tq: ptpel;
begin {end of proc def}
  if isFct then tpop(tp); {result type}
    {address of the result = FP+l+m, on target stack}
  tpop(ta); {the proc or funct identifying type}
  ident:=ta^.tname;
  machineInfo.procName:=ident;
  with ident^ do begin
    if (y=2) or { Forward or Interface->Implementation }
     ((y=4) and (not scope.publicPart) and (qualif=scope.currentUnit))
     then begin
      {old definition overrides any new one}
      tq:=typof^.q;
      if tq<>Nil then chain:=tq^.tname else chain:=Nil;{recover via type info}
      {y:=0;  ? can be Forward once more}
      leveldown(Nil); { kill dummy scope of last param list}
    end else begin
      if isFct then ta^.p:=tp; {m:=tp^.l;}
      chain:=cide; {tname made at blockEntry}
      ta^.m:=machineInfo.nParam;
      if y=4 then y:=0; {delete memory of interface part}
    end;
  end; {with}
end;

procedure prototype(n: integer); {2:Forward 3:External 4: Interface}
{CALLER: _forwDecl _intfDecl _extDecla
}
begin
  with machineInfo do begin {no block follows}
    if full and ((n=2)or(n=4)) then begin {must keep args for later expansion}
      rangeCheck(procName,'ProtoTyp');
      leveldown(procName);  {keep arg list in a special mini-tree}
    end else leveldown(Nil);
    procName^.y:=n; {mark proc Id as FORWARD,EXTERNAL,INTERFACE}
  end;
end;

procedure callSomething(pp:pide);
{ ACTION: push the result type AND type of 1st formal parameter
  CALLER: semanticAction _procCall,functCall
}
var ta:ptpel;
begin ta:=pp^.typof; tpush(ta); tpush(ta^.q);
  if pp^.y=1 then error('Function has no C code?');
end;

procedure verifyCall;
{ ACTION: verifies a function or procedure call parameter list
  CALLER: semanticAction _doCall
}
var ta,tb:ptpel; miss:integer; err:str40;
begin
  qtpop(tb); {must be Nil if parameter list size match}
  tpop(ta); if ta^.cl='U' then tpush(ta^.p);
  if tb<>Nil then begin {count the missing parameters}
    miss:=-ta^.m; {m missing parameters are allowed! };
    while tb<>Nil do begin miss:=succ(miss); tb:=tb^.q end;
    if miss>0 then begin str(miss,err);
      error(err+' Missing parameters');
    end;
  end;
end; {for Function, result type on TOS ! }

procedure semanticAction( c:char; var stat:scanStatus;
  var ident:pide; var exprType,refType:ptpel);
{ ACTION: context-bound things the lexical and syntactical analyser ignore:
          - data type relationships, type checking for expressions,...
          - scope handling (nested procedures, records, With statements...)
          - type info extraction for the subsequent C code generator step
  CALLER: pcpc.basicParser via  cbulk.compilerAction .
  INPUT : c = action label for the Case list: one for each _-symbol of grammar.
          stat= the current scanner status
  OUTPUT: ident= last strategic identifier
          exprType= type of pending expression, at START of this procedure.
          refType=  reference type info:
            for parameter and assignment translators.
            For constants, refType is a copy of machineInfo.ctype
}
var l1,l2, ml:integer;
    ta,tb,tp,ti: ptpel;
    pi,q: pide;
    fileVar:boolean;
begin   {semanticAction}
  if traceMode then if machineInfo.full then write(' ',actionList[ord(c)]);
  if ttos<>nil then begin
    exprType:=ttos^.t; {state BEFORE applying operator!}
    runTypeChain(exprType);
  end;

  with stat do begin
    oldAction:=newAction;
    newAction:=actionName[ord(c)];
    case newAction of
    {---------------  the list of actions -----------}

pointTo   : begin tp:=ttos^.t; {generate code for pointed var}
              runTypeChain(tp); {may be var/val parameter ! }
              if (tp^.cl<>'P')and(tp^.cl<>'p') then
                error('[-pointTo] No pointer')
              else begin
                tp:=tp^.p; {get the pointed type} ttos^.t:=tp;
              end
            end;
dotSymb   : pointSymbol(ttos^.t); {restrict symbol table to fields}
subField  : {addressing a field in a record} getField(pp);
arrayAddr : begin
           {target data stack holds the index value on top, the array base addr
           beyond. Type stack holds index type on top, array type beyond.}
            tpop(tb); ta:=ttos^.t; runTypeChain(ta); {ta = array pointer}
            if ta^.cl='s' then begin {we have a string index}
              machineInfo.offset:=1; ttos^.t:=ta^.q; {char type ? }
            end else if not indexCompatible(ta^.p,tb) then
              error('[-arrayAddr] Index type')
            else begin {compatibility relaxed to admit subranges}
              ml:=ta^.m; {multiplier}
              machineInfo.offset:=ml;
              ttos^.t:=ta^.q; {subarray linkage}
            end;
           end;
getAddr   : getAddress(pp);
parAddr   : getAddress(pp);
functName : getAddress(pp); { means: tpush(pp^.typof) }
fileAddr  : getAddress(pp);
assignmt  : assignment(refType);{ checkbounds opcodes still missing!}
pushConst : begin {push last const on the stack}
             tpush(machineInfo.ctype);
            end;
pushVar   : machineInfo.offset:=ttos^.t^.l;  {for code generator }
              {Bug: length should be m for ValPars ! }
valpAddr  : begin {pp^.typof is known type, pp^.x is offset}
              getAddress(pp); { PushMem(ttos^.t^.m); }
            end;
procCall  : callSomething(pp);
functCall : callSomething(pp);
pushParam : begin { must check type compatibility here ! }
              tpop(ta); {type of actual parameter}
              qtpop(tb); tpush(tb^.q); {ongoing list of formal param. types}
              refType:=tb; {tells if formal param is vAr or vaL }
              if (tb^.cl='A')and (oldAction<>pushVar) then
                {code to be refined:  VAR arg isn't var}
                error('[-pushParam] invalid VAR par.?'); {"Lvalue required"}
              checkProcPar(ta,tb);
            end;
doCall    : verifyCall;
forInit   : {init FOR var but keep address on stack !}
            begin assignment(refType); {do not discard type/addr? }
             {DEBUG if not((b='i')or(b='y')or(b='c')or(b='e')) then
             error('[-forInit] illegal loop var.');}
            end;
comparTo  : begin machineInfo.offset:=ttos^.t^.l;tpop(ta) end;
comparDown: begin machineInfo.offset:=ttos^.t^.l;tpop(ta) end;
increment : tpop(ta);
decrement:  tpop(ta);
addit : arithbin('A');  equal  : comparop('E',refType);  andLog: logop('A');
subtr : arithbin('S');  unEqual: comparop('U',refType);  orLog: logop('O');
multi : arithbin('M');  greater: comparop('G',refType);  notLog: logop('N');
divis : arithbin('D');  less   : comparop('L',refType);
modulo: arithbin('O');  greaterEqu: comparop('g',refType);
negate: arithuna;       lessEqu : comparop('l',refType);
shfLeft:arithbin('L');     shfRight: arithbin('R'); xorLog: logop('X');
               {Procedure and Function defs}
blockEntry: defFunct(pp);
blockBegin: {action entry} begin
              machineInfo.frameSize:= varSpace[scope.actual];
            end;
blockEnd  : {block exit} begin
              machineInfo.frameSize:= varSpace[scope.actual];
              leveldown(Nil);
            end;
forwDecl  : prototype(2); {forward function prototype}
intfDecl  : prototype(4); {much like Forward}
extDecla  : prototype(3);
paramDef  : {install a new vAr or vaL parameter}
            begin newParam(ta);
              if pp^.class=varParId then ta^.cl:='A' else ta^.cl:='L';
              pp^.typof:=ta; ta^.tname:=pp;
              ttos^.t^.q:=ta; {link} ta^.q:=nil; ta^.p:=NIL;
              if ttos^.t^.l=-2 then ta^.l:=-1 else ta^.l:=0; {mark first}
              tpush(ta); ipush(pp); {so tpush is redundant ? }
              with machineInfo do if optPart then nParam:=nParam+1;
            end;
typeNull  : with ttos^.t^ do begin
              p:=stdType[tNull]; {default parameter type ! }
              m:=0; {strong typing required}
            end;
relaxTp   : if scope.actual>1 then error('duplicate : symbol?') else begin
              with ttos^.t^ do
                if (cl='A')or(cl='L') then m:=1 {flag for weak typing}
                else if cl='U' then {write('|',l,'|')};
                { ?? l= sum or arg lengths, m =nb of option parameters}
            end;
paramTp   : {install param type into last of list}
            begin tpop(ta); ttos^.t^.p:=ta; end;
paramEnd  : {end of param type}
            begin subtypeUpdate(cide); {points to 1st param}
             tpop(ta); {discard top param} ttos^.t^.l:=ta^.l
            end; {l sticks to -2 if there are no params}
procEnd   : endDeff(false,ident);
functEnd  : endDeff(true,ident);
arrayDef  : begin {create array after ARRAY symbol}
              newType(ta,Nil);ta^.cl:='Y';ta^.l:=-1;ta^.tname:=nil;
              tpush(ta)
            end;
midIndex  : begin {after , symb: get index, open subarray}
              tpop(ti) {index type};ta:=ttos^.t;ta^.p:=ti; {link index}
              newType(tb,Nil);ta^.q:=tb; tb^.l:=0;tb^.cl:='Y'; tb^.tname:=nil;
              tpush(tb); {subarray}
              ipush(NIL)
            end;
lastIndex : begin {index link after ] symbol} tpop(ti);ttos^.t^.p:=ti;
            ipush(NIL) end;
arrayEnd  : begin {arr base type on tos} tpop(tb);ttos^.t^.q:=tb;
             subtypeUpdate(listIde) end;
recordDef : begin newrec:=true; recordUp; end;
newField  : begin {a field id pp has been parsed}
             newType(ta,Nil); ta^.cl:='R'; ta^.p:=nil;ta^.q:=nil;
             ta^.m:=scope.variantNb[scope.recIndex];
             if newrec then begin ta^.l:=-1;newrec:=false end
             else begin ta^.l:=0;ttos^.t^.q:=ta end; {link with preceding}
             pp^.typof:=ta; ta^.tname:=pp; {link field id} tpush(ta);
             ipush(pp); end;
fieldType : begin {field type is on Tos}
              tpop(ta);ttos^.t^.p:=ta; {link to last subrecord}
            end;
mkVariant : with scope do variantNb[recIndex]:=succ(variantNb[recIndex]);
recordEnd : begin subtypeUpdate(listIde);
              setFlags(listIde^.typof);
              recordDown;
            end; {end record def.}
ptrDef    : begin {make pointed type after ^ symbol}
              newType(ta,Nil);ta^.cl:='P';ta^.q:=nil;ta^.l:=2;ta^.tname:=nil;
              tpush(ta)
            end;
linkTname : begin tpop(ta); ttos^.t^.p:=ta; end;
linkToPtr : begin {link to pointed type name pp, only used for forward name}
             ta:=ttos^.t; {ta is a pointer type pointing to some pp}
             if (pp^.class=typeId) and (pp^.typof<>Nil) then begin
               ta^.p:=pp^.typof; {we really had a fully defined type}
             end else begin {Bug: we still need to link ta to the name ! }
               pp^.typof:=ta; pp^.class:=forwId;  ta^.p:=Nil;
               ta^.tname:=pp; {the POINTED name, if forward class ! }
             end;   {signal to the type Id that ta is pointing to it }
            end;
typeDef   : begin  {pp^ may be a typeId OR a forwId!};
              if pp^.class=typeId then pp^.typof:=Nil; {for later...}
              ipush(pp); {if NOT typeId, typof holds valid pointer info! }
            end;
enumDef   : begin {open ( enumeration type}
              newType(ta,Nil);
              ta^.cl:='E';ta^.p:=nil;ta^.q:=nil; ta^.tname:=nil;
              cide:=nil; {for constant name chain}
              listIde:=nil; {have the 1st constant}
              newenu:=succ(newenu);ta^.m:=newenu;nbenu:=0; tpush(ta);
            end;
newConst  : begin {pp is enumerated constant}
              if cide<>nil then cide^.chain:=pp; cide:=pp;
              if listIde=nil then listIde:=pp;
              pp^.typof:=ttos^.t;nbenu:=succ(nbenu);
              pp^.x:=nbenu; pp^.y:=scope.actual;
            end;
enumEnd   : begin {end of enumeration ')'}
              ttos^.t^.l:=nbenu;
              ttos^.t^.tname:=listIde; {"name" = 1st list element ? }
            end;
subranDef : with machineInfo do begin {first const of a subrange type}
              {BUG: typecheck here: the index must be ordinal type}
              newType(ta,Nil);ta^.cl:='S';ta^.p:=ctype;
              ta^.l:=cval;ta^.q:=nil;
              ta^.tname:=nil; tpush(ta)
            end;
subranEnd : with machineInfo do begin {2nd const of a subrange}
              ta:=ttos^.t;
              {debug} rangeCheck(ta,'ta:sbrEn');
              ta^.m:=cval;
              if (ta^.l>=0)and(ta^.p^.cl='i')and(ctype^.cl='w') then
                 ta^.p:=ctype {map integer to word }
              else if ctype<>ta^.p then error('[-subranEnd] type conflict');
              if cval<ta^.l then error('[-subranEnd] illegal subrange');
              ta^.ixName:=cname; {BUG: 1st index always nameless}
            end;
typeName  : begin {ident:=pp;} tpush(pp^.typof) end;
              {type definition by identifier}
typeBool  : begin tpush(stdType[tbool]); {ident:=stdTide[tbool]} end;
typeByte  : begin tpush(stdType[tbyte]); {ident:=stdTide[tbyte]} end;
typeChar  : begin tpush(stdType[tchar]); {ident:=stdTide[tchar]} end;
typeInt   : begin tpush(stdType[tinte]); {ident:=stdTide[tinte]} end;
typeShort : begin tpush(stdType[tshor]); {ident:=stdTide[tshor]} end;
typeWord  : begin tpush(stdType[tword]); {ident:=stdTide[tword]} end;
typeLong  : begin tpush(stdType[tlong]); {ident:=stdTide[tlong]} end;
typeReal  : begin tpush(stdType[treal]); {ident:=stdTide[treal]} end;
typeDoub  : begin tpush(stdType[tdoub]); {ident:=stdTide[tdoub]} end;
typeText  : begin tpush(stdType[ttext]); {ident:=stdTide[ttext]} end;
               {..later change varId to fileId ! }
typeFile  : begin tpush(stdType[tFile]); {ident:=stdTide[tfile]} end;
typePoin  : begin tpush(stdType[unipo]); {ident:=stdTide[unipo]} end;
typeComp  : begin tpush(stdType[tcomp]); {ident:=stdTide[tcomp]} end;
typeExte  : begin tpush(stdType[texte]); {ident:=stdTide[texte]} end;
maxiStr   : begin tpush(stdType[tstri]); {ident:=stdTide[tstri]} end;
typeEnd   : begin tpop(ta); ipop(q);
             {debug} rangeCheck(q,'q:typEnd');
             if ta^.cl='P' then begin {look if we can chain to the base name}
               if ta^.tname<>Nil then q^.chain:=ta^.tname; {pointer to forwId}
               if ta^.p<>Nil then q^.chain:=ta^.p^.tname; {regular pointer}
             end else begin {regular chaining required}
               q^.chain:=listIde; {OK for record, buggy for Enum type ! }
             end;
             if q^.class=forwId then begin {now install it as typeId, and}
               q^.class:=typeId;           { reverse the pointers}
               tb:=q^.typof; {must be some pointer type}
               {debug} rangeCheck(tb,'tb:tpEnd');
               tb^.p:=ta; {pointer linking, finally }
             end;
             q^.y:=scope.actual; {type names hava a scope tag, for later}
             q^.typof:=ta ; ta^.tname:=q;
             ident:=q;
            end; {end type def}
typeStr   : begin  tpop(tb); {kill the preceding maxiStr}
              ii:=machineInfo.cval; { ii is string length}
              newType(ta,stdType[tstri]);
              if (ii<1)or(ii>255) then
                error('[-typeStr] String index <1 or >255');
              ta^.l:=ii; ta^.tname:=nil; tpush(ta);
            end;
firstVar  : begin pp^.x:=-1; ipush(pp); end;
            {1st var declaration of a given type has a negative mark}
nextVar   : begin pp^.x:=0;  itos^.pi^.chain:=pp; ipush(pp); end;
            {found another var id pp }
tpVarList : begin {var's type is on top of stack} tpop(ta);
             fileVar:=(ta=stdType[ttext]); {must touch Id class}
             repeat ipop(q); ml:=q^.x;
               if fileVar then q^.class:=fileId;
               q^.typof:=ta;q^.x:=varspace[scope.actual];
               {addr and type retrofits}
               varspace[scope.actual]:=varspace[scope.actual]+ta^.l;
             until (ml<0); {clear stack}
             ident:=q;
            end;
constIde  : cide:=pp {a const id is seen};
typConst  : begin tpop(ta);
              cide^.typof:=ta; cide^.class:=varId;
              ident:=cide;
            end; {typed constant is like a variable}
assignCon : with  machineInfo do begin {const assignment} ident:=cide; {?}
              cide^.typof:=ctype;
              cide^.x:=cval;  cide^.y:=scope.actual;
              refType:=ctype;
            end;
stringCon : with machineInfo do begin {string const of length 1 is a char}
              if chainLen<>1 then begin
                newType(ctype,stdtype[tstri]);
                ctype^.l:=chainLen;
                cval:= chainLen; { superfluous for string ?}
              end else begin ctype:=stdtype[tchar];
                cval:=ord(chain[1]);
              end;
              refType:=ctype;
            end;
plus      : cplus:=true {+ sign seen};
minus     : cminus:=true {-sign};
constRef  : with machineInfo do begin {const identifier seen}
             ctype:=pp^.typof; cval:=pp^.x;
             refType:=ctype;
             if cminus then begin cval:=-cval; cName:=Nil end else cName:=pp;
             if (cminus or cplus)and(ctype<>stdType[tinte]) then
               error('[-constRef] Sign illegal?')
            end;
intConst  : with machineInfo do begin
              cName:=Nil;
              {integer or real: BUG isFloat=FALSE, always}
              if isFloat then begin
                ctype:=stdType[treal];
              end else begin
                if (ii>=minInteg)and (ii<=maxInteg) then ctype:=stdType[tinte]
                else if (ii>=0)and(ii<=maxWord) then ctype:=stdType[tword]
                else ctype:=stdType[tlong];
              end;
              cval:=ii; if cminus then cval:=-cval;
              refType:=ctype;
            end;
endConst  : begin {end of signed const}
              cminus:=false; cplus:=false;
              refType:=machineInfo.ctype;
            end;
nilSymbol : with machineInfo do begin {NIL symbol seen}
              ctype:=stdType[unipo]; cval:=0; {universal pointer type}
              refType:=ctype;
            end;
trueSymb  : with machineInfo do begin ctype:=stdType[tbool]; cval:=1;
              refType:=ctype;
            end;
falsSymb  : with machineInfo do begin ctype:=stdType[tbool]; cval:=0;
              refType:=ctype;
            end;
tradCons  : refType:=machineInfo.ctype;
forDef    : {FOR} begin getAddress(pp); tpush(pp^.typof);
              {double on type stack!}
            end;
endRep    : tpop(ta); {BUG: type check for boolean here!}
doWhile   : tpop(ta);
caseIntv  : refType:=machineInfo.ctype; {type of the case label before ..}
caseFirst : ;
caseNext  : {???};
ifThen    : tpop(ta);
typeSet   : begin newType(ta,stdType[tset]); tpush(ta) end;
tpSetEnd  : begin tpop(tb); ttos^.t^.p:=tb; {link set->baseType} end;
setDef    : tpush(stdType[tset]);       { set handling}
interval  : tpop(ta); {should compare with ttos^.t ? }
setList   : tpop(ta);
setMake   : begin tpop(ta); if ta=stdType[tset] then tpush(ta); {empty set!}
            end;
inOper    : begin tpop(ta);tpop(tb); tpush(stdType[tbool]) end; {stub!}
formData  : begin end; {stubs}
fmtOne    : tpop(ta);
fmtTwo    : tpop(ta);
fileRef   : begin end;
doRead    : begin end;
doRdLn    : begin end;
doWrite   : begin end;
doWriLn   : begin end;
rdVar     : tpop(ta);
wrFmt     : tpop(ta);
numToStr  : begin tpop(ta);tpop(ta) end;
memAlloc  : begin tpop(ta); {want to do NEW on that type..}
              runTypeChain(ta);
              if ta^.cl<>'P' then error('[-memAlloc] no pointer arg to NEW');
            end;
withFirst : manageWith(1); {stack manager}
withNext  : manageWith(0);
withAddr  : begin getAddress(pp); {better use the With stack info here ! }
              ttos^.t:=ttos^.t^.p; {the field type is required}
              scope.markId:=0; {reset record mark, after search!}
            end;
withReleas: with withStack do begin nWith:=nWith-1;
              repeat wsp:=pred(wsp) until nwi[wsp]<=nWith; {old level}
            end;
mainFile  : enterFile(stat,false);
unitFile  : enterFile(stat,true);
intLabel  : begin end;
intJump   : begin end;
intLbDef  : begin end;
symbLabel : begin end;
symbJump  : begin end;
symbLbDef : begin end;
implPart  : begin scope.publicPart:=false; {implementation section starts here}
(*              levelup(Nil);  {like blockEntry}
*)            end;
normUnit  : begin {equivalent to blockBegin blockEnd}
(*              machineInfo.frameSize:= varSpace[scope.actual];
              leveldown(Nil);
*)            write('END');
            end;
mainPrgr  : write('END');
initUnit  : write('END');
optional  : if scope.actual>1 then error('misplaced symbol?')
            else machineInfo.optPart:=true;
tpFlEnd   : begin tpop(ta); ttos^.t^.p:=ta end;
typeCast  : begin end;
dummyTp   : tpop(ta);
doProg    : machineInfo.full:=true;
doUnit    : machineInfo.full:=true;
doIntf    : machineInfo.full:=false;
valCast   : tpop(ta); {pop off the old type. Length check here?}
getPtr    : begin tpop(ta); tpush(stdType[unipo]) end;
getSize   : begin tpop(ta); tpush(stdType[tWord]) end;
typeSize  : begin tpop(ta); ident:=ta^.tname; tpush(stdType[tWord]) end;
gotoExit  : begin end;
setcoInit : setCoOp(0,stat);
setcoOne  : setCoOp(1,stat);
setcoTwo  : setCoOp(2,stat);
setcoTerm : setCoOp(3,stat);
kwMem     : tpush(stdType[tByte]);
kwMemw    : tpush(stdType[tWord]);
kwMeml    : tpush(stdType[tLong]);
memArray  : begin tpop(ta);tpop(ta); {the 2 address expr. must be Word type}
              refType:=ttos^.t; {result type: byte/word/long}
            end;
kwPort    : tpush(stdType[tByte]);
kwPortw   : tpush(stdType[tWord]);
ioPort    : begin tpop(ta); refType:=ttos^.t; end;
ignore    : begin end;
forbidden : error('Feature has no C code.');
isMissing : begin
              if scope.actual>0 then error('meaningless "@" ?')
              else begin {@ in System unit: function without a C equivalent}
                {procName is still the one returned after procEnd..}
                rangeCheck(machineInfo.procName,'@Missing');
                machineInfo.procName^.y:=1;
              end;
            end;
    {--------------  end of the action list ---------}
    else{otherwise} end; {case}
  end; {with newAction}
end; {semantics}

begin end. {unit semantic}
