unit pcpcpars;
{$S+,R+}

interface
uses pcpcdata,
     pascannr, {the source code scanner}
     semanti6, { the semantic actions}
{    pmachine,  assembly code generator}
     cBulk;    {the C code generator}

var
  sDat:symbolData; {used for symbol table insertion }
  emergency:boolean; { Global flag: stops any of the 3 loops in BasicParser
      and CheckElem. This program is Goto- and Exit-free! }

procedure basicParser(var success: boolean; var p:integer;
  var stat: scanStatus;  mustskip,freshFile:boolean);

implementation

{ This is the syntax rule interpreter. Faster, non-recursive, memory-hungry
  parsers are tested in GRAMTOOL.PAS.
  BasicParser and Checkelem are mutually recursive routines.
  They are the switching centre of the whole translator, with 4 hooks to the
  outside world:
- Gt: grammar table compiled from the file Grammar5.txt
- Scanner:  is called whenever a fresh item of source code is needed. (New
    identifiers automatically go into the symbol table).
- TreatSymbol: checks syntax (input vs. grammarTable) and updates symbol table
    when recycling old identifiers.
- CompilerAction: triggers semantic actions and the output code generator(s).
}

const
  start='{';   {special markers in Gt the grammar table}
  termi='}';
  separ='|';
  repete='#';
  escape='_';
  nontrm='~';

procedure runto(c: char; var p:integer);
{ ACTION:  advances to the char c or to Termi symbol in Gt,
           whichever comes first at Level 0, i.e. we skip nested curly braces
  CALLER:  basicParser
  INPUT :  p index in global table Gt
  OUTPUT:  p advanced so that Gt[p] = c OR the closing brace symbol
}
var lev:integer; q:char;
begin lev:=0; q:=Gt[p];  {here, q is NOT an escape ? }
  while not((lev=0)and ((q=c)or(q=termi))) do begin
    if q=start then lev:=succ(lev)
    else if q=termi then lev:=pred(lev);
    p:=succ(p); q:=Gt[p];
    while (q=escape)or(q=nontrm) do begin p:=p+2; q:=Gt[p] end;  {skip}
  end; {while}
end;

procedure basicParser(var success: boolean; var p:integer;
  var stat: scanStatus;  mustskip,freshFile:boolean);
{ ACTION: recursive descent parser, driven by the grammar productions Gt.
  CALLER: itself via Checkelem, and Translate.
  INPUT : p is the current start symbol in grammar table Gt
          stat = current source symbol data, to be compared with Gt[p].
          mustskip is TRUE if basicParser is called for a sublist, p must
          be advanced to terminator at exit.
          freshFile tells basicParser to fetch 1st code item.
  OUTPUT: Success is set if some leading item of the production is recognized.
}

{  To make checkelem global if you wish: pass the stat parameter. }
procedure checkelem(var success:boolean; var p:integer;
  { var stat:scanStatus; } leader:boolean);
{ ACTION: check 1 entry of syntax sequence: terminals, nonterminals, sublists.
          preceding repetition symbol and trailing semantic actions are
          handled here. In Emergency case, recursions and repetitions are
          skipped . Rep symbol always succeeds.
  CALLER: BasicParser
  INPUT : like BasicParser. leading=True for director nonterminal symbol.
  OUTPUT: success if Gt[p] is recognized. Emergency if syntax error.
}
var rep, match, goAhead, inPhrase: boolean;
  lp,rp: integer; {the local p for repeating, the recursion p}
  q,r: char;
begin
  { here ,emergency always FALSE due to While loop in caller}
  rep:=(Gt[p]=repete); if rep then p:=succ(p);
  lp:=p; success:=rep; match:=false;
  inPhrase:= not (leader or rep); {the symbol MUST succeed or fail}
  repeat {loop over 0,1,2... items at lp if rep}
    p:=lp;
    q:=Gt[p]; goAhead:=false;
    if q=start then begin {sublist = implicit no-name nonterminal }
      rp:=p;
      basicParser(match, p,stat, true {mustskip}, false);
      if inPhrase and (not match) then begin
        SyntaxBug (rp, q,r, stat,sdat); emergency:=true;
      end;
    end else if q=nontrm then begin {explicit nonterminal}
      p:=succ(p); q:=Gt[p]; rp:=index[ord(q)];
      basicParser(match,rp,stat,false,false);   { recursion ! }
      if inPhrase and (not match) then begin
        SyntaxBug(0,nontrm,q, stat,sdat); emergency:=true;
      end;
    end else begin {terminal symbol}
      goAhead:=true;
      if (q='?')or(q='&') then begin p:=succ(p);r:=Gt[p] end;
      treatsymbol(match,emergency, q,r, leader or rep, stat,sDat);
        { at start of phrase, treatsymbol mismatch --> recursion backtrack }
    end;
    p:=succ(p);
    if not rep then success:=match; {a Handle is seen, else success:=true }
    while Gt[p]=escape do begin
      p:=succ(p);
      if match then begin
        compilerAction(Gt[p], stat);
        {if asmOutput then  StackMachine(Gt[p], stat) } ;
      end;
      p:=succ(p)
    end;
    if match and goAhead then begin
      scanner(stat, sDat);  { the source pointer is advanced}
      if stat.cc=#136 {BEGIN token } then write('-');
      { cc may be: % ? ' (token) (terminalSymbol) }
    end;
  until (not rep) or (not match) or (emergency);
end; {checkelem}

var  goodInput, firstAtom: boolean;
begin {basicParser: LL(1)  without backtracking}
 if freshFile then begin
   scanner(stat, sDat); {get first item}
   emergency:=False;  {reset emergency exit signal }
 end;
 {Here, we know both the next item from the input file (record Stat)
  and the grammar production set to match, at entry point p in table Gt   }
  repeat {loop over alternative clauses, i.e. the OR | symbols }
    p:=succ(p);
    firstAtom:=true; { the 1st atom of a list decides if we accept the whole}
    success:=true;
    while success and not ((Gt[p]=separ)or(Gt[p]=termi)) and (not emergency)
    do begin
        {inner loop over a sequence of (non)terminals, i.e. implicit AND}
      checkelem(goodInput, p, {stat,} firstAtom);
        {if checkelem succeeds, some input has been parsed.}
      if firstAtom then begin success:=goodInput; firstAtom:=false end;
    end; {while}
    if not success then runto(separ,p); {else we are there}
  until success or (Gt[p]=termi) or emergency;
  if success and mustskip then runto(termi,p);
end; {basicParser}

end. {unit}
