{
  PCPC.PAS  Version 1.0      Copyright (c) 1991  by Georg Post

 PCPC, Post's Conservative Pascal-C Code Converter
 translation program generating K&R C code from Turbo Pascal sources.
 Two-pass processing :
    PCPC    :   xyz.pas  -->  xyz.pc1
    REORD2  :   xyz.pc1  -->  xyz.c

Brief description : pcpcinfo.txt
User's guide      : pcpcdoc.txt
List of everything: files.txt

This file is the main loop with the "user interface"
}

program PCPC;
{$M 15000,150000,200000}
{$S+,R+}

uses pcpcdata,
     pascannr, {the source code scanner}
     semanti6, { the semantic actions}
     cBulk,    {the C code generator}
     pcpcpars, { the parser kernel}
     getUnits; { makes the network of used units }

{********   Spartan "user interface" *********}

const banner='PCPC   :  Pascal-C Converter  Vers.1.0 (1991)';
var   codeDir,dataDir:str40; {codeDir for grammar5, dataDir for *.pas}

procedure translate(srcName, Cfile: str40; keepUses:boolean;
  var nU:integer; var goOn:boolean);
{ ACTION: translation of all used Unit interfaces and of srcName.
          the global emergency flag stops the loop.
  CALLER: main prog
  INPUT : source/destination file names, keepUses if uses list needed.
  OUTPUT: if keepUses, sourceName[2]..[nU] return the non-sys units used
}
var p, entryPoint,unitPoint, nbUnits,nbSysFiles,useCount:integer;
    stat:scanStatus; success:boolean;
    path:str40;
    src:pTextBuff;
begin
  initPascann(src); { allocate file buffer on heap. actual:=0; currentUnit=0 }
  goOn:=(src<>Nil);
  if goOn then begin
   initSemantic;     { create heap data for standard types }
{  initStackMachine;  clears a label stack. Call once. }
   getUses(dataDir, srcName, nbUnits,nbSysFiles);
    {GETUNITS must read unit interface codes from 1 thru nbUnits-1 }
   write('Reading Grammar ');
   readgram(codeDir+'grammar5.txt', entryPoint,unitPoint, src^);
    {trailer from grammar file is the System Unit}
   writeln('InitTranslator');
   initCBulk(dataDir,Cfile,srcName,'PCPC 1.0');
     {opens output file. Heap init for GlobIds}
   importPart:=false; {to get less noise! }
   writeln('Parsing the System Unit');
   p:=index[ unitPoint];
   stat.newAction:=endSymb; {dummy initializer}
   basicParser(success,p,stat,false,true);  {system Ids --> level 0}
   CheaderEnd; {end of declarations which also appear in "convpac.h" }
   useCount:=0;
   repeat useCount:=useCount+1;
    importPart:=(useCount<nbUnits); {all the external declarations}
    if useCount<=nbSysFiles then path:=codeDir else path:=dataDir;
      {nbSysFiles = 0..3 according to use of Crt Dos Graph }
    write('Reading ',path,fileName[useCount]);
    if importPart then begin    {don't read all, Interface only}
      readInterface(path+fileName[useCount]);
      p:=index[unitPoint];
    end else begin       {read the whole, with comments}
      readSource(path+fileName[useCount]);
      p:=index[entryPoint]; { main Prog entry index to grammar table Gt}
    end;
    write(' Parsing: ');
    basicParser(success,p,stat,false,true);
    if importPart then CunitEnd(useCount);
    writeln;
   until (not success) or (useCount>=nbUnits) or (emergency);
   {if asmOutput then begin  writeln(object);  close(object); end;}
   termCbulk;    { close listing and cleanup for GlobIds}
   termSemantic; { neutralise ident symbol lists, tpel heap cleanup }
   termPascann;  { ide heap cleanup }
   if keepUses then transferNames(nbSysFiles,nbUnits,nU); {in GetUnits}
  end; {if goOn}
end;

{ PCPC Main Program: loop over all command line arguments. Example:
      pcpc /Pex arg1 arg2 arg3    ( optional Path and up to 9 names)
  will translate ex\arg1.pas into ex\arg1.pc1 (intermediate format)
        ....     ex\arg3.pas      ex\arg3.pc1
}
var srcName, Cfile: str40;
    iRun, nbRuns: integer; {for more than one run}
    buildAll,AnsiKill,goOn: boolean;
begin
  writeln(banner);
  waitReturn:=false;
  parameters(nbRuns, codeDir,dataDir,
    BuildAll,TraceMode,AnsiKill,UnderbarLegal);
  iRun:=1; goOn:=true;
  while (iRun<=nbRuns)and(goOn) do begin
    srcName:=sourceName[iRun] + '.pas';
    Cfile:= {dataDir +} sourceName[iRun] + '.pc1';
    translate(srcName,Cfile, (iRun=1) and buildAll, nbRuns,goOn);
    iRun:=iRun+1;
  end;
  if nbRuns<=0 then begin
    writeln('Usage  :  PCPC Options file1 [ file2 ... file9 ]');
    writeln('Options:  [/Pdatapath] [/Ccodepath] [/Trace] [/Build]');
    writeln('Note   :  Same path for ALL TP files.  Automatic .PAS suffix.');
  end;
end.
