
/*  convpac.c :   released to the Public Domain  by Georg Post (1991)

   These are the functions prototyped in convpac.h

   All you C wizards, please forgive me this code. I wanted readability
   (by Pascal programmers) even if the efficiency went down.

   In these days, megabyte-sized, processor-hogging GUI libraries get
   linked into almost every program, so efficiency is no longer an issue !?

   Test compiler:  Turbo C++ Version 1.0 .
   Compiler options which are NOT at default value:
-    MEMORY MODEL       :  LARGE
-    TEST STACK OVERFLOW:  YES
-    **ALL** ERROR & WARNING OPTIONS ON !

   Only 3 numeric types used:  short long double.  ( sizes: 2 4 8 )
   unsigned short (not K&R but most Unixes)  for Pascal Word and Byte
   unsigned char (neither K&R nor in Bourne: "The Unix System") not used.
   "Non-portable" types avoided: int float (in C, nobody knows sizeof(int))

 Use of (newfangled) <stdlib.h> amounts to 5  symbols only:
     exit free malloc rand srand.
*/

#define CONVPAC 1
#include "convpac.h"

#ifdef msDOS
#include <stdlib.h>  /* doesn't exist on old Unix */
#endif

/*  global data storage and decent stack size under Turbo C */

  Real Pi=3.1415926;
  Text Input= { stdin, "con"};
  Text Output={ stdout, "con"};
  short _paramcount;
  char * _paramstr[20]; /* room for 19 command line arguments */
  Word PrefixSeg, FreeMin;
  Integer ExitCode;
  Longint RandSeed;
  Byte FileMode;
  Pointer HeapOrg, HeapPtr, FreePtr, HeapError, ExitProc, ErrorAddr,
   SaveInt00, SaveInt02, SaveInt23, SaveInt24, SaveInt75;

#ifdef msDOS
  extern unsigned _stklen = 0xC000;
#endif

/*******  memory move and compare functions *******/
/* _mY, _cA: for arrays,strings,sets; _mR, _cR: for records */

void  _mV(char *a, char *b, short n)   /* non-overlapping memory copy */
{ short i;                         /*  Bug: for overlapping move, use memcpy */
  for (i=0;i<n;i++) a[i]=b[i];
}

void _mF(char *p, short n, char c)  /* FillChar */
{ short i; for(i=0;i<n;i++) p[i]=c; }

Boolean _mC(char h, Char *a, Char *b, short n)  /* hybrid memory compare */
/*  h is a code for the relational operator, n the array size */
/*  _mC  does some half-order, not lexical order relations ! */
/*  neither Sets nor Strings use this here  */
{ short j;
   j= -1;       /* Lo truncates sign byte ( & 0xFF) for unsigned compare */
   switch(h) {
   case 'G': do j++; while ((j<n) && (Lo(a[j]) >  Lo(b[j]))); break;
   case 'L': do j++; while ((j<n) && (Lo(a[j]) <  Lo(b[j]))); break;
   case 'g': do j++; while ((j<n) && (Lo(a[j]) >= Lo(b[j]))); break;
   case 'l': do j++; while ((j<n) && (Lo(a[j]) <= Lo(b[j]))); break;
   case 'E': do j++; while ((j<n) && (a[j] == b[j])); break;
   case 'U': do j++; while ((j<n) && (a[j] == b[j])); break;
   }
   if (h=='U') return (j<n); /* one comparison failed*/
   else return (j>=n);      /* all comparisons successful */
}

Boolean _cL(char h, char *a, char *b, short n)
/*  Compare Lexical: h = GLglEU: skip equals, decide on 1st difference */
/*  operates on Strings and Arrays of Char  */
{ short j= -1;
   do j++; while ((j<n) && (a[j] == b[j]));
   switch(h) {
   case 'G': return ((j<n) && (Lo(a[j]) >  Lo(b[j])));
   case 'L': return ((j<n) && (Lo(a[j]) <  Lo(b[j])));
   case 'g': return ((j==n) || (Lo(a[j]) > Lo(b[j])));
   case 'l': return ((j==n) || (Lo(a[j]) < Lo(b[j])));
   case 'E': return (j>=n);
   case 'U': return (j<n);
   }
}

/******  set functions *******
*
*  set elements are either Bytes (0..255) or Chars (-128..127)
*  To account for negative chars, some dubious " & 255 " trickery here
*/

Boolean _cE(char h, Set a, Set b)  /* bitset compare */
/*  h is opcode g l E U : example g is (a>=b) <==> (a*b = b) */
{ short j= -1;
   switch(h) {
   case 'g': do j++; while ((j<16) && ((a[j] & b[j]) == b[j])); break;
   case 'l': do j++; while ((j<16) && ((a[j] & b[j]) == a[j])); break;
   case 'E': do j++; while ((j<16) && (a[j] == b[j])); break;
   case 'U': do j++; while ((j<16) && (a[j] == b[j])); break;
   default : printf("\nUnknown set operator: %s\n",h); exit(3);
   }
   if (h=='U') return (j<16); /* one comparison failed*/
   else return (j>=16);      /* all comparisons successful */
}

Word * _eU(Set s, Set a, Set b)  /* set union */
{ short k;
  for(k=0;k<16;k++) s[k]= a[k] | b[k];
  return s;
}

Word * _eI(Set s, Set a, Set b)   /* set intersection */
{ short k;
  for(k=0;k<16;k++) s[k]= a[k] & b[k];
  return s;
}

Word * _eD(Set s, Set a, Set b)   /* set difference */
{ short k;
  for(k=0;k<16;k++) s[k]= a[k] - (a[k] & b[k]);
  return s;
}

Word * _eV(Set s)           /* void (empty) set */
{ short k;
  for(k=0;k<16;k++) s[k]=0;
  return s;
}

/*
Word * _eC(Set s, short nb)   //  set constructor: NOT USED
{ short k, x,y;
  y=Hi(nb); x=Lo(nb); if (y<x) y=x;             // set interval x..y
  for(k=x;k<=y;k++) s[k>>4] |= (1 <<(k & 15));  // better bit[k & 15] ?
  return s;
}
*/

Word * _eE_(Set s, short n)   /*  add 1 set element */
{ if((n>= -128)&&(n<=255)) s[(n & 255)>>4] |= (1 <<(n & 15));
  return s;
}

Boolean _eIn(short x,Set s)
{ if((x>= -128)&&(x<=255)) return (s[(x & 255)>>4] & (1 <<(x & 15))) != 0;
  else return 0;
}

Word * _eR_(Set s, short x, short y)   /*  add interval to set */
{ short k;
  if((x>= -128)&&(y<=255))  /*  bug for char interval like #120..#140 ??  */
   { for(k=x;k<=y;k++) s[(k & 255)>>4] |= (1 <<(k & 15)); };
  return s;
}

/*********  string functions **********/

short Length(char *s)   /* strlen with cut at 255 */
{ short i=0;
  while ((i<255)&&(s[i]!='\0')) i++;
  return i;
}

Boolean _cS(char h, char *a, char *b)   /*string compare  */
{ short n= Length(a)+1; /* include the final \0 in the test */
  return _cL(h, a, b,n);
}

char * _sI(char *s, char *t)  /* strcpy, cut at 255 */
{ char c; short i=0;
  do {c=t[i];s[i]=c;i++;} while ((i<=255)&&(c!='\0'));
  return s;
}

char * _sM(char *s, char *t, short n) /* strcpy cut at n */
{ char c; short i=0;
  do {c=t[i];s[i]=c;i++;} while ((i<=n)&&(c!='\0'));
  if (i>n) s[n]='\0';
  return s;
}

char * _sS(char *s, char *t)  /* strcat, cut at 255 */
{ char c; short i,k;
  i=Length(s); k=0;
  do {c=t[k];s[i]=c;i++;k++;} while ((i<=255)&&(c!='\0'));
  return s;
}

char * _sK(String s, char k) /* init string with char */
{ s[0]=k; s[1]='\0'; return(s); }

char * _sL(char k, String s)
/* like _sK in reverse order, result=string address */
{ s[0]=k; s[1]='\0'; return(s); }

char * _sC(String s, char k) /* add k to s */
{ short i;
  i=Length(s); s[i]=k; s[i+1]='\0'; return(s);
}

char * _sY(char *a, char *b, short n) /* add Array b to string a */
{ short i,k;
  i=Length(a);
  for (k=0;k<n;k++) {a[i]=b[k]; i++;};
  a[i]='\0'; return(a);
}

char * _sA(char *a, char *b, short n) /* String a = n chars from array b */
{ short i;
  for (i=0;i<n;i++) a[i]=b[i]; a[n]='\0'; return(a);
}

char UpCase(char c)
{ char x;
  if ((c>='a')&&(c<='z')) x=(char)((short)c - 32); else x=c;
  return x;
}

void Insert(String source,String s,short ix) /* INS source INTO s AT ix */
{ short i,j,k;
  i=Length(s); j=Length(source);
  if ((i+j)>255) j=255-i; /* maximum that fits ! */
  for(k=i;k>=(ix-1); k--) s[k+j]=s[k];    /* shift [ix-1...i] */
  for(k=0;k<j; k++) s[ix-1+k]=source[k];  /* do insertion */
}

void Delete(String s,short ix,short count)
{ short i,j,k,n;
  i=Length(s);
  if (ix<=i) {
    if ((ix+count-1)>i) n=i-ix+1; else n=count; /* n = truncated count */
    j=ix+n-1;
    for(k=j;k<=i;k++) s[k-n]=s[k]; /* null termination is copied */
  }
}

char *Copy(String aux,String s,short ix,short count)
{ short i,k,n;
  i=Length(s);
  if (ix<=i) {
    if ((ix+count-1)>i) n=i-ix+1; else n=count; /* n = truncated count */
    for(k=0;k<n;k++) aux[k]=s[k+ix-1];
  } else n=0;
  aux[n]='\0';
  return aux;
}

Byte Pos(char *sub, char *st)  /* Position of substring sub inside st */
{
  Boolean Ok,Fit;
  Integer Ls,Lsub,I,J,K;
  Lsub = Length(sub);
  Ls = Length(st);
  Fit = (Ls > 0) && (Lsub > 0) && (Lsub <= Ls);
  if(Fit) {
    I = 0;
    do {
      I = I+1;  K = I;  J = 1;
      do {
        Ok = (sub[J-1] == st[K-1]);
        J = J+1;  K = K+1;
      } while((J <= Lsub) && (K <= Ls) && Ok);
      Fit = Ok && (J > Lsub);
    } while( !Fit && ((I+Lsub) <= Ls));
  }
  if(Fit) return I; else return 0;
}

void Val(String s, short *v, Integer *code)
{ short n;
  n=sscanf(s, " %hd", v);
  if (n==1) *code = 0;  else *code= 1;
}

void VAl(String s, long *v, Integer *code)
{ short n; n=sscanf(s, " %ld", v);
  if (n==1) *code = 0;  else *code= 1;
}

void VaL(String s, Real *v, Integer *code)
{ short n; n=sscanf(s, " %lf", v);
  if (n==1) *code = 0;  else *code= 1;
}

/********  heap and file functions ********/

Pointer NeW(Word s)
{ Pointer p=(Pointer)malloc(s);
  if (p==NULL) { printf("\nHeap overflow: malloc()==NULL\n"); exit(3); }
  else return(p);
}

void DisposE(Pointer p) {free(p);}
/*  I resist  the temptation:
#define Dispose free
    so that PCPC output doesn't need to read <stdlib.h>.
*/

void GEtMem(Pointer *p, Word n)  { *p = NeW(n); }
void FReeMem(Pointer *p, Word n) { free(*p); *p = NULL; }  /* n unused! */

Longint MemAvail(void) /* free core left, in units of 1000, max 1 Mega */
{ short i,j;
  char * p[40];
  unsigned k=32000;
  long total=0;
  i=0;
  do {   /* catch as catch can */
    i++; p[i]= (char*)malloc(k);
    if (p[i] != NULL) total+=k;
    if (i>30) k=k / 2;   /* grasp 30 times 32K, then smaller chunks */
  } while (k>=1000);
  for (j=i;j>0;j--) {if (p[j] != NULL) free(p[j]); };  /* forget it */
  return total;
}

void HalT(void)   { exit(1); }
void Halt(short n)  { exit(n); }

static short _ioresult;
short IoResult(void) { return _ioresult; }

static void FileTrap(Text *f)  /* be conservative: file error stops program */
{
  if ((f->s)==NULL) {
    _ioresult=1;
    printf("\n%s%s\n","Cannot access ",f->n); exit(1);
  } else _ioresult=0;
}

void ReseT(Text *f)
{ (f->s) = fopen(f->n,"r"); FileTrap(f); }

void RewritE(Text *f)
{ (f->s) = fopen(f->n,"w"); FileTrap(f); }

void Append(Text *f)
{ (f->s) = fopen(f->n,"a"); FileTrap(f); }

Boolean Eoln(Text *f)
{ short c; c=getc(f->s); ungetc(c, f->s); return ((char)c == '\n');
}

Boolean Eof(Text *f)
/* #define Eof(f)  feof((f)->s)    IS WRONG !
   in C, feof is true if the last input WAS an end of file marker: Too late.
*/
{ short c; Boolean yes;
  c=getc(f->s); yes=feof(f->s); ungetc(c, f->s); return yes;
}

/******** numerics **********/

short Abs(short i) {if (i>=0)   return(i); else return(-i); }
long  ABs(long i)  {if (i>=0)   return(i); else return(-i); }
Real AbS(Real i)   {if (i>=0.0) return(i); else return(-i); }

long Round(double r)
{ return (long)floor(r+0.5); }

short Trunc(Real r)
{ if (r>=0.0) return (short)floor(r);
         else return (short)ceil(r);
}

Real Frac(Real x)
{ if (x>=0.0) return(x - floor(x)); else return(x - ceil(x)); }

Real Int(Real x)
{ if (x>=0.0) return floor(x); else return ceil(x); }

void Randomize(void)     {srand(1);}
Word Random( Word range)
 {if (range<=0) return(0); else return rand() % range; }

double RandoM(void)
{short p,q; p=rand();q=rand();
  if ((q==0)||(p==0)) return(0.0);
  else if (p<q) return( (1.0*p)/q);
  else return((1.0*q)/p);
}

/********  system stuff ***********/

Integer ParamCount(void)   {return _paramcount; }

char *ParamStr(String aux,Integer i)
{ _sI(aux, _paramstr[i]); return aux; }

#ifdef msDOS
Word Seg(Pointer p)  {return ((long)p) >>16; }     /* large memory model ! */
Word Ofs(Pointer p)  {return ((long)p) & 0xFFFF; }
#else
Word Seg(Pointer p)  {return 0; }    /* stubs! */
Word Ofs(Pointer p)  {return 0; }
#endif

Pointer Ptr(Word sg, Word of) /* like Turbo C MK_FP  */
{ long q=  ((long)sg<<16)+ ((long)of & 0xFFFF);
  return (Pointer)q;
}

void Swap(Word *X)
{ *X= ((*X >>8) & 255) + ((*X & 255)<<8); }

/********   STUBS  **********/

static void Stub(char *s)
{ printf("\n%s not implemented in PCPC.\n",s); exit(3); }

Longint MaxAvail(void)    {return 150000L; }
void MArk(Pointer *p)     {}
void RElease(Pointer *p)  { Stub("Release"); }

Byte MEm;   /* waste bin for Mem and Port access */
Word MEmW;
Longint MEmL;

Byte *Mem(Word seg, Word ofs)     { Stub("Mem");  return &MEm;}
Word *Memw(Word seg, Word ofs)    { Stub("Memw"); return &MEmW;}
Longint *Meml(Word seg, Word ofs) { Stub("Meml"); return &MEmL;}
Byte *Port(Word ofs)              { Stub("Port"); return &MEm;}
Word *Portw(Word ofs)             { Stub("Portw");return &MEmW;}

/***  advanced file function stubs ******/

void Reset(File *f, Word rsize)    {Stub("Reset");}
void Rewrite(File *f, Word rsize)  {Stub("Rewrite");}
void Rename(Text *f,String s)  {Stub("Rename");}
void Erase(Text *f)            {Stub("Erase");}
void ChDir(String S)           {Stub("ChDir");}
void MkDir(String S)           {Stub("MkDir");}
void RmDir(String S)           {Stub("RmDir");}
void GetDir(Byte D,String S)   {Stub("GetDir");}
Longint FilePos(File *F)       {Stub("FilePos");}
Longint FileSize(File *F)      {Stub("FileSize");}
/* void Seek(File *F,Longint N); */
/* void SeekEof(Text *F); */
void SeekEoln(Text *F)         {Stub("SeekEoln");}
void Truncate(File *F)         {Stub("Truncate");}
void SetTextBuf(Text *F,VAR *Buf,Word Size)            {Stub("SetTextBuf");}
void BlockRead(File *F,VAR *Buf,Word Count,Word *Res)  {Stub("BlockRead");}
void BlockWrite(File *F,VAR *Buf,Word Count,Word *Res) {Stub("BlockWrite");}

/*

----   miscellaneous code, unused:

#define Range(a,b)  (a+(b>>8))

Word bit[16] = {1,2,4,8, 16,32,64,128, 0x100,0x200,0x400,0x800,
                 0x1000,0x2000,0x4000,0x8000 };
Set EmptySet={0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0};

void Readln(Text *g, char opcode, Pointer p)
{ String s;  short ls;
  fscanf(g->s, "%[^\n]%*c", s);   ls=Length(s);
  switch(opcode) {
  case '*': break;                              /* simple readln
  case 'c': (char)*p = s[ls-1]; break;          /* last char
  case 's': strcpy((char*)p,s); break;          /* string
  case 'i': sscan(s, "%i", (short *)p);   break;  /* integer
  case 'r': sscan(s, "%f", (double *)p); break; /* real
  }
}


*/
