program AnsiKill; {  (c) Copyright 1991 by  Georg Post }

{$R+,S+}

{ Examples:
ansikill toto
  converts a file "toto.c" into  "toto.krc" (Kernighan-Ritchie C)
ansikill toto.h
  converts  "toto.h" into "toto.krh".

Extracted from reord2.pas and works only on C files produced by, or supplied
with, PCPC. Strips the  ANSI information off function declarations.
Useful to test PCPC output with older C compilers.

ASSUMES the following: A line which starts at column ONE and has (2..5 tokens
later) a "(" symbol on the same line is a Function declaration or definition.
The following ")" is assumed to close the arg list, it may occur some
lines later. After that, either the opening brace  or ";" or "/*" is expected.
In case of ";", the thing is treated as a (forward) declaration and the
arg list reduces to "()". The other cases are handled as function definitions
and the arg list is written twice: inside the parentheses, without type
declarators, and then the full list outside.

Declared but not defined functions reduce to: extern ? ... (); ?
Bug for array types in headers, doesn't throw away the [] !
}

uses killAnsi;

type  str40=string[40];
      str255=string[255];
var   dataDir: str40;

procedure cycle(fname:str40);
var inp,otp: text;
    ext: str40;
    ninp,notp: str255;
    lin,ix,k:word;
    ok:boolean;  c:char;
begin
  write(dataDir,fname);
  initLbuffer;     { the line buffer }
  ninp:=fname; {analyse name of input file}
  lin:=length(ninp); ix:=lin;
  repeat ix:=pred(ix) until (ninp[ix]='.')or((lin-ix)>=3)or(ix<=1);
  if ninp[ix]='.' then begin {extension found}
    ext:=copy(ninp,ix+1,lin-ix);
    notp:=copy(ninp,1,ix-1);
  end else begin
    ext:='c'; {assume .c file}
    notp:=ninp;
    ninp:=ninp+'.c';
  end;
  ext:=copy('kr'+ext,1,3); {transform c->krc  h->krh   pas->krp ...}
  notp:=notp+'.'+ext;
  assign(inp,dataDir+ninp); {$I-}  reset(inp); {$I+}
  ok:=(ioResult=0);
  if not ok then begin
    writeln(' Cannot find ',dataDir,ninp);
  end else begin
    write(' --> ',notp,' ');
    assign(otp,dataDir+notp); rewrite(otp);
    ix:=0; {buffer index}
    while not eof(inp) do begin
      if eoln(inp) then begin readln(inp); c:=#13; end else read(inp,c);
      fwrite(otp,c);
    end;
    termLbuffer(otp,1);
    close(otp);
    close(inp);
  end;
  if ok then writeln(' Ok') else writeln;
end;

var j,n: integer;
begin
  dataDir:='';
  killem:=true;
  writeln('--- From ANSI back to K&R-C ---');
  n:=paramCount;
  if n<1 then begin
    writeln ('Usage  :  ansikill <filename> ...');
  end else begin
    for j:=1 to n do cycle(paramStr(j));
  end;
end.




