{
      REORDER.PAS     (c) Copyright 1991 by  Georg Post

 Reordering filter program for the 2nd pass of Pascal-to-C converter PCPC.
          Produces pre-ANSI 1978 Kernighan-Ritchie C, on request.
          Same command-line parameters as for PCPC. Specific option: /A
 Input :  a text file, made of normal lines, "control lines",
          Reorder-specific macroDefinitions and macroCalls.
 Output:  text file with lines in a different order, some are duplicated.
          Phase 0: read (bracketed) packet of lines, extract macroDefinitions.
          Phase 1: sort the lines, control lines are thrown away
          Phase 2: expand the macroCalls
          Phase 3: translate ANSI function headers to ancient style (option /A)

 Bugs:    Adds some ";" symbols where the 1st pass cannot know them (forward).

 Permutation of lines:
 Consider the input as a stream of regular lines a,b,c ... and
 special "list constructing" and "bracketing" lines: commented [ | ]  ( ) < > .
 Hybrid structures < >, ( > and < ) replace ( ) for special purposes.
 If A, B, C ... are text chunks, maybe void, these reduction rules apply:
    [ A ]          -> A
    [ A | B ]      -> B A            lists are inverted
    [ A | B | C ]  -> C B A          .. and so on
    A ( B ) C      -> A B C          outermost brackets ignored
    ( A ( B ) C )  -> ( B A C )      inner brackets turn into prefixes
    ( A < B ) C >  -> B ( B A C )    prefixing & echo outside a () scope
    ( A < B > C >  -> B ( A B C )    echo without permutation
    ( A < B ) C )  -> ( A ( B ) C )  if no trailing >, ignore inner < .

 In short, the structure (<)> means: Repat and move, and (<>> means: repeat
 but don't move.
 Example: this program transforms a source :
    ( a b ( c d ( [e f | ( g ) h ] ( i ) ) j ) k )
 into :
    g i h e f c d j a b k

 That is, innermost brackets have priority over any outer brackets.
 Clearly, there is a recursive definition/algorithm behind such prefixing.
 Bracket constructs () or [||] must balance, in the obvious way.
 This mechanism applies to the 2nd pass of Pascal-C translation:

  - to untangle nested subprocedures like this:
     (proc A (proc B ... end;) ... end;)
  - to advance trailing auxiliary local var declarations like this:
     proc A ... var ..; [ begin ... end | var aux..] ;
  - if a nested B calls A (recursion), proc A is bracketed by (> to tell the
     reorder program to repeat an A function header in front of all inner
     procedures (sort of Forward declaration ) .
  - The function headers that MAY repeat get <> if Reorder should not consider
     them as a ()-structure (move them),
     they get <) if they should move in front, too.

 (Pascal-like syntax here is symbolic only, real input files have the C syntax)

Postprocessing of specific MACROS is done to retrofit auxiliary parameter
lists in Pascal-nested function declarations and calls.
Macro DEFINITIONS start at 1st column of a line and stop at a Newline, but may
be multiline <512 chars. They are extracted in the block read phase.
Macro CALLS may occur anywhere within a line, are translated in output phase.
In general, the Calls precede the Definitions in a source file .PC1 . However,
one block i.e. () or [] structure at the outer level, must be self-contained
and smaller than 64 K.

/*#word anything...*/ is the macro DEF. : substitute for "word"  "anything..."
/*@word 3*/           is the macro CALL, it has 1 number argument "Arg"

"anything" is a list of entries like this, where  [  ]  means an option:
   , Number [ & ] [ Prefix . ] Name    (first argument without the comma )
At macroCall, Numbers are compared with Arg.   (Arg=caller's nesting level)
If Arg=0, do not interpret "anything" but output the macro expansion "as is".
Else If Arg=Number, keep the optional "&" and/or "Prefix." .
Else suppress them.

Reorder has a "projection" property: REORDERing its output a second time
leaves it essentially untouched. But do not rely on the /A option to process
ANY C file from ANSI to pre-ANSI syntax!  Reorder's Ansi killer makes specific
assumptions on text lines; only output from PCPC has been tested...
}

program reOrder;  {compiler: Turbo Pascal 4.0 }
{$R+,S+}
uses getunits, {used by PCPC too: cmd line parser, used-unit extractor}
     killAnsi; { post-post processor to destroy Ansi syntax}

{  BUGS:
    -   produces extra characters at end of some output blocks !
}
const
      skipBeg='#if 0';
      skipEnd='#endif';

      bra    ='/*(*/';   { all control codes are C comments }
      ket    ='/*)*/';   {the BraKet pair  of lines}
      listBeg='/*[*/';
      listSep='/*|*/';
      listEnd='/*]*/';   { the List structure [|| ] }
      specBra='/*<*/';   {special brackets }
      specKet='/*>*/';

      maxErr=5;
      maxBuff=65000;  { input buffer: no (..) or [..] part may be bigger ! }
      maxStak=100;    { nesting stack limit }
      maxTable=200;   { bracket pair table limit }
      maxList=10;     { max. number of allowed | is 9 }
      maxName=18;     {max length of a macro name}
      maxMacro=1000;  {max length of a macro}

type str255=string[255];{ longer source lines are not allowed ! }
     marker = (Normal,  { ()     basic one of the 5 types of constructs     }
               List,    { []     marks an inversion list [ | | | ...]       }
               Recurs,  { (>     recursive procedure; duplicate its header  }
               Duplic,  { <>     marks procedure header. MAYBE duplicate it }
               DupMov); { <)     header that MAY duplicate and MUST move    }
     bfTable=array[1..maxBuff] of char;

var
    buff: ^bfTable; {input buffer. Its block structure = the tables A,B,C.}
    a,b: array[0..maxTable] of word;  {A[i]..B[i] the block interval indexes}
    mark: array[0..maxTable] of marker; {mark[i]= the type of block i}
    c:   array[0..maxTable,0..maxList] of word;
       {if block i is a List [|| ], the row C[i,*] = the separator indexes}
    maxi: integer;                      {max index to a,b,c tables}
    stak: array[0..maxStak] of integer; {for the read phase, 0 unused ! }
    istak: integer; {top of Stak index}

{---(1) ------  the macro processor -------------}

type {str40=string[40];}
     str20=string[20];
     strBig=array[1..maxMacro] of char;
       {macros may be multiline, up to 1000 chars}
     pMacro=^macroData;
     macroData=record
       key:str20;     {the macro name}
       size: integer; {valid length of "expand"}
       expand: strBig;{the macro expansion}
       rg,lf: pMacro; {for binary tree storage of macros}
     end;
var  mRoot: pMacro;     { the root of the macro tree}
     doMacros: boolean; {for debugging, macro handling may be switched off}

procedure initMacros(ok:boolean);
begin mRoot:=Nil; doMacros:=ok; end;

procedure freeHeap(p:pMacro; var n:integer);
begin
  if p<>Nil then begin
    freeHeap(p^.rg, n);
    freeHeap(p^.lf, n);
    dispose(p); n:=n+1;
  end;
end;

procedure killMacros(var victims: integer); {free the heap space}
begin
  victims:=0; freeHeap(mRoot,victims);
  mRoot:=Nil;
end;

procedure searchMacro(var name:str20; var p:pMacro; var found,small: boolean);
{ ACTION: search for a macro with Key=Name in the macro list (binary tree).
  CALLER: insertMacro, dumpMacro
  OUTPUT: p=valid pointer if Found. Else p= insertion point, and Small=true
          if the entry "Name" would go to p^.lf.
}
var q:pMacro;
begin
  found:=false; small:=false;
  p:=mRoot;
  q:=nil;  { tree search loop}
  while p<>nil do begin {=nil, end of search}
    q:=p;
    found:=(name=p^.key);
    if not found then begin
      small:=(name<p^.key);
      if small then p:=p^.lf else p:=p^.rg;
    end else p:=nil; {and q is result pointer}
  end;
  p:=q; {the insertion point if NOT found, the good pointer if found ! }
end;

procedure insertMacro(var name:str20; var txt:strBig {255}; n:integer);
{ ACTION: insert macro Name with expansion Txt and size N into the list.
          this one may override an old macro definition
  CALLER: macroDeclare, macroDefine
}
var p,q:pMacro;  found,small: boolean;
begin
  searchMacro(name,p,found,small);
  if not found then begin {must create a new heap object}
    q:=p; new(p);
    with p^ do begin key:=name; lf:=Nil;rg:=Nil end;
    if q=Nil then mRoot:=p {p was the first macro at all} else begin
      if small then q^.lf:=p else q^.rg:=p; {tree linking}
    end;
  end;
  p^.expand:=txt;
  p^.size:=n; {n=0 is legal}
end;

procedure dumpMacro(var t:text; var name:str20; arg:integer; var Okay:boolean);
{ ACTION: write a macro expansion for Name (aux. parameter lists)
  CALLER: macroExpand
  INPUT : Arg is the level of the caller, or 0: expansion rules depend on Arg.
}
const nArgMax=255; {debug}
var p:pMacro; ok,found,small:boolean;  c:char; i,k:integer;
    numb,nArg, luff: integer;
    prefix,ident: str40;
begin
  {debug writeln('/',name,'/'); }
  searchMacro(name,p,found,small);
  Okay:=Found; nArg:=0;
  if not found then begin
    writeln('Undefined Macro BUG:',name);
  end else with p^ do begin
    luff:=size; { macro expansion may be void! }
    if arg=0 then begin {unadorned output}
      for i:=1 to luff do begin c:=expand{stuff}[i];
        fwrite(t,c);
      end;
    end else if luff>0 then begin
     { if Arg is = the Number, keep the optional parts, else skip them .}
      i:=1;
      repeat
        ok:=(i<luff);
        if ok then begin c:=expand[i]; ok:=(c=',')  or (i=1); {???}
        end;
        if ok then begin
          if (c=',') then begin fwrite(t,c); i:=succ(i); end;
          numb:=0;
          while expand[i] in ['0'..'9'] do begin
            numb:=10*numb+ord(expand[i])-ord('0'); i:=succ(i);
          end;
          {All macro params start with a NUMBer, to be checked against Arg}
          if expand[i]='&' then begin prefix:='&'; i:=succ(i)
          end else prefix:='';
          ident:='';
          while (i<=luff)and(expand[i]<>',') do begin
            c:=expand[i]; i:=succ(i);
            if c<>'.' then ident:=ident+c else begin
              prefix:=prefix+ident; ident:='';
            end;
          end;
        end;
          {if ok, we have: numb, prefix, ident }
        if numb=arg then begin  {column 5 of table in Cnesting.pas }
          ident:=prefix+ident;
        end else begin {column 6, put the _p prefix only}
          ident:='_p'+ident;
        end;
        for k:=1 to length(ident) do begin
           c:=ident[k];
           fwrite(t,c);
        end;
        nArg:=nArg+1;
      until (i>=luff) or (nArg>nArgMax);
    end; {if arg>0}
  end;   {with p^}
  if nArg>nArgMax then begin
    write('Macro Overflow Bug:');
    with p^ do for k:=1 to size do write(expand[k]);
    writeln;
    Okay:=false;
  end;
end;

procedure macroDeclare(var bf:strBig; var Ok:boolean);
{ ACTION: the multiline bf is a macroDefinition: store it on the heap.
  CALLER: readBuffer
}
var name:str20; txt:strBig;  j,k: integer;
begin
  j:=4; name:=''; k:=0;
  repeat name:=name+bf[j]; j:=succ(j); k:=succ(k);
  until (k>maxName) or (bf[j]<'0');
  if bf[j]<=' ' then j:=succ(j);
  k:=0;
  while (k<maxMacro) and (j<(maxMacro-1))
    and ((bf[j]<>'*') or (bf[j+1]<>'/')) do begin
    k:=succ(k); txt[k]:=bf[j]; j:=succ(j);
  end;
  Ok:=(j<=(maxMacro-2));
  if not Ok then writeln('Macro expansion ',name,': too long !');
  insertMacro(name,txt,k);
end;

procedure macroDefine(var bf: bfTable; var i: word; var ok:boolean);
{ ACTION: macroDefinition  extracted from array Bf, beginning at i.
          void macro /*#Blabla */ is legal.
  CALLER: dumpStuff, should never be called as readBuffer catches the macros.
  OUTPUT: i is advanced beyond the macro definition.
          i is on the / of a sequence /*#. At exit, will be after */
}
var name:str20; txt:strBig;  j:word; k: integer;
begin
  j:=i+3; name:=''; k:=0;
  repeat name:=name+bf[j]; j:=succ(j); k:=succ(k);
  until (k>maxName) or (bf[j]<'0');
  if bf[j]<=' ' then j:=succ(j);
  {txt:='';}  k:=0;
  while (k<maxMacro) and ((bf[j]<>'*') or (bf[j+1]<>'/')) do begin
    k:=succ(k); txt[k]:=bf[j]; j:=succ(j);
  end;
  ok:=(k<maxMacro);
  if not Ok then writeln('Macro expansion ',name,': too long !');
  insertMacro(name,txt,k);
  i:=j+2; {beyond the */ }
end;

procedure macroExpand(var t:text; var bf:bfTable; var i:word; var ok:boolean);
{ ACTION: expand the macro call which starts at bf[i].
  CALLER: dumpStuff
  INPUT : bf holds a MACRO CALL at position i,  t is output text file
  OUTPUT: i is advanced beyond the call
}
var name:str20; txt:str255;  j:word; k,nb,err: integer;
begin
  j:=i+3; name:=''; k:=0;
  repeat name:=name+bf[j]; j:=succ(j); k:=succ(k);
  until (k>maxName) or (bf[j]<'0');
  if bf[j]<=' ' then j:=succ(j);
  txt:='';  k:=0;
  while (k<=255) and ((bf[j]<>'*') or (bf[j+1]<>'/')) do begin
    txt:=txt+bf[j]; j:=succ(j); k:=succ(k);
  end;
  val(txt, nb,err);
  if err>0 then nb:=0; {macro call may have 1 nb argument}
  dumpMacro(t, name, nb, ok);  {nb used in prefix handling}
  i:=j+2; {beyond the */ }
end;


{---(2)-------  data input from .PC1 file  -----}

procedure getLine(var t:text; var s:str255; var count:integer);
{ ACTION: transfer 1 line : file T --> string S. Increment Count.
  CALLER: readBuffer
}
var c:char;
begin
  s:='';
  while not (eof(t) or eoln(t)) do begin
    read(t,c); s:=s+c;
  end;
  if eoln(t) then readln(t);
  count:=succ(count);
end;

procedure flagError(messg:str255; var bf:bfTable;
  lineCount,bfIx: word; {bf index if >0}
  var errCount: integer);
{ ACTION: print warning Messg and its context in buffer Bf.
  CALLER: newEntry, readBuffer
  OUTPUT: errCount is incremented
}
var i,k:word; c:char;
begin
  writeln('Problem @ line ',lineCount,': ',messg,' .');
  errCount:=succ(errCount);
  if bfIx>0 then begin {dump latest chunk of buffer text}
    i:=bfIx-200; if i<=0 then i:=0;
    for k:=i to bfIx do begin c:=bf[k];
      if c<' ' then writeln else write(c);
    end;
    writeln;
  end;
end;

procedure newEntry(var bf:bfTable; var istak,k,lineCount,errCount: integer);
{ ACTION: increment the global variable Maxi and push it onto stack
          (global table Stak at Istak)
  CALLER: readBuffer, whenever an opening bracket appears
  INPUT : Bf,lineCount,errCount: for error message only
  OUTPUT: k= new value of Maxi; = index to the global A B C tables.
}
begin
  istak:=succ(istak);
  if istak>maxStak then begin
    flagError('Expression stack overflow',bf,lineCount,0,errCount);
    errCount:=maxErr+1;
  end else begin
    maxi:=succ(maxi); stak[istak]:=maxi;
    if maxi>maxTable then begin
      flagError('Bracket table overflow', bf,lineCount,0,errCount);
      errCount:=maxErr+1; maxi:=0;
    end;
    k:=maxi;
  end;
end;

procedure readBuffer(var inFile:text; var buff:bfTable;
  var ix:word; var lineCount,errCount:integer);
{ ACTION: transfer one Block (bracketed construct) from InFile to Buff.
  CALLER: cycle
  OUTPUT: ix = character counter, last char read = Buff[ix].
          lineCount, errCount are incremented as required
}
var li:str255; leli,h,i,j,k: integer;
    mac: strBig; lmac: integer;
    liLen: integer; extLi:string[10]; {extracted from line Li}
    happens,stop,ok: boolean; {at least one bracketing symbol ...}
begin
  happens:=false;
  a[0]:=ix+1; c[0,0]:=1; {dummy [..] around everything}
  mark[0]:=List;
  istak:=0; maxi:=0;
  repeat getLine(inFile,li,lineCount);
    while li=skipBeg do begin  { shunt that stuff }
{#}   repeat getLine(inFile,li,lineCount) until li=skipEnd;
      getLine(inFile,li,lineCount);
    end;
    liLen:=length(li); i:=0;
    repeat i:=succ(i); stop:=(i>liLen);
      if not stop then stop:=li[i]<>' ';  {skip leading blanks }
    until stop;
    if (i<liLen) then extLi:=copy(li,i,5) else extLi:='';
     if copy(extLi,1,3)='/*#' then begin {multiline macro definitions,
       always start at column 1 }
       for h:=1 to liLen do mac[h]:=li[h]; lmac:=lilen;
       while (mac[lmac]<>'/') {and (lmac<maxMacro)} do begin {macro goes on! }
         getLine(inFile,li,lineCount); leli:=length(li);
         lmac:=lmac+1; mac[lmac]:=chr(13);
         if (lmac+leli)>(maxMacro-3) then begin {stop giant macro}
           mac[lmac]:='*'; lmac:=lmac+1; mac[lmac]:='/';
           flagError('Macro too big',buff,lineCount,0,errCount);
           ok:=false;
         end else begin
           for h:=1 to leli do begin
             lmac:=lmac+1; mac[lmac]:=li[h];
           end;
         end;
       end;
       macroDeclare(mac , ok);
       if not ok then errCount:=succ(errCount);
{(}  end else if (extli=bra)or(extLi=specBra) then begin
{<}   happens:=true;
      newEntry(buff,istak,k,lineCount,errCount);
      if k>0 then begin  {new index to a,b tables}
        a[k]:=ix+1; {ix = where to put text into buffer }
        c[k,0]:=0; {is a bracket. If list, c[k,0] = the nbr of entries}
        if extLi=bra then mark[k]:=Normal else mark[k]:=Duplic;
      end;
{)} end else if (extli=ket)or(extLi=specKet) then begin
{>}   {k:=stak[istak];}
      istak:=pred(istak); {Bug: if istak=0, k undefined ! }
      if istak<0 then begin
        flagError(' ) without ( ',buff,lineCount,0,errCount);
        istak:=0;
      end;
      k:=stak[istak+1];
      if c[k,0]<>0 then begin {error, matches [) ? }
        flagError('illegal delimiter pair [ )',buff,lineCount,0,errCount);
        c[k,0]:=0;
      end;
      b[k]:=ix;   {bracketed text goes from a[k] to b[k] inclusive ! }
      if extLi=ket then begin
        if mark[k]=Duplic then mark[k]:=DupMov; {adjust initial guess}
      end else begin
        if mark[k]=Normal then mark[k]:=Recurs
        else c[k,0]:=1;  {Duplic object, is treated like a List}
      end;
{[} end else if extli=listBeg then begin
      happens:=true;
      newEntry(buff,istak,k,lineCount,errCount);
      if k>0 then begin
        a[k]:=ix+1; {ix = where to put text into buffer }
        c[k,0]:=1;  { c[k,0] = the nbr of entries}
        mark[k]:=List;
      end;
{]} end else if extli=listEnd then begin
      k:=stak[istak]; istak:=pred(istak);
      if istak<0 then begin
        flagError('] without [ ',buff,lineCount,0,errCount);
        istak:=0;
      end;
      if c[k,0]=0 then begin {error }
        flagError('illegal delimiter pair ( ] ',buff,lineCount,0,errCount);
        c[k,0]:=1;
      end;
      b[k]:=ix;   {list text goes from a[k] to b[k] inclusive ! }
{|} end else if extli=listSep then begin
      k:=stak[istak]; j:=c[k,0];
      if j<=0 then begin
        flagError('illegal sequence ( | ',buff,lineCount,0,errCount);
        {and ignore the vertical bar }
      end else if j>maxList then begin
        flagError('Inversion list is too long',buff,lineCount,0,errCount);
      end else begin  {the separator  is Endpoint of preceding section}
        c[k,j]:=ix; c[k,0]:=j+1;
      end;
{.} end else begin {put that text line}
      if (ix+liLen)>(maxBuff-2) then begin
        liLen:=0;
        flagError('Fatal buffer overflow',buff,lineCount,ix,errCount);
        errCount:=maxErr+1; {abandon everything}
      end;
      for j:=1 to liLen do begin
        ix:=succ(ix); buff[ix]:=li[j]
      end;
      ix:=succ(ix); buff[ix]:=chr(13); {end of line mark}
      {debug write(li);readln; }
    end;
  until eof(inFile) or (happens and (istak<=0)) or (errCount>maxErr);
  b[0]:=ix;
end;


{---(3)---- data output to .C file  -----}

{ Here come the bracket-controlled line permutations & duplications.
  The only interface from here to output file is the FWRITE(t,c) call
  which does just the following, modulo the ANSI filter activity:
      if c=chr(13) then writeln(t) else write(t,c);
}

procedure dumpStuff(var t:text; var bf:bfTable; i,j: word; var ok:boolean);
{ ACTION:  The basic output routine: text chunk   Bf[i]...Bf[j] --> file T.
           the only interface points with the macro processor are here:
           MacroDefine (perhaps not used) and MacroExpand
           Search for Macro specific comment syntax keeps track of quoted
           strings or characters: no macros inside there .
  CALLER:  dumpTerm
  OUTPUT:  ok=True if no macro-related error occurs.
}
var h,k:word;  a,c,sl:char;
    macr,stQuote,chQuote,bakSlash:boolean; {string or char quote}
begin    h:=i;
  bakSlash:=false; stQuote:=false; chQuote:=false; ok:=true;
  a:=' ';
  while ok and (h<=j) do begin
    c:=bf[h];
    if c=chr(13) then begin stQuote:=false; chQuote:=false; end;
    if stQuote or chQuote then begin
      {keep memory of preceding backSlash char}
      if bakSlash then bakSlash:=false else bakSlash:=(a='\');
    end;
    if (not chQuote) and (c='"') then begin
      if not stQuote then stQuote:=true {double quote: we are in a string}
      else if not bakSlash then stQuote:=false;
    end;
    if (not stQuote) and (c='''') then begin {single quote}
      if not chQuote then chQuote:=true
      else if not bakSlash then chQuote:=false;
    end;
    a:=c;
    macr:=doMacros and (not (chQuote or stQuote))
          and (c='/')and (bf[h+1]='*');
    if macr then begin
      k:=h+2; macr:=(k<j);
      if macr then begin sl:=bf[k];
        if sl='#' then macroDefine(bf,h,ok)      {advances h AFTER the */ }
          {should NEVER occur if macros are filtered by macroDeclare }
        else if sl='@' then macroExpand(t,bf,h,ok)
        else macr:=false;
      end;
    end;
    if not macr then begin {regular character}
      fwrite(t,c);
      h:=succ(h);
    end;
  end; {while}
end;

procedure nextSubexpress(var h,newx: word; x,y: word; var stop: boolean);
{ ACTION: search in the global tables A,B:  Increment h until the interval
          a[h]..b[h] is inside x..y, i.e.   x <= a[h]<b[h] <= y.
  CALLER: dumpTerm, scanList, dumpBracket
  OUTPUT: Stop := true if none found, else newx is start for next search
}
var found:boolean;
begin  newx:=x;
  repeat h:=h+1; stop:=(x>y) or (h>maxi);
    if not stop then stop:=(b[h]>y); {overshoot ! }
    if not stop then begin
      found:=(a[h]>=x);
      if found then newx:=b[h]+1;
    end;
  until stop or found;
end;

{ mutual recursions:
  dumpTerm calls itself and dumpBracket
  scanList calls  itself and dumpBracket
  dumpBracket calls itself, scanList and dumpTerm
}

procedure dumpBracket(var outFile:text; var buff:bfTable; i:word;
var ok: boolean); forward;

procedure dumpTerm(var outFile:text; var buff:bfTable; j:word;
  full:boolean; var ok:boolean);
{ ACTION: output from Buff, index range A[j].. B[j] (a []- or ()-structure)
          If full=True, output everything inside a[j]..b[j].
          Else only the skeleton i.e. skip any internal (..) construct,
          supposed to be done earlier.
          Recursion for nested [...] lists.
  CALLER: Cycle (main prog) with Full=True, dumpBracket, dumpTerm
  OUTPUT: ok=True if no error detected
}
var h,i,k,x,newx,y,mark: word; stop,noList:boolean;
begin
  ok:=true;
  mark:=c[j,0]; noList:=(mark=0);
  if noList then mark:=1; {ugly trick to have one-time loop}
  for k:=mark downto 1 do if ok then begin
    if noList then begin
      x:=a[j];y:=b[j];
    end else begin
      if k=c[j,0] then y:=b[j] else y:=c[j,k];
      if k=1 then x:=a[j] else x:=c[j,k-1]+1;
    end;
     {now scan text section from x to y inclusive }
    h:=j; 
    repeat
      nextSubexpress(h,newx,x,y, stop);
      if (not stop) then begin {inner structure found ...}
        dumpStuff(outFile,buff, x, a[h]-1, ok);
        if c[h,0]=0 then begin
          if full then dumpBracket(outFile,buff,h,ok);
          {if not, brackets were done before}
        end else dumpTerm(outFile,buff,h,full,ok);
      end else begin {  do not forget the trailer}
        dumpStuff(outFile,buff, x,y, ok);
      end;
      x:=newx;
    until stop or (not ok);
  end; {for k}
end;

procedure scanList(var outFile:text; var buff:bfTable; j:word;
var ok:boolean);
{ ACTION: recursively scan a list structure [||| ], Buff index  A[j]..B[j].
          The sections are at index C[j,1] , C[j,2] etc.
          output the inner (...) stuff only, the rest is for dumpTerm.
  CALLER: scanList, dumpBracket
  OUTPUT: ok=True if it worked
}
var h,i,k,x,newx,y: word; stop:boolean;
begin
  ok:=true;
  for k:=c[j,0] downto 1 do if ok then begin
    if k=c[j,0] then y:=b[j] else y:=c[j,k];
    if k=1 then x:=a[j] else x:=c[j,k-1]+1;
     {text section from x to y inclusive to be scanned
     for recursive (..) structure output, abc tables from j to end }
    h:=j;
    repeat
      nextSubexpress(h,newx,x,y, stop);
      if (not stop) then begin {inner structure...}
        if c[h,0]=0 then dumpBracket(outFile,buff, h,ok)
        else scanList(outFile,buff,h,ok);
      end;
    until stop or (not ok);
  end; {for k}
end;

procedure dumpBracket(var outFile:text; var buff:bfTable; i:word;
var ok:boolean);
{ ACTION: recursively output ()-structure: buff[A[i]]...buff[B[i]].
          loop over all k's following i with a[k]..b[k] inside a[i]..b[i],
          detect the highest-level fragments and write them before own stuff.
  CALLER: dumpTerm, scanList, dumpBracket
  OUTPUT: ok if no problem encountered.
}
var h,k, x,newx,y,z: word;
    stop: boolean;
begin
  h:=i; x:=a[i]; y:=b[i]; ok:=true;
  if mark[i]=Recurs then begin {look up some Forward-type prefix inside}
    {detect things that need to be written twice: forward function protos}
    repeat nextSubexpress(h,newx,x,y, stop);
      x:=newX;  {??? is the first one the right one ? }
    until stop or (mark[h]=Duplic)or(mark[h]=DupMov);
    if not stop then begin
      dumpTerm(outFile, buff, h, {full=} true,ok);
   {---------  horrible unstructured kludge -------------}
      fwrite(outFile,';'); fwrite(outFile,chr(13));
   {----------   ; missing in the input pre-C code ------}
    end;
  end;
  h:=i; x:=a[i]; y:=b[i]; ok:=true;
  repeat {main loop: output priority stuff}
    nextSubexpress(h,newx,x,y, stop);
    if (not stop) then begin
      if c[h,0]=0 then begin { bracket construct: recursion}
        dumpBracket(outFile, buff, h,ok);
      end else begin {there is a List or Duplic, scan it backwards}
        scanList(outFile, buff, h,ok);
      end;
    end;
    x:=newx;
  until stop or (not ok);
  if ok then dumpTerm(outFile,buff,i,false,ok);
   { here we do the non-() stuff inside}
end;


{----(4) --- the command-line "user interface"-------}

var  codeDir, dataDir:str40;    {common directory of all PC1 files}
     inCount: integer; {number of files to translate}

procedure compileBatch(dir,mainFile: str40; sys,last: integer);
{ ACTION: makes compile and link batch file CmainFil.BAT et mainFile.LNK
}
var s:str80; {compiler argument string}
    fn,t: str40; {file name}
    f: text; i:integer;
begin  s:='';
  fn:='C'+mainFile;
  if length(fn)>8 then fn:=copy(fn,1,8); fn:=fn+'.bat';
  assign(f,fn); rewrite(f);
  writeln(f,'rem ',fn);
  for i:=sys+1 to last do begin
    t:={getunits.}fileName[i]; t:=copy(t,1,length(t)-4); {strip the .PAS}
    if s='' then s:=dir+t else s:=s+' '+dir+t;
    if (length(s)>40) or (i=last) then begin
      writeln(f,'set args=',s); writeln(f,'call bcc');
      {batch c compiler takes arg list as %args%  }
      s:='';
    end;
  end;
  writeln(f,'set args=');
  writeln(f,'tlink ',mainFile);
  close(f);
  writeln('Created batch file: ',fn);
  fn:=mainFile+'.lnk'; {link file}
  assign(f,fn); rewrite(f);
  s:='convpac';
  if sys>0 then s:=s+' crtdos'; {sys>0, suppose Crt or Dos is used}
  for i:=sys+1 to last do begin
    t:=fileName[i]; t:=copy(t,1,length(t)-4);
    if s='' then s:=t else s:=s+' '+t;
    if (length(s)>40) or (i=last) then begin
      writeln(f,s,'+');   {link list, each line ends with + }
      s:='';
    end;
  end;
  writeln(f,',',mainFile); {last arg is EXE file name}
  close(f); {end of link file}
  writeln('Created link file: ',fn);
end;

procedure cycle(fname:str40);
{ ACTION: translate Fname.PC1 to Fname.C . Clears used heap at exit!
  CALLER: main program
}
var inp,otp: text;
    ninp,notp: str255;
    ix,k:word;
    nMac,lineCount,errCount: integer;
    debug,ok,dumpOk:boolean;
begin
  write(dataDir,fname);
  debug:=false;
  initLbuffer;     { the line buffer, just before the final output }
  ninp:=fname+'.pc1';  notp:=fname+'.c';
  assign(inp,dataDir+ninp); {$I-}  reset(inp); {$I+}
  ok:=(ioResult=0);
  if not ok then begin
    writeln(' Cannot find ',dataDir,ninp);
    errCount:=1;
  end else begin
    if notp='' then begin notp:='con'; debug:=true end;
    assign(otp,dataDir+notp); rewrite(otp);
    writeln(otp,'/*   ',notp,' <-- ',ninp,'  (REORDER  1.0.2)  */');
    if killem then writeln(otp,'/*  pre-ANSI mode  */');
    lineCount:=0;
    errCount:=0;
    ix:=0; {buffer index}
    repeat
      readBuffer(inp,buff^, ix,lineCount,errCount);
      if debug then begin
        writeln('Input: ',ix, ' chars at line: ',lineCount);
        for k:=1 to maxi do writeln(a[k]:4,' ... ',b[k]:4,
          '  Type: ',ord(mark[k]):4);
        write('<Ret>'); readln;
      end else write('.');
      if errCount=0 then dumpTerm(otp,buff^,0, {full=}true,dumpOk);
      if not dumpOk then errCount:=succ(errCount);
    until eof(inp) or (errCount>maxErr);
    writeln;
    termLbuffer(otp,1);
    close(otp);
    close(inp);
  end;
  if errCount=0 then write('Successful conversion: ',ninp,'-->',notp,' .')
  else write('Unable to convert ',ninp,' .');
  killMacros(nMac); writeln('  Macros = ',nMac);
end;

var i,last,sys:integer;
    buildAll,traceMode,Uopt: boolean;
begin
  new(buff); {the 64K block buffer on the heap}
  writeln('-------  REORDER filter  Version 1.0.2 -------');
  initMacros(true);
  parameters(inCount, codeDir,dataDir,
    buildAll,traceMode, killem, Uopt);
    {inCount = nbr of files to translate}
  if inCount=0 then begin
    writeln
    ('Usage  :  REORD2 [ /Ppath ] [ /A ] [ /B ] file1 [ file2 ... file9 ]');
  end else if buildAll then begin {shuffle Used-by-First into sourceName}
    getUses(dataDir,sourceName[1]+'.pas', last,sys);
    compileBatch(dataDir,sourceName[1], sys,last);
    transferNames(sys,last, inCount);
  end;
  for i:=1 to inCount do cycle(sourceName[i]);
  dispose(buff);
end.

