{
  CDECLARA.PAS   (c) Copyright 1990  by Georg Post

  -  compile with Turbo Pascal 4.0
  -  declaration code generator for PCPC: translator from Pascal to C
  -  function prototypes in ANSI C, everything else should stay 1978 K&R C
  -  Conventions for "non-conflicting" aux. identifiers invented in PCPC:
       _s1 _sX ...  String variables and operations
       _e1 _eX      Set variables, operations
       _0 _1 ....   internal unions and structs of variant records,
       _l99...      labels
       _nIdent      enum type identifiers
       _Ident       reused "system" identifiers
       _gIdent      auxiliary Id to some  "Ident"
       _fIdent      globalised local procedure/function Ids (_f2Id, too?).
       _pIdent      aux. parameter Id in globalised nested proc/funct
       _tIdent      global type names, from nested proc/funct
       _gIdent      gobalized local const declarations ?
}

unit cDeclara;
{$S+,R+}

interface

uses pcpcdata, { global types and data }
     pascannr; { the source code scanner }

const expStkMax=30;    {upper limit of expression stack}
var
    listing:text;   {the .PC1 output file}
    expStack: array[1..expStkMax] of str255;  {expression stack}
    lastExp: integer; {TOS index, reset after each Statement}
    expTypes: array[1..expStkMax] of ptpel; {the type of items on expStack}
    expLevel: array[1..expStkMax] of integer; {their precedence levels}
    bigBuff: array[1..1000] of char; BBix: integer;
{bigBuff holds long write list or string concat, avoid overflow of expStack }
    blockLevel: integer; {nesting level of the current function}
{needed to compare with idLevel, Redundancy with Scope.actual !? }
    headerDeclared, { a flipflop, used to trigger "uglyTrick"}
    statementPart,  {state: dealing with Statement vs. Declaration part}
    implemPart:boolean;  {Implementation vs. Interface part of code}
    AuxPrefix: str20; {preceding all our aux variables}

procedure initCdeclara;

procedure outC(s:str255);
procedure outCi(i:longint);
procedure outCstring(var s:textLine; len:integer; quote:byte);
procedure nonTrivialTerm;
procedure unaryOp(s1,s2:str80; level,check:integer);
procedure binaryOp(s1,s2,s3:str80; level:integer);
procedure pointerOp(p:pide);
procedure pushExp(s:str80; level:integer);
procedure outCexp(npop:integer);
procedure putBigBuff(s:str80);
procedure BigBuffToC(n:integer);
procedure bufferExp;
procedure pushIdent(pi:pide);
procedure pushLine(var t:textline; n:integer);
procedure pushIntVal(i:longint);
procedure initAuxVar(n: integer);
procedure resetAuxVar(n: integer);
procedure pushAuxString;
procedure pushAuxSet;
procedure pushString(var s:textline; len:integer);
procedure declareAuxVar(n: integer);
procedure getIdent(pi:pide; var s:str20);
procedure getTypeName(pt:ptpel; var s:str20);
procedure putIdent(pi:pide);
procedure putTypeName(pt:ptpel);
procedure fullTypeName(pt:ptpel; expand:byte; var pref,suff:str80);
procedure ANSIheader(pi:pide; n:integer; complete,imported:boolean);
procedure putVarList(pi:pide; imported,normal: boolean);
procedure constDeclare(pi:pide; refType:ptpel;
  var stat:scanStatus; imported:boolean);
procedure typeDeclare(pi: pide);
procedure localCopies(p:pide);

implementation

type auxVarType=record maxSets,maxStri, lastSets,lastStri: integer
     end;
var  auxVar:  array[0..20] of auxVarType;  {memory on aux. local variables}
{ for any procedure level, we need auxiliary (automatic-local-volatile)
  String and Set variables, named _s1 , _e3  etc.
  auxVar access via: initAuxVar/resetAuxVar/pushAuxString/pushAuxSet/
     declareAuxVar
 }
    Cline: array[1..500] of char;  {textline buffer for OutC}
    Cindent,Cindex: integer; ClastChar:char;  {state machine for...}
    quote1,quote2,bakSlash: boolean;          {... the output formatter}

procedure initCdeclara;
{ ACTION:  Called once to initialise global data
  CALLER:  Cbulk.initCbulk
}
var i,n:integer;
begin
  statementPart:=false;  {wait for declaration parts}
  headerDeclared:=false;
    (* we use some nasty trick to get either ; or { after function header *)
  Cindent:=0; Cindex:=0; ClastChar:=chr(0);
  quote1:=false; quote2:=false;
  lastExp:=0;
  BBix:=0; {clear the big buffer}
  blockLevel:=0; {count nested procedure/function blocks }
  AuxPrefix:='_g';
end;  {initTranslator}

{-------  the output formatter  -------}

procedure scratchLine;
{ ACTION: end of line in C file output. Pending "error" messages, too.
  CALLER: outC
}
var i:integer; c:char;
begin
  for i:=1 to Cindex do write(listing,Cline[i]);writeln(listing);
  if parseWarning then begin {the parser had some problems}
    parseWarning:=false; write(listing,'/*===');
    for i:=1 to length(WarnBuffer) do begin c:=WarnBuffer[i];
      if c>=' ' then write(listing,c) else writeln(listing);
    end;
    writeln(listing,'<======*/'); WarnBuffer:='';
  end;
  Cindex:=Cindent; for i:=1 to Cindent do Cline[i]:=' ';
  quote1:=false; quote2:=false; bakSlash:=false;
end;

procedure uglyTrick;
{ could it be avoided by some change in the Pascal grammar rules ? }
{ ACTION: inserts the function brace before function body output
  CALLER: outC,
}
begin headerDeclared:=false;
  writeln(listing,'{');
  Cindex:=2;Cindent:=2; Cline[1]:=' ';Cline[2]:=' ';
end;

procedure outC(s:str255);
{ ACTION: text output to .PC1 file. Big lines are broken up.
  CALLER: -anything-
  INPUT : string s. Metacharacter '@' at s[1] controls indentation formatting.
          Character '`' anywhere stands for End-of-line.
  OUTPUT: side effects on Global state vars quote1,quote2, bakSlash

output formatting:
  s may contain, anywhere outside quotes, a Newline symbol: antiquote `.
  Indent formattings by  @+ @- @= @n , at line start only:
  @+ : put current item as is, BUT indent after the following linefeed !
  @- : output pending line, switch back indent counter, then output s stuff.
  @= : output a newline IF the current line buffer is non-empty, then s.
  @n : like @=, then set indent counter to absolute n*space, then output s.
}
const space=2; {indent step is 2 spaces}
      eolBell=60; {position to ring the end-of-line bell}
var i,i0,ls, oldindent:integer;
    s1,s2:char;
    newLn,cut,inQuote: boolean;
begin  if headerDeclared then uglyTrick;
  ls:=length(s);
  if ls>=250 then error('Expression too long.');
  if (ls>=2) and (s[1]='@') then begin
    s2:=s[2];
    if s2='@' then i0:=2 else begin  {line @@.... means @... }
      i0:=3; { positions 1,2 = formatting code , i0 = start of valid text }
      if s2='+' then begin {indent more after Next EOL }
        oldIndent:=Cindent;
        Cindent:=Cindent+space;
      end else if s2='-' then begin {indent less}
        oldIndent:=Cindent;
        Cindent:=Cindent-space;
        if Cindent<0 then Cindent:=0; {underflow! }
        if Cindex>oldindent then scratchLine else Cindex:=Cindent;
      end else if s2='=' then begin
        if Cindex>Cindent then scratchLine; {conditional newline}
      end else if (s2>='0')and(s2<='9') then begin
        if Cindex>Cindent then scratchLine; {nonempty line in buffer}
        Cindent:=space*(ord(s2)-ord('0'));
        Cindex:=Cindent; for i:=1 to Cindent do Cline[i]:=' ';
      end;
    end;
  end else i0:=1;
  if Cindex>0 then s1:=Cline[Cindex] else s1:=' ';
  for i:=i0 to ls do begin   {leave quoted things and identifiers intact}
    s2:=s[i]; newLn:=false;
    inQuote:=quote1 or quote2; {we are inside a string}
    if inQuote then begin      {keep memory of preceding backSlash char}
      if bakSlash then bakSlash:=false else bakSlash:=(s1='\');
    end;
    if s2='"' then begin
      if not inQuote then quote2:=true {double quote}
      else if quote2 and (not bakSlash) then quote2:=false;
    end else if s2='''' then begin
      if not inQuote then quote1:=true {single quote}
      else if quote1 and (not bakSlash) then quote1:=false;
    end;
    s1:=s2;
    cut:= (s2 in ['`',',',';','(',')', {' ',} '[']); {blank NOT allowed!}
    if cut and not (quote1 or quote2) then begin  {newline allowed}
      newLn:=(s2='`');
      if newLn or (Cindex>eolBell) then scratchLine; {cut long lines}
    end;
    if not newLn then begin
      Cindex:=succ(Cindex);
      ClastChar:=s1; Cline[Cindex]:=s1;
    end;
  end;
end;

procedure outCi(i:longint);
{ ACTION: output an integer i. If it is large, append the L marker.
}
var numb:string[20];
begin
  str(i,numb); if (i<minInteg)or(i>maxInteg) then numb:=numb+'L';
  outC(numb)
end;

procedure nonTrivialTerm;
{ ACTION: puts non-trivial statement terminator ';' if necessary
}
begin
  if (ClastChar<>'}') and (ClastChar<>';') then outC(';`');
end;

{-- expression stack and buffer handling, only when statementPart=TRUE --}

procedure unaryOp(s1,s2:str80; level,check:integer);
{ ACTION: top of expression stack modified: TOS <-- s1 + TOS + s2
          Parentheses added if check>0 and old TOS has low-precedence operator
  CALLER: -anything-
  INPUT : Level is the binding force of the new expression. 0=tightest
}
begin
  {debug if (lastExp<1)or(lastExp>expStkMax) then begin
    writeln('Expression stack bounds error: ',lastExp);
    writeln('Attempted: ',s1,' $ ',s2);
  end;  }
  if (check>0)and(expLevel[lastExp]>level) then begin
    s1:=s1+'('; s2:=')'+s2; end;
  expStack[lastExp]:=s1+expStack[lastExp]+s2;
  expLevel[lastExp]:=level;
end;

procedure binaryOp(s1,s2,s3:str80; level:integer);
{ ACTION: compose (TOS-1) <-- s1 + (TOS-1) + s2 + TOS + s3
          Parentheses added if an operand has precedence later than (>) Level
  CALLER: --
  INPUT : level= new operator precedence.
}
begin
  if expLevel[lastExp]>level then begin s2:=s2+'('; s3:=')'+s3; end;
  if expLevel[lastExp-1]>level then begin s1:=s1+'('; s2:=')'+s2; end;
  expStack[lastExp-1]:=s1+expStack[lastExp-1]+s2+expStack[lastExp]+s3;
  lastExp:=lastExp-1; expLevel[lastExp]:=level;
end;

procedure pushExp(s:str80; level:integer);
{ ACTION: push s, with a level number, on the expression stack
}
var i:integer;
begin
  if lastExp<expStkMax then begin
    lastExp:=lastExp+1; expStack[lastExp]:=s; expLevel[lastExp]:=level
  end else begin
    error('[CD:pushExp] stack overflow');
    for i:=expStkMax downto expStkMax-10 do writeln(i:2,': ',expStack[i]);
  end;
end;

procedure outCexp(npop:integer);
{ ACTION: output top of expression stack. Subtract Npop from stack pointer.
}
begin outC(expStack[lastExp]); lastExp:=lastExp-nPop; end;

procedure putBigBuff(s:str80);
{ ACTION: add string s to the special output buffer "bigBuff"
  CALLER: read/write list construction for IO statements.
}
var i:integer;
begin
  for i:=1 to length(s) do begin BBix:=BBix+1;bigBuff[BBix]:=s[i] end;
end;

procedure BigBuffToC(n: integer);
{ ACTION: output (part of) the special buffer "BigBuff" and clear it.
  CALLER:
}
var i:integer;
begin for i:=n to BBix do outC(bigBuff[i]); BBix:=0 end;

procedure bufferExp;
{ ACTION: transfer expression frop stack --> bigBuff
}
begin putBigBuff(expStack[lastExp]); lastExp:=pred(lastExp) end;

procedure getIdent(pi:pide; var s:str20);
{ ACTION: get the identifier string s using IDE pointer pi.
          Ambiguous identifiers get the underbar prefix here.

 Symbol for C: limited to 15 characters.
  ReUse=0: unambiguous symbol.
  ReUse=1: redefined at level 1 from 0, or at 2 from 0 or 1.
           append underbar --> hopefully unique C symbol.
  ReUse>2: inter-unit redefined at level 1 (Pascal Interface parts). C error!
           No action taken here; redefinition was commented out: BUGs!
}
var nk:char; k:integer; risky:boolean;
begin s:='';
  with pi^ do begin
    for k:=1 to lenIde do begin nk:=name[k]; if nk>' ' then s:=s+nk;
    end;
    nk:=typof^.cl;
    risky:=(reUse=1);   {reuse of Pascal std library Ids etc  }
      {re-use of proc/funct/const/var/type ID: put underbar in front }
    if risky then s:='_'+s;
  end;
end;

procedure pointerOp(p:pide);
{ ACTION: special Record.Field binary op. Reduce  *(Id). to  (Id)->
          take care of variant records (= struct of unions of structs in C)
          annex a member Id p^ to preceding Record expression.
          Let p^.typof^.m  =  128*U + 64*S + n.
          If U=1 , prefix _0. . if S=1, prefix _n.
  CALLER:
}
var st:str20; t:str80;   u,s,n,x: integer;  c:char;
begin
  getIdent(p,st); t:=st; x:=p^.typof^.m;
  u:=x div 128; s:= x div 64 ; n:=x mod 64;
  if odd(s) then begin str(n,st); t:='_'+st+'.'+t; end;
  if odd(u) then t:='_0.'+t;
  if (expLevel[lastExp]=1) and (expStack[lastExp][1]='*') then begin
    delete(expStack[lastExp],1,1); {Beware: the rest may stay level 1! }
    c:=expStack[lastExp][1];
    if (c>='A')and(c<='Z') then expLevel[lastExp]:=0; {assume Id= level 0}
    t:='->'+t;
  end else t:='.'+t;
  unaryOp('', t,  0,1);
end;

procedure pushIdent(pi:pide);
{ ACTION: identifier --> expression stack
}
var s:str20;
begin
  getIdent(pi,s); pushExp(s,0);
end;

procedure pushLine(var t:textline; n:integer);
{ ACTION: n characters from t --> expression stack. Precedence level := 0
}
var s:str80; k:integer;
begin  s:=''; for k:=1 to n do s:=s+t[k]; pushExp(s,0); end;

procedure pushIntVal(i:longint);
{ ACTION: integer constant --> expression stack. L suffix if i is big.
}
var s:str80;
begin str(i,s);
  if (i<minInteg)or(i>maxInteg) then s:=s+'L';
  pushExp(s,0);
end;

{*********   auxiliary variable manager ********}

procedure initAuxVar(n: integer);
{ ACTION: prepare procedure at level n for aux strings _s1 _s2 .., sets _e1
  CALLER:
}
begin
  with auxVar[n] do begin
    maxSets:=0;maxStri:=0;    {max. nb. of aux vars required}
    lastSets:=0;lastStri:=0;  {nb. of aux. vars in use inside an expression}
  end;
end;

procedure resetAuxVar(n: integer);
{ ACTION: reset counter of aux. vars currently in use
  CALLER: Cbulk, at the end of each statement.
  INPUT : nesting level n
}
begin
  with auxVar[n] do begin
    lastSets:=0;
    lastStri:=0;
  end;
end;

procedure pushAuxString;
{ ACTION: provide for a fresh string variable on the expression stack
  CALLER:
}
var k:integer; s:str20;
begin
  with auxVar[blockLevel] do begin
    lastStri:=succ(lastStri);
    if lastStri>maxStri then maxStri:=lastStri;
    str(lastStri,s); pushExp('_s'+s,0);
  end;
end;

procedure pushAuxSet;
{ ACTION:  a fresh set, like pushAuxString
  CALLER:
}
var k:integer; s:str20;
begin
  with auxVar[blockLevel] do begin
    lastSets:=succ(lastSets); if lastSets>maxSets then maxSets:=lastSets;
    str(lastSets,s);  pushExp('_e'+s,0);
  end;
end;

procedure declareAuxVar(n: integer);
{ ACTION: output declaration part for aux. strings/sets of current procedure
  CALLER: Cbulk, at the end of a statement part.
}
var s:str255; t:str20; k: integer;
begin
  with auxVar[n] do begin
    if (maxSets>0)or(maxStri>0) then outC('/*|*/`');
{list separator for re-ordering: postprocessor will lift the stuff in front}
    if maxSets>0 then begin s:='Set '; {set variable declaration}
      for k:=1 to maxSets do begin
        str(k,t);
        s:=s+'_e'+t;
        if k<maxSets then s:=s+', ' else s:=s+';';
      end;
      outC(s);
    end;
    if maxStri>0 then begin s:='String '; {strings declared}
      for k:=1 to maxStri do begin
        str(k,t);
        s:=s+'_s'+t;
        if k<maxStri then s:=s+', ' else s:=s+';';
      end;
      outC(s);
    end;
  end;
end;

procedure getTypeName(pt:ptpel; var s:str20);
{ ACTION: return the name of type pt^ in string s. Local types get a prefix.
  CALLER: localCopies, putTypeName,
}
begin
  with pt^ do begin
    if (cl>='A')and(cl<='Z') then begin {user defined type}
      if tname<>nil then getIdent(tname,s) else s:='???Type?';
      if tname^.class=forwId then s:=s+' *'; {exception: forward pointing}
    end else if (tname<>Nil) then begin
      getIdent(tname,s);
(*
      case cl of {standard types}
      '*': s:='void'; {wildcard type}
*)
    end  else s:='BUGtype='+cl; {any type has a valid name! }
    if tname<>Nil then begin {check for nonglobal type name}
      if tname^.y > 2 then s:='_t'+s;
    end;
    s:=s+' ';
  end;
end;

procedure localCopies(p:pide); 
{ ACTION: array/record Value Parameters in Pascal become pointer params in C.
          The current proc. may need explicit local scratchpad copies of them.
  CALLER: Cbulk, when entering a procedure's statement part.
  INPUT : p= entry point of the parameter list to be scanned here.
}
var nam,typ:array[1..20] of str20;
    reco: array[1..20] of boolean;
    ncopy: integer;
    pp:pide; pt:ptpel; class: char; i:integer; s:str80;
begin
  pp:=p^.chain; ncopy:=0;
  while pp<>Nil do begin {1st pass: get names,typeId,class}
    pt:=pp^.typof;
    if pt^.cl='L' then begin class:=pt^.p^.cl;
      if class in ['R','Y','s','e'] then begin {record array string set}
        ncopy:=succ(ncopy); reco[ncopy]:=(class='R');
        getTypeName(pt^.p,typ[ncopy]);
        getIdent(pp,nam[ncopy]);
      end;
    end;
    pp:=pp^.chain;
  end; {while}
  for i:=1 to ncopy do begin {first the local declarations}
    s:=typ[i]+auxPrefix+nam[i]+';`'; outC(s);
  end;
  for i:=1 to ncopy do begin {the copy operations}
    if reco[i] then s:='_mR' else s:='_mY'; {record or array move macro}
    s:=s+'('+auxPrefix+nam[i]+','+nam[i]+');`';
    { -- sizeof('+typ[i]+'));`'; }
    outC(s);
  end;
end;

{-- declaration part handler ---}

procedure putIdent(pi:pide);
{ ACTION: output an identifier. In statement part, use Cnesting.pushIdentL !
}
var  s:str20;
begin   getIdent(pi,s); outC(s); end;

procedure putTypeName(pt:ptpel);
{ ACTION: output a type name
}
var s:str20;
begin  getTypeName(pt, s); outC(s); end;

procedure putPointedName(pt:ptpel);
{ ACTION:  output a type name accessed via a pointer type pt
  CALLER:  TypeDeclare
a pointer type element has 3 possible states:
 1:  the pointed type p is fully defined
 2:  the pointed Name only, not the own name, not the pointed type.
 3:  the own name and the pointed name (chained to the own)
 In cases 2 and 3 we assume that the pointed thing is a record, and put a
 struct tag with standard prefixChar
}
var q:pide;
begin
  if pt^.p<>Nil then putTypeName(pt^.p) else begin
    q:=pt^.tname;   outC('struct '+auxPrefix);
    if q^.chain=Nil then putIdent(q) {is pointed name of anonymous ptr}
    else putIdent(q^.chain);
    outC(' ');
  end;
end;

var maxEnum: integer;
    enumId: array[1..10] of pide; {entry points to pending enum lists}
{Purpose: after Set of no-name enum, or array index type = no-name enum,
    must output the enum identifiers separately}

procedure pushEnum(id:pide);
{ ACTION: add Id to the list of pending "anonymous" enum types
  CALLER: outSet, indexCode
}
begin maxEnum:=maxEnum+1; enumId[maxEnum]:=id end;

procedure outEnum(pid:pide);
{ ACTION: output a list somewhat like "enum [ item1, item2, ... ]"
  CALLER: enumLists, fullTypeName, typeDeclare
}
var pp:pide;
begin
  outC('enum {');  pp:=pid;
  while pp<>Nil do begin putIdent(pp);
    pp:=pp^.chain; if pp<>nil then outC(',');
  end; {while}
  outC('} ');
end;

procedure enumLists;
{ ACTION: output all piled-up enum lists as pseudo variables, clear the list.
  CALLER: typeDeclare, putVarList.
}
var i: integer;
begin
  for i:=1 to maxEnum do begin
    outEnum(enumId[i]); outC('_n'); putIdent(enumId[i]); outC(';`');
  end;
  maxEnum:=0;
end;

procedure outSet(pq:ptpel; brandNew:boolean);
{ ACTION: output a Set type declarator. Save any internal Enums for later.
  CALLER: fullTypeName, typeDeclare
  INPUT : if brandNew=false, check for existing name
}
var pix:ptpel; chk:string[4];
    nameOk:boolean; i:integer;
begin {All sets are equal to set of char, in our version}
  if not brandNew then begin {check if we can do away with a name}
    chk:=''; for i:=1 to 4 do chk:=chk+pq^.tname^.name[i];
    nameOk:=chk<>'Set ';
  end else nameOk:=false;
  if nameOk then begin
    putTypeName(pq);
  end else begin
    outC('Set '); pix:=pq^.p; {base type}
    if pix^.cl='E' then {anonymous enum check}
      if pix^.tname^.class=constId then pushEnum(pix^.tname);
  end;
end;

procedure indexCode(pt:ptpel;  var mx:str80);
{ ACTION: get an array dimension. Save embedded enum types.
          for type Subrange, make m-l+1, for type string make l+1
  CALLER: fullTypeName, typeDeclare
  INPUT : pt points to some array index type
  OUTPUT: mx = an integer expression, for array dimension in C.
}
var pref,aux:str20; n:longInt;
    id:pide;
begin
  with pt^ do begin
    if (cl='S')or(cl='s') then begin {subrange,string}
     if ixName=Nil then begin {no symbol}
      if cl='S' then str(m-l+1,mx) else str(l+1,mx)
     end else begin {maximum is symbolic}
      if cl='S' then n:=-l+1 else n:=1;
      if n=0 then aux:='' else begin str(n,aux);
        if aux[1]<>'-' then aux:='+'+aux;
      end;
      getIdent(ixName,pref); mx:=pref+aux;
     end;
   end else if cl='b' then begin {boolean}
     mx:='2'
   end else if (cl='y')or(cl='c') then begin {byte,char}
     mx:='256';
   end else if cl='E' then begin {Enum}
     str(l,mx);  id:=tname;
     if id^.typof<>pt then pushEnum(id); {anonymous enum, follows later}
   end else mx:='BUG';
  end;
end;

procedure strucUnion(p,q:pide); forward;
{ for mutual recursion with fullTypeName}

procedure fullTypeName(pt:ptpel; expand: byte; var pref,suff:str80);
{ ACTION:  output expanded type declaration for type Pt^.
           For subranges fall back to the base type. Recursion for records
  CALLER:  strucUnion, typeDeclare, putVarlist, Cnesting.DumpInfo
  INPUT :  expand options: 0 abbreviate with type name, if known
           1:  expand even if Pt has has a type name.
           2:  expand by simplification: array,string->pointer, enum->short
               For aux. parameter passing in Cnesting.DumpInfo
  OUTPUT:  for Array and Pointer types, return * prefixes and [dim] suffixes
           which are attached to following identifier(s), in C.
}
var arlen,pre2,suf2:str80;
    pq,pix:ptpel; cla:char;
    noName: boolean;
begin pref:='';suff:='';
  noName:=(expand>0);
  pq:=pt; cla:=pq^.cl;   {trace down any evident anonymous types ! }
  while ((noName) or (pq^.tname=Nil)) and
        ((cla='Y')or(cla='P')or(cla='S')or(cla='s'))
  do begin
    noName:=false; {works only at first sight}
    if  cla='P' then begin { precedence enforced !}
      if suff<>'' then begin pref:='('+pref; suff:=suff+')' end;
      pref:='*'+pref; pq:=pq^.p
    end; {pointer}
    if cla='S' then pq:=pq^.p
    else if cla='s' then begin {string}
      if expand=2 then begin
        pq:=pq^.q; { outC('char ');} pref:='*'+pref;
      end else begin
        indexCode(pq,arlen); pq:=pq^.q;
        if pref<>'' then begin pref:='('+pref; suff:=suff+')' end;
        suff:=suff+'['+arlen+']';
      end;
    end else if cla='Y' then begin
      if expand=2 then begin {simply transform array -> pointer}
        pref:='*'+pref;
      end else begin
        pix:=pq^.p; {index type}
        indexCode(pix,arlen);
      { if pix^.cl='S' then begin subrange, the most frequent case}
      { implement: named and no-name enum, boolean byte char }
        if pref<>'' then begin pref:='('+pref; suff:=suff+')' end;
        suff:=suff+'['+arlen+']';
      end;
      pq:=pq^.q; {the base type or rest-array type }
    end;
    cla:=pq^.cl;
  end;  {while}
  if (cla='R')then begin
    {Design quirk: Nameless record has tname = first field name, Named record
     has tname = type Id name. So, tname^.class makes the difference !
     Bug1: Unify with typeDeclare code! Here we chain with ptpels NOT pides
     Bug2: If expand=2,  make char * out of no-name record.
    }
    if (pq^.tname^.class)=fieldId then begin {anonymous record}
      if expand=2 then outC('char ')  {suspicious ptr conversion?}
      else strucUnion(Nil,pq^.tname);
    end else putTypeName(pq);
  end else if cla='e' then begin
    if expand=2 then outC('Set ') else outSet(pq,false);
  end else if (cla='E') then begin  {check for anonymous Enum}
    if expand=2 then outC('short ')
    else if (pq^.tname^.class=constId) then outEnum(pq^.tname)
    else putTypeName(pq);
  end else begin
    putTypeName(pq);
  end;
end;

procedure strucUnion(p,q:pide);
{ ACTION: output a variant record --> mixed struct/union declaration
          if p<>Nil, we possibly need a Struct Tag.
  CALLER: fullTypeName, typeDeclare
  INPUT : p=type identifier if known. q=ident of the first field
   BUG:   in ancient C, struct/union member names MUST be almost unique,
          even among different struct/unions,
          whereas each Pascal record has its private scope.
}
var uIndex, uBefor,uNext:integer;
    unOpen, stOpen: boolean; {flags inner open union and struct parts}
    pref,suff:str80;
    pp:pide; pfield:ptpel;
begin
  pp:=q;
  uBefor:=0; unOpen:=false; stOpen:=false;
  pfield:=pp^.typof;
  uIndex:=(pfield^.m) mod 64; {the 1st field}
  if uIndex>0 then begin
    outC('@+union '); uBefor:=-1;
  end else outC('@+struct ');
  if p<>Nil then begin outC(auxPrefix); putIdent(p); end;
  outC(' {`');
  while pp<>Nil do begin
    if pp^.chain<>Nil then uNext:=(pp^.chain^.typof^.m) mod 64
    else uNext:=0;
    if uIndex>uBefor then begin {start new union and/or struct part}
      if uBefor=0 then begin
        outC('@+union {`'); unOpen:=true;
      end else if uBefor>0 then begin
        if stOpen then begin {close inner struct}
          outC('@-} _'); outCi(uBefor); outC(';`'); stOpen:=false;
        end;
      end;
      if uIndex=uNext then begin {start a struct inside union }
        stOpen:=true; outC('@+struct {`');
      end;
    end;
    fullTypeName(pfield^.p, 0, pref,suff); {maybe recursion }
    outC(pref);putIdent(pp); outC(suff);
    uBefor:=uIndex; pp:=pp^.chain; uIndex:=uNext;
    if pp<>Nil then  pfield:=pp^.typof;
    outC(';`');
  end; {while}
  if stOpen then begin outC('@-} _'); outCi(uBefor); outC(';`'); end;
  if unOpen then outC('@-} _0;');
  outC('@-} ');
end;

procedure typeDeclare(pi: pide);
{ ACTION: write a C typedef construct after  Pascal Type parsing.
          Variant record yields a   struct of union of struct in worst case.
          Local type Ids get _t prefix, declaration is bracketed:
          postprocessor will make it global.
  CALLER: Cbulk.compilerAction @typeEnd
  INPUT : type identifier pi^
  Bugs: when the Id is re-declared at level 1 (2 distinct unit interface parts)
        output is commented out! Suppose that those type redeclarations are
        STRICTLY identical.
        merge some features of this routine with fullTypeName ?
}
var pt,pix:ptpel; pp:pide;  class:char;
    arlen:array[1..10] of longint; {will support up to 10 dim arrays ! }
    parlen: array[1..10] of ptpel;
    suffix,doubleDef:boolean;
    j,k:integer;
    pref,suff:str80;
begin
  maxEnum:=0;
  doubleDef:= (pi^.reUse>=2); { double declaration error in C }
  if scope.actual>2 then outC('@=/*(*/`'); {extraction bracket}
  if doubleDef then outC('@=#if 0`');  {re-defined!}
  pt:=pi^.typof;
  outC('@+typedef ');
  class:=pt^.cl;
  suffix:=false; pref:=''; suff:='';
  if class='R' then begin
    strucUnion(pi,pi^.chain);
  end else if (class='s') then begin {string}
    j:=pt^.l;
    if j>255 then putTypeName(pt) else begin suffix:=true;
      putTypeName(pt^.q); {char} arlen[1]:=j+1; arlen[2]:=0;
      parlen[1]:=pt;
    end;
  end else if class='Y' then begin
    fullTypeName(pt, 1, pref,suff);
  end else if class='P' then begin
    putPointedName(pt); pref:='*';
  end else if class='S' then begin {map subrange to base type}
    {outC('/* '); outCi(pt^.l);outC('..');outCi(pt^.m);outC('*/ '); }
    putTypeName(pt^.p);
  end else if class='e' then begin
    outSet(pt,true);
  end else if class='E' then begin
    outEnum(pi^.chain);
  end else putTypeName(pt);
  outC(pref);
  if scope.actual>2 then outC('_t'); {to be made global}
  putIdent(pi);
  outC(suff);
  if suffix then begin k:=1;  {still used for strings...}
    while arlen[k]>0 do begin outC('[');
      if parlen[k]<>Nil then begin
        indexCode(parlen[k], pref); outC(pref);
      end else outCi(arlen[k]);
      outC(']');
      k:=succ(k);
    end;
  end;
  outC(';');
  outC('@-');
  enumLists;
  if doubleDef then outC('#endif`');
  if scope.actual>2 then outC('/*)*/`'); {extraction bracket end}
end;

procedure ANSIheader(pi:pide; n:integer; complete,imported:boolean);
{ ACTION: write funct header in ANSI C. If complete, no AuxParams will follow.
          if imported, flag the thing as External.
  CALLER: Cnesting.extendHeader, Cnesting.CreatePlist
  INPUT : pi=proc/funct identifier, n= Serial Number for prefixing if >0.

  Array,String,Set are ALWAYS "var" params in C, but NO * should appear.
  Records are forced "var" (pointer) params, too, WITH a * however.
  In the Implement section of a Unit, non-exported names are flagged STATIC.
}
var pt,rt:ptpel; pp:pide; clas,ptp:char;
    static:boolean;  {for static prefix of unit-private globals }
    isString:boolean;
begin
  isString:=false;
  if (pi^.class<>unitId) then begin {else, parasitic from Prog header !}
    pt:=pi^.typof;  clas:=pt^.cl; {proceDure or fUnction}
    static:=implemPart and (pi^.y<>4); {y=4 <=> it was Interface defined ? }
      { not(pi^.reUse) ? and (scope.actual>=2) ??? };
    if static then outC('static ') else if imported then outC('extern ');
    if clas='D' then outC('void ');
    if clas='U' then begin rt:=pt^.p; {result type: simple or string}
      isString:=( rt^.cl='s' );
      if isString then outC('char *') else puttypeName(rt);
    end;
    if n>0 then outC('_f');
    if n>1 then outCi(n); {serial nb of unique id's}
    putIdent(pi);
    outC('(');
      if isString then begin
        outC('char *'+auxPrefix); putIdent(pi);
        if pi^.chain<>Nil then outC(',');
      end;
      if pi^.chain<>Nil then begin
        pp:=pi^.chain;
        while pp<>Nil do begin
          pt:=pp^.typof; {A or L parameter} putTypeName(pt^.p);
          ptp:=pt^.p^.cl; {parameter's type class}
          if ((pt^.cl='A')and not((ptp='Y')or(ptp='s')or(ptp='e')))
            or (ptp='R') then outC('*'); {non-Array Var, or Records, get *}
          {var parameter -> a pointer. Array/Record special cases }
          putIdent(pp);
          pp:=pp^.chain; if pp<>nil then outC(',');
        end; {while}
      end;
    if complete then begin {else leave room for aux parameters}
      if (pi^.chain=Nil)and(not isString) then outC('void');
      outC(')`');
    end else outC('`');
  end;
end;

procedure putVarList(pi:pide; imported,normal: boolean);
{ ACTION: output variable declaration: a list having a common type.
          structured constants made into C "initializers" here.
  CALLER: Cbulk.compilerAction _tpVarList, _constDeclare
  INPUT : pi -> the 1st var name, normal=True if varlist, else typed const
}
var pt:ptpel; pp:pide;
    pref,suff:str80;
begin
  maxEnum:=0;
  pt:=pi^.typof; {named or unnamed type ? } pp:=pi;
  if imported then outC('extern ')
  else if {(not normal) OR ??} ((scope.actual<=2) AND implemPart)
  then outC('static ');
  fullTypeName(pt, 0, pref,suff);
  if normal then begin
    while pp<>Nil do begin
      outC(pref);putIdent(pp);outC(suff);
      pp:=pp^.chain; if pp<>Nil then outC(',');
    end; {while}
    outC(';`');
    enumLists;
  end else begin
    outC(pref);putIdent(pp);outC(suff);
    if not imported then outC('=`');
    {the rest of the initializer comes in Cbulk}
  end;
end;

procedure pushString(var s:textline; len:integer);
{ ACTION: put char string s on the expression stack, using C syntax.
  CALLER: constDeclare
}
var t:str80;
    i,j,n, c1,c2,c3,z: integer; c:char;
begin
  t:='';
  for i:=1 to len do begin c:=s[i];
    if (c<' ')or(c>'~') then begin {octal format} n:=ord(c);
      t:=t+'\';
      c3:=n mod 8; n:=n div 8; c2:=n mod 8; c1:=n div 8;
      z:=ord('0');
      t:=t+(chr(c1+z)+chr(c2+z)+chr(c3+z));
    end else begin
      if (c='\')or(c='''')or(c='"')or(c='?') then t:=t+'\';
      t:=t+c;
    end;
  end;
  pushExp(t,0);
end;

procedure outCstring(var s:textLine; len:integer; quote:byte);
{ ACTION: put string s (un-/single-/double- quoted ) in the C output buffer.
  CALLER: constDeclare, Cbulk.caseLabel
  OUTPUT: output in C format with octal control chars
}
var i,n, c1,c2,c3,z: integer; c:char;
begin
  if len>maxLine then len:=maxLine; {truncate}
  pushString(s,len);
  if quote=1 then unaryOp('''','''',0,0) else
  if quote=2 then unaryOp('"','"',0,0);
  outCexp(1);
end;

procedure constDeclare(pi:pide; refType:ptpel;
  var stat:scanStatus; imported:boolean);
{ ACTION: translate a single Pascal (non-typed) const declaration
  CALLER: cbulk.compilerAction _assignCon
  INPUT : pi^ identifier, scan status for value and type.
          if pi=Nil, do only the value!
          refType is  Semanti6.machineInfo.ctype
  OUTPUT: for string and float constants, copy the parsed string stat.s
          Big integers declared by #define ;  small integers by enum;
          chars by funny enum, too.
          strings and reals by static variable initializer
  BUGS:   #define may violate Pascal scope rules
          put typedef before the dummy enum declarations?
}
var pt:ptpel;  cla:char; ddef,normal:boolean;
    qu:byte; xx:longInt;
begin
  normal:=(pi<>Nil);
  if normal then ddef:=(pi^.reUse>=2) else ddef:=false;
  if ddef then outC('@=#if 0`'); {WARNING: redefined, do NOT use /*...*/ ! }
  if normal then begin
    pt:=pi^.typof; xx:=pi^.x;
  end else begin
    pt:=refType; xx:=stat.ii; {last integer const}
  end;
  cla:=pt^.cl;
  if cla in ['i','w','l','y','h'] then begin {integer numbers}
    if normal then begin
      if (xx>=0)and(xx<32767) then begin {or 256 only? }
        { may replace #define with something that's scope aware:}
        { if imported then outC('extern ') else
        if implemPart then outC('static '); }
        outC('typedef enum {'); putIdent(pi); outC('='); outCi(xx);
        outC('} _n'); putIdent(pi); outC(';`');
      end else begin
        { add opcode @1 to goto first column ?}
        outC('@=#define '); putIdent(pi); outC(' ');
        outCi(xx); outC('`');
      end;
    end else outCi(xx);
  end else if (cla='c') and normal then begin {normal chars are Enums,too}
    {if imported then outC('extern ') else if implemPart then outC('static ');}
    outC('typedef enum {'); putIdent(pi); outC('=');
    outCstring(stat.chain,stat.chainlen,1);
    outC('} _n'); putIdent(pi); outC(';`');
  end else begin
    if normal then begin
      if imported then outC('extern ') else if implemPart then outC('static ');
      if cla='s' then outC('char *')
      else if cla='c' then outC('char ')
      else putTypeName(pt);
      putIdent(pi);
    end;
    if (not imported) or (not normal) then begin
      if normal then outC('=');
      if (cla='s')or(cla='r')or(cla='c')or(cla='d') then begin
        if cla='s' then qu:=2 else if cla='c' then qu:=1 else qu:=0;
        outCstring(stat.chain, stat.chainlen,qu);
      end else if cla='b' then begin {Boolean}
        if xx=0 then outC('FALSE') else outC('TRUE')
      end else begin {? not implemented}
        outCi(xx);
      end;
    end;
    if normal then outC(';`');
  end;
  if ddef then outC('@=#endif`');
end;

end. {unit Cdeclara}
