{$R+,S+}              { Copyright (c) 1991  by  Georg Post }
program toytest;
uses crt,dos,
     toymenu, { makes windows, bar menus, scroll menus, tick menus }
     toyedit; { line and screen editor, Dos directory read,.. }

{ This is a trivial 2-window editor which uses part of Crt and Dos units.
  Not very useful "as is". Demonstrates the PCPC translation of Crt,Dos.
  Screen gets frequently clobbered with outdated window fragments, since
  Crt has no "gettext" function.

    Pascal Source Code is copyrighted, but PCPC-produced C versions, as well
    as other low-level code derived from this stuff, are in the public domain.
}

const split=13; {screen split up in 2 parts 1..split-1, split..25}
var edBuff: array[1..2] of ediCtrlBloc;
    active: integer;
    evTab:array[1..10] of integer; {table of shortcut events}

procedure entryBox(x,y:byte; prompt:str80; var s:str50; var escape:boolean);
{ make an entry box at upper left = (x,y), to edit s which is initialized.
  If escape=True at exit, s is left undisturbed.
}
begin
  {toymenu.}frame(x,y,x+51,y+2, 2, lightgreen,blue, prompt,
   'Entry box. <Ret> validate, <Esc> abort');
  textcolor(lightcyan);
  {toyEdit.}readString(s, x+1,y+1,50, escape);
  frame(x,y,x+51,y+2, 1, lightgray,black, '','');
end;

procedure getEvent(funcKey: integer; var state:str10; var event: integer);
{ Controls the bar menu with pull-down appendixes, and fast keys.
  state[1]='2'...'9' currently selected submenu
  state[2...9] selection inside submenu
  funcKey is 0 (Esc) or 1..10 (F1..F10) for shortcut keys.
  F10 and Esc: always goto main menu
Input: event is previous choice. If last decimal >0, fall into submenu.
Output: event is user choice
}
var choice,cbar,hotkey:integer;
    goSubmenu,ok: boolean;
begin
  cbar:=(event div 10)-1; ok:=false;
  goSubmenu:=((event mod 10)<>0);
  hotKey:=funcKey;
  if hotKey=10 then begin hotKey:=0; {F10: main menu }
    goSubmenu:=false;
  end;
  if hotKey=0 then repeat
    barMenu('THE TOY EDITOR',
     {if goSubmenu, just repaint barMenu, no key wait}
     'File |Edit-F4|Options   |Window',21,1,cbar,goSubmenu);
    goSubmenu:=false;
    if cbar<0 then hotkey:=-cbar else
    if cbar>0 then begin
     choice:=ord(state[cbar+1])-ord('0');
     if choice>0 then begin {submenu follows}
      case cbar of
       1:rollMenu('Text files',
         'Load   F3|Save   F2|Save as..F8|ChangeDir|Exit Toy',
         21,3, choice);
       4:rollMenu('Windows',
         'Next   F6|Zoom   F5|Erase  F7', 57,3, choice);
      else{otherwise} end;
      if choice>0 then begin state[cbar+1]:=chr(choice+ord('0'));
        ok:=true;
      end else if (choice<0)and(choice>-10) then begin {f1...f9 key code }
        hotKey:=-choice;
      end;
     end else ok:=true; {main menu = good choice}
    end; {if cbar>0}
  until ok or (hotKey>0);
  if hotKey>0 then begin
    event:=evTab[hotKey];
  end else if ok then begin
    event:=10*(cbar+1)+choice;
  end;
end;

procedure initToys; {make 2 edit buffers}
var i:integer;
begin
  with edBuff[1] do begin topRow:=1; bottomRow:=split-1; buffNumber:=1; end;
  with edBuff[2] do begin topRow:=split; bottomRow:=25; buffNumber:=2 end;
  edi('N',edBuff[1]);
  edi('N',edBuff[2]);
  active:=1;
  for i:=1 to 10 do evTab[i]:=10; {dummy event}
  evTab[2]:=22;  evTab[3]:=21;  evTab[4]:=30;  evTab[5]:=52;
  evTab[6]:=51;  evTab[7]:=53;  evTab[8]:=23;
end;

procedure zoomWindow(active:integer);
begin
  with edBuff[active] do begin
    if active=1 then begin
      if bottomRow=(split-1) then bottomRow:=25 else bottomRow:=split-1
    end else if active=2 then begin
      if topRow=split then topRow:=1 else topRow:=split;
    end;
  end;
end;

procedure checkSave(var b:ediCtrlBloc);
var no:boolean;
    rep:str50;
begin
  with b do if modified then begin
    rep:='Y';
    entryBox(10,8,fname+' modified. Save Y/N ?',rep,no);
    if (not no)and(upcase(rep[1])<>'N') then edi('S',b);
    modified:=false;
  end;
end;

procedure mainLoop;
var quit,no: boolean;
    state: str10;
    name: str80;
    dir :str50;
    callCode,event: integer;
begin
  clrScr;
  initToys;
  quit:=false;
  callCode:=0; {entry code for getEvent, hotkey filtering}
  dir:='.';  {current directory}
  state:='11001'; event:=21; { File | Load }
  repeat getEvent(callCode,state,event);
    case event of {event number has 2 decimals: bar menu, submenu}
    21: begin {load file to currently selected window}
          fileMenu(dir, '*.*',name);
          if name<>'' then begin {else no file}
            checkSave(edBuff[active]);
            edBuff[active].fname:=name;
            edi('R',edBuff[active]);
            edi('E',edBuff[active]);
          end;
        end;
    22: begin
          edi('S',edBuff[active]); {save current window}
          edi('E',edBuff[active]);
        end;
    23: begin {save with new name}
          entryBox(10,8,'Save with a new file name',edBuff[active].fname,no);
          if not no then edi('S',edBuff[active]);
          edi('E',edBuff[active]);
        end;
    24: begin {select directory}
          entryBox(10,8,'Directory for loading files',dir,no);
          edBuff[active].exitFlag:=0;
        end;
    25: quit:=true;
    30: edi('E',edBuff[active]); {edit current window}
    52: begin {zoom current window}
          zoomWindow(active);
          edi('E',edBuff[active]);
        end;
    53: begin
          checkSave(edBuff[active]);
          edi('N',edBuff[active]); {erase buffer}
          edi('E',edBuff[active]);
        end;
    51: begin {goto next window}
          if active=1 then active:=2 else active:=1;
          edi('E',edBuff[active]);
        end;
    else{otherwise} end;
    callCode:=edBuff[active].exitFlag; {may become >0 at exit of edi('E'... }
  until quit;
  checkSave(edBuff[1]);
  checkSave(edBuff[2]);
  gotoxy(1,25);
end;

begin mainLoop end.


