{$R+,S+}

unit ToyEdit;

{ Toy  screen editor Edi, and string editor ReadString.
 Very conservative: needs no DOS, no BIOS, no INLINE MEM ABSOLUTE....

 Edi works on data structures of type EdiCtrlBloc.
 Calls: Edi(<code:  'R'ead 'N'ew 'E'dit 'S'ave>,<controlBloc>)
 The first call for a new structure B  MUST be Edi('N',B)

It is incredibly slow; big buffer shuffling at entry & exit.
No Block nor Search/Replace functions!
Text limit 25 K. Line limit 79 characters.
Not 100% TP editor compatible.
There are no 2-key command sequences.
Usage: see procedure helpEdi below.

}
interface
uses crt;

const
    ediMaxBuf=25000;
type

  ediBuffer= packed array[0..ediMaxBuf] of char;
  str50= string[50];
  ediCtrlBloc=record
    fname: str50;
    bf: ediBuffer;
    overflow,  {buffer overflow encountered}
    modified: boolean; {flags modified, unsaved buffer}
    buffNumber, {serial number of the buffer}
    size,       {used buffer size }
    headPos,    {head of buffer: valid chars at 1..headPos}
    tailPos     {tail of buffer at tailPos..maxBuf},
                {always: bf[0] == bf[headPos] == bf[maxBuf]= CR }
    nLine,      {numb of current line}
    totLine,    {total nb of lines }
    cursor,     {cursor position}
    exitFlag,   {0 if normal termination}
    topRow,bottomRow, VideoMaxL, {for split-screen editing}
    ToggleBackColor,
    ToggleColor,
    HeadBackColor,
    HeadFirstColor,
    HeadSecondColor,
    TextBackColor,
    CharColor :integer;
  end; {ediCtrlBloc}

procedure Edi(opcode:char; var data:ediCtrlBloc);
  {screen editor. works inside a full-width screen window.}

procedure readString(var s:str50; x,y,maxLen: integer; var escape:boolean);
   {"readln(s)" replacement. use ESC to abandon string entry, RET to validate}
   { edit s @ (x,y), up to maxLen chars. escape=TRUE if aborted with Esc key }
   { s must be initialized before a call to readString !}


implementation

const
  linErase=true; {delEoln exists}
  linInsDel=true; { insLine, delLine exist}
  maxCol=79; rightCol=80;
  lastAscii=255;

type tline= packed array[0..rightCol] of char;
     str80=string[80];

var null,cr,lf,esc,del,tab,bs,fs,
    ctrS,ctrD,ctrE,ctrX, {cursor left,right,up,down}
    ctrA,ctrF, {word left,right}
    ctrR,ctrC, {page up,down}
    ctrW,ctrZ, {start, end of text}
    ctrG,ctrT,ctrY, {del char,word,line}
    ctrP,ctrL, {delEol, recoverLine}
    ctrV,ctrO, {ins/rep  indent/firstCol toggle}
    ctrN {insLine},
    ctr29{help}, ctr30{homeLine}, ctr31{endLine},
    F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,  {funct keys}
    lastCharAscii :char;

    cursLin, cursCol: integer;
    cln: tline; {the current line buffer}
    headStat: integer; {0: all false, 1: line, 2:column false, 8:OK }
    indent,
    insMode:boolean; {false if replace mode}

procedure initColors(var b:ediCtrlBloc);
begin
  with b do begin
    ToggleBackColor:=blue;
    ToggleColor:=yellow;
    HeadBackColor:=brown;
    HeadFirstColor:=lightgreen;
    HeadSecondColor:=lightcyan;
    TextBackColor:=black;
    CharColor:=green;
  end;
end;

procedure initChar;
begin null:=chr(0); cr:=chr(13); lf:=chr(10); esc:=chr(27); del:=chr(127);
   ctrS:=chr(19);ctrD:=chr( 4);ctrE:=chr( 5);ctrX:=chr(24);ctrP:=chr(16);
   ctrA:=chr( 1);ctrF:=chr( 6);ctrR:=chr(18);ctrC:=chr( 3);ctrL:=chr(12);
   ctrW:=chr(23);ctrZ:=chr(26);ctrG:=chr( 7);ctrT:=chr(20);ctrY:=chr(25);
   ctrV:=chr(22);ctrN:=chr(14);ctrO:=chr(15);
   tab:=chr( 9);bs:=chr(8);fs:=chr(28);
   F1:=chr(176);F2:=chr(177);F3:=chr(178);F4:=chr(179);F5:=chr(180);
   F6:=chr(181);F7:=chr(182);F8:=chr(183);F9:=chr(184);F10:=chr(185);
   ctr29:=chr(29); ctr30:=chr(30); ctr31:=chr(31);
   lastCharAscii:=chr(255);
end;

procedure readkbd(var c:char); {treat IBM PC cursor controls}
var cc:char;n:integer;
begin  c:=readKey;
  if (c=#0) then begin
   if keypressed then begin c:=readKey;
    if ((ord(c)>=59) and (ord(c)<=68)) then c:=chr(ord(c)+117) else
    if c in ['G','H','I','K','M','O','P','Q','R','S',#132,#118] then begin
     case c of
      'K': cc:=ctrS; {left arrow}  'M': cc:=ctrD; {right arrow}
      'H': cc:=ctrE; {up arrow}    'P': cc:=ctrX; {down arrow}
      'G': cc:=#30;  {home line}   'O': cc:=#31;  {end line}
      'I': cc:=ctrR; {page up}     'Q': cc:=ctrC; {page down}
      'R': cc:=ctrV; {ins toggle}  'S': cc:=ctrG; {del}
      #118:cc:=ctrZ; {CtrlPgDwn}    #132:cc:=ctrW;  {ctrlPgUp}
     end {case}; c:=cc;
    end else c:=null;
   end;
  end;
end;

procedure readChar(var c:char); {terminal dependent}
begin  readkbd(c);
  if c>lastCharAscii then c:=chr(ord(c)-lastAscii-1);
  if c=del then c:=bs else if c=lf then c:=ctrX;
end;

procedure beep; begin write(chr(7)); end;

procedure helpEdi;
var c:char;
procedure w(s:str80); begin writeln(s) end;

begin
  window(1,1, 80,25); textcolor(lightGray); clrScr;

w('  HELP on the TOY EDITOR:  79-character lines,  25 K files.');
w('');
w('Ins    or Ctr-V:  toggle between insert/replace mode.');
w('Ctrl-O:  toggle between  Indent/ First Column  on new line');
w('ESC   :  terminate editing');
w('');
w('arrows  or... Ctr-D:  cursor right   Ctr-S:  cursor left');
w('              Ctr-E:  cursor up      Ctr-X:  cursor down');
w('Ctr-F:  goto next word');
w('Ctr-A:  go back 1 word');
w('Home    goto first column');
w('End     goto last column');
w('PgUp       or  Ctr-R:  go back 1 page            F2:  Save');
w('PgDn       or  Ctr-C:  goto next page            F3:  Load');
w('Ctrl-PgUp  or  Ctr-W:  goto top of text          F5:  Zoom');
w('Crtl-PgDn  or  Ctr-Z:  goto end of text          F6:  Next Window');
w('<--- :  backspace & delete char                  F7:  Erase');
w('Ctr-G:  delete char                              F8:  Save as..');
w('Ctr-T:  delete word, or glue lines               F9:  Switch color');
w('Ctr-L:  recover line before change               F10  Main menu');
w('Ctr-Y:  delete line: irreversible !');
w('Ctr-P:  delete end of line');
w('Ctr-N:  insert line');
w('                           (Press any key to return to editor)');

  c:=readKey;
end;

{*******  text buffer handling  *********}

procedure moveLines(var b:ediCtrlBloc; n:integer);
{move between head/tail sections of buffer}
var k:integer;c:char;
begin k:=0;
  with b do begin
   if n>0 then begin {tail lines go to head}
     while (k<n)and(tailPos<=edimaxBuf) do begin
       k:=succ(k); nLine:=succ(nLine);
       repeat
         c:=bf[tailPos]; tailPos:=tailPos+1;
         headPos:=headPos+1; bf[headPos]:=c;
       until c=cr;
     end
   end else if n<0 then begin
     while (k>n)and(headPos>0) do begin
       k:=k-1; nLine:=nLine-1; headPos:=headPos-1; c:=bf[headPos];
       tailPos:=tailPos-1; bf[tailPos]:=cr;
       while c<>cr do begin
         tailPos:=tailPos-1; bf[tailPos]:=c;
         headPos:=headPos-1; c:=bf[headPos];
       end;
     end;
   end;
  end;
end; {moveLines}

procedure clearBf(var b:ediCtrlBloc); {basic buffer init, MUST be called once}
begin
  initColors(b);
  with b do begin
   fName:='NoName.txt';
   bf[0]:=cr; headPos:=0; tailPos:=edimaxBuf+1;
   nLine:=0; totLine:=0;
   cursor:=1;
   exitFlag:=0;
   modified:=false;
   overflow:=false;
  end;
end;

procedure takeHead(var b:ediCtrlBloc;var li:tline);
{headPos>0, 1 line buffer-->linebuf}
var k,l,m:integer;
begin
 with b do begin
   m:=headPos-1; l:=0; headPos:=m; {the last CR is skipped}
   while bf[headPos]<>cr do headPos:=headPos-1;
   for k:=headPos+1 to m do begin l:=l+1; li[l]:=bf[k]; end;
   li[0]:=chr(l); {length byte}  nLine:=nLine-1; totLine:=totLine-1;
  end;
end;

procedure takeTail(var b:ediCtrlBloc; var li:tline);
var l:integer; c:char;
begin
  with b do begin
   if tailPos>edimaxBuf then li[0]:=null
   else begin  l:=0; c:=bf[tailPos];
     while c<>cr do begin
       l:=l+1; li[l]:=c; tailPos:=succ(tailPos); c:=bf[tailPos];
     end;
     tailPos:=succ(tailPos); li[0]:=chr(l); totLine:=totLine-1;
   end;
  end;
end;

procedure glueHead(var b:ediCtrlBloc; li:tline);
var i,lsize:integer;
begin
  lsize:=ord(li[0]);
  with b do begin
   nLine:=nLine+1; totLine:=totLine+1;
   if (headPos+lsize)>(tailPos-4) then begin {buffer overflow}
     lsize:=tailPos-4-headPos;
     overflow:=true;
   end;
   for i:=1 to lsize do begin
     headPos:=headPos+1; bf[headPos]:=li[i];
   end;
   headPos:=headPos+1; bf[headPos]:=cr;
  end;
end;

procedure glueTail(var b:ediCtrlBloc; li:tline);
var i,lsize:integer;
begin
  lsize:=ord(li[0]);
  with b do begin
   if (headPos+lsize)>(tailPos-4) then begin {buffer overflow}
     lsize:=tailPos-4-headPos;
     overflow:=true;
   end;
   tailPos:=tailPos-1; bf[tailPos]:=cr; totLine:=totLine+1;
   for i:=lsize downto 1 do begin
     tailPos:=tailPos-1; bf[tailPos]:=li[i];
   end;
  end;
end;

procedure searchBack(var b:ediCtrlBloc; p: integer; var cc:integer);
{cursor column}
begin
  glueTail(b,cln); while (b.headPos>=p) do moveLines(b,-1);
  cc:=(p-b.headPos);
  takeTail(b,cln);
end;

procedure storeFile(var b:ediCtrlBloc);
var f:text; i:integer; c:char;
begin
  with b do begin
   gotoxy(1,25); textcolor(yellow); clrEol; write('Storing ',fname);
   assign(f,fname);rewrite(f);
   for i:=1 to headPos do begin c:=bf[i];
     if c=cr then writeln(f) else write(f,c);
   end;
   for i:=tailPos to edimaxBuf do begin c:=bf[i];
     if c=cr then writeln(f) else write(f,c);
   end;
   close(f);
   exitFlag:=0;
   modified:=false;
 end;
end;

procedure loadFile(var b:ediCtrlBloc);
var f:text; c:char; tooBig:boolean;
    i,ncolo:integer;
 {breaks lines >80 cols, filters tab,>=lastCharAscii etc..}
begin
  with b do begin
   gotoxy(1,25); textcolor(yellow); clrEol; write('Loading ',fname);
   assign(f,fname);reset(f);
   nLine:=0; i:=0; nColo:=0; bf[0]:=cr;
   tooBig:=false;
   while not (eof(f) or tooBig) do begin
     while not (eoln(f) or eof(f) or tooBig) do begin
       read(f,c); if c=tab then c:=' ';
       if (c<lastCharAscii) and  (c>=' ') then begin {ignore ctrl chars}
         nColo:=nColo+1;
         if nColo>maxCol then begin {break up long lines}
           nColo:=1; nLine:=nLine+1; i:=i+1; bf[i]:=cr;
         end;
         i:=i+1; bf[i]:=c;
         tooBig:=(i>(ediMaxBuf-40));
       end;
     end;
     if eoln(f) then readln(f);
     nColo:=0; nLine:=nLine+1; i:=i+1; bf[i]:=cr;
   end; {while}
   if tooBig then begin
     write('  Too big! Truncated. Press Esc'); c:=readKey;
   end;
   overflow:=tooBig;
   headPos:=i; tailPos:=edimaxBuf+1; totLine:=nLine;
   close(f);
   cursor:=1;
   exitFlag:=0; {=1 if file read was unsuccessful}
   modified:=false;
  end;
end;

function backText(var b:ediCtrlBloc; n:integer):integer;
{returns pointer n lines back in the head section}
var k,p:integer;
begin
  with b do begin
   p:=headPos;
   for k:=1 to n do if (p>0) then begin
     p:=pred(p);
     while bf[p]<>cr do p:=pred(p);
   end; {stop on cr, bf[0] is =cr }
   backText:=p+1;
 end;
end;

function forwText(var b:ediCtrlBloc; n:integer):integer;
{0 or more lines ahead}
var k,p:integer;
begin
  with b do begin
   p:=tailPos;
   for k:=1 to n do if p<edimaxBuf then begin
     while (bf[p]<>cr) do p:=succ(p); p:=succ(p);
   end;
   forwText:=p;
  end;
end;

function previCol(var b:ediCtrlBloc) :integer; {for auto-indent}
var p,x:integer;
begin p:=1;
  with b do begin
   if indent then begin x:=backText(b,1);
     if x<headPos then begin
       while bf[x]=' ' do begin x:=x+1;p:=p+1 end;
     end
   end;
   previCol:=p;
  end;
end;

function tabul(var b:ediCtrlBloc; cl:integer):integer;
{ TAB aligns to words on line - 1 }
var x,dp:integer;
begin
  dp:=backText(b,1)-1; x:=dp+cl;
  with b do begin
   while(x<headPos) and (bf[x]<>' ') do x:=x+1;
   while(x<headPos) and (bf[x]=' ') do x:=x+1;
   if x<headPos then tabul:=x-dp else tabul:=cl;
  end;
end;

procedure screenDump(var b:ediCtrlBloc; ptext,fline: integer; var stop:char);
{ renew screen from fline to last line, with buffer at ptext. Abort on stop}
var i,p,q,r:integer; c,d:char;
begin
  with b do begin
   gotoxy(1,fline); p:=ptext; i:=fline; d:=' '; {stop is <>' '}
   repeat
     if p<tailPos then if p>headPos then p:=tailPos;
     if p<=edimaxBuf then c:=bf[p] else c:=cr; q:=p;
     while c<>cr do begin
       write(c); p:=succ(p); c:=bf[p];
     end;
     if linErase then clrEol else
       for r:=p-q+1 to maxCol do write(' ');
     if i<videoMaxL then writeln;
     if p<edimaxBuf then p:=succ(p);
     i:=i+1;
     if keypressed then readchar(d);
     if d=null then d:=' ';
   until (i>videoMaxL)or(d=stop);
   if d<>stop then stop:=null; {completion mark}
  end;
end;

{****** vertical screen movements  **************}

procedure insLin(var b:ediCtrlBloc; n:integer; var s:char);
{downscroll by soft simulation}
begin
   if linInsDel then begin gotoxy(1,n);insLine;s:=null end
   else screenDump(b,b.tailPos,n+1,s);
end;

procedure delLin(var b:ediCtrlBloc; n:integer; var s:char {abandon?});
begin
   if linInsDel then with b do begin
     gotoxy(1,n);delLine;
     screenDump(b, forwText(b, videoMaxL-n),videoMaxL,s);
   end else screenDump(b,b.tailPos,n,s);
end;

procedure wriLine(ln: tline);  var i,k:integer;
begin gotoxy(1,cursLin); k:=ord(ln[0]);
   for i:=1 to k do write(ln[i]);
   if linErase then clrEol else for i:=k+1 to maxCol do write(' ');
end;

procedure toggleMode(var b:ediCtrlBloc);
begin insMode:=not insMode;
  with b do begin
   textcolor(ToggleColor);textbackground(ToggleBackColor);
   gotoxy(57,1); if insMode then write('Ins') else write('Rep');
   textcolor(CharColor);textbackground(TextBackColor);
  end;
end;

procedure togglIndent(var b:ediCtrlBloc);
begin
  indent:=not indent;
  with b do begin
   textcolor(ToggleColor);textbackground(ToggleBackColor);
   gotoxy(49,1);
   if indent then write('Indent') else
      begin textbackground(HeadBackColor);write('      ') end;
   textcolor(CharColor);textbackground(TextBackColor);
  end;
end;

procedure updateHead(var b:ediCtrlBloc); {header line of the editor}
var i:integer;
begin
  with b do begin
   textbackground(HeadBackColor); textcolor(HeadFirstColor);
   case headStat of
   0:begin
      gotoxy(1,1); clrEol;  write('<#',buffNumber,'>');
      gotoxy(10,1); write(fname:15);
      gotoxy(34,1); write((nLine+1):4);
      gotoxy(45,1); write(cursCol:2);
      gotoxy(72,1); write('ESC');
      gotoxy(63,1); write('F1');
      textcolor(HeadSecondColor);write('-help');
      gotoxy(75,1); write('-exit');
      gotoxy(29,1);write('Line ');
      gotoxy(41,1);write('Col ');
      textbackground(ToggleBackColor);textcolor(ToggleColor);
      if indent then begin  gotoxy(49,1); write('Indent') end;
      gotoxy(57,1);
      if insMode then write('Ins') else write('Rep'); {at col 67}
     end;
   1:begin gotoxy(34,1); write((nLine+1):4); end;
   2:begin gotoxy(45,1); write(cursCol:2); end;
   else end; {case}
   if overflow then begin
     textcolor(lightRed); gotoxy(5,1); write(' BUFFER OVERFLOW! ');
   end;
   textbackground(TextBackColor);textcolor(CharColor);
   gotoxy(cursCol,cursLin); headStat:=8;
  end;
end;

procedure upCursor(var b:ediCtrlBloc);  {screen and database moves}
var signal:char;
begin signal:=ctrE;
  with b do begin
   while (nLine>0)and (signal=ctrE) do begin
     glueTail(b,cln); takeHead(b,cln); headStat:=1;
     if cursLin>2 then begin cursLin:=cursLin-1; signal:=null end
     else begin if nLine=0 then signal:=null; {force completion}
       insLin(b,2,signal); wriLine(cln);
     end
   end
  end;
end;

procedure downCursor(var b:ediCtrlBloc);
begin
  with b do begin
   if (nLine<=totLine)and(tailPos<=ediMaxBuf) {??} then begin
     glueHead(b,cln); takeTail(b,cln); headStat:=1;
     if cursLin<videoMaxL then cursLin:=cursLin+1
     else begin {is on very last line}
       writeln; headStat:=0; wriLine(cln);
     end
   end
  end;
end;

procedure delCln(var b:ediCtrlBloc); {delete the current line}
var signal:char;
begin signal:=ctrY;
   repeat delLin(b,curslin,signal); takeTail(b,cln) until signal=null;
end;

procedure insCln(var b:ediCtrlBloc); {puts a free line in front of cln}
var s:char;
begin s:=null; {no abort}
   glueTail(b,cln); insLin(b,cursLin,s); cln[0]:=null;
   wriLine(cln);
end;

procedure fillingLevel(var b:ediCtrlBloc);
{ gadget: filling level of buffer is shown}
var k,fn:integer;
begin
  with b do begin
   VideoMaxL:=bottomRow-topRow+1;
   if bottomRow<25  then begin
     window(1,1, rightCol,25);
     textcolor(brown); textbackground(black);
     gotoxy(1,bottomRow+1);
     write(' buffer level |');
     size:=headPos+(ediMaxBuf-tailPos);
     fn:=size div 500; {fill number 1..60 for size<30000}
     for k:=1 to 50 do if (k<=fn) then write('>') else write(' ');
     write('|'); clrEol;
   end;
   window(1,topRow, rightCol,bottomRow);
   textbackground(TextBackColor);textcolor(CharColor);
  end;
end;

procedure pageScreen(var b:ediCtrlBloc; dir:char {+-*$0});
{move by + or - 22 lines, 0=refresh  *= to top, $=to bottom }
var delta,x,p,n: integer; stop:char; go:boolean;
begin
  go:=false;
  with b do begin
   repeat delta:=videoMaxL-2; n:=nLine+1; {nb of the current line}
    stop:=null;
    case dir of
     '-': begin {up}
       x:=n - (cursLin-1); if x<delta then delta:=x else stop:=ctrR;
       delta:=-delta; end;
     '+': begin x:=totLine-nLine; if x<delta then delta:=x else stop:=ctrC;
          end;
     '*': delta:=cursLin-1 - n;
     '$': delta:=totLine-nLine;
     '0': begin delta:=0; go:=true; end;
    end; {case}
    if (delta<>0) or go  then begin
      glueHead(b,cln);
      fillingLevel(b);
      if (dir='*')or(dir='$') then begin
        gotoxy(1,1); write(' Moving  ');
        headStat:=0;
      end else headStat:=1;
      moveLines(b,delta);
      p:=backText(b,cursLin-1);
      screenDump(b,p,2,stop);
      takeHead(b,cln);
    end;
   until stop=null;
  end;
end;

procedure cutLine(var b:ediCtrlBloc);
var ln:tline; x,z,la,cc:integer;
begin
  with b do begin
   if insMode then begin la:=ord(cln[0]); cc:=cursCol-1;
     if la<=cc then begin
       downCursor(b); cursCol:=previCol(b); insCln(b);
     end else begin
       z:=la-cc; x:=cc;
       while (x>0)and(cln[x]=' ') do x:=x-1;
       cln[0]:=chr(x); wriLine(cln);
       for x:=1 to z do ln[x]:=cln[cc+x]; ln[0]:=chr(z);
       downCursor(b); cursCol:=1;
       insCln(b); cln:=ln; wriLine(Cln);
     end
   end else begin
     downCursor(b); cursCol:=1;
   end;
   headStat:=0;
  end;
end;

procedure glueLine(var b:ediCtrlBloc);
var ln:tline; cc,ll,x,z,glu:integer; disapp:boolean;
begin
  with b do begin
   takeTail(b,ln); x:=ord(ln[0]); cc:=cursCol-1; ll:=ord(cln[0]);
   for z:=ll+1 to cc do cln[z]:=' ';
   glu:=maxCol-cc; disapp:=(glu>=x); if disapp then glu:=x;
   for z:=1 to glu do cln[cc+z]:=ln[z];
   z:=cc+glu; while (z>0)and(cln[z]=' ') do z:=z-1;
   cln[0]:=chr(z); wriLine(cln);
   if disapp then ln[0]:=null else begin
     for z:=glu+1 to x do ln[z-glu]:=ln[z]; ln[0]:=chr(x-glu);
   end;
   glueTail(b,ln); downCursor(b);
   if disapp then delCln(b) else wriLine(cln);
   upCursor(b);
  end;
end;

procedure nextLine(var b:ediCtrlBloc);
begin downCursor(b);
  with b do begin cursCol:=1; headStat:=0 end;
end;

procedure prevLine(var b:ediCtrlBloc);
begin
   with b do if nLine>0 then
   begin
     upCursor(b); cursCol:=ord(cln[0])+1; headStat:=0
   end;
end;

procedure glueBack(var b:ediCtrlBloc); { backspace at first column }
begin
   if b.nLine>0 then  begin prevLine(b);glueLine(b) end;
end;

procedure initScreen(var b:ediCtrlBloc; cp:integer);
{buffer must be initialized. Is called at start of EditAction }
var s:char;
begin
  cln[0]:=null; {make a dummy line}
  clrScr;
  with b do begin
   gotoxy(1,1); write(' Moving  ');
   cursLin:=2; cursCol:=1; s:=null;
   if (cp<=1)or(cp>headPos) then pageScreen(b,'*')
   else begin
     searchBack(b,cp,cursCol);
     glueHead(b,cln);
     screenDump(b,backtext(b,1),cursLin,s);
     takeHead(b,cln);
   end;
   headStat:=0; insMode:=true; indent:=true;
   updateHead(b);
  end;
end;

procedure termScreen(var b:ediCtrlBloc) ;
{deletes trailing empty lines from buffer}
var hp:integer;
begin
  with b do begin
   gotoxy(1,1); textbackground(lightgray);textcolor(black);
   clrEol;  write('<#',buffNumber,'>'); {dim the header line}
   gotoxy(10,1); write(fname:15);
   window(1,1, rightCol,25); {restore whole screen}
   gotoxy(1,25); textbackground(black);textcolor(yellow);
   clrEol; write(' Moving buffer');
   glueHead(b,cln); moveLines(b,edimaxBuf); hp:=headPos-1;
   while (hp>0)and(bf[hp]=cr) do begin hp:=hp-1; totLine:=totLine-1 end;
   headPos:=hp+1; nLine:=totLine;
  end;
end;

procedure changeColor(var b:ediCtrlBloc);
begin
 with b do begin
  CharColor:=CharColor+1;
  if CharColor>15 then CharColor:=1;
  textcolor(CharColor);
 end;
end;

{******** line editing ***************}

procedure edLin(var b:ediCtrlBloc;
   var c:tline; var ct:char; {terminator}
   mx,li:integer; var co:integer);
var a:tline; p,r,q,t,la,i:integer; ch,cr:char; era:boolean;

procedure forget; begin while(la>0)and(a[la]=' ') do la:=la-1 end;

begin
   p:=co; a:=c; la:=ord(c[0]); gotoxy(p,li);
   repeat readchar(ch);
     case ord(ch) of {check for possible effect on buffer}
       20,16,12,7,8: b.modified:=true;
     else{otherwise} end;
     case ord(ch) of
     22:{ctrV} begin toggleMode(b); gotoxy(p,li); ch:=null; end;
     15:{ctrO} begin togglIndent(b);gotoxy(p,li); ch:=null end;
     19:{ctrS} begin p:=p-1; if p<1 then p:=1; ch:=null end;
     04:{ctrD} begin if p<=mx then p:=p+1; ch:=null end;
     30: {home}begin p:=1;ch:=null end;
     31: {end} begin p:=la+1;ch:=null end;
     09:{tab } begin p:=tabul(b,p); ch:=null end;
     06:{ctrF} if p<=la then begin ch:=null;
          while (p<=la)and(a[p]<>' ') do p:=p+1;
          while (p<=la)and(a[p]=' ') do p:=p+1;
        end;
     01:{ctrA} if p>1 then begin ch:=null;
          if p>la then p:=la; if p=0 then p:=1;
          while (p>1)and(a[p]<>' ') do p:=p-1;
          while (p>1)and(a[p]=' ') do p:=p-1;
        end;
     20:{ctrT} if p<=la then begin ch:=null;
         q:=p; t:=p-1;
         while (q<=la)and(a[q]<>' ') do q:=q+1;
         while (q<=la)and(a[q]=' ') do q:=q+1;
         for r:=q to la do begin t:=t+1; cr:=a[r]; write(cr); a[t]:=cr; end;
         for r:=p+1 to q do write(' ');
         la:=t; forget;
       end;
     16:{ctrP} begin ch:=null;
          if p<=la then begin for r:=p to la do write(' '); la:=p-1; forget;
          end;
       end;
     12:{ctrL} begin ch:=null; a:=c; la:=ord(a[0]); {recover} gotoxy(1,li);
          for i:=1 to maxcol do if i<=la then write(a[i]) else write(' ');
        end;
     7,8: {ctrG,bs} begin era:=true;
       if ch=bs then if p>1 then begin
         p:=p-1;gotoxy(p,li);ch:=null;
       end else era:=false; {no action}
       if (p<=la)and era then begin ch:=null;
         for i:=p to la-1 do begin a[i]:=a[i+1];write(a[i]) end;
         la:=la-1; write(' ');
       end; {erase}
      end {case}
      else if ((ch>=' ') and (ord(ch)<159)) then begin {printable char}
       if p>mx then beep else begin
        if p<=la then begin
          b.modified:=true;
          if not insMode then begin a[p]:=ch;write(ch) end
          else begin
            if la>=mx then begin
              beep; p:=p-1
            end else begin
              la:=la+1; for i:=la downto p+1 do a[i]:=a[i-1];
              a[p]:=ch; for i:=p to la do write(a[i]);
            end
          end
        end else begin {p>la}
          write(ch); for i:=la+1 to p-1 do a[i]:=' '; la:=p; a[la]:=ch;
        end; {if p}
        forget; {trailing blanks}
        if p<=mx then p:=p+1;
       end;
       ch:=null;
      end; {printable ch}
     end; {case}
     curscol:=p; headStat:=2;
     updateHead(b); gotoxy(p,li);
   until ch<>null; {escape char}
   c:=a; c[0]:=chr(la); ct:=ch; co:=p; {return values}
end; {edLin}

procedure editAction(var b:ediCtrlBloc);
{edit the current text buffer at position b.cursor
  exit on Esc or function keys F2..F8 ?
}
var c:char; ll:integer;
begin
  with b do begin
   overflow:=false;
   fillingLevel(b);
   initScreen(b,cursor);
   repeat edlin(b,cln,c, maxCol, cursLin, cursCol);
     case ord(c) of
       14,25,13,20,8: modified:=true;
     else{otherwise} end;
     case ord(c) of {screen move actions}
       5{ctrE}: upCursor(b);
      24{ctrX}: downCursor(b);
      18{ctrR}: pageScreen(b,'-');
       3{ctrC}: pageScreen(b,'+');
      23{ctrW}: pageScreen(b,'*');
      26{ctrZ}: pageScreen(b,'$');
      14{ctrN}: insCln(b);
      25{ctrY}: delCln(b);
      13{CR}  : cutLine(b);
      20{ctrT}: glueLine(b);
      1{ctrA} : prevLine(b);
      6{ctrF} : nextLine(b);
      176:{F1 :  help }
        begin helpEdi;
          pagescreen(b,'0') ; headStat:=0;
        end;
      184:{F9: change Color} begin changeColor(b);pagescreen(b,'0'); end;
      8{ BS }:glueBack(b);
     else end; {case}
     updateHead(b);
   until (c=Esc)or(c=F10)or((c>F1)and(c<F9)); {F1,F9 are local!}
   ll:=ord(cln[0])+1; if cursCol>ll then cursCol:=ll;
   cursor:=headPos+cursCol;
   if c=Esc then exitFlag:=0 else exitFlag:=ord(c)-ord(F1)+1;
   termScreen(b);
  end;
end; {editAction}

procedure Edi(opcode:char; var data:ediCtrlBloc);
begin
  initChar;
  case opcode of
   'N': clearBf(data);
   'R': loadFile(data);
   'S': storeFile(data);
   'E': editAction(data);
  else{otherwise} end;
  data.size:=data.headPos;
end;

{******  readString: string entry, with possible Escape  *********}

{   Active keys are:
  Ctrl- A S D F G T Y V   Wordstar-like
  Ctrl- L  recover line
  Ctrl- O  undelete line from Ctr-Y
  Ctrl- P  delEol
}

procedure LineInput(x,y,lmax: integer; var s:tline; var exit:char);
  {Input at x,y  limited to maxCol-minCol characters}
  {string s MUST be initialized}
  {an encapsulated, modified version of edLin }

const linErase=false; {cannot use DelEol, must stop at x+lmax }
var
    minCol,maxCol,col,ls: integer;
    insMode:boolean; {false if replace mode}
    save,tmp: tLine;

procedure putLine(x,y: integer; var ln: tline);  var i,k:integer;
begin gotoxy(x,y); k:=ord(ln[0]);
   for i:=1 to k do write(ln[i]);
   if linErase then clrEol else for i:=x+k to maxCol do write(' ');
end;

procedure edLin(var c:tline; var ct:char; {terminator}
   mi,mx,li:integer; var co:integer);
{line editor for data c, on line li. Cursor starts at column co
 and is limited to mi..mx. }
var a:tline; p,r,q,t,la,i,pmx:integer; ch,cr:char; era:boolean;
    {p points to string a. co is the column RELATIVE to origin mi-1}

procedure forget; begin while(la>0)and(a[la]=' ') do la:=la-1 end;

begin
   putLine(mi,li,c);
   p:=co; a:=c; la:=ord(c[0]); gotoxy(p+mi-1,li); pmx:=mx-mi+1;
   repeat readchar(ch);
     case ord(ch) of
     22:{ctrV} begin {if inText then} insMode:=not insMode; ch:=null; end;
     02:{ctrB} begin {if inText then togglIndent;} ch:=null end;
     19:{ctrS} begin p:=p-1; if p<1 then p:=1; ch:=null end;
     04:{ctrD} begin if p<=pmx then p:=p+1; ch:=null end;
     30: {home}begin p:=1;ch:=null end;
     31: {end} begin p:=la+1;ch:=null end;
     09:{tab } begin {if inText then p:=tabul(p);} ch:=null end;
     06:{ctrF} if p<=la then begin ch:=null;
          while (p<=la)and(a[p]<>' ') do p:=p+1;
          while (p<=la)and(a[p]=' ') do p:=p+1;
        end;
     01:{ctrA} if p>1 then begin ch:=null;
          if p>la then p:=la; if p<1 then p:=1;
          while (p>1)and(a[p]<>' ') do p:=p-1;
          while (p>1)and(a[p]=' ') do p:=p-1;
        end;
     20:{ctrT} if p<=la then begin ch:=null;
         q:=p; t:=p-1;
         while (q<=la)and(a[q]<>' ') do q:=q+1;
         while (q<=la)and(a[q]=' ') do q:=q+1;
         for r:=q to la do begin t:=t+1; cr:=a[r]; write(cr); a[t]:=cr; end;
         for r:=p+1 to q do write(' ');
         la:=t; forget;
       end;
     16:{ctrP} begin ch:=null;
          if p<=la then begin for r:=p to la do write(' '); la:=p-1; forget;
          end;
       end;
     12:{ctrL} begin ch:=null; a:=c; la:=ord(a[0]); {recover} gotoxy(mi,li);
          for i:=1 to pmx do if i<=la then write(a[i]) else write(' ');
        end;
     7,8: {ctrG,bs} begin era:=true;
        if ch=bs then if p>1 then begin
          p:=p-1;gotoxy(p+mi-1,li);ch:=null;
        end else era:=false; {no action}
        if (p<=la)and era then begin ch:=null;
          for i:=p to la-1 do begin a[i]:=a[i+1];write(a[i]) end;
          la:=la-1; write(' ');
        end; {erase}
       end
     else{otherwise} if ch>=' ' then begin {printable char}
       if p>pmx then beep else begin
        if p<=la then begin
          if {inText and}(not insMode) then begin a[p]:=ch;write(ch) end
          else begin
            if la>=pmx then begin
              beep; p:=p-1
            end else begin
              la:=la+1; for i:=la downto p+1 do a[i]:=a[i-1];
              a[p]:=ch; for i:=p to la do write(a[i]);
            end
          end
        end else begin {p>la}
          write(ch); for i:=la+1 to p-1 do a[i]:=' '; la:=p; a[la]:=ch;
        end; {if p}
        forget; {trailing blanks}
        if p<=pmx then p:=p+1;
       end;  ch:=null;
      end; {printable ch}
     end; {case}
     gotoxy(p+mi-1,li);
   until ch<>null; {escape char}
   c:=a; c[0]:=chr(la); ct:=ch; co:=p; {return values}
end; {edLin}

begin  {lineInput}
  insMode:=true;
  minCol:=x; maxCol:=x+lmax-1;
  {if maxCol>79 then maxCol:=79; }
  col:=1;   ls:=ord(s[0]);
  if ls>(maxCol-minCol+1) then s[0]:=chr(maxCol-minCol+1); {trunc}
  save:=s;
  repeat edLin(s,exit,  minCol,maxCol, y, col);
    if exit=ctrY then begin save:=s; s[0]:=chr(0); end;
    if exit=ctrO then begin tmp:=s; s:=save; save:=tmp end; {swapping}
  until (exit=CR)or(exit=ESC);
end;   {lineInput}

procedure readString(var s:str50; x,y,maxLen: integer; var escape:boolean);
{x+maxLen MUST be <= current window length ! }
var t:tline; i,ls: integer;  ex:char;
begin
  initChar;
  ls:=length(s); if ls>maxLen then ls:=maxLen; t[0]:=chr(ls);
  for i:=1 to ls do t[i]:=s[i];
  lineInput(x,y,maxLen, t, ex); {exit character ESC or RET}
  escape:=(ex=ESC);
  if not escape then begin
    ls:=ord(t[0]); s:='';
    for i:=1 to ls do s:=s+t[i]; {for portability, don't use s[i]:=t[i]! }
  end;
end;

end. {unit toyEdit}

{----------------------------------}
