{$R+,S+}
unit CrtDos;          {   Copyright (c) by Georg Post  (1991)

  A partial substitute for Crt/Dos libraries, convertible to C by PCPC.
  This is a hack I found useful to test my Pascal-C converter, since
  99% of all Turbo Pascal programs use Dos & Crt. So I made a minimal
  clone library: in Pascal of course, for easier debugging.

  To translate it for Turbo C++ 1.0, first run PCPC with the confidential
  leading underbar option -U on CrtDos (legalize _rN etc. as identifiers):
    pcpc -u  crtdos
    reord2 crtdos

  Option -U tells the scanner to store identifiers that start with '_' as they
  are written (no upper case/lower case conversion, unlike the rest).
  Without this option, my converter chokes on such identifiers.
  Regular programs should never use the leading underbars.

Then tweak CrtDos.C as follows:

1.  Add 2 preprocessor lines to fetch "intr"  from <dos.h>.
   (the REGPACK is compatible with "registers" if "Word" <--> "unsigned")
   These 2 lines must replace the do-nothing procedure void Intr(void) :

#include <dos.h>
#define Intr(x,y) intr(x,(struct REGPACK *)y)

2.  rename the init procedure _gCrtDos to _gCrt.

3.  add a do-nothing procedure:

void _gDos(void) (*pair of braces*)

----------------------------------------------

  Ugly Inline code for the essence of the Dos Unit: procedures Intr & Msdos.
  Quick-and-dirty replacements for part of Turbo Pascal Crt Unit:

    Window      TextColor  TextBackground   LowVideo   HighVideo
    NormVideo   GotoXy     Wherex           Wherey     ClrScr
    ClrEol      InsLine    DelLine          TextMode   KeyPressed
    ReadKey
  The windowed console I/O  works fine: Uses BIOS Intr $10/$16.
  Delay and Sound generator not supported.

  Since there is no interrupt bending (something I'd hate to do), Pascal
  programs using CrtDos instead of Crt MUST recode ALL Read(Ln) and Write(Ln)
  going to the console. Pascal programs using Crt, and wanting to pass through
  PCPC, should not recode their I/O calls, but should observe what I call the
  "conservative keyboard rules". PCPC will crack their Read/Write calls into
  the new I/O calls listed below. The translated program will link with the
  translated version of CrtDos.

  Rules for the use of CrtDos under Pascal:

  First, adhere to a conservative Pascal style for keyboard input:
  - Never use Read for console input-with-echo, always Readln.
  - never try to get more than 1 item per console Readln.
  - but freely use ReadKey and KeyPressed to catch characters on the fly.

  Only then, replace console Readln with the following type-specific calls
  (I use leading underbars as an undocumented feature of Turbo Pascal 4) :

   Readln (no args)  -> _rN
   Readln (char)     -> _rC
   Readln (string)   -> _rS
   Readln (integer)  -> _rI
   Readln (real)     -> _rF

  Console output: Split multi-argument Write(ln) up into individual calls:

   Writeln (no args)   -> _wN
   Write   (char)      -> _wC
   Write   (string)    -> _wR
   Write   (string:f)  -> _wS (string,f)   f=1 if absent
   Write   (integer:f) -> _wI (int,f)      f=1
   Write   (real:f:g)  -> _wF (real,f,g)   f=17 g=-1

}

interface

type registers=record ax,bx,cx,dx, bp,si,di,ds,es,flags: word end;
  { I never use the Byte variant of registers }

procedure Intr(Nb:byte; var regs:registers);  { clone for Dos.Intr }
procedure MsDos(var regs:registers);

const
  BW40          = 0;
  CO40          = 1;
  BW80          = 2;
  CO80          = 3;
  Mono          = 7;
  Font8x8       = 256;
  C40           = CO40;
  C80           = CO80;
  Black         = 0;
  Blue          = 1;
  Green         = 2;
  Cyan          = 3;
  Red           = 4;
  Magenta       = 5;
  Brown         = 6;
  LightGray     = 7;
  DarkGray      = 8;
  LightBlue     = 9;
  LightGreen    = 10;
  LightCyan     = 11;
  LightRed      = 12;
  LightMagenta  = 13;
  Yellow        = 14;
  White         = 15;
  Blink         = 128;

var
  CheckBreak: Boolean;
  CheckEOF: Boolean;
  DirectVideo: Boolean;
  CheckSnow: Boolean;
  LastMode: Word;
  TextAttr: Byte;
  WindMin: Word;  { (x-1)+256*(y-1) :  x=1..80, y=1..25 }
  WindMax: Word;
  SaveInt1B: Pointer;

procedure AssignCrt(var F: Text);
function  KeyPressed: Boolean;
function  ReadKey: Char;
procedure TextMode(Mode: Word);
procedure Window(X1,Y1,X2,Y2: Byte);
procedure GotoXY(X,Y: Byte);
function  WhereX: Byte;
function  WhereY: Byte;
procedure ClrScr;
procedure ClrEol;
procedure InsLine;
procedure DelLine;
procedure TextColor(Color: Byte);
procedure TextBackground(Color: Byte);
procedure LowVideo;
procedure HighVideo;
procedure NormVideo;
procedure Delay(MS: Word);
procedure Sound(Hz: Word);
procedure NoSound;

procedure _wN;                         {writeln}
procedure _wR(s:string);               {write(s)}
procedure _wC(c:char);                 {write(c)}
procedure _wK(c:char; fmt:integer);    {write(c:fmt)}
procedure _wS(s:string;  fmt:integer); {write(s:fmt)}
procedure _wI(i:longInt; fmt:integer); {write(i:fmt}
procedure _wF(r:real;  f1,f2:integer); {write(r:f1:f2)}

procedure _rN;                {readln}
procedure _rC(var c:char);    {readln(c)}
procedure _rS(var s:string);  {readln(s)}
procedure _rI(var i:longInt); {readln(i)}
procedure _rF(var r:real);    {readln(r)}

implementation

{-ugly-&-slow-} procedure Intr(nb: byte; var regs:registers);
{
 Parameter-controlled software interrupt call, needs "self-modifying code".
 Bug: Perverse Interrupts which destroy  SS, SP or CS  MUST NOT be called!
 In some books they say that e.g. Msdos EXEC (AH=$4B) forgets SS:SP !
 I save Bp,Ds,Es but NOT Sp,Ss. Other registers don't matter to Turbo Pascal.
 My trick here: issue an intersegment indirect CallFar [ss:bp]
 after creation of a parameter-dependent miniprogram on the stack:
   mov bp, [Regs.Bp] / Int nb / RetFar
 That's "better" than naive self-modification, is theoretically ROMable and
 reentrant. However, future protected-mode systems might severely punish any
 attempt at executing code stored in the stack segment ? What then ?
}
begin inline(
   $06         {    push es }
  /$1E         {    push ds ; save 3 registers }
  /$55         {    push bp }
  /$C5/$B6/>regs{   lds si,regs[bp] ; now  ds:si points to Regs }
               {      record of 10 words: ax bx cx dx bp si di ds es flags}
               {      next, prepare an 8-byte procedure  ax...dx ->  stack }
  /$8A/$A6/>nb {    mov ah, nb[bp]}
  /$B0/$CD     {    mov al, 0cdh    ; ax = the Int nb code}
  /$BB/>$90CB  {    mov bx, 090cbh  ; bx = RetFar Nop}
  /$B9/>$BD90  {    mov cx, 0bd90h  ; cx = Nop  MovImmediate bp,  word}
  /$8B/$54/$08 {    mov dx, [si+8]  ; data from Regs.bp}
  /$53         {    push bx}
  /$50         {    push ax}
  /$52         {    push dx}
  /$51         {    push cx; here  the 8-byte subroutine is at [sp]...[sp+7]}

  /$8B/$EC     {    mov bp,sp ; [ss:bp] is the address of the subroutine}
  /$16         {    push ss}
  /$55         {    push bp   ; push the ss:bp double word = the far address}
  /$8B/$EC     {    mov bp,sp ; now ss:bp  holds }
               {              ; the address of the procedure's address! }
  /$1E         {    push ds}
  /$56         {    push si;   save ds:si for later recovery }
  /$FF/$74/$12 {    push [si+18] ; flags}
  /$FF/$74/$0E {    push [si+14] ; ds}
  /$FF/$74/$0A {    push [si+10] ; si}
  /$8B/$04     {    mov ax,[si]    ; fill all CPU registers but bp from Regs}
  /$8B/$5C/$02 {    mov bx,[si+2]}
  /$8B/$4C/$04 {    mov cx,[si+4]}
  /$8B/$54/$06 {    mov dx,[si+6]}
  /$8B/$7C/$0C {    mov di,[si+12]}
  /$8E/$44/$10 {    mov es,[si+16]}
  /$5E         {    pop si}
  /$1F         {    pop ds}
  /$9D         {    popf}
  /$FF/$5e/$00 {    call far [bp+0] ; call the 8-byte  code via [ss:bp]}
               {      at [bp] we find IP, at [bp+2] we have CS=SS }
  /$9C         {    pushf}
  /$1E         {    push ds}
  /$56         {    push si}
  /$55         {    push bp  ; this is the bp after interrupt processing }
  /$8B/$EC     {    mov bp,sp; prepare for address 4 words inside stack}
  /$8B/$76/$08 {    mov si,[bp+8] ;  si pointing to Regs}
  /$8E/$5E/$0A {    mov ds,[bp+10];  ds:si -> Regs}
  /$8C/$44/$10 {    mov [si+16],es;  transfer 6 CPU registers to Regs}
  /$89/$7C/$0C {    mov [si+12],di}
  /$89/$54/$06 {    mov [si+6], dx}
  /$89/$4C/$04 {    mov [si+4], cx}
  /$89/$5C/$02 {    mov [si+2], bx}
  /$89/$04     {    mov [si]  , ax}
  /$8F/$44/$08 {    pop [si+8]  ;bp   transfer 4 stack words to Regs}
  /$8F/$44/$0A {    pop [si+10] ;si}
  /$8F/$44/$0E {    pop [si+14] ;ds}
  /$8F/$44/$12 {    pop [si+18] ;flags}
  /$83/$C4/$10 {    add sp,16       ;  2+2+4 stack words are skipped}
  /$5D         {    pop bp}
  /$1F         {    pop ds ; recover 3 registers}
  /$07         {    pop es}
) end;

procedure MsDos(var regs:registers);
begin intr($21,regs) end;

var regs:registers;
    minx,miny,maxx,maxy,posx,posy: byte; {absolute window & position }
    scanCode: byte; {global toggle for pending scan code }
    RdBuffer:string; {line input buffer}

procedure Window(X1,Y1,X2,Y2: Byte);  {start at 1}
var err: boolean;
begin
  err:=(x1<1)or(x1>80)or(x2<1)or(x2>80)or(x2<x1)
     or(y1<1)or(y1>25)or(y2<1)or(y2>25)or(y2<y1);
  if not err then begin
    minx:=x1;miny:=y1; maxx:=x2;maxy:=y2;
    WindMin:=(x1-1)+((y1-1)shl 8);   {these start at 0}
    WindMax:=(x2-1)+((y2-1)shl 8);
  end;
end;

procedure TextColor(Color: Byte);
begin
  if Color>15 then Color:=(Color and $F) or $80; {make them blink!}
  TextAttr:=(TextAttr and $70) or Color;
end;

procedure TextBackground(Color: Byte);
begin
  Color:=Color and $7; {only 3 bits are valid}
  TextAttr:=(TextAttr and $8F) or (Color shl 4)
end;

procedure LowVideo;  begin TextAttr:=LightGray  end;
procedure HighVideo; begin TextAttr:=White      end;
procedure NormVideo; begin TextAttr:=LightGreen end;

procedure GotoXY(X,Y: Byte);  {window relative, x,y start at 1 !}
{ The ONLY place where posx,posy are updated}
var px,py: byte; err:boolean;
begin
  px:=minx+x-1;py:=miny+y-1;
  err:=(px>maxx)or(py>maxy)or(px<minx)or(py<miny);
  if not err then begin
    with regs do begin Ax:=$200; bx:=0;
      dx:=WindMin+(x-1)+((y-1) shl 8);
    end;
    Intr($10, regs);
    posx:=px; posy:=py;
  end;
end;

function  WhereX: Byte; {relative position, start at 1}
begin WhereX:=posx-minx+1; end;

function  WhereY: Byte;
begin  WhereY:=posy-miny+1; end;

procedure ClrScr; {clear current window}
var n:word;
begin
  gotoxy(1,1);
  n:=(WindMax-WindMin) shr 8 +1; {number of lines for dummy Scrollup}
  with regs do begin
    ax:=$600+n; bx:=TextAttr shl 8;
    cx:=WindMin; dx:=WindMax;
  end;
  Intr($10,regs);
end;

procedure ClrEol;
begin
  with regs do begin
    cx:=maxx-posx+1; {number of blanks to write, at least One}
    bx:=TextAttr; ax:=$900;
    intr($10, regs); {fillchar..}
  end;
end;

procedure InsLine; {push down bottom of window}
begin
  with regs do begin
    cx:=WindMin+ (posy-miny) shl 8;
    dx:=WindMax;
    bx:=TextAttr shl 8; ax:=$701; {ScrollDown}
    Intr($10, regs);
  end;
end;

procedure DelLine; {push up bottom of window}
begin
  with regs do begin
    cx:=WindMin+ (posy-miny) shl 8;
    dx:=WindMax;
    bx:=TextAttr shl 8; ax:=$601; {ScrollUp}
    Intr($10, regs);
  end;
end;

procedure scrolLine; {push up partial window above & including current line}
begin
  with regs do begin
    cx:=WindMin;
    dx:=WindMin + (posy-miny) shl 8 + (maxx-minx);
    bx:=TextAttr shl 8; ax:=$601; {ScrollUp}
    Intr($10, regs);
  end;
end;

procedure TextMode(Mode: Word);
begin
  regs.ax:=Mode and $ff; Intr($10,regs);
end;

function KeyPressed:Boolean;
begin
  if scanCode>0 then KeyPressed:=True
  else begin
    regs.ax:=$100; Intr($16,regs);
    KeyPressed:=(regs.Flags and $40)=0; {zero flag = 0}
  end;
end;

function readKey:char;
var k:byte;
begin
  if scanCode>0 then begin
    readKey:=chr(scanCode);
    scanCode:=0;
  end else begin {no reserve char}
    regs.ax:=0; Intr($16,regs);
    k:=(regs.ax and $ff);
    if k=0 then scanCode:=(regs.ax shr 8); {save the scan code}
    readKey:=chr(k);
  end;
end;

{**********  IO formatting **************}

procedure Beep;
begin
  regs.ax:=$e07; regs.bx:=0; Intr($10,regs); (* write Teletype *)
end;

procedure _wC(c:char);  { output 1 char to screen:
 filtering NULL BEEP CR LF BS, provide windowed linewrap & scrolling.
 Slow: in general needs 2 Intr-$10 calls per char: Services $9 and $2.
 The service $A is no better since it doesn't put the attribute.
}
var wx,wy:byte;
begin
  wx:=posx-minx+1; wy:=posy-miny+1; {start at 1}
  if c=#7 then Beep
  else if c=#13 then begin
    Gotoxy(1,wy);
  end else if c=#10 then begin
    if posy<maxy then Gotoxy(wx,wy+1) else ScrolLine;
  end else if c=#8 then begin {backspace}
    if posx>minx then Gotoxy(wx-1,wy);
    with regs do begin {now rub out with a blank}
      ax:=$900+ord(' '); bx:=TextAttr; cx:=1;
      Intr($10,regs);
    end;
  end else if c>#0 then begin
    {char output at current cursor, followed by Gotoxy}
    with regs do begin
      ax:=$900+ord(c); bx:=TextAttr; cx:=1;
      Intr($10,regs);
    end;
    if posx<maxx then Gotoxy(wx+1,wy)
    else if posy<maxy then Gotoxy(1,wy+1)
    else begin {end of last line! }
      Gotoxy(1,wy); ScrolLine;
    end;
  end;
end;

procedure _wN;  begin _wC(#13); _wC(#10) end;

procedure _wR(s:string);
var k:integer;
begin for k:=1 to length(s) do _wC(s[k]); end;

procedure _wS(s:string; fmt:integer);
var k:integer;
begin for k:=1 to fmt-length(s) do _wC(' '); _wR(s) end;

procedure _wK(c:char; fmt:integer);
var k:integer;
begin for k:=1 to fmt-1 do _wC(' '); _wC(c) end;

procedure _wI(i:longInt; fmt:integer); {default fmt=1}
var s:string;
begin str(i:fmt,s); _wR(s) end;

procedure _wF(r:real; f1,f2:integer); {default f1=17, f2=-1}
var s:string;
begin str(r:f1:f2,s); _wR(s) end;

procedure _rS(var s:string); {basic line input, replaces  ReadLn}
{ implements Ctrl-ADFSZ Esc editing features }
var c:char;  stop,echo:boolean;
    i:integer;
begin s:=''; stop:=false;
  repeat
    echo:=(scanCode=0); {scancode special chars are not echoed or entered}
    c:=readKey;
    if echo then begin
      if (c=#27)or(c=#1) then begin {Ctrl-A, Escape clears input}
        for i:=1 to length(s) do _wC(#8); s:='';
      end else if c=#4 then begin {Ctrl-D, take from buffer}
        i:=length(s)+1;
        if i<=length(RdBuffer) then begin
          c:=RdBuffer[i]; s:=s+c; _wC(c);
        end;
      end else if c=#6 then begin {Ctrl-F, take buffer}
        i:=length(s)+1;
        while i<=length(RdBuffer) do begin
          c:=RdBuffer[i]; s:=s+c; _wC(c); i:=i+1;
        end;
      end else begin
        if c=#26 then begin {CtrlZ end input}
          c:=#13; if checkEOF then s:=s+c;
        end;
        stop:=(c=#13);
        if not stop then begin
          if (c=#19)or(c=#127)or(c=#8) then begin
            delete(s,length(s),1); _wC(#8);
            { BS, Ctrl-S, DEL all delete 1 char from s, not from RdBuffer}
          end else if (c>=' ') then begin  {printable character}
            s:=s+c; i:=length(s);
            if i>length(RdBuffer) then RdBuffer:=s else RdBuffer[i]:=c;
            _wC(c);
          end;
        end;
      end;
    end;
  until stop;
  _wC(#13);_wC(#10);
  RdBuffer:=s;
end;

procedure _rN;
var s:string; begin _rS(s) end;

procedure _rC(var c:char);
var s:string; begin _rS(s); c:=s[length(s)]
end;

procedure _rI(var i:longint);
var s:string; err:integer;
begin
  repeat _rS(s); val(s,i,err); if err<>0 then Beep;
  until err=0;
end;

procedure _rF(var r:real);
var s:string; err:integer;
begin
  repeat _rS(s); val(s,r,err); if err<>0 then Beep;
  until err=0;
end;

{********  STUBS   ******}

procedure Delay(MS: Word); begin end;
procedure Sound(Hz: Word); begin Beep end;
procedure NoSound; begin end;
procedure AssignCrt(var F: Text); begin end;

begin
  checkEOF:=false;
  RdBuffer:='';
  scanCode:=0;
  Window(1,1,80,25); LowVideo;
  with regs do begin ax:=0;bx:=0;cx:=0;dx:=0 end;
  (* regs.ax:=$500; intr($10,regs); -- select page 0 *)
  gotoxy(1,25);
end. {unit CrtDos}

