/*   convpac.h   : released to the Public Domain by Georg Post (1991)

      system header for PCPC  Pascal->C converter
      see convpac.c for comments and function definitions.
      Uppercase as 1st letter:  Pascal identifiers
      underbar: ancillary functions
*/

#include <stdio.h>
#include <math.h>
#define msDOS 1
  /*  for non-DOS systems, mask this #define */

typedef char Char;  /* unsigned char is NOT K&R */
typedef unsigned short Word;  /* 16 bit words, non-K&R but Unix?  */
typedef short Integer;
typedef char  Shortint;
typedef long  Longint;
typedef unsigned short Byte;
typedef short Boolean;
typedef float Single;
typedef double Real;
typedef double Double;
typedef double Extended;
typedef double Comp;
typedef char *Pointer; /* "void *" isn't portable! */
typedef char String[256];
typedef struct {FILE *s; char n[80]; long datasize;} File;/* file of non-char*/
typedef Word Set[16]; /* set is array of 256 bits */

#define TRUE 1
#define FALSE 0
#define NIL NULL
#define VAR void
#define Text File
#define Dispose(p) DisposE((Pointer)(p))
#define New(t)     (t*)NeW(sizeof(t))
   /*   usage P=New(Complex).  NeW is malloc-with-NULL-check  */
#define Assign(f,s) _sM((f)->n,s,80)
#define Readln(g)   fscanf(g, "%*c")
#define Writeln(g)  putc('\n',g)
#define Read(f,x)   fread(&(x),sizeof(x),1,f)
#define Write(f,x)  fwrite(&(x),sizeof(x),1,f)
#define Seek(f,n)   fseek((f)->s,(n)*((f)->datasize),0)
#define SeekEof(f)  fseek((f)->s,0,2)
#define Close(f)    fclose((f)->s)
#define Flush(f)    fflush((f)->s)
#define InC(x)      (*(x))++
#define DeC(x)      (*(x))--
#define Inc(x,n)    *(x)+=(n)
#define Dec(x,n)    *(x)-=(n)
#define Hi(x)       (((x)>>8) & 255)
#define Lo(x)       ((x)& 255)
#define Ord(x)      ((short)(x)& 255)
#define Addr(x)     (x)
#define Chr(x)      (char)(x)
#define Succ(x)     ((long)(x)+1)
#define Pred(x)     ((long)(x)-1)
#define Odd(i)      (((i) & 1)==1)
#define Sqrt        sqrt
#define ArcTan      atan
#define Ln          log
#define Sin         sin
#define Cos         cos
#define Exp         exp
#define Sqr(x)      ((x)*(x))

#ifdef msDOS
#define CSeg _CS
#define DSeg _DS
#define SSeg _SS
#define SPtr _SP
#else
#define CSeg 0
#define DSeg 0
#define SSeg 0
#define SPtr 0
#endif

#define _mY(a,b)         _mV((char*)(a),(char*)(b),sizeof(a))
#define _mR(a,b)         _mV((char*)&(a),(char*)&(b),sizeof(a))
#define _cA(h,a,b)       _mC(h,(Char*)(a),(Char*)(b),sizeof(a))
#define _cR(h,a,b)       _mC(h,(Char*)&(a),(Char*)&(b),sizeof(a))
#define _cF(h,a,b,n)     _mC(h,(Char*)(a),(Char*)(b),n)
#define Move(src,dst,n)  _mV((char*)dst,(char*)src,n)
#define _mA(a,b,n)       _mV((char*)(a),(char*)(b),n)
 /*   Bug: for overlapping move, use memcpy !  */
#define FillChar(p,n,c)  _mF((char *)p, n, (char)c)

#define _eE(s,x)     _eE_(s,(short)(x))
#define _eR(s,x,y)   _eR_(s,(short)(x),(short)(y))
#define In(x,s)      _eIn((short)x,s)
#define Mark(x)      MArk((Pointer *)(x))
#define Release(x)   RElease((Pointer *)(x))
#define GetMem(x,n)  GEtMem((Pointer *)(x), n)
#define FreeMem(x,n) FReeMem((Pointer *)(x),n)

#ifndef CONVPAC
  extern Real Pi;
  extern Text Input,Output;
  extern short _paramcount;
  extern char * _paramstr[20];
  extern Word PrefixSeg, FreeMin;
  extern Integer ExitCode;
  extern Longint RandSeed;
  extern Byte FileMode;
  extern Pointer HeapOrg, HeapPtr, FreePtr, HeapError, ExitProc, ErrorAddr,
   SaveInt00, SaveInt02, SaveInt23, SaveInt24, SaveInt75;
/*   headers of external functions defined in convpac.c   */

extern Boolean _cS(char h, char *a, char *b);           /* string compare */
extern Boolean _cL(char h, char *a, char *b, short n);  /* lexical compare */
extern Boolean _cE(char h, Set a, Set b);               /* bitset compare */
extern Boolean _mC(char h, Char *a, Char *b, short n);  /* hybrid compare */
extern void    _mV(char *a, char *b, short n);
extern void    _mF(char *p, short n, char c);

extern Word *  _eE_(Set s, short n);        /*  add 1 set element */
extern Word *  _eR_(Set s, short x, short y); /*  add interval Range to set */
extern Boolean _eIn(short x,Set s);          /* test if x is in S */
extern Word *  _eU(Set s, Set a, Set b);   /* set union */
extern Word *  _eI(Set s, Set a, Set b);   /* set intersection */
extern Word *  _eD(Set s, Set a, Set b);   /* set difference */
extern Word *  _eV(Set s);                 /* empty set */
extern Word *  _eC(Set s, short nb);         /*  set constructor */

extern short Length(char *s);        /* strlen cut at 255 */
extern char * _sI(char *s, char *t); /* strcpy cut at 255 */
extern char * _sS(char *s, char *t); /* strcat cut at 255 */
extern char * _sM(char *s, char *t, short n); /* strcpy cut at n */
extern char * _sK(String s, char k); /* init string with char */
extern char * _sL(char k, String s); /* _sK with inverted args */
extern char * _sC(String s, char k); /* add k to s */
extern char * _sY(char *a, char *b, short n); /* add Array b to string a */
extern char * _sA(char *a, char *b, short n);

/*  IBM PC BIOS console IO : code in "crtdos.c" */
#ifdef msDOS

extern void _wN(void);                /* write newline */
extern void _wC(char c);              /* write char    */
extern void _wK(char c, short n);       /* write fmt khar*/
extern void _wS(char *s, short n);      /* write string  */
extern void _wI(long i,  short n);      /* write integer */
extern void _wF(double f,short n,short m);/* write float   */

extern void _rN(void);      /* read   newline */
extern void _rC(char *c);   /* readln char    */
extern void _rS(char *s);   /* readln string  */
extern void _rI(long *i);   /* readln integer */
extern void _rF(double *f); /* readln float   */

#endif

extern char UpCase(char c);
extern void Insert(String source,String s,short ix);
extern void Delete(String s,short ix,short count);
extern void HalT(void);
extern void Halt(short code);
extern Boolean Eoln(Text *f);
extern Boolean EolN(void);
extern Boolean Eof(Text *f);
extern Boolean EoF(void);

extern long Round(Real r);
extern short Trunc(Real r);
extern Real Int(Real r);
extern Real Frac(Real r);
extern short Abs(short i); /* abs  */
extern long  ABs(long i);  /* labs */
extern Real  AbS(Real r);  /* fabs */

extern Byte *Mem(Word seg, Word ofs);
extern Word *Memw(Word seg, Word ofs);
extern Longint *Meml(Word seg, Word ofs);
extern Byte *Port(Word ofs);
extern Word *Portw(Word ofs);

extern void ReseT(Text *f);
extern void RewritE(Text *f);
extern void Reset(File *f, Word rsize);
extern void Rewrite(File *f, Word rsize);
/* ?? void Readln(Text *g, char opcode, Pointer p);  */
extern void Append(Text *F);
extern void Rename(Text *f,String s);
extern void Erase(Text *f);
extern void ChDir(String S);
extern void MkDir(String S);
extern void RmDir(String S);
extern void GetDir(Byte D,String S);
extern Longint FilePos(File *F);
extern Longint FileSize(File *F);
/* void Seek(File *F,Longint N); */
/* void SeekEof(Text *F); */
extern void SeekEoln(Text *F);
extern void Truncate(File *F);
extern void SetTextBuf(Text *F,VAR *Buf,Word Size);

extern char *Copy(String aux,String s,short ix,short count);
extern Byte Pos(String sub,String s);
extern void Val(String s, short *v, Integer *code);
extern void VAl(String s, long  *v, Integer *code);
extern void VaL(String s, Real  *v, Integer *code);
extern Word Ofs(Pointer p);
extern Word Seg(Pointer p);
extern Pointer Ptr(Word sg, Word of);

extern void MArk(Pointer  *p);
extern void RElease(Pointer  *p);
extern Pointer NeW(Word s);
extern void DisposE(Pointer p);
extern void GEtMem(Pointer *p, Word n);
extern void FReeMem(Pointer *p, Word n);
extern Longint MemAvail(void);
extern Longint MaxAvail(void);
extern short IoResult(void);
extern Integer ParamCount(void);
extern char *ParamStr(String aux,Integer i);
extern void Randomize(void);
extern Word Random(Word range);
extern double RandoM(void);
extern void BlockRead(File *F,VAR *Buf,Word Count,Word *Res);
extern void BlockWrite(File *F,VAR *Buf,Word Count,Word *Res);
extern void Swap(Word *X);

#endif
/*  end ifndef CONVPAC */
