(*
   chekgram.pas       Copyright (c) 1991  by Georg Post

   The Grammar Checking Utility.  see GramTool.pas
*)

program checkGrammar;
{$M 38000,100000,200000}
{$R+,S+}
uses pcpcdata,
     pascannr,
     semanti6,
     getUnits,   {these 4 modules are the PCPC front end }
     gramtool;   { tools for grammar checking and parser generation }

const syntaxFile='grammar5.txt';
var coreLeft:longInt;
    pbuffer: pTextBuff;
    gramFile,pascFile: str40;
    entryPoint,unitPoint: integer;
    parseTable: ppTab;
    userWait:  boolean;

procedure wait; {keyboard wait}
begin
  if userWait then begin
    write('<Ret>'); readln;
  end else writeln;
end;

procedure translate( fname:str40;
   var baseIndex:biTp; var nontmTab,ruleTab: tabTp;
   var pt:parseTab; var ti:TermSymbIx;
   progPoint,unitPoint: integer; mode:char);
{ ACTION: translation of all used Unit interfaces and of srcName.
          the global emergency flag stops the loop.
  CALLER: main prog
  INPUT : source/destination file names
          mode='R' recursive, 'C'=Compact or 'T'=Turbo parser
}
var i,p,npar,la, nbUnits,useCount,nbs:integer;
    importPart,success,go, slow,turbo:boolean;
    srcName,argu, dataDir: str40;
begin
  emergency:=false;
  slow:=(mode='R');
  turbo:=(mode='T');
  if not slow then begin
    progPoint:=progPoint+256;
    unitPoint:=unitPoint+256; {conventions for nonterminals}
  end;
  traceMode:=false;
  go:=false; dataDir:='';
  npar:=paramCount;
  if npar>0 then begin
    i:=1;
    argu:=paramStr(1); la:=length(argu);
    if la>2 then if (argu[1]='/') and (upcase(argu[2])='P') then begin
      npar:=npar-1; dataDir:=copy(argu,3,la-2); i:=2;
      if argu[la]<>'\' then dataDir:=dataDir+'\';
    end;
  end;
  if npar>0 then begin
    srcName:=paramStr(i) + '.pas';
    go:=true;
  end else begin
    go:=(fname<>'');
    if go then srcName:=fname;
  end;
  if go then begin
    getUses(dataDir,srcName, nbUnits,nbs);
    { must read unit interface codes from 1 thru nbUnits-1 }
    initSemantic;     { create heap data for standard types }
    writeln('Parsing the System Unit');
    stat.newAction:=endSymb; {dummy initializer}
    if slow then begin
      p:= index[unitPoint];
      basicParser(success, p, stat, false,true)
    end else
      tableParser(success, baseIndex, nonTmTab,ruleTab, pt,ti,unitPoint,
        false,turbo);
      {gets into level 0}
    useCount:=0;
    repeat useCount:=useCount+1;
      importPart:=(useCount<nbUnits); {all the external declarations}
      write('Reading ',fileName[useCount]);
      if importPart then begin
        readInterface(dataDir+fileName[useCount]);
        p:=unitPoint;
      end else begin
        readSource(dataDir+fileName[useCount]);
        p:=progPoint;
        {entryPoint --> main Prog entry index to grammar table Gt}
      end;
      write(' Parsing: ');
      if slow then begin
        p:=index[p]; {p is destroyed by basicParser call}
        basicParser(success, p, stat, false,true)
      end else
        tableParser(success,baseIndex,
           nonTmTab,ruleTab, pt,ti,p,{debug=}false, turbo);
      writeln;
    until (not success) or (useCount>=nbUnits) or emergency;
    termSemantic; { does some cleanup on heap }
  end;
end;

procedure grammCheck(full:boolean;
  var conti:contiTp; var nTerm,lastIndex: integer;
  var baseIndex:biTp; var nontmTab,ruleTab: tabTp;
  var pt:parseTab; var ti:TermSymbIx);
begin
  if full then begin
    writeln('------- Checking for Unbalanced Braces');
    checkBraces;
    wait;
  end;
  writeln('------- Expanding the list of productions');
  productionList;
  if full then begin
    wait;
    writeln('------- Checking for Useless Symbols');
    testUse;
    wait;
    showAllProd(userWait);
  end;
  writeln('------- Building the First  sets');
  compFirst; { any nonterminals get a list of First terminals}
  writeln('------- Building the Follow sets');
  compFollow;
  writeln('------- Checking LL(1) properties');
  testLL1(conti);
  if full then begin
    wait;
    writeln('------- Checking for suspect triples:');
    suspectTriple;
    wait;
    writeln('------- Checking for anticipated Actions');
    checkActions;
    wait;
  end;
  writeln('------- Making parsing tables');
  modifConti(conti); {continuation sets: ALL unknown Ids mapped to anyId}
  parsingTables(conti, nTerm,lastIndex, baseIndex,nonTmTab,ruleTab,pt,ti);
  wait;
end;

procedure batchVersion(filename:str40);
var rp: char;
    conti: contiTp; {the continuation set of a production}
    termIndex: termSymbIx;
    nTerm: integer; {number of terminals}
        {the following tables are provided to prepare a table-driven, non-
        recursive version of the LL(1) parser.  }
    baseIndex: biTp;  {Help! we forgot the Epsilon symbol ! }
    lastIndex: integer;
    nontmTab ,ruleTab : tabTp;
  {     for any terminal symbol t, we put b=baseIndex[t].
        n = nontmTab[b] = number of nonterminals such that t belongs to one of
        the continuation sets. nontmTab[b+1 ... b+n] are those nonterminals.
        ruleTab[b+i] is THE unique rule where parsing continues after the pair
        (t at input, nontmTab[b+i] on symbol queue) has been seen.
      Many terminals have 10, the worst one has 65 nontmTab entries !
      Dichotomic search in nonTmTab is time-consuming;
      True matrix table is space consuming: 125 * 200 * 2 = 50K bytes
  }
begin
{  write('Basic recursive parser Y/N ? '); readln(rp); basic:=upcase(rp)='Y';
   write('Big Memory Y/N ? '); readln(rp); bigMemory:=upcase(rp)='Y';
}
  basic:=false;
  userWait:=false;
  gramFile:=syntaxFile;
  writeln('Reading ',gramFile);
  readGram(gramFile, entryPoint,unitPoint, pbuffer^);
  writeln('------- Checking for Unbalanced Braces');
  checkBraces;
  wait;
  if not basic then begin
    writeln('------- Expanding the list of productions');
    productionList;
    wait;
    writeln('------- Checking for Useless Symbols');
    testUse;
    wait;
    showAllProd(userWait);
    writeln('------- Building the First  sets');
    compFirst; { any nonterminals get a list of First terminals}
    writeln('------- Building the Follow sets');
    compFollow;
    writeln('------- Checking LL(1) properties');
    testLL1(conti);
    wait;
    writeln('------- Checking for suspect triples:');
    suspectTriple;
    wait;
    writeln('------- Checking for anticipated Actions');
    checkActions;
    wait;
    writeln('------- Making parsing tables');
    modifConti(conti); {continuation sets: ALL unknown Ids mapped to anyId}
    parsingTables(conti, nTerm,lastIndex, baseIndex,nonTmTab,ruleTab,
      parseTable^, termIndex);
{
  storeParsTable( nProd,nNonterm-256,nTerm, parseTable^, termIndex);
}
  end; {if not basic}
  translate(fileName, baseIndex,nonTmTab,ruleTab, parseTable^, termIndex,
    entryPoint,unitPoint, 'C');
end; {main}

procedure prompt(var rep:char; grd,gchk: boolean; version:char);
begin
  writeln;
  writeln
  ('CHEKGRAM utility Version 1.0:          LL1 grammar check  &  Parser test');
  writeln;
  write  ('       Syntax file   : ',gramFile);
  if grd then write('  [read]'); if gchk then write('  [checked]');
  writeln;
  writeln('       Pascal file   : ',pascFile);
  writeln('       Available heap: ',coreLeft);
  writeln;
  writeln('S = switch to another Syntax file');
  writeln('R = Read the Syntax file');
  writeln('F = Full grammar check sequence');
  writeln('M = Minimum grammar check sequence');
  writeln;
  writeln('P = switch to another Pascal file');
  write  ('V = select parser Version');
  if version='T' then writeln('    [Fast]') else
  if version='C' then writeln('    [Medium]') else writeln('    [Slow]');
  writeln('G = Go ahead to parsing');
  writeln('Q = Quit');
  write('? ');readln(rep); rep:=upcase(rep);
end;

procedure menuVersion; {glass teletype interactive mode}
var rep:char;
    conti: contiTp; {the continuation set of a production}
    termIndex: termSymbIx;
    nTerm: integer; {number of terminals}
    baseIndex: biTp;
    lastIndex: integer;
    nontmTab ,ruleTab : tabTp;
    gramRead, checked: boolean;
    parserVersion: char;
begin
  gramFile:=syntaxFile;
  pascFile:='chekgram.pas';
  gramread:=false; checked:=false;
  parserVersion:='R';  basic:=true;
  repeat prompt(rep, gramread,checked,parserVersion);
    case rep of
    'S': begin write('Syntax file: '); readln(gramFile);
           gramread:=false; checked:=false;
         end;
    'P': begin write('Pascal file: '); readln(pascFile) end;
    'V': begin
           writeln;
           writeln('    R = Recursive parser (lean, mean & slow)');
           writeln('    C = Condensed table parser      (medium)');
           writeln('    T = sparse Table parser   (fast but fat)');
           write('Select a version: '); readln(parserVersion);
           parserVersion:=upcase(parserVersion);
           basic:=(parserVersion='R');
           if (parserVersion='T') and (not bigMemory) then begin
             write('Not enough memory for fat parser <Ret>'); readln;
             parserVersion:='C';
           end;
         end;
    'R': begin
           writeln('Reading ',gramFile);
           readGram(gramFile, entryPoint,unitPoint, pbuffer^);
           gramread:=true;
         end;
    'F': if gramread then begin grammCheck(true, conti, nTerm,lastIndex,
             baseIndex,nonTmTab,ruleTab,parseTable^,termIndex);
           checked:=true;
         end else begin
           write('Please read a syntax file first. <Ret>'); readln;
         end;
    'M': if gramread then begin grammCheck(false,conti, nTerm,lastIndex,
             baseIndex,nonTmTab,ruleTab,parseTable^,termIndex);
           checked:=true;
         end else begin
           write('Please read a syntax file first. <Ret>'); readln;
         end;
    'G': if checked then begin
           translate(pascFile, baseIndex,nonTmTab,ruleTab, parseTable^,
             termIndex, entryPoint,unitPoint, parserVersion);
           termPascann;
           initPascann(pbuffer); {bug: this radical cleanup is necessary}
           checked:=false; gramread:=false;
           writeln('Sorry, the grammar info in memory is lost now.');
         end else begin
           write('Please check the grammar first. <Ret>'); readln;
         end;
    else{otherwise} end;
  until rep='Q';
end;

begin
  coreLeft:=memAvail;
  if coreLeft<100000 then begin
    writeln('Not enough memory to run');
  end else begin
    userWait:=true;
    bigMemory:=(coreLeft>180000);
    if bigMemory then new(parseTable) else parseTable:=Nil;
    initPascann(pbuffer);
    if paramCount=0 then menuVersion else batchVersion(paramStr(1));
    termPascann;
    if bigMemory then dispose(parseTable);
  end;
end.
