 BEGIN
  
  COMMENT
          This program will plot a set of points in three 
          dimensions using the high resolution graphics.   ;
 
  REAL extent,vx,vy,topx,topy;
  REAL ARRAY x(500),y(500),z(500);
  INTEGER limit,i;
 
  PROCEDURE Plotter;
  BEGIN
   COMMENT This procedure scales and plots the points on
           the computer screen. ;
 
   INTEGER i;
   REAL maxx,maxy,minx,miny,difx,dify;
 
   maxx := -1*10^30; maxy := maxx; minx := 1*10^30; miny := minx;
   topx := 639; topy := 200;
 
   FOR i := 1 STEP 1 UNTIL limit DO
   BEGIN
    IF x(i) >= maxx THEN maxx := x(i);
    IF x(i) <= minx THEN minx := x(i);
    IF y(i) >= maxy THEN maxy := y(i);
    IF y(i) <= miny THEN miny := y(i);
   END
 
   COMMENT The maximum and minimum x and y values are computed. ;
 
   difx := maxx-minx; dify := maxy-miny;
 
   FOR i := 1 STEP 1 UNTIL limit DO
   BEGIN
    x(i) := ((x(i)-minx)/difx)*topx;
    y(i) := ((y(i)-miny)/dify)*topy;
    PSET(x(i),topy-y(i)),7;
   END
 
  END
 
  PROCEDURE Convert_3D_to_2D;
  BEGIN
 
   COMMENT This procedure converts 3 dimensional coordinates to
           2 dimensional coordinates.                           ;
 
   REAL cosine_45,sine_45;
   INTEGER i;
 
   cosine_45 := COS((45.*3.14159)/180.);
   sine_45 := SIN((45.*3.14159)/180.);
 
   FOR i := 1 STEP 1 UNTIL limit DO
   BEGIN
    x(i) := x(i) + (extent-y(i))*cosine_45;
    y(i) := z(i) + (extent-y(i))*sine_45;
   END
 
  END
 
 
 
  COMMENT This is the start of the main program. ;
 
 
 
  HOME; SCREEN 2;
 
  Start_plot:
 
  INPUT('Enter the scale factor:' @ extent); HOME;
  
  OUTPUT('.... WAIT ....');
 
  IF extent < 0 THEN GO Finish;
  i:=1;
  FOR vx := -1. STEP .1 UNTIL 1. DO
  BEGIN
   FOR vy := -1. STEP .1 UNTIL 1. DO
   BEGIN
    x(i) := vx; y(i) := vy; z(i) := SQR(2.-vx^2-vy^2); i := i+1;
   END
  END
 
  COMMENT Points have been computed,now set up axes. ;
 
  x(i+1) := extent; y(i+1) := 0; z(i+1) := 0;
  x(i+2) := -extent; y(i+2) := 0; z(i+2) := 0;
  x(i+3) := 0; y(i+3) := extent; z(i+3) := 0;
  x(i+4) := 0; y(i+4) := -extent; z(i+4) := 0;
  x(i+5) := 0; y(i+5) := 0; z(i+5) := extent;
  x(i) := 0; y(i) := 0; z(i) := -extent;
  limit := i+5;
 
 
  Convert_3D_to_2D;
 
  HOME;
 
  Plotter;
 
  OUTPUT( DATE$ + ' ' + TIME$ );
 
  LINE (x(i+1),topy-y(i+1)) - (x(i+2),topy-y(i+2)),7;
  LINE (x(i+3),topy-y(i+3)) - (x(i+4),topy-y(i+4)),7;
  LINE (x(i),topy-y(i)) - (x(i+5),topy-y(i+5)),7;
 
  Busy: IF INKEY$ = '' THEN GO TO Busy;
        ELSE GO TO Start_plot;
 
  Finish:
 END 
                                                                      