BEGIN
	COMMENT Sieve of Eratosthenes program to calculate
		prime numbers. ;
 
 
	REAL Time_in_seconds; { Output argument of PROCEDURE
				Compute_time_in_seconds.        }
 
	PROCEDURE Compute_time_in_seconds;
	BEGIN
		STRING Time_string; { This holds the current time. }
 
		Time_string:=TIME$; { HH:MM:SS }
		Time_in_seconds:=VAL(MID$(Time_string,1,2))*3600 {Hours * 3600}
			+VAL(MID$(Time_string,4,2))*60  {Minutes*60 added}
			+VAL(MID$(Time_string,7,2)); {Seconds added}
 
		{ The time in seconds are now computed. }
	END
 
 
	INTEGER ARRAY FLAGS(8191); {Prime number flags.}
 
	INTEGER I,M,K,PRIME,COUNT; {Loop variables,prime number counter.}
 
	REAL Start_time,        {Start time of test}
	     Finish_time;       {Finish time for ten iterations.}
 
	Compute_time_in_seconds; {Compute the current time.}
	Start_time:=Time_in_seconds; {Set Start time.}
 
	OUTPUT('Time is:' + TIME$);
 
	FOR M := 1 STEP 1 UNTIL 10 DO
	BEGIN
		COUNT := 0;
 
		FOR I := 1 STEP 1 UNTIL 8191 DO
		BEGIN
			FLAGS(I) := 1;
		END
 
		FOR I := 1 STEP 1 UNTIL 8191 DO
		BEGIN
			IF FLAGS(I) = 1 THEN
			BEGIN
				PRIME := I+I+3;
				K := I+PRIME;
 
				WHILE K <= 8191 DO
				BEGIN
					FLAGS(K) := 0;
					K := K+PRIME;
				END
 
				COUNT := COUNT+1;
			END
		END
	END
 
	Compute_time_in_seconds; {Compute the current time.}
	Finish_time:=Time_in_seconds; {Set Finish time.}
 
	OUTPUT('Time is:' + TIME$); OUTPUT();
	OUTPUT(COUNT @ ' PRIMES for each of Ten iterations.'); OUTPUT();
	OUTPUT('Time for one iteration is:' @
	 	(Finish_time - Start_time)/10.
		@ ' seconds.');
END 
                              