'+--------------------------[ User2Asc Ver 0.95]----------------------------+
'|  Written By Gary Meeker 06/13/93                        Updated 11/11/94  |
'|  SYSOP: SHARP Technical Support Line BBS               Lawrenceville, GA  |
'|         (404) 962-1788                          300-28800 Baud. 24 Hours  |
'+---------------------------------------------------------------------------+
'V0.90 06/13/93 - Initial Beta Release
'V0.91 07/02/93 - Rewrote for new PCBTYPES.INC File
'                  Added Command line parameter for Range of Users
'V0.92 03/13/94 - Fixed problem caused by the new PCBTYPES.INC that
'                  resulted in not getting the ALIAS & VERIFY fields.
'                  Added /D:/ paramater to use '/' in dates instead of '-'
'                  Added /F for Full Data (all fields)
'V0.93 06/29/94 - Fixed problem with Notes PSA accidentally reading the
'                  first Note field for all 5 fields.
'V0.94 07/09/94 - Fixed problem caused by last change that made the reading
'                  PSA fields unreliable.
'V0.95 11/11/94 - Added changing of NULS in strings to spaces.
'                  Added new PSA fields for PCBoard 15.2

DEFINT A-Z

'   QuickPack Declarations
DECLARE FUNCTION QInstrB% (Start%, Source$, Srch$)
DECLARE FUNCTION QPStrI$ (IntValue%)
DECLARE FUNCTION QPStrL$ (LongValue&)

'   PDQ Declarations
DECLARE FUNCTION ExeName$ ()
DECLARE FUNCTION PDQParse$ (Work$)
DECLARE FUNCTION PDQValI% (Number$)
DECLARE FUNCTION PDQValL& (Number$)
DECLARE FUNCTION WaitKey2%()                                    'MyOwn
DECLARE SUB CritErrOff ()
DECLARE SUB CritErrOn ()
DECLARE SUB PDQRestore ()
DECLARE SUB SetDelimitChar (Char)

'   ProBas Declarations

'   Myown Declarations
DECLARE FUNCTION Dbl2Long&(Num$)
DECLARE FUNCTION EndString(Temp$, EndCh$)
DECLARE FUNCTION ExistFile% (FileName$)
DECLARE FUNCTION FindLastCh(St$, BYVAL Ch)
DECLARE FUNCTION MidStr(St$, BYVAL Pointer)
DECLARE FUNCTION ReplaceBLANK$ (Char$, St$)     ' ASC(0 - 32, 127)
DECLARE FUNCTION Sng2Long&(Num$)
DECLARE FUNCTION UnSignedL& (BYVAL X%)
DECLARE FUNCTION UnSignedI% (BYVAL X&)
DECLARE SUB DelChar (Target$, Position, Char$)
DECLARE SUB INC ALIAS "_inc" (IntVar%)
DECLARE SUB INC2 ALIAS "_incL" (LongVar&)
DECLARE SUB InsChar (Target$, Position, Char$)

'   Local Declarations
DECLARE SUB Print3(St$)
DECLARE FUNCTION IntStr$(IntVar, Length)
DECLARE FUNCTION LongStr$(LongVar&, Length)
DECLARE FUNCTION DoubleStr$(DblStr$, Length)
DECLARE FUNCTION NumStr$(St$, Length)
DECLARE FUNCTION MakeDate$(St$)
DECLARE FUNCTION BitStr$(Which, Flags)
DECLARE FUNCTION EndChar$(St$, EndCh$)
DECLARE FUNCTION MakeExt$(St$, Ext$)
DECLARE SUB Check4File(FileName$, Ercd, ErrMsg)
DECLARE FUNCTION GetParameter(Parameter$, Value)
DECLARE FUNCTION JulianInt2Str$(Julian)
DECLARE FUNCTION ZeroStr$(Num)

' $INCLUDE: 'PCBTYPES.INC'          ' Found in PCB152QB.ZIP

TYPE AppsRecord
   Offset AS LONG
   Typ AS INTEGER
END TYPE

DIM SHARED None, TRUE, FALSE
DIM SHARED Users AS UsersRecord, UsersInf AS UsersInfRecord, _
           UsersInfHdr AS UsersInfHdrRecord, UsersApp AS UsersAppRecord
DIM SHARED Alias2 AS STRING * 25, Address AS AddressRecord, _
           Verify AS STRING * 25, Password AS PasswordRecord, _
           Notes(4) AS STRING * 60, Stats AS StatsRecord, _
           Account AS AccountRecord, QWKConfig AS QWKConfigRecord
DIM SHARED FirstName AS STRING * 25, LastName AS STRING * 25, _
           BDPhone AS STRING * 13, HVPhone AS STRING * 13, S AS STRING * 1, _
           DblStr AS STRING * 8

DIM SHARED Days(0 TO 1, 1 TO 12)

FALSE = 0 : TRUE = -1 : None = -1

' Set up shared variables for Check4File
DIM SHARED ComDir$, ExeDir$, PCBDATDir$, PCBDir$

PRINT "User2Asc Ver 0.95 - Copyright 1993,1994 Gary Meeker"

Q$ = CHR$(34) : Q2$ = Q$ + "," + Q$ : Q1$ = "," + Q$
S$ = "-"

Days(0, 1) =   0   :   Days(1, 1) =   0
Days(0, 2) =  31   :   Days(1, 2) =  31
Days(0, 3) =  59   :   Days(1, 3) =  60
Days(0, 4) =  90   :   Days(1, 4) =  91
Days(0, 5) = 120   :   Days(1, 5) = 121
Days(0, 6) = 151   :   Days(1, 6) = 152
Days(0, 7) = 181   :   Days(1, 7) = 182
Days(0, 8) = 212   :   Days(1, 8) = 213
Days(0, 9) = 243   :   Days(1, 9) = 244
Days(0,10) = 273   :   Days(1,10) = 274
Days(0,11) = 304   :   Days(1,11) = 305
Days(0,12) = 334   :   Days(1,12) = 335

UserLen   = LEN(Users)

CritErrOff                     ' Stop nasty DOS/SHARE Errors

SetDelimitChar 32

' Get command line
C$ = UCASE$(COMMAND$)

' Parse possible command line arguments
X = GetParameter("/F", FullData)
X = GetParameter("/R:", Dummy) : Range$ = Value$
IF  GetParameter("/D:", Dummy) THEN  S$ = Value$

ComDir$ = EndChar$(PDQParse$(C$), "\")

' Get Environment variables for Check4File
Program$ = ExeName$
ExeDir$ = LEFT$(Program$, FindLastCh(Program$, 92))
PCBDir$ = EndChar$(ENVIRON$("PCBDRIVE") + ENVIRON$("PCBDIR"), "\")
PCBDATDir$ = ENVIRON$("PCBDAT")
PCBDATDir$ = LEFT$(PCBDATDir$, FindLastCh(PCBDATDir$, 92))
PCBDAT$ = "PCBOARD.DAT"
Ercd = FALSE

Check4File PCBDAT$, Ercd, TRUE
IF Ercd GOTO ErrorEnd

PRINT #255, "Reading "; PCBDAT$
OPEN PCBDAT$ FOR INPUT ACCESS READ SHARED AS #1     '    Open it
   FOR X = 1 TO 27
      LINE INPUT #1, A$       ' scan past what we don't need
   NEXT X
   LINE INPUT #1, USERSIndexPath$  ' Location of USERS File Index Files   28
   LINE INPUT #1, UserFile$        ' Loc/Name of Users File               29
   FOR X = 1 TO 150
      LINE INPUT #1, A$            ' scan past some more lines
   NEXT X
   LINE INPUT #1, UsersInfFile$     ' Name and location of USERS.INF file 180
CLOSE                                   ' got all we need

PRINT #255, "Reading "; UsersInfFile$
OPEN UsersInfFile$ FOR BINARY ACCESS READ SHARED AS #1
'                   1          2         3           4        5        6          7
'          1        0          1         1           3        2        1          2
   PSA$ = "/PCBALIAS/PCBADDRESS/PCBVERIFY/PCBPASSWORD/PCBNOTES/PCBSTATS/PCBACCOUNT/PCBQWKNET/"
   GET #1, 1, UsersInfhdr
   NumofApps& = UnSignedL&(UsersInfhdr.NumofApps)
   HeaderSize& = NumofApps& * LEN(UsersApp) + LEN(UsersInfhdr) + 1&
   DIM Apps(UsersInfhdr.NumofApps) AS AppsRecord
   FOR X = 1 TO UsersInfhdr.NumofApps
     GET #1, , UsersApp
     Apps(X).Offset& = UsersApp.Offset&
     Test$ = "/" + RTRIM$(UsersApp.AppName$) + "/"
     SELECT CASE INSTR(PSA$, Test$)
        CASE 1
           AliasPSA = TRUE
           Apps(X).Typ = 1
           PRINT "Alias Support Found"
        CASE 10
           AddressPSA = TRUE
           Apps(X).Typ = 2
           PRINT "Address Support Found"
        CASE 21
           VerifyPSA = TRUE
           Apps(X).Typ = 3
           PRINT "Verify Support Found"
        CASE 31
           PasswordPSA = TRUE
           Apps(X).Typ = 4
           PRINT "Password Support Found"
        CASE 43
           NotesPSA = TRUE
           Apps(X).Typ = 5
           PRINT "Notes Support Found"
        CASE 52
           StatsPSA = TRUE
           Apps(X).Typ = 6
           PRINT "Statistics Support Found"
        CASE 61
           AcctPSA = TRUE
           Apps(X).Typ = 7
           PRINT "Accounting Support Found"
        CASE 72
           QwkNetPSA = TRUE
           Apps(X).Typ = 8
           PRINT "QWKNet Support Found"
'       CASE ELSE
'          PRINT "Skipping "; UsersApp.AppName$
     END SELECT
   NEXT X
CLOSE #1

Alias2$ = SPACE$(25)
Verify$ = SPACE$(25)
Password.Previous1$ = SPACE$(12)
Password.Previous2$ = SPACE$(12)
Password.Previous3$ = SPACE$(12)
Address.Street1 = SPACE$(50)
Address.Street2 = SPACE$(50)
Address.City    = SPACE$(25)
Address.State   = SPACE$(10)
Address.Zip     = SPACE$(10)
Address.Country = SPACE$(15)
FOR N = 0 TO 4
   Notes$(N) = SPACE$(60)
NEXT N

UserAscFile$ = MakeExt(UserFile$, "ASC")
PRINT #255, "Creating "; UserASCFile$;
OPEN UserFile$ FOR RANDOM ACCESS READ SHARED AS #1 LEN = UserLen
OPEN UsersInfFile$ FOR BINARY ACCESS READ SHARED AS #2
OPEN UserAscFile$ FOR OUTPUT ACCESS WRITE SHARED AS #3 LEN = 16384
   Recs& = LOF(1) \ UserLen
   Handle = FILEATTR(2,2)
   SetDelimitChar 44        ' Look for "," in Range
   PDQRestore
   Rec& = PDQValL&(PDQParse(Range$))
   IF Rec& < 1 THEN Rec& = 1
   EndRec& = PDQValL&(PDQParse(Range$))
   IF (EndRec& < 1) OR (EndRec& > Recs&) THEN EndRec& = Recs&
   PRINT #255, "  (Records:"; Rec&; "to"; STR$(EndRec&); ")"
   DO While Rec& <= EndRec&
      GET #1, Rec&, Users
      Pointer& = HeaderSize& + (Users.UsersInfPointer& - 1&) * UsersInfhdr.TotalRecSize&
      GET #2, Pointer&, UsersInf
      FOR X = 1 TO UsersInfhdr.NumofApps
        AppPointer& = Pointer& + Apps(X).Offset&
        SEEK #2, AppPointer&
        SELECT CASE Apps(X).Typ
           CASE 1           ' Alias
              GET #2, , Alias2$
           CASE 2           ' Address
              GET #2, , Address
           CASE 3           ' Verify
              GET #2, , Verify$
           CASE 4           ' Password
              GET #2, , Password
           CASE 5           ' Notes
              FOR N = 0 TO 4
                 GET #2, , Notes$(N)
              NEXT N
           CASE 6           ' Stats
              GET #2, , Stats
           CASE 7           ' Accounting
              GET #2, , Account
           CASE 8           ' QWKNet
              GET #2, , QWKConfig
        END SELECT
      NEXT X
      X = QInstrB(-1, RTRIM$(Users.UserName$), " ")
      IF X THEN
         LSET FirstName$ = LEFT$(Users.UserName$, X - 1)
         LSET LastName$  = MID$(Users.UserName$, X + 1)
      ELSE
         LSET FirstName$ = ""
         LSET LastName$  = Users.UserName$
      END IF
      RSET BDPhone$ = RTRIM$(Users.BusDataPhone$)
      RSET HVPhone$ = RTRIM$(Users.HomeVoicePhone$)
      IF FullData THEN
         LastConf = ASC(Users.LastConference$)
         IF LastConf = 255 THEN
            LastConf = Users.ExtLastConference
         END IF
      END IF
      PRINT #3, Q$;
      Print3 LastName$
      Print3 FirstName$
      Print3 Alias2$
      IF FullData THEN
         Print3 Users.CityState$
      END IF
      Print3 Address.Street1$
      Print3 Address.Street2$
      Print3 Address.City$
      Print3 Address.State$
      Print3 Address.Zip$
      Print3 Address.Country$
      Print3 BDPhone$
      Print3 HVPhone$
      Print3 Users.UserComment$
      Print3 Users.SysopComment$
      PRINT #3, MakeDate$(Users.RegExpDate$); Q2$; _
                IntStr$(ASC(Users.ExpSecLevel$), 3); Q2$; _
                IntStr$(ASC(Users.SecLevel$), 3); Q2$; _
                Users.Password$; Q2$;
      Print3 Password.Previous1$
      Print3 Password.Previous2$
      Print3 Password.Previous3$
      IF FullData THEN
         PRINT #3, JulianInt2Str$(Password.LastChange); Q2$; _
                   JulianInt2Str$(Password.ExpireDate); Q2$; _
                   IntStr$(Password.TimesChanged, 6); Q2$;
      END IF
      PRINT #3, Verify$; Q2$;
      IF FullData THEN
         PRINT #3, Users.ExpertMode$; Q2$; Users.Protocol$; Q2$; _
                   IntStr$(ASC(Users.PageLen$), 3); Q2$; _
                   MakeDate$(Users.LastDirScan$); Q2$;
      END IF
      PRINT #3, IntStr$(Users.NumTimesOn, 6); Q2$; _
                MakeDate$(Users.LastOnDate$); Q2$; Users.LastOnTime$;
      IF FullData THEN
         PRINT #3, Q2$; IntStr$(Users.ElapsedTimeOn, 6); Q2$; _
                   BitStr$(0, 0); Q2$; BitStr$(&h20, 0); Q2$; _
                   BitStr$(&h40, 0); Q2$; BitStr$(&h80, 0); Q2$; _
                   BitStr$(1, 1); Q2$; Users.DeleteFlag$; Q2$;
         PRINT #3, IntStr$(Users.NumUploads, 6); Q2$; _
                   IntStr$(Users.NumDownloads, 6); Q2$; _
                   NumStr$(Users.DailyDnldBytes$, 16); Q2$; _
                   NumStr$(Users.TotDnldBytes$, 16); Q2$; _
                   NumStr$(Users.TotUpldBytes$, 16); Q2$;
         PRINT #3, NumStr$(Users.LastMsgMain$, 8); Q2$; _
                   IntStr$(LastConf, 5); Q2$; _
                   LongStr$(UsersInf.MsgsRead&, 12); Q2$; _
                   LongStr$(UsersInf.MsgsLeft&, 12); Q2$;
         FOR X = 0 TO 4
            Print3 Notes(X)
         NEXT X
         PRINT #3, JulianInt2Str$(Stats.FirstDateOn); Q2$; _
                   IntStr$(Stats.NumSysopPages, 6); Q2$; _
                   IntStr$(Stats.NumGroupChats, 6); Q2$; _
                   IntStr$(Stats.NumComments, 6); Q2$;
         PRINT #3, IntStr$(Stats.Num300, 6); Q2$; _
                   IntStr$(Stats.Num1200, 6); Q2$; _
                   IntStr$(Stats.Num2400, 6); Q2$; _
                   IntStr$(Stats.Num9600, 6); Q2$; _
                   IntStr$(Stats.Num14400, 6); Q2$;
         PRINT #3, IntStr$(Stats.NumSecViol, 6); Q2$; _
                   IntStr$(Stats.NumNotReg, 6); Q2$; _
                   IntStr$(Stats.NumReachDnldLim, 6); Q2$; _
                   IntStr$(Stats.NumFileNotFound, 6); Q2$; _
                   IntStr$(Stats.NumPwrdErrors, 6); Q2$; _
                   IntStr$(Stats.NumVerifyErrors, 6); Q2$;
         PRINT #3, IntStr$(QWKConfig.MaxMsgs, 6); Q2$; _
                   IntStr$(QWKConfig.MaxMsgsPerConf, 6); Q2$; _
                   LongStr$(QWKConfig.PersonalAttachLimit, 12); Q2$; _
                   LongStr$(QWKConfig.PublicAttachLimit, 12); Q2$;
         PRINT #3, DoubleStr$(Account.StartingBalance$, 12); Q2$; _
                   DoubleStr$(Account.StartThisSession$, 12); Q2$; _
                   DoubleStr$(Account.DebitCall$, 12); Q2$; _
                   DoubleStr$(Account.DebitTime$, 12); Q2$; _
                   DoubleStr$(Account.DebitMsgRead$, 12); Q2$;
         PRINT #3, DoubleStr$(Account.DebitMsgReadCapture$, 12); Q2$; _
                   DoubleStr$(Account.DebitMsgWrite$, 12); Q2$; _
                   DoubleStr$(Account.DebitMsgWriteEchoed$, 12); Q2$; _
                   DoubleStr$(Account.DebitMsgWritePrivate$, 12); Q2$; _
                   DoubleStr$(Account.DebitDownloadFile$, 12); Q2$;
         PRINT #3, DoubleStr$(Account.DebitDownloadBytes$, 12); Q2$; _
                   DoubleStr$(Account.DebitGroupChat$, 12); Q2$; _
                   DoubleStr$(Account.DebitTPU$, 12); Q2$; _
                   DoubleStr$(Account.DebitSpecial$, 12); Q2$; _
                   DoubleStr$(Account.CreditUploadFile$, 12); Q2$;
         PRINT #3, DoubleStr$(Account.CreditUploadBytes$, 12); Q2$; _
                   DoubleStr$(Account.CreditSpecial$, 12); Q2$; _
                   IntStr$(ASC(Account.DropSecLevel$), 3);
      END IF
      PRINT #3, Q$
      Inc2 Rec&
   LOOP
CLOSE #2
CLOSE #1

Ercd = FALSE

ErrorEnd:
IF Ercd THEN
  PRINT #255, "Press any key to Terminate"
  Ke = WaitKey2
END IF

ExitProgram:

CritErron
END

'-----------------------------------------------------------------------------
' FUNCTION / SUB Procedures
'-----------------------------------------------------------------------------

SUB Print3(St$)
   SHARED Q2$
   PRINT #3, ReplaceBLANK$ (" ", St$); Q2$;
END SUB

FUNCTION MakeDate$(St$) STATIC
    DIM TempDate AS STRING * 8
    LSET TempDate$ = MID$(St$, 3, 4) + LEFT$(St$, 2)
    InsChar TempDate$, 3, S$
    InsChar TempDate$, 6, S$
    MakeDate$ = TempDate$
END FUNCTION

FUNCTION BitStr$(Which, Flags) STATIC
   SELECT CASE Which
      CASE 0
         Temp = (ASC(Users.PackedFlags$) AND &h18) \ 8
         BitStr$ = MID$("ANxY", Temp+1, 1)
      CASE ELSE
         IF Flags THEN
            Temp = (ASC(Users.PackedFlags2$) AND Which) = 0
            BitStr$ = MID$("AU", Temp+2, 1)
         ELSE
            Temp = (ASC(Users.PackedFlags$) AND Which) = 0
            BitStr$ = MID$("NY", Temp+2, 1)
         END IF
   END SELECT
END FUNCTION

FUNCTION IntStr$(IntVar, Length) STATIC
   DIM Temp AS STRING * 6
   RSET Temp$ = QPStrL$(UnSignedL&(IntVar))
   IntStr$ = RIGHT$(Temp$, Length)
END FUNCTION

FUNCTION LongStr$(LongVar&, Length) STATIC
   DIM Temp AS STRING * 12
   RSET Temp$ = QPStrL$(LongVar&)
   LongStr$ = RIGHT$(Temp$, Length)
END FUNCTION

FUNCTION DoubleStr$(DblStr$, Length) STATIC
   DIM Temp AS STRING * 12
   RSET Temp$ = STR$(CVD(DblStr$))
   DoubleStr$ = RIGHT$(Temp$, Length)
END FUNCTION

FUNCTION NumStr$(St$, Length) STATIC
   DIM Temp AS STRING * 16
   IF Length < 12 THEN
      RSET Temp$ = QPStrL$(Sng2Long&(St$))
   ELSE
      RSET Temp$ = QPStrL$(Dbl2Long&(St$))
   END IF
   NumStr$ = RIGHT$(Temp$, Length)
END FUNCTION

FUNCTION EndChar$(St$, EndCh$) STATIC
   Temp$ = RTRIM$(ST$)
   IF EndString(Temp$, EndCh$) THEN
      EndChar$ = Temp$
   ELSE
      EndChar$ = Temp$ + EndCh$
   END IF
END FUNCTION

FUNCTION MakeExt$(St$, Ext$) STATIC
   ExtPos = FindLastCh(St$, 46)
   IF ExtPos THEN
      MakeExt$ = LEFT$(St$, ExtPos) + Ext$
   ELSE
      MakeExt$ = RTRIM$(St$) + "." + Ext$
   END IF
END FUNCTION

FUNCTION GetParameter(Parameter$, Value) STATIC
   SHARED C$, Value$
   GetParameter = 0
   StrLen = LEN(Parameter$)
   Flag = INSTR(C$, Parameter$)
   IF Flag THEN                                   ' Was Parameter present?
      IF MidStr(Parameter$, StrLen) = 58 THEN     ' Yes, Is it an Optional? ':'
         EndName = INSTR(Flag, C$, " ")           '      Yes, Find End
         IF EndName = 0 THEN                      '
            EndName = LEN(C$) + 1                 '      Must be end of Line
         END IF                                   '
         Temp = EndName - Flag - StrLen           '      This is the length
         Value$ = MID$(C$, Flag + StrLen, Temp)   ' So we can return this
         Value = PDQValI(Value$)                  '
         GetParameter = -1                        ' Show we got it
      ELSE
         Temp = 0                                 ' No, so zero length
         Value = -1                               ' Alternate method
         GetParameter = -1                        ' Show we got it
      END IF
      DelChar C$, Flag, SPACE$(StrLen + Temp)     ' delete it all
   END IF
END FUNCTION

FUNCTION JulianInt2Str$(Julian) STATIC
   IF Julian <> 0 THEN
      Julian& = UnSignedL&(Julian)
      Year   = (100 * Julian&) \ 36525&
      Temp&  = Year * 36525&
      DayofYear = Julian& - (Temp& \ 100)

      IF (Temp& MOD 100) = 0 THEN
         INC DayOfyear
         Leap = 1
      ELSE
         Leap = 0
      END IF
      Month = 1
      FOR Counter = 2 TO 12
         IF Days(Leap, Counter) < DayOfYear THEN
            Month = Counter
         END IF
      NEXT Counter
      Day = DayOfYear - Days(Leap, Month)
   ELSE
      Year = 0
      Month = 0
      Day = 0
   END IF
   JulianInt2Str$ = ZeroStr$(Month) + S$ + ZeroStr$(Day) + S$ + ZeroStr$(Year)
END FUNCTION

' Function used in JulianInt2Str$ to return a 2 digit '0' padded number

FUNCTION ZeroStr$(Num) STATIC
   ZeroStr$ = RIGHT$("00" + LTRIM$(STR$(Num)), 2)
END FUNCTION

SUB Check4File(FileName$, Ercd, ErrMsg)
   IF ExistFile(ComDir$ + FileName$) THEN
      FileName$ = ComDir$ + Filename$
   ELSEIF ExistFile(FileName$) THEN
      EXIT SUB
   ELSEIF ExistFile(PCBDATDir$ + FileName$) THEN
      FileName$ = PCBDATDir$ + FileName$
   ELSEIF ExistFile(PCBDir$ + FileName$) THEN
      FileName$ = PCBDir$ + Filename$
   ELSEIF ExistFile(ExeDir$ + FileName$) THEN
      FileName$ = ExeDir$ + Filename$
   ELSE
      IF ErrMsg THEN
         PRINT #255, CHR$(34); FileName$; CHR$(34); " not Found!"
         PRINT #255, ""
      END IF
      Ercd = TRUE
   END IF
END SUB

'This file was last compiled with:
'BC SCANUSER.BAS  /o /s /ah;
'LINK SCANUSER+
'     C:\QB\LIB\_NOERROR C:\QB\LIB\_NOFIELD C:\QB\LIB\_NOREAD +
'     /ex /nod /noe /packcode /far
'
'     nul
'     C:\QB\LIB\SCREEN C:\QB\LIB\MYOWN C:\QB\LIB\QPPRO C:\QB\LIB\PDQFP
'
