#include <stdio.h>
#include <errno.h>
#include <fcntl.h>

#define CR "\n"

void show_instructions(){
	char *str=CR
	"ARC_CHK Ver 1.0, Checks binary file for identifier string.  If found the"CR
	"program returns an errorlevel 1, otherwise it returns errorlevel 0. "CR
	"Program execution errors return a level 255"CR CR

	"Usage: ARC_CHK filename offset string [show_buffer]"CR CR
	"               filename ................ File to check"CR
	"                        offset ......... Start search at this offset"CR
	"                               string .. String to search for"CR CR
	"NOTE: If you add another parameter (anything) the data at the specified"CR
	"      offset will be displayed to you.  This was designed to aid you in"CR
	"      locating a string of text in a file."CR CR;
	printf("%s",str);
	exit(-1);
}

main(int argc, char **argv){
	int handle;
	long val;
	char buffer[80];
	if(argc<4) show_instructions();
	argv++;
	if((handle=open(*argv,O_BINARY|O_RDONLY))==-1){
		printf("\n\aError encountered opening %s\n",*argv);
		perror("Error");
		exit(-1);
	}
	argv++;
	val=atol(*argv);
	if((lseek(handle,val,SEEK_SET))==-1){
		printf("\n\aError encountered seeking position in %s\n",*argv);
		perror("Error");
		exit(-1);
	}
	argv++;
	if((read(handle,buffer,strlen(*argv)))==-1){
		printf("\n\aError encountered reading in data\n");
		perror("Error");
		exit(-1);
	}
	if(argc>4) printf("\nData found at specified offset was: %s",buffer);
	close(handle);
	if((strncmp(*argv,buffer,strlen(*argv)))==0) exit(1);
	exit(0);
}
