/*******************************************************************************
 *   FILE LOCKOUT.C                                                            *
 *   Created 01-SEP-1991            Rickie W. Belitz                           *
 *                                  P.O. Box 5895                              *
 *                                  Maryville, Tennessee  37802                *
 *                                  BBS (615) 982-6512 v.32                    *
 *                                      (615) 982-6537 v.32                    *
 *                                      (615) 982-8723 v.32                    *
 *                                                                             *
 *   This code is designed to be used with the CKIT door libraries.            *
 *   The source and program are free.   The source can be modified             *
 *   as desired but no fees should be charged for it or any programs           *
 *   compiled with it.   Some enhancements might be to record the              *
 *   lockouts to a file or the caller log.                                     *
 *   This code was a quick fix for locking out new 1200 baud users             *
 *   on my BBS and allowing me to grandfather my existing 1200 baud            *
 *   users.  PCBoard at the present time does not allow selectively            *
 *   locking out baud rates based on security levels.                          *
 *   Although not perfect, this is the next best thing.  The door is           *
 *   is meant to used as a shelled login door within PCBoard and               *
 *   the door access level set for new user security level.                    *
 *   The door expects the desired baud rate to lock out and the path           *
 *   to pcboard.sys to be passed on the command line.  It will also            *
 *   accept the PORT:AAAA:X cmd to change port and irq if need be.             *
 *   AAAA = port base, and X = irq to use passed as a 3rd argument.            *
 *                                                                             *
 *   An example door bat file might be:                                        *
 *   d:                                                                        *
 *   cd c:\pcb\doors                                                           *
 *   lockout 1200 c:\pcb\pcboard.sys <port:AAAA:X>                             *
 *                                                                             *
 *   Notice there is no "board" statement to return to the BBS since it is     *
 *   a shelled door.                                                           *
 *                                                                             *
 *  Direct any comments/suggestions to the BBS numbers or address above.       *
 *                                                                             *
 *                        Rickie Belitz                                        *
 *******************************************************************************/
#include    <stdio.h>
#include    <malloc.h>
#include    "oldckit.h"          /* For version 2.0 CKit           */
#include    "ckit.h"             /* Include CKIT Header file!      */

#define     BELL    0x07

/****************************************************************************
 *                   function prototypes                                    *
 ****************************************************************************/
void    print_error(short, char **);    /* Print open_door errors       */
void    send_byte(BYTE);                /* Send single byte out remote  */
void    s_printf(char *, ...);
void        shut_down(void);    /* Shuts door down if normal or error occurs. */


/****************************************************************************
 *     Misc. variables                                                      *
 ****************************************************************************/
char        progname[21] = "1200 lockout";
short       OPENED;             /* Flag to know if open_door has been called  */
short       CLOSED;             /* Flag to know if close_door has beeb called */
short       LOCKOUT;
void        shut_down(void);    /* Shuts door down if normal or error occurs. */

/****************************************************************************
 *     Error messages for open_door()                                       *
 ****************************************************************************/
char    error1[128] = "Error opening system file -> ";
char    error2[128] = "Error reading system file -> ";
char    error3[128] = "Unknown BBS file type     -> ";
char    error4[128] = "Error opening users file  -> ";
char    error5[128] = "Invalid User Record in ->";
char    error6[128] = "Error reading user record -> ";
char    error7[128] = "Port syntax error: USAGE: PORT:AAAA:X AAAA=COMBASE X=IRQ";
char    error8[128] = "Fossil driver not installed";
char    error9[128] = "Unable to allocate memory";
/*****************************************************************************
 *  Create array of pointers to our error messages                           *
 *****************************************************************************/
static  char    *ckit_errors[9] = {
    error1,
    error2,
    error3,
    error4,
    error5,
    error6,
    error7,
    error8,
    error9,
 };

/******************************************************************************
 *                     Start of Main Program                                  *
 *****************************************************************************/
main(int argc, char **argv) {
short   result;

    CLOSED  = FALSE;            /* Door not closed                       */
    OPENED  = FALSE;            /* Door not opened                       */
    LOCKOUT = FALSE;            /* Wrong baud, dump the user             */
    FORCEOFFHOOK = FALSE;       /* Don't take modem off-hook             */
    if (argc > 1) {
        *(ck_logoff_msgs) = '\0';   /* Don't want to display an exit msg */
        result = open_door(argv[2], argv[3]);
        if(!result) {
            OPENED = TRUE;
            atexit(shut_down);
        } else {
            OPENED = FALSE;
            if(result <= 3) {
                strcat(ckit_errors[result-1], argv[1]); /* sys file problem */
            } else {
            print_error(result-1, ckit_errors);  /* Port or fossil problem */
            }
            exit(1);
        }
        if(!stricmp(baud_rate, argv[1])) {
            newline();
            s_printf("\aSorry, %s baud is not supported.\r\n", baud_rate);
            newline();
            ck_wait(2);
            LOCKOUT = TRUE;
        }
    } else {
        printf("\nUsage: login.exe baudrate c:\\pcb\\pcboard.sys <port:AAAA:X>\n");
    }
 }
/******************************************************************************
*                       End of Main Program                                   *
******************************************************************************/
/****************************************************************************
 *      Printf() function for sending output to port                        *
 ****************************************************************************/
void s_printf(char *s_format,...) {
    va_list arg_pointer;
    char buffer[256];
    va_start(arg_pointer, s_format);
    vsprintf(buffer, s_format, arg_pointer);
    s_puts(buffer);
    va_end(arg_pointer);
}

/*****************************************************************************
 *  Prints messages, enter with msg table to use                             *
 *****************************************************************************/
void    print_error(short index, char **msg_table) {
    printf(msg_table[index]);
}

/****************************************************************************
 *      Close door, reset vectors etc.                                      *
 *  Need in case of a run time error occurs in door                         *
 ****************************************************************************/
 void   shut_down(void) {
    if(OPENED && !CLOSED) {
        close_door();
        CLOSED = TRUE;
        if(LOCKOUT) {     /* Wrong baud, dump the user             */
            lower_dtr();  /* Drop DTR, hang up modem */
        }
    }
}

/****************************************************************************/
/************************ E N D  O F   M O D U L E **************************/
