procedure update_bbs_file;

(* ----------------------------------------------------------------------- *)

Begin                                           { procedure }

{displn('Updating Master BBS Data Base With Your Node Information...');}

dos_getmem(nodeinfo_ptr,sizeof(nodeinfo_record));


dummy_string := global_record.work_dir +
		node_id + '.INF';

bopen(work_file,dummy_string,1,sizeof(nodeinfo_ptr^));   (* get node.inf string *)


bread(work_file,nodeinfo_ptr^);
bclose(work_file);
dos_unlink(dummy_string);


allow_send := nodeinfo_ptr^.send_ind = 'Y';        (* for future reference *)
max_bytes_incoming_hold  := nodeinfo_ptr^.max_bytes_incoming;


ws_record.ws_node_code             := nodeinfo_ptr^.node_code;       (* build ws *)
ws_record.ws_sysop_name            := nodeinfo_ptr^.sysop_name;
ws_record.ws_tag_line              := nodeinfo_ptr^.tag_line;
ws_record.ws_hub_ind               := nodeinfo_ptr^.hub_ind;


for t := 1 to max_conferences do
  begin
  ftos(0.0,ws_record.ws_conferences[t].ws_last_message_processed);
	   ws_record.ws_conferences[t].ws_conf := '        ';
  end;



dummy_string := netmail_dir + default_bbs_filename;    (* if not exists bbs *)

while lock_set(dummy_string) do;

bopen(work_file,dummy_string,25,sizeof(bbs_record));    (* open bbs file *)

repeat                                                 (* read until find *)
bread(work_file,bbs_record);                            (* caller          *)
dummy_word := btell(work_file);
until berr or (bbs_record.bbs_node_code = node_id);

if berr then
   begin
   bseekeof(work_file);
   move(ws_record,bbs_record,sizeof(bbs_record));
   make_log_entry(system_date + ' ' + system_time +
		 ' NOTE: ' + node_id + ' is a NEW NODE',false);
   end
else
   begin
   bseek(work_file,dummy_word -1);
   end;

x := 0;
t := 1;
while (t <= max_conferences) and (nodeinfo_ptr^.conferences[t].nodeinfo_conf <> '        ') do
begin

    for y := 1 to conference_count do
    begin

       if (nodeinfo_ptr^.conferences[t].nodeinfo_conf = cnames_ptr^[y].conference_name) and
	  (cnames_ptr^[y].network_indicator = 'Y') then
       begin

	  inc(x);
	  ws_record.ws_conferences[x].ws_conf := nodeinfo_ptr^.conferences[t].nodeinfo_conf;

	  ws_record.ws_conferences[x].ws_last_message_processed := nodeinfo_ptr^.conferences[t].nodeinfo_last_msg_processed;

	  for z := 1 to max_conferences do
	  begin

	     if ws_record.ws_conferences[x].ws_conf = bbs_record.bbs_conferences[z].bbs_conf then
	     begin

		if stof(nodeinfo_ptr^.conferences[t].nodeinfo_last_msg_processed) <= 0.0 then
		  begin
		    ws_record.ws_conferences[x].ws_last_message_processed :=
		    bbs_record.bbs_conferences[z].bbs_last_message_processed;
		  end
		  else
  {mjf start}     begin
	  ftos(stof(bbs_record.bbs_conferences[z].bbs_last_message_processed) -
	       stof(nodeinfo_ptr^.conferences[t].nodeinfo_last_msg_processed),
		    ws_record.ws_conferences[x].ws_last_message_processed);

		      if stof(ws_record.ws_conferences[x].ws_last_message_processed) = 0.0 then
			 begin
			 ftos(1.0,ws_record.ws_conferences[x].ws_last_message_processed);
			 end;
  {mjf end}       end;
	     end;

	  end;

	 {while lock_set(cnames_ptr^[y].full_conference_filename) do;}

	  bopen(out_msg_file,cnames_ptr^[y].full_conference_filename,1,sizeof(msg_block));
	  bread(out_msg_file,msg_block);
	  bclose(out_msg_file);

	  if (stof(ws_record.ws_conferences[x].ws_last_message_processed) >
	      stof(msg_block.high_message_number))
			     OR
	     (stof(ws_record.ws_conferences[x].ws_last_message_processed) <= 0.0) then
	  begin
	    ws_record.ws_conferences[x].ws_last_message_processed :=
	    msg_block.high_message_number;
	  end;

       end;
    end;
    inc(t);
end;




{mjf start}

disp('Do You Wish to Re-Receive Your Previous Mail Packet? [y/N] : ');
dummy_char := time_key(10000);

newline;

if upcase(dummy_char) = 'Y' then
   begin
     if exists(netmail_dir + node_id + '.HST') then
     begin
	bopen(out_msg_file,netmail_dir + node_id + '.HST',1,sizeof(bbs_record));
	bread(out_msg_file,ws_record);
	bclose(out_msg_file);
     end;
   end;

{mjf end}

move(ws_record,bbs_record,sizeof(bbs_record));
bwrite(work_file,bbs_record);
bclose(work_file);

{mjf start}

dos_unlink(netmail_dir + node_id + '.HST');
bcreate(netmail_dir + node_id + '.HST');
bopen(out_msg_file,netmail_dir + node_id + '.HST',1,sizeof(bbs_record));
bwrite(out_msg_file,bbs_record);
bclose(out_msg_file);

{mjf end}


end;    { update bbs file procedure }


