Procedure read_and_export_messages;

var
  counter                                : integer;

label
loop, loopend, continue;


begin  { read and write messages procedure }

output_file_created := false;
crc_count      := 0;
msg_counter    := 0;



new_msg_start  := trunc(stof(ws_record.ws_conferences[t].ws_last_message_processed));

write_tag_line       := cnames_ptr^[x].suppress_tag_use_indicator = 'N';
echoes_only          := cnames_ptr^[x].echo_pcb_indicator         = 'Y';


bopen(work_file,cnames_ptr^[x].full_conference_filename,recbufs,sizeof(io_pointer^[1]));
bread(work_file,io_pointer^[1]);

loop:
bread(work_file,io_pointer^[1]);                         (* read header         *)
if (berr) then goto loopend;



starting_block_of_msg := btell(work_file);

if (io_pointer^[1].time[3] <> ':') or
   (io_pointer^[1].blocks  <   2 ) then goto loop;


if (io_pointer^[1].status <> live_message) then
  begin
    if (io_pointer^[1].blocks > max_blocks_in_message) then
       begin
	 goto loop;
       end;

  bseek(work_file,starting_block_of_msg + (io_pointer^[1].blocks -1));
  goto loop;
  end;


if date_check then
   begin
   move(io_pointer^[1].date,date_red,sizeof(io_pointer^[1].date));
   if invalid_date then
	begin
	bseek(work_file,starting_block_of_msg + (io_pointer^[1].blocks -1));
	goto loop;
	end;
   end;

crc_out := 0;

bread(work_file,io_pointer^[2]);


set_up_crc;

crcstr(io_pointer^[1].whofrom,whofrom_subject_size);
crcstr(io_pointer^[1].date,date_time_whoto_size);
crcstr(io_pointer^[2],msg_block_size);


inc(crc_count);
crc_pointer^[crc_count].crc := crc_out;
crc_pointer^[crc_count].crc_msg_number := io_pointer^[1].message_number;


if stof(io_pointer^[1].message_number) <= new_msg_start then goto loop;

if ((user_file_sent) and
   (io_pointer^[1].status_code in ['*', '+', '~', '`', '#', '$'])) then
begin

  crc_out := 0;

  crcstr(io_pointer^[1].whoto,whoto_size);

  for b := 1 to user_count do
    begin

      if crc_out = user_ptr^[b] then goto continue;
    end;

  ws_record.ws_conferences[t].ws_last_message_processed :=
  io_pointer^[1].message_number;

  bseek(work_file,starting_block_of_msg + (io_pointer^[1].blocks -1));
  goto loop;

end;


continue:



if stof(io_pointer^[1].refer_to) <> 0 then
begin
    counter := 1;
    while not (counter > crc_count) do
      begin
	 if stof(io_pointer^[1].refer_to) = stof(crc_pointer^[counter].crc_msg_number) then
	   begin
	      move(crc_pointer^[counter].crc,io_pointer^[1].refer_to,crc_size);
	      counter := crc_count;
	   end;
      inc(counter);
      end;
end;

inc(msg_counter);

if not output_file_created then
begin
  dummy_string := global_record.work_dir + cnames_ptr^[x].conference_name;
  bcreate(dummy_string);
  bopen(out_msg_file,dummy_string,100,sizeof(msg_block));
  output_file_created := true;
end;


for counter := 3 to io_pointer^[1].blocks do    (* fill rest of message *)
begin
  bread(work_file,io_pointer^[counter]);
end;


if write_tag_line then
   begin
      dummy_string[0] := chr(ord(255));
      move(io_pointer^[counter - 1],dummy_string[1],255);

      if pos('NET/Mail : ',dummy_string) < 1 then
	begin
	  inc(io_pointer^[1].blocks);
	  move(tag_line,io_pointer^[io_pointer^[1].blocks],sizeof(tag_line));
	end;
    end;



last_msg_processed := io_pointer^[1].message_number;

for counter := 1 to (io_pointer^[1].blocks) do
   begin
      bwrite(out_msg_file,io_pointer^[counter]);                 (* of message          *)
   end;



goto loop;

loopend:

if output_file_created then
begin
   bclose(out_msg_file);
end;

bclose(work_file);

if msg_counter > 0 then
begin
  ws_record.ws_conferences[t].ws_last_message_processed := last_msg_processed;
end;

end;  { read and export messages procedure }
