{$A+,D-,I-,L-,R-,S-,V-}
{$M 7500,0,1500}
program netdoor;
{ $DEFINE SHOW}  {choices are DEBUG and SHOW}




Uses
   Dos,
   MiniCrt,    {BIOS-only crt functions}
   MdosIO,     {Dos-level random access files}
   BufIO,      {Buffered record i/o}
   Tools,      {Various utilities}
   ProData,    {ProDoor/pcboard data}
   ProRoot,    {ProDoor/ProKit main support library}
   KitInit,    {ProKit initialization/deinit}
   dates,
   dosmem;

{$DEFINE PCB14}         {Compile for PCBoard 14.0 (otherwise 12.1)}



const
title                       = 'NetDoor v4.3';
default_bbs_filename        = 'BBS.NET';
default_global_filename     = 'GLOBAL.NET';
default_conference_filename = 'CONF.NET';
default_nodelist_filename   = 'NODELIST';
default_national_nodelist_filename = 'NETWORK.LST';
sysop_constant              = 'SYSOP                    ';
delete_nodelist_rec_days    = 14;
netmail_version_number      = 99;
max_sends                   = 50;
{max_tcans                  = 10;  }
recbufs                     = 250;
compress_command            = 'pkzip -a ';
decompress_command          = 'pkunzip -o ';
max_conferences             = 255;
max_blocks_in_message       = 70;
max_indexes                 = 8192;
live_message                = #225;
maxusers                    = 10000;

type
index_array     = array[1..max_indexes] of single;

national_nodelist_rec_type   = record
  hub_id          : string[8];
  node_id         : string[8];
  node_tag_line   : string[60];
  last_updated    : string[6];
  hub_ind         : char;
  registered_ind  : char;
  fill            : char2;
end; {record}




io_array_type               = record
  status_code               : char;
  message_number            : single;
  refer_to                  : single;
  blocks                    : byte;
  date                      : char8;
  time                      : char5;
  whoto                     : char25;
  readdate                  : single;
  readtime                  : char5;
  hasreplys                 : char;
  whofrom                   : char25;
  subject                   : char25;
  password                  : char12;
  status                    : char;
  echoflag                  : char;
  filler                    : char6;
end;  {record}


io_array             = array[1..max_blocks_in_message] of io_array_type;


global_record_type          = record
 sysops_full_name            : string[25];
 bbs_code                    : string[8];
 user_file_path              : string[25];
 work_dir                    : string[25];
 file_dir                    : string[25];
 comm_dir                    : string[25];
 cnames_dir                  : string[25];
 hub_indicator               : char;
 verify_door_caller          : char;
 days_old                    : integer;
 send_indicator              : char;
 max_bytes_in                : longint;
 disable_netdoor_from_hh     : integer;
 disable_netdoor_from_mm     : integer;
 disable_netdoor_to_hh       : integer;
 disable_netdoor_to_mm       : integer;
 tag_line                    : string[60];
 node_hub_indicator          : char;
 filler                      : array[1..254] of char;
end; {record}


cnames_occurrence            = record
  conference_name                          : string[8];
  full_conference_filename                 : string[40];
  last_message_number_exported             : real;
  network_indicator                        : char;
  max_messages_to_import                   : integer;
  stop_incoming_private                    : char;
  stop_outgoing_private                    : char;
  convert_incoming_private                 : char;
  convert_outgoing_private                 : char;
  echo_pcb_indicator                       : char;
  suppress_tag_use_indicator               : char;
  echo_on_export_indicator                 : char;
  filler                                   : array[1..4] of char;
end; {record}


tag_line_type                  = record
  init_char                                 : char;
  tag_prefix                                : char11;
  tag                                       : array[1..60] of char;
  term_char                                 : char;
  filler                                    : array[1..55] of char;
end; {record}


bbs_confs_type               = record
  bbs_conf                       : string[8];
  bbs_last_message_processed     : single;
end; {record}

bbs_record_type              = record
 bbs_node_code               : string[8];
 bbs_sysop_name              : string[25];
 bbs_tag_line                : string[60];
 bbs_hub_ind                 : char;
 bbs_last_called             : string[8];
 bbs_conferences             : array[1..max_conferences] of bbs_confs_type;
end; {record}

ws_confs_type               = record
  ws_conf                       : string[8];
  ws_last_message_processed     : single;
end; {record}

ws_record_type              = record
 ws_node_code               : string[8];
 ws_sysop_name              : string[25];
 ws_tag_line                : string[60];
 ws_hub_ind                 : char;
 ws_last_called             : string[8];
 ws_conferences             : array[1..max_conferences] of ws_confs_type;
end; {record}


nodeinfo_conf_type       = record
  nodeinfo_conf                 : string[8];
  nodeinfo_last_msg_processed   : single;
end; {record}

nodeinfo_record      = record
  node_code               : string[8];
  sysop_name              : string[25];
  tag_line                : string[60];
  hub_ind                 : char;
  nodelist_request_ind    : char;
  registered_ind          : char;
  days_to_receive         : integer;
  send_ind                : char;
  max_bytes_incoming      : longint;
  conferences             : array[1..max_conferences] of nodeinfo_conf_type;
end; {record}


msg_block_type         = record
  high_message_number            : single;
  low_message_number             : single;
  active_messages                : single;
  callers                        : single;
  lock_indicator                 : char6;
  filler                         : array[1..106] of char;
end; {record}



send_record_type             = record
 send_file                   : string;
 send_bbs                    : array[1..max_sends] of string[8];
end; {record}

old_tag                    = record
  fillchar              : char;
  prior_tag_prefix      : char11;
  restofill             : array[1..116] of char;
end; {record}


date_red_type              = record
  date_red_mm            : char2;
  date_red_fill5         : char;
  date_red_dd            : char2;
  date_red_fill6         : char;
  date_red_yy            : char2;
end; {record}

tcan_array_type  = record
  tcan_word                    : char25;
  tcan_ind                     : char;
  word_size                    : byte;
end; {record}

crc_array_type               = record
crc                      : word;
crc_msg_number           : single;
end; {record}

crc_array    = array[1..max_indexes] of crc_array_type;

search_record_type       = record
 search_mm          : char2;
 search_fill1       : char;
 search_dd          : char2;
 search_fill2       : char;
 search_yy          : char2;
end; {record}

string50            = string[50];

conf_array          = array[1..max_conferences] of cnames_occurrence;

user_array       = array[1..maxusers] of word;

const

io_pointer     : ^io_array        = nil;
{tag_pointer    : ^old_tag         = nil;  }
crc_pointer    : ^crc_array       = nil;
index_pointer  : ^index_array     = nil;
cnames_ptr     : ^conf_array      = nil;
nodeinfo_ptr   : ^nodeinfo_record = nil;
user_ptr       : ^user_array      = nil;

var


starting_block_of_msg       : word;
national_nodelist_rec       : national_nodelist_rec_type;
national_nodelist_rec_hold  : national_nodelist_rec_type;
user_count                  : integer;
max_bytes_incoming_hold     : longint;
send_in_progress            : boolean;
hour_word                   : word;
minute_word                 : word;
echoes_only                 : boolean;
no_messages_in_base         : boolean;
programname                 : string50;
cmdline                     : string;
last_msg_processed          : single;
crc_size                    : byte;
bypass_import               : boolean;
index_count                 : longint;
index_size                  : word;
index_used                  : real;
index_calculated            : boolean;
fill_line                   : boolean;
count                       : integer;
last_message_number_imported : single;
dummy_int                   : integer;
dummy_real                  : real;
{tcan_word_size              : byte;   }
{tcan_array                  : array[1..max_tcans] of tcan_array_type;}
{tcan_present                : boolean;   }
{tcan_count                  : integer;   }
allow_send                  : boolean;
work_string2                : string[2];
work_string1                : string[2];
work_julian                 : word;
work_yy,work_mm,work_dd     : integer;
date_check                  : boolean;
write_tag_line              : boolean;
new_msg_start               : longint;
msg_counter                 : integer;
crc_count                   : integer;
refer_to_found              : boolean;
refer_crc                   : word;
date_red                    : date_red_type;
source_file                 : string[80];
dest_file                   : string[80];
index_file                  : dos_handle;
search_record               : search_record_type;
send_record                 : send_record_type;    (* send files info    *)
dummy_word                  : word;                (* all purpose word   *)
t,x,y,z,a,b                 : integer;             (* work integer       *)
out_msg_file                : buffered_file;       (* output msg file    *)
bbs_record                  : bbs_record_type;     (* bbs record         *)
ws_record                   : ws_record_type;      (* bbs record         *)
noderec                     : searchrec;           (* found in dos unit  *)
node_id                     : string[8];           (* node id of caller  *)
dummy_char                  : char;
dummy_string                : string;              (* all purpose string *)
command                     : string;              (* DOS command line   *)
work_file                   : buffered_file;       (* bbs file handle    *)
global_record               : global_record_type;  (* global record      *)
netmail_dir                 : string[40];
snd_empty                   : boolean;
conference_count            : integer;
national_nodelist_rec_found : boolean;
msg_block                   : msg_block_type;
netdoor_registered          : boolean;
hubs_node_dir               : string;
tag_line                    : tag_line_type;
msg_block_size              : word;
whofrom_subject_size        : word;
date_time_whoto_size        : word;
work_sysops_name            : char25;
output_file_created         : boolean;
user_file_sent              : boolean;
whoto_size                  : integer;


{$i cleardir.inc}
{$i term.inc}                        (* close door                      *)
{$i upchar.inc}
{$i lock.inc}
{$i setcrc.inc}
{$i loaduser.inc}
{$i invaldat.inc}
{$i dateset.inc}
{$i upnodinf.inc}
{$i closindx.inc}
{$i nodelist.inc}
{$i crc16.inc}
{$i loadcrc.inc}
{$i addback.inc}                     (* add backslash                   *)
{$i chekcarr.inc}
{$i loadglob.inc}                    (* load global file info           *)
{$i init.inc}                        (* initialize procedure            *)
{$i exec.inc}                        (* execute DOS command             *)
{$i loadconf.inc}
{$i loadtag.inc}
{$i loadcfg.inc}                     (* load files and work dir         *)
{$i recmail.inc}                     (* receive arc file from node      *)
{$i detnode.inc}                     (* determine calling node name     *)
{$i verify.inc}                      (* verify caller's security        *)
{$i getsend.inc}                     (* get any SEND files waiting      *)
{$i readexp.inc}
{$i arcout.inc}                      (* arc all outgoing mail           *)
{$i sendmail.inc}                    (* send mail to node               *)
{$i readimp.inc}
{$i uplast.inc}
{$i openindx.inc}
{$i openmsg.inc}
{$i import.inc}
{$i unarcinf.inc}                     (* unarc mail received by node     *)
{$i updbbs.inc}                      (* update of bbs.net               *)
{$i national.inc}
{$i mvbbsin.inc}                     (* send files to ALL               *)
{$i send.inc}                        (* send files if any               *)


begin

progname := title;
init;                                (* open prokit                     *)
initialize;                          (* perform initialization          *)
{lock_door; }
load_config_file;                    (* load files and work dir         *)
receive_mail_from_node;              (* receive arc file from node      *)
determine_calling_node;              (* determine calling node name     *)
verify_caller;                       (* verify caller's authority       *)
unarc_inf_record;                    (* unarc inf record                *)
update_bbs_file;                     (* update of bbs.net               *)
process_national_nodelist;
load_user_table;                     (* load user file if sent          *)
arc_all_outgoing_mail;               (* arc all outgoing mail           *)
send_mail_to_node;                   (* send mail to node               *)
unarc_incoming_packet;
send_files;                          (* send files if any               *)
import_mail;
terminate;                           (* close door                      *)

end.
