procedure add_update_nodelist;
begin


  if national_nodelist_rec_hold.last_updated < dummy_string then exit;

  berr := false;

  bseek(out_msg_file,0);

  national_nodelist_rec_found := false;
  while not berr do
    begin
      bread(out_msg_file,national_nodelist_rec);
      dummy_word := btell(out_msg_file);
      if not berr then
      begin
      if (national_nodelist_rec_hold.hub_id  = national_nodelist_rec.hub_id)
				  AND
	 (national_nodelist_rec_hold.node_id = national_nodelist_rec.node_id) then
	 begin
	   bseek(out_msg_file,dummy_word - 1);
	   bwrite(out_msg_file,national_nodelist_rec_hold);
	   national_nodelist_rec_found := true;
	 end;
      end;
    end;

  if not national_nodelist_rec_found then
  begin
    bseekeof(out_msg_file);
    bwrite(out_msg_file,national_nodelist_rec_hold);
  end;

end; {add update nodelist procedure}

(* -------------------------------------------------------------------- *)

procedure process_national_nodelist;
label add_calling_node_info;

Begin                                           { procedure }

{displn('Updating Network-Wide Nodelist File With Your Information...');}

if paramcount > 4 then
begin
  hubs_node_dir := paramstr(5);
  add_backslash(hubs_node_dir);
end
else
begin
  displn('Please Notify Sysop of Missing (5th) NetDoor Parameter!');
  hubs_node_dir := '';
end;

work_yy := atoi(system_yy) + 1900;
work_mm := atoi(system_mm);
work_dd := atoi(system_dd);
DMYtoDATE(work_dd,work_mm,work_yy,work_julian);
work_julian := bumpdate(work_julian,-delete_nodelist_rec_days,0,0);
DATEtoDMY(work_julian,work_dd,work_mm,work_yy);
work_yy := work_yy - 1900;

work_string1 := itoa(work_mm);
work_string2 := itoa(work_dd);

if work_mm < 10 then work_string1 := '0' + work_string1;
if work_dd < 10 then work_string2 := '0' + work_string2;

dummy_string := itoa(work_yy) + work_string1 + work_string2;

hubs_node_dir := hubs_node_dir + default_national_nodelist_filename;

if not exists(hubs_node_dir) then bcreate(hubs_node_dir);

while lock_set(hubs_node_dir) do;
bopen(out_msg_file,hubs_node_dir,50,sizeof(national_nodelist_rec));

if not exists(global_record.work_dir + default_national_nodelist_filename) then
begin
  goto add_calling_node_info;
end;

bopen(work_file,global_record.work_dir + default_national_nodelist_filename,50,sizeof(national_nodelist_rec));

while not berr do
begin
  bread(work_file,national_nodelist_rec_hold);
  if berr then goto add_calling_node_info;
  add_update_nodelist;
end;

add_calling_node_info:

national_nodelist_rec_hold.hub_id        := global_record.bbs_code;
national_nodelist_rec_hold.node_id       := node_id;
national_nodelist_rec_hold.node_tag_line := nodeinfo_ptr^.tag_line;
national_nodelist_rec_hold.last_updated  := system_yy + system_mm + system_dd;
national_nodelist_rec_hold.hub_ind       := nodeinfo_ptr^.hub_ind;
national_nodelist_rec_hold.registered_ind := nodeinfo_ptr^.registered_ind;
national_nodelist_rec_hold.fill          := '  ';


add_update_nodelist;

if exists(global_record.work_dir + default_national_nodelist_filename) then
begin
  bclose(work_file);
end;

bclose(out_msg_file);


end; {procedure}









